/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity;

import java.util.List;
import java.util.stream.Stream;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.errors.OrekitException;
import org.orekit.forces.AbstractForceModel;
import org.orekit.forces.ForceModel;
import org.orekit.forces.gravity.HolmesFeatherstoneAttractionModel;
import org.orekit.forces.gravity.OceanTidesField;
import org.orekit.forces.gravity.potential.CachedNormalizedSphericalHarmonicsProvider;
import org.orekit.forces.gravity.potential.GravityFieldFactory;
import org.orekit.forces.gravity.potential.NormalizedSphericalHarmonicsProvider;
import org.orekit.forces.gravity.potential.OceanTidesWave;
import org.orekit.frames.Frame;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.time.UT1Scale;
import org.orekit.utils.IERSConventions;
import org.orekit.utils.OrekitConfiguration;
import org.orekit.utils.ParameterDriver;

public class OceanTides
extends AbstractForceModel {
    public static final double DEFAULT_STEP = 600.0;
    public static final int DEFAULT_POINTS = 12;
    private final ForceModel attractionModel;

    public OceanTides(Frame centralBodyFrame, double ae, double mu, int degree, int order, IERSConventions conventions, UT1Scale ut1) throws OrekitException {
        this(centralBodyFrame, ae, mu, true, 600.0, 12, degree, order, conventions, ut1);
    }

    public OceanTides(Frame centralBodyFrame, double ae, double mu, boolean poleTide, double step, int nbPoints, int degree, int order, IERSConventions conventions, UT1Scale ut1) throws OrekitException {
        List<OceanTidesWave> waves = GravityFieldFactory.getOceanTidesWaves(degree, order);
        OceanTidesField raw = new OceanTidesField(ae, mu, waves, conventions.getNutationArguments(ut1), poleTide ? conventions.getOceanPoleTide(ut1.getEOPHistory()) : null);
        NormalizedSphericalHarmonicsProvider provider = nbPoints < 2 ? raw : new CachedNormalizedSphericalHarmonicsProvider(raw, step, nbPoints, OrekitConfiguration.getCacheSlotsNumber(), 604800.0, 43200.0);
        this.attractionModel = new HolmesFeatherstoneAttractionModel(centralBodyFrame, provider);
    }

    @Override
    public boolean dependsOnPositionOnly() {
        return this.attractionModel.dependsOnPositionOnly();
    }

    @Override
    public Vector3D acceleration(SpacecraftState s, double[] parameters) throws OrekitException {
        return this.attractionModel.acceleration(s, parameters);
    }

    @Override
    public <T extends RealFieldElement<T>> FieldVector3D<T> acceleration(FieldSpacecraftState<T> s, T[] parameters) throws OrekitException {
        return this.attractionModel.acceleration(s, (RealFieldElement[])parameters);
    }

    @Override
    public Stream<EventDetector> getEventsDetectors() {
        return this.attractionModel.getEventsDetectors();
    }

    @Override
    public <T extends RealFieldElement<T>> Stream<FieldEventDetector<T>> getFieldEventsDetectors(Field<T> field) {
        return this.attractionModel.getFieldEventsDetectors(field);
    }

    @Override
    public ParameterDriver[] getParametersDrivers() {
        return this.attractionModel.getParametersDrivers();
    }
}

