/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.hipparchus.exception.DummyLocalizable;
import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.CCSDSFrame;
import org.orekit.files.ccsds.CcsdsTimeScale;
import org.orekit.files.ccsds.KeyValue;
import org.orekit.files.ccsds.Keyword;
import org.orekit.files.ccsds.TDMFile;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScalesFactory;
import org.orekit.utils.IERSConventions;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TDMParser
extends DefaultHandler {
    private TDMFileFormat fileFormat;
    private final AbsoluteDate missionReferenceDate;
    private final IERSConventions conventions;
    private final boolean simpleEOP;

    public TDMParser() {
        this(TDMFileFormat.UNKNOWN, AbsoluteDate.FUTURE_INFINITY, null, true);
    }

    private TDMParser(TDMFileFormat fileFormat, AbsoluteDate missionReferenceDate, IERSConventions conventions, boolean simpleEOP) {
        this.fileFormat = fileFormat;
        this.missionReferenceDate = missionReferenceDate;
        this.conventions = conventions;
        this.simpleEOP = simpleEOP;
    }

    public TDMParser withFileFormat(TDMFileFormat newFileFormat) {
        return new TDMParser(newFileFormat, this.getMissionReferenceDate(), this.getConventions(), this.isSimpleEOP());
    }

    public TDMFileFormat getFileFormat() {
        return this.fileFormat;
    }

    public TDMParser withMissionReferenceDate(AbsoluteDate newMissionReferenceDate) {
        return new TDMParser(this.getFileFormat(), newMissionReferenceDate, this.getConventions(), this.isSimpleEOP());
    }

    public AbsoluteDate getMissionReferenceDate() {
        return this.missionReferenceDate;
    }

    public TDMParser withConventions(IERSConventions newConventions) {
        return new TDMParser(this.getFileFormat(), this.getMissionReferenceDate(), newConventions, this.isSimpleEOP());
    }

    public IERSConventions getConventions() {
        return this.conventions;
    }

    public TDMParser withSimpleEOP(boolean newSimpleEOP) {
        return new TDMParser(this.getFileFormat(), this.getMissionReferenceDate(), this.getConventions(), newSimpleEOP);
    }

    public boolean isSimpleEOP() {
        return this.simpleEOP;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TDMFile parse(String fileName) throws OrekitException {
        try (FileInputStream stream = new FileInputStream(fileName);){
            TDMFile tDMFile = this.parse(stream, fileName);
            return tDMFile;
        }
        catch (IOException ioe) {
            throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_FIND_FILE, fileName);
        }
    }

    public TDMFile parse(InputStream stream) throws OrekitException {
        return this.parse(stream, "<unknown>");
    }

    public TDMFile parse(InputStream stream, String fileName) throws OrekitException {
        if (TDMFileFormat.UNKNOWN.equals((Object)this.fileFormat)) {
            if (fileName.toLowerCase().endsWith(".txt")) {
                return this.withFileFormat(TDMFileFormat.KEYVALUE).parse(stream, fileName);
            }
            if (fileName.toLowerCase().endsWith(".xml")) {
                return this.withFileFormat(TDMFileFormat.XML).parse(stream, fileName);
            }
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_TDM_UNKNOWN_FORMAT, fileName);
        }
        if (this.fileFormat.equals((Object)TDMFileFormat.KEYVALUE)) {
            return this.parseKeyValue(stream, fileName);
        }
        if (this.fileFormat.equals((Object)TDMFileFormat.XML)) {
            return this.parseXml(stream, fileName);
        }
        throw new OrekitException((Localizable)OrekitMessages.CCSDS_TDM_UNKNOWN_FORMAT, fileName);
    }

    public TDMFile parseKeyValue(InputStream stream, String fileName) throws OrekitException {
        KeyValueHandler handler = new KeyValueHandler(new ParseInfo(this.getMissionReferenceDate(), this.getConventions(), this.isSimpleEOP(), fileName));
        return handler.parse(stream, fileName);
    }

    public TDMFile parseXml(InputStream stream, String fileName) throws OrekitException {
        try {
            XMLHandler handler = new XMLHandler(new ParseInfo(this.getMissionReferenceDate(), this.getConventions(), this.isSimpleEOP(), fileName));
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(stream, (DefaultHandler)handler);
            TDMFile tdmFile = handler.parseInfo.tdmFile;
            tdmFile.checkTimeSystems();
            return tdmFile;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new OrekitException(e, (Localizable)new DummyLocalizable(e.getMessage()), new Object[0]);
        }
    }

    private static class XMLHandler
    extends DefaultHandler {
        private ParseInfo parseInfo;
        private Locator locator;
        private Keyword currentKeyword;
        private Keyword currentObservationKeyword;
        private AbsoluteDate currentObservationEpoch;
        private double currentObservationMeasurement;

        XMLHandler(ParseInfo parseInfo) {
            this.parseInfo = parseInfo;
            this.locator = null;
            this.currentKeyword = null;
            this.currentObservationKeyword = null;
            this.currentObservationEpoch = null;
            this.currentObservationMeasurement = Double.NaN;
        }

        @Override
        public void setDocumentLocator(Locator documentLocator) {
            this.locator = documentLocator;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            block11: {
                try {
                    if (this.currentKeyword == null) break block11;
                    String value = new String(ch, start, length);
                    this.parseInfo.line = "<" + this.currentKeyword.name() + ">" + value + "</" + this.currentKeyword.name() + ">";
                    this.parseInfo.lineNumber = this.locator.getLineNumber();
                    this.parseInfo.keyValue = new KeyValue(this.currentKeyword, value, this.parseInfo.line, this.parseInfo.lineNumber, this.parseInfo.fileName);
                    switch (this.currentKeyword) {
                        case CREATION_DATE: {
                            this.parseInfo.tdmFile.setCreationDate(new AbsoluteDate(this.parseInfo.keyValue.getValue(), (TimeScale)TimeScalesFactory.getUTC()));
                            break;
                        }
                        case ORIGINATOR: {
                            this.parseInfo.tdmFile.setOriginator(this.parseInfo.keyValue.getValue());
                            break;
                        }
                        case COMMENT: {
                            this.parseInfo.commentTmp.add(this.parseInfo.keyValue.getValue());
                            break;
                        }
                        case tdm: 
                        case header: 
                        case body: 
                        case segment: 
                        case metadata: 
                        case data: 
                        case observation: {
                            break;
                        }
                        default: {
                            if (this.parseInfo.currentObservationsBlock != null && (this.parseInfo.parsingData || this.parseInfo.parsingMetaData)) {
                                if (this.parseInfo.parsingMetaData) {
                                    this.parseInfo.parseMetaDataEntry();
                                    break;
                                }
                                if (this.parseInfo.parsingData) {
                                    this.parseObservationDataLine();
                                }
                                break;
                            }
                            throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNEXPECTED_KEYWORD, this.parseInfo.lineNumber, this.parseInfo.fileName, this.parseInfo.line);
                        }
                    }
                }
                catch (OrekitException e) {
                    throw new SAXException(e);
                }
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            try {
                try {
                    this.currentKeyword = Keyword.valueOf(qName);
                }
                catch (IllegalArgumentException e) {
                    throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNEXPECTED_KEYWORD, this.locator.getLineNumber(), this.parseInfo.fileName, "<" + qName + ">");
                }
                switch (this.currentKeyword) {
                    case tdm: {
                        this.parseInfo.tdmFile.setFormatVersion(Double.parseDouble(attributes.getValue("version")));
                        break;
                    }
                    case observation: {
                        this.currentObservationKeyword = null;
                        this.currentObservationEpoch = null;
                        this.currentObservationMeasurement = Double.NaN;
                        break;
                    }
                    case segment: {
                        TDMFile tdmFile = this.parseInfo.tdmFile;
                        tdmFile.addObservationsBlock();
                        this.parseInfo.currentObservationsBlock = tdmFile.getObservationsBlocks().get(tdmFile.getObservationsBlocks().size() - 1);
                        break;
                    }
                    case metadata: {
                        this.parseInfo.parsingMetaData = true;
                        break;
                    }
                    case data: {
                        this.parseInfo.parsingData = true;
                        break;
                    }
                }
            }
            catch (IllegalArgumentException | OrekitException e) {
                throw new SAXException(e);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            try {
                Keyword endKeyword;
                this.currentKeyword = null;
                try {
                    endKeyword = Keyword.valueOf(qName);
                }
                catch (IllegalArgumentException e) {
                    throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNEXPECTED_KEYWORD, this.locator.getLineNumber(), this.parseInfo.fileName, "</" + qName + ">");
                }
                switch (endKeyword) {
                    case header: {
                        this.parseInfo.tdmFile.setHeaderComment(this.parseInfo.commentTmp);
                        this.parseInfo.commentTmp.clear();
                        break;
                    }
                    case observation: {
                        if (this.currentObservationKeyword == null || this.currentObservationEpoch == null || Double.isNaN(this.currentObservationMeasurement)) {
                            throw new OrekitException((Localizable)OrekitMessages.CCSDS_TDM_XML_INCONSISTENT_DATA_BLOCK, this.locator.getLineNumber(), this.parseInfo.fileName);
                        }
                        this.parseInfo.currentObservationsBlock.addObservation(this.currentObservationKeyword.name(), this.currentObservationEpoch, this.currentObservationMeasurement);
                        break;
                    }
                    case segment: {
                        break;
                    }
                    case metadata: {
                        this.parseInfo.currentObservationsBlock.getMetaData().setComment(this.parseInfo.commentTmp);
                        this.parseInfo.commentTmp.clear();
                        this.parseInfo.parsingMetaData = false;
                        break;
                    }
                    case data: {
                        this.parseInfo.currentObservationsBlock.setObservationsComment(this.parseInfo.commentTmp);
                        this.parseInfo.commentTmp.clear();
                        this.parseInfo.parsingData = false;
                        break;
                    }
                }
            }
            catch (IllegalArgumentException | OrekitException e) {
                throw new SAXException(e);
            }
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            return new InputSource();
        }

        private void parseObservationDataLine() throws OrekitException {
            switch (this.currentKeyword) {
                case EPOCH: {
                    this.currentObservationEpoch = this.parseInfo.parseDate(this.parseInfo.keyValue.getValue(), this.parseInfo.currentObservationsBlock.getMetaData().getTimeSystem());
                    break;
                }
                default: {
                    try {
                        this.currentObservationKeyword = this.currentKeyword;
                        this.currentObservationMeasurement = Double.parseDouble(this.parseInfo.keyValue.getValue());
                        break;
                    }
                    catch (NumberFormatException nfe) {
                        throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, this.parseInfo.lineNumber, this.parseInfo.fileName, this.parseInfo.line);
                    }
                }
            }
        }
    }

    private static class KeyValueHandler {
        private ParseInfo parseInfo;

        KeyValueHandler(ParseInfo parseInfo) {
            this.parseInfo = parseInfo;
        }

        private void parseObservationsDataLine() throws OrekitException {
            double measurement;
            String[] fields = this.parseInfo.keyValue.getValue().split("\\s+");
            if (fields.length != 2) {
                throw new OrekitException((Localizable)OrekitMessages.CCSDS_TDM_INCONSISTENT_DATA_LINE, this.parseInfo.lineNumber, this.parseInfo.fileName, this.parseInfo.line);
            }
            AbsoluteDate epoch = this.parseInfo.parseDate(fields[0], this.parseInfo.currentObservationsBlock.getMetaData().getTimeSystem());
            try {
                measurement = Double.parseDouble(fields[1]);
            }
            catch (NumberFormatException nfe) {
                throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, this.parseInfo.lineNumber, this.parseInfo.fileName, this.parseInfo.line);
            }
            this.parseInfo.currentObservationsBlock.addObservation(this.parseInfo.keyValue.getKeyword().name(), epoch, measurement);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public TDMFile parse(InputStream stream, String fileName) throws OrekitException {
            try {
                Throwable throwable = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));){
                    TDMFile tdmFile = this.parseInfo.tdmFile;
                    String line = reader.readLine();
                    while (line != null) {
                        ++this.parseInfo.lineNumber;
                        if (line.trim().length() != 0) {
                            this.parseInfo.line = line;
                            this.parseInfo.keyValue = new KeyValue(this.parseInfo.line, this.parseInfo.lineNumber, this.parseInfo.fileName);
                            if (this.parseInfo.keyValue.getKeyword() == null) {
                                throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNEXPECTED_KEYWORD, this.parseInfo.lineNumber, this.parseInfo.fileName, this.parseInfo.line);
                            }
                            switch (this.parseInfo.keyValue.getKeyword()) {
                                case CCSDS_TDM_VERS: {
                                    tdmFile.setFormatVersion(this.parseInfo.keyValue.getDoubleValue());
                                    break;
                                }
                                case CREATION_DATE: {
                                    tdmFile.setHeaderComment(this.parseInfo.commentTmp);
                                    this.parseInfo.commentTmp.clear();
                                    tdmFile.setCreationDate(new AbsoluteDate(this.parseInfo.keyValue.getValue(), (TimeScale)TimeScalesFactory.getUTC()));
                                    break;
                                }
                                case ORIGINATOR: {
                                    tdmFile.setOriginator(this.parseInfo.keyValue.getValue());
                                    break;
                                }
                                case COMMENT: {
                                    this.parseInfo.commentTmp.add(this.parseInfo.keyValue.getValue());
                                    break;
                                }
                                case META_START: {
                                    tdmFile.addObservationsBlock();
                                    this.parseInfo.currentObservationsBlock = tdmFile.getObservationsBlocks().get(tdmFile.getObservationsBlocks().size() - 1);
                                    this.parseInfo.parsingMetaData = true;
                                    break;
                                }
                                case META_STOP: {
                                    this.parseInfo.currentObservationsBlock.getMetaData().setComment(this.parseInfo.commentTmp);
                                    this.parseInfo.commentTmp.clear();
                                    this.parseInfo.parsingMetaData = false;
                                    break;
                                }
                                case DATA_START: {
                                    this.parseInfo.parsingData = true;
                                    break;
                                }
                                case DATA_STOP: {
                                    this.parseInfo.currentObservationsBlock.setObservationsComment(this.parseInfo.commentTmp);
                                    this.parseInfo.commentTmp.clear();
                                    this.parseInfo.parsingData = false;
                                    break;
                                }
                                default: {
                                    if (this.parseInfo.currentObservationsBlock != null && (this.parseInfo.parsingData || this.parseInfo.parsingMetaData)) {
                                        if (this.parseInfo.parsingMetaData) {
                                            this.parseInfo.parseMetaDataEntry();
                                            break;
                                        }
                                        this.parseObservationsDataLine();
                                        break;
                                    }
                                    throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNEXPECTED_KEYWORD, this.parseInfo.lineNumber, this.parseInfo.fileName, this.parseInfo.line);
                                }
                            }
                        }
                        line = reader.readLine();
                    }
                    tdmFile.checkTimeSystems();
                    TDMFile tDMFile = tdmFile;
                    return tDMFile;
                }
                catch (IOException ioe) {
                    try {
                        throw new OrekitException(ioe, (Localizable)new DummyLocalizable(ioe.getMessage()), new Object[0]);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
            }
            catch (IOException ioe) {
                throw new OrekitException(ioe, (Localizable)new DummyLocalizable(ioe.getMessage()), new Object[0]);
            }
        }
    }

    private static class ParseInfo {
        private final AbsoluteDate missionReferenceDate;
        private final IERSConventions conventions;
        private final boolean simpleEOP;
        private String fileName;
        private TDMFile.ObservationsBlock currentObservationsBlock;
        private int lineNumber;
        private String line;
        private TDMFile tdmFile;
        private KeyValue keyValue;
        private List<String> commentTmp;
        private boolean parsingMetaData;
        private boolean parsingData;

        private ParseInfo(AbsoluteDate missionReferenceDate, IERSConventions conventions, boolean simpleEOP, String fileName) {
            this.missionReferenceDate = missionReferenceDate;
            this.conventions = conventions;
            this.simpleEOP = simpleEOP;
            this.fileName = fileName;
            this.lineNumber = 0;
            this.line = "";
            this.tdmFile = new TDMFile();
            this.commentTmp = new ArrayList<String>();
            this.currentObservationsBlock = null;
            this.parsingMetaData = false;
            this.parsingData = false;
        }

        private void parseMetaDataEntry() throws OrekitException {
            TDMFile.TDMMetaData metaData = this.currentObservationsBlock.getMetaData();
            try {
                switch (this.keyValue.getKeyword()) {
                    case TIME_SYSTEM: {
                        if (!CcsdsTimeScale.contains(this.keyValue.getValue())) {
                            throw new OrekitException((Localizable)OrekitMessages.CCSDS_TIME_SYSTEM_NOT_IMPLEMENTED, this.keyValue.getValue());
                        }
                        CcsdsTimeScale timeSystem = CcsdsTimeScale.valueOf(this.keyValue.getValue());
                        metaData.setTimeSystem(timeSystem);
                        if (metaData.getStartTimeString() != null) {
                            metaData.setStartTime(this.parseDate(metaData.getStartTimeString(), timeSystem));
                        }
                        if (metaData.getStopTimeString() != null) {
                            metaData.setStopTime(this.parseDate(metaData.getStopTimeString(), timeSystem));
                        }
                        break;
                    }
                    case START_TIME: {
                        metaData.setStartTimeString(this.keyValue.getValue());
                        if (metaData.getTimeSystem() != null) {
                            metaData.setStartTime(this.parseDate(this.keyValue.getValue(), metaData.getTimeSystem()));
                        }
                        break;
                    }
                    case STOP_TIME: {
                        metaData.setStopTimeString(this.keyValue.getValue());
                        if (metaData.getTimeSystem() != null) {
                            metaData.setStopTime(this.parseDate(this.keyValue.getValue(), metaData.getTimeSystem()));
                        }
                        break;
                    }
                    case PARTICIPANT_1: 
                    case PARTICIPANT_2: 
                    case PARTICIPANT_3: 
                    case PARTICIPANT_4: 
                    case PARTICIPANT_5: {
                        String key = this.keyValue.getKey();
                        int participantNumber = Integer.parseInt(key.substring(key.length() - 1));
                        metaData.addParticipant(participantNumber, this.keyValue.getValue());
                        break;
                    }
                    case MODE: {
                        metaData.setMode(this.keyValue.getValue());
                        break;
                    }
                    case PATH: {
                        metaData.setPath(this.keyValue.getValue());
                        break;
                    }
                    case PATH_1: {
                        metaData.setPath1(this.keyValue.getValue());
                        break;
                    }
                    case PATH_2: {
                        metaData.setPath2(this.keyValue.getValue());
                        break;
                    }
                    case TRANSMIT_BAND: {
                        metaData.setTransmitBand(this.keyValue.getValue());
                        break;
                    }
                    case RECEIVE_BAND: {
                        metaData.setReceiveBand(this.keyValue.getValue());
                        break;
                    }
                    case TURNAROUND_NUMERATOR: {
                        metaData.setTurnaroundNumerator(this.keyValue.getIntegerValue());
                        break;
                    }
                    case TURNAROUND_DENOMINATOR: {
                        metaData.setTurnaroundDenominator(this.keyValue.getIntegerValue());
                        break;
                    }
                    case TIMETAG_REF: {
                        metaData.setTimetagRef(this.keyValue.getValue());
                        break;
                    }
                    case INTEGRATION_INTERVAL: {
                        metaData.setIntegrationInterval(this.keyValue.getDoubleValue());
                        break;
                    }
                    case INTEGRATION_REF: {
                        metaData.setIntegrationRef(this.keyValue.getValue());
                        break;
                    }
                    case FREQ_OFFSET: {
                        metaData.setFreqOffset(this.keyValue.getDoubleValue());
                        break;
                    }
                    case RANGE_MODE: {
                        metaData.setRangeMode(this.keyValue.getValue());
                        break;
                    }
                    case RANGE_MODULUS: {
                        metaData.setRangeModulus(this.keyValue.getDoubleValue());
                        break;
                    }
                    case RANGE_UNITS: {
                        metaData.setRangeUnits(this.keyValue.getValue());
                        break;
                    }
                    case ANGLE_TYPE: {
                        metaData.setAngleType(this.keyValue.getValue());
                        break;
                    }
                    case REFERENCE_FRAME: {
                        metaData.setReferenceFrameString(this.keyValue.getValue());
                        metaData.setReferenceFrame(this.parseCCSDSFrame(this.keyValue.getValue()).getFrame(this.conventions, this.simpleEOP));
                        break;
                    }
                    case TRANSMIT_DELAY_1: 
                    case TRANSMIT_DELAY_2: 
                    case TRANSMIT_DELAY_3: 
                    case TRANSMIT_DELAY_4: 
                    case TRANSMIT_DELAY_5: {
                        String key = this.keyValue.getKey();
                        int participantNumber = Integer.parseInt(key.substring(key.length() - 1));
                        metaData.addTransmitDelay(participantNumber, this.keyValue.getDoubleValue());
                        break;
                    }
                    case RECEIVE_DELAY_1: 
                    case RECEIVE_DELAY_2: 
                    case RECEIVE_DELAY_3: 
                    case RECEIVE_DELAY_4: 
                    case RECEIVE_DELAY_5: {
                        String key = this.keyValue.getKey();
                        int participantNumber = Integer.parseInt(key.substring(key.length() - 1));
                        metaData.addReceiveDelay(participantNumber, this.keyValue.getDoubleValue());
                        break;
                    }
                    case DATA_QUALITY: {
                        metaData.setDataQuality(this.keyValue.getValue());
                        break;
                    }
                    case CORRECTION_ANGLE_1: {
                        metaData.setCorrectionAngle1(this.keyValue.getDoubleValue());
                        break;
                    }
                    case CORRECTION_ANGLE_2: {
                        metaData.setCorrectionAngle2(this.keyValue.getDoubleValue());
                        break;
                    }
                    case CORRECTION_DOPPLER: {
                        metaData.setCorrectionDoppler(this.keyValue.getDoubleValue());
                        break;
                    }
                    case CORRECTION_RANGE: {
                        metaData.setCorrectionRange(this.keyValue.getDoubleValue());
                        break;
                    }
                    case CORRECTION_RECEIVE: {
                        metaData.setCorrectionReceive(this.keyValue.getDoubleValue());
                        break;
                    }
                    case CORRECTION_TRANSMIT: {
                        metaData.setCorrectionTransmit(this.keyValue.getDoubleValue());
                        break;
                    }
                    case CORRECTIONS_APPLIED: {
                        metaData.setCorrectionsApplied(this.keyValue.getValue());
                        break;
                    }
                    default: {
                        throw new OrekitException((Localizable)OrekitMessages.CCSDS_UNEXPECTED_KEYWORD, this.lineNumber, this.fileName, this.line);
                    }
                }
            }
            catch (NumberFormatException nfe) {
                throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, this.lineNumber, this.fileName, this.line);
            }
        }

        private CCSDSFrame parseCCSDSFrame(String frameName) {
            return CCSDSFrame.valueOf(frameName.replaceAll("-", ""));
        }

        private AbsoluteDate parseDate(String date, CcsdsTimeScale timeSystem) throws OrekitException {
            return timeSystem.parseDate(date, this.conventions, this.missionReferenceDate);
        }
    }

    public static enum TDMFileFormat {
        KEYVALUE,
        XML,
        UNKNOWN;

    }
}

