/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.Keyword;
import org.orekit.files.ccsds.StreamingOemWriter;
import org.orekit.files.general.EphemerisFile;
import org.orekit.files.general.EphemerisFileWriter;
import org.orekit.time.TimeScale;
import org.orekit.utils.TimeStampedPVCoordinates;

public class OEMWriter
implements EphemerisFileWriter {
    public static final String CCSDS_OEM_VERS = "2.0";
    public static final InterpolationMethod DEFAULT_INTERPOLATION_METHOD = InterpolationMethod.LAGRANGE;
    public static final String DEFAULT_ORIGINATOR = "OREKIT";
    private final InterpolationMethod interpolationMethod;
    private final String originator;
    private final String spaceObjectId;
    private final String spaceObjectName;

    public OEMWriter() {
        this(DEFAULT_INTERPOLATION_METHOD, DEFAULT_ORIGINATOR, null, null);
    }

    public OEMWriter(InterpolationMethod interpolationMethod, String originator, String spaceObjectId, String spaceObjectName) {
        this.interpolationMethod = interpolationMethod;
        this.originator = originator;
        this.spaceObjectId = spaceObjectId;
        this.spaceObjectName = spaceObjectName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void write(Appendable writer, EphemerisFile ephemerisFile) throws OrekitException, IOException {
        String idToProcess;
        if (writer == null) {
            throw new OrekitIllegalArgumentException(OrekitMessages.NULL_ARGUMENT, "writer");
        }
        if (ephemerisFile == null) {
            return;
        }
        if (this.spaceObjectId != null) {
            if (!ephemerisFile.getSatellites().containsKey(this.spaceObjectId)) throw new OrekitIllegalArgumentException(OrekitMessages.VALUE_NOT_FOUND, this.spaceObjectId, "ephemerisFile");
            idToProcess = this.spaceObjectId;
        } else {
            if (ephemerisFile.getSatellites().keySet().size() != 1) throw new OrekitIllegalArgumentException(OrekitMessages.EPHEMERIS_FILE_NO_MULTI_SUPPORT, new Object[0]);
            idToProcess = ephemerisFile.getSatellites().keySet().iterator().next();
        }
        EphemerisFile.SatelliteEphemeris satEphem = ephemerisFile.getSatellites().get(idToProcess);
        List<? extends EphemerisFile.EphemerisSegment> segments = satEphem.getSegments();
        if (segments.isEmpty()) {
            return;
        }
        EphemerisFile.EphemerisSegment firstSegment = segments.get(0);
        String objectName = this.spaceObjectName == null ? idToProcess : this.spaceObjectName;
        TimeScale timeScale = firstSegment.getTimeScale();
        LinkedHashMap<Keyword, String> metadata = new LinkedHashMap<Keyword, String>();
        metadata.put(Keyword.TIME_SYSTEM, firstSegment.getTimeScaleString());
        metadata.put(Keyword.ORIGINATOR, this.originator);
        metadata.put(Keyword.OBJECT_ID, idToProcess);
        metadata.put(Keyword.OBJECT_NAME, objectName);
        metadata.put(Keyword.INTERPOLATION, this.interpolationMethod.toString());
        StreamingOemWriter oemWriter = new StreamingOemWriter(writer, timeScale, metadata);
        oemWriter.writeHeader();
        for (EphemerisFile.EphemerisSegment ephemerisSegment : segments) {
            metadata.clear();
            metadata.put(Keyword.CENTER_NAME, ephemerisSegment.getFrameCenterString());
            metadata.put(Keyword.REF_FRAME, ephemerisSegment.getFrameString());
            metadata.put(Keyword.START_TIME, ephemerisSegment.getStart().toString(timeScale));
            metadata.put(Keyword.STOP_TIME, ephemerisSegment.getStop().toString(timeScale));
            metadata.put(Keyword.INTERPOLATION_DEGREE, String.valueOf(ephemerisSegment.getInterpolationSamples() - 1));
            StreamingOemWriter.Segment segmentWriter = oemWriter.newSegment(null, metadata);
            segmentWriter.writeMetadata();
            for (TimeStampedPVCoordinates timeStampedPVCoordinates : ephemerisSegment.getCoordinates()) {
                segmentWriter.writeEphemerisLine(timeStampedPVCoordinates);
            }
        }
    }

    public static enum InterpolationMethod {
        HERMITE,
        LAGRANGE,
        LINEAR;

    }
}

