/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.sequential;

import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.orekit.errors.OrekitException;
import org.orekit.estimation.sequential.AbstractCovarianceMatrixProvider;
import org.orekit.frames.LOFType;
import org.orekit.frames.Transform;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.SpacecraftState;

public class UnivariateProcessNoise
extends AbstractCovarianceMatrixProvider {
    private final LOFType lofType;
    private final PositionAngle positionAngle;
    private final UnivariateFunction[] lofCartesianOrbitalParametersEvolution;
    private final UnivariateFunction[] propagationParametersEvolution;

    public UnivariateProcessNoise(RealMatrix initialCovarianceMatrix, LOFType lofType, PositionAngle positionAngle, UnivariateFunction[] lofCartesianOrbitalParametersEvolution, UnivariateFunction[] propagationParametersEvolution) throws OrekitException {
        super(initialCovarianceMatrix);
        this.lofType = lofType;
        this.positionAngle = positionAngle;
        this.lofCartesianOrbitalParametersEvolution = lofCartesianOrbitalParametersEvolution;
        this.propagationParametersEvolution = propagationParametersEvolution;
        if (lofCartesianOrbitalParametersEvolution.length != 6) {
            throw new OrekitException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, lofCartesianOrbitalParametersEvolution, 6);
        }
    }

    public LOFType getLofType() {
        return this.lofType;
    }

    public PositionAngle getPositionAngle() {
        return this.positionAngle;
    }

    public UnivariateFunction[] getLofCartesianOrbitalParametersEvolution() {
        return this.lofCartesianOrbitalParametersEvolution;
    }

    public UnivariateFunction[] getPropagationParametersEvolution() {
        return this.propagationParametersEvolution;
    }

    @Override
    public RealMatrix getProcessNoiseMatrix(SpacecraftState previous, SpacecraftState current) {
        RealMatrix inertialOrbitalProcessNoiseMatrix = this.getInertialOrbitalProcessNoiseMatrix(previous, current);
        if (this.propagationParametersEvolution.length == 0) {
            return inertialOrbitalProcessNoiseMatrix;
        }
        RealMatrix propagationProcessNoiseMatrix = this.getPropagationProcessNoiseMatrix(previous, current);
        int orbitalMatrixSize = this.lofCartesianOrbitalParametersEvolution.length;
        int propagationMatrixSize = this.propagationParametersEvolution.length;
        RealMatrix processNoiseMatrix = MatrixUtils.createRealMatrix((int)(orbitalMatrixSize + propagationMatrixSize), (int)(orbitalMatrixSize + propagationMatrixSize));
        processNoiseMatrix.setSubMatrix(inertialOrbitalProcessNoiseMatrix.getData(), 0, 0);
        processNoiseMatrix.setSubMatrix(propagationProcessNoiseMatrix.getData(), orbitalMatrixSize, orbitalMatrixSize);
        return processNoiseMatrix;
    }

    private RealMatrix getInertialOrbitalProcessNoiseMatrix(SpacecraftState previous, SpacecraftState current) {
        double deltaT = current.getDate().durationFrom(previous.getDate());
        int lofOrbitalprocessNoiseLength = this.lofCartesianOrbitalParametersEvolution.length;
        double[] lofOrbitalProcessNoiseValues = new double[lofOrbitalprocessNoiseLength];
        for (int i = 0; i < lofOrbitalprocessNoiseLength; ++i) {
            double functionValue = this.lofCartesianOrbitalParametersEvolution[i].value(deltaT);
            lofOrbitalProcessNoiseValues[i] = functionValue * functionValue;
        }
        RealMatrix lofCartesianProcessNoiseMatrix = MatrixUtils.createRealDiagonalMatrix((double[])lofOrbitalProcessNoiseValues);
        double[][] lofToInertialRotation = this.lofType.rotationFromInertial(current.getPVCoordinates()).revert().getMatrix();
        RealMatrix jacLofToInertial = MatrixUtils.createRealMatrix((int)6, (int)6);
        jacLofToInertial.setSubMatrix(lofToInertialRotation, 0, 0);
        jacLofToInertial.setSubMatrix(lofToInertialRotation, 3, 3);
        Transform lofToInertial = this.lofType.transformFromInertial(current.getDate(), current.getPVCoordinates()).getInverse();
        Vector3D OM = lofToInertial.getRotationRate().negate();
        double[][] MOM = new double[3][3];
        MOM[0][1] = -OM.getZ();
        MOM[0][2] = OM.getY();
        MOM[1][0] = OM.getZ();
        MOM[1][2] = -OM.getX();
        MOM[2][0] = -OM.getY();
        MOM[2][1] = OM.getX();
        double[][] dYdC = new double[6][6];
        current.getOrbit().getJacobianWrtCartesian(this.positionAngle, dYdC);
        RealMatrix jacParametersWrtCartesian = MatrixUtils.createRealMatrix((double[][])dYdC);
        RealMatrix jacobian = jacParametersWrtCartesian.multiply(jacLofToInertial);
        RealMatrix inertialOrbitalProcessNoiseMatrix = jacobian.multiply(lofCartesianProcessNoiseMatrix).multiply(jacobian.transpose());
        return inertialOrbitalProcessNoiseMatrix;
    }

    private RealMatrix getPropagationProcessNoiseMatrix(SpacecraftState previous, SpacecraftState current) {
        double deltaT = current.getDate().durationFrom(previous.getDate());
        int propagationProcessNoiseLength = this.propagationParametersEvolution.length;
        double[] propagationProcessNoiseValues = new double[propagationProcessNoiseLength];
        for (int i = 0; i < propagationProcessNoiseLength; ++i) {
            double functionValue = this.propagationParametersEvolution[i].value(deltaT);
            propagationProcessNoiseValues[i] = functionValue * functionValue;
        }
        return MatrixUtils.createRealDiagonalMatrix((double[])propagationProcessNoiseValues);
    }
}

