/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitExceptionWrapper;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.Range;
import org.orekit.models.earth.IonosphericModel;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.utils.Differentiation;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterFunction;
import org.orekit.utils.StateFunction;

public class RangeIonosphericDelayModifier
implements EstimationModifier<Range> {
    private final IonosphericModel ionoModel;

    public RangeIonosphericDelayModifier(IonosphericModel model) {
        this.ionoModel = model;
    }

    private double rangeErrorIonosphericModel(GroundStation station, SpacecraftState state) throws OrekitException {
        Vector3D position = state.getPVCoordinates().getPosition();
        double elevation = station.getBaseFrame().getElevation(position, state.getFrame(), state.getDate());
        if (elevation > 0.0) {
            double azimuth = station.getBaseFrame().getAzimuth(position, state.getFrame(), state.getDate());
            double delay = this.ionoModel.pathDelay(state.getDate(), station.getBaseFrame().getPoint(), elevation, azimuth);
            return delay;
        }
        return 0.0;
    }

    private double[][] rangeErrorJacobianState(final GroundStation station, SpacecraftState refstate) throws OrekitException {
        double[][] finiteDifferencesJacobian = Differentiation.differentiate(new StateFunction(){

            @Override
            public double[] value(SpacecraftState state) throws OrekitException {
                try {
                    double value = RangeIonosphericDelayModifier.this.rangeErrorIonosphericModel(station, state);
                    return new double[]{value};
                }
                catch (OrekitException oe) {
                    throw new OrekitExceptionWrapper(oe);
                }
            }
        }, 1, Propagator.DEFAULT_LAW, OrbitType.CARTESIAN, PositionAngle.TRUE, 15.0, 3).value(refstate);
        return finiteDifferencesJacobian;
    }

    private double rangeErrorParameterDerivative(final GroundStation station, ParameterDriver driver, final SpacecraftState state, double delay) throws OrekitException {
        ParameterFunction rangeError = new ParameterFunction(){

            @Override
            public double value(ParameterDriver parameterDriver) throws OrekitException {
                return RangeIonosphericDelayModifier.this.rangeErrorIonosphericModel(station, state);
            }
        };
        ParameterFunction rangeErrorDerivative = Differentiation.differentiate(rangeError, driver, 3, 10.0);
        return rangeErrorDerivative.value(driver);
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }

    @Override
    public void modify(EstimatedMeasurement<Range> estimated) throws OrekitException {
        Range measurement = estimated.getObservedMeasurement();
        GroundStation station = measurement.getStation();
        SpacecraftState state = estimated.getStates()[0];
        double[] oldValue = estimated.getEstimatedValue();
        double delay = this.rangeErrorIonosphericModel(station, state);
        double[] newValue = (double[])oldValue.clone();
        newValue[0] = newValue[0] + delay;
        estimated.setEstimatedValue(newValue);
        double[][] djac = this.rangeErrorJacobianState(station, state);
        double[][] stateDerivatives = estimated.getStateDerivatives(0);
        for (int irow = 0; irow < stateDerivatives.length; ++irow) {
            for (int jcol = 0; jcol < stateDerivatives[0].length; ++jcol) {
                double[] dArray = stateDerivatives[irow];
                int n = jcol;
                dArray[n] = dArray[n] + djac[irow][jcol];
            }
        }
        estimated.setStateDerivatives(0, stateDerivatives);
        for (ParameterDriver driver : Arrays.asList(station.getEastOffsetDriver(), station.getNorthOffsetDriver(), station.getZenithOffsetDriver())) {
            if (!driver.isSelected()) continue;
            double parameterDerivative = estimated.getParameterDerivatives(driver)[0];
            estimated.setParameterDerivatives(driver, parameterDerivative += this.rangeErrorParameterDerivative(station, driver, state, delay));
        }
    }
}

