/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.leastsquares;

import java.util.List;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.estimation.leastsquares.Model;
import org.orekit.estimation.leastsquares.PreCompensation;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.sampling.MultiSatStepHandler;
import org.orekit.propagation.sampling.OrekitStepInterpolator;
import org.orekit.time.AbsoluteDate;

class MeasurementHandler
implements MultiSatStepHandler {
    private final Model model;
    private final List<PreCompensation> precompensated;
    private int number;
    private int index;

    MeasurementHandler(Model model, List<PreCompensation> precompensated) {
        this.model = model;
        this.precompensated = precompensated;
    }

    @Override
    public void init(List<SpacecraftState> initialStates, AbsoluteDate target) {
        this.number = 0;
        this.index = 0;
    }

    @Override
    public void handleStep(List<OrekitStepInterpolator> interpolators, boolean isLast) throws OrekitException {
        while (this.number < this.precompensated.size()) {
            PreCompensation next = this.precompensated.get(this.number);
            AbsoluteDate currentDate = interpolators.get(0).getCurrentState().getDate();
            if (this.model.isForwardPropagation() && next.getDate().compareTo(currentDate) > 0 || !this.model.isForwardPropagation() && next.getDate().compareTo(currentDate) < 0) {
                if (isLast) {
                    throw new OrekitInternalError(null);
                }
                return;
            }
            ObservedMeasurement<?> observed = next.getMeasurement();
            List<Integer> indices = observed.getPropagatorsIndices();
            SpacecraftState[] states = new SpacecraftState[indices.size()];
            for (int i = 0; i < states.length; ++i) {
                states[i] = interpolators.get(i).getInterpolatedState(next.getDate());
            }
            EstimatedMeasurement<?> estimated = observed.estimate(this.model.getIterationsCount(), this.model.getEvaluationsCount(), states);
            this.model.fetchEvaluatedMeasurement(this.index, estimated);
            ++this.number;
            this.index += observed.getDimension();
        }
    }
}

