/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.data;

import java.util.zip.GZIPInputStream;
import org.orekit.data.DataFilter;
import org.orekit.data.NamedData;

public class GzipFilter
implements DataFilter {
    private static final String SUFFIX = ".gz";

    @Override
    public NamedData filter(NamedData original) {
        String oName = original.getName();
        NamedData.StreamOpener oOpener = original.getStreamOpener();
        if (oName.endsWith(SUFFIX)) {
            String fName = oName.substring(0, oName.length() - SUFFIX.length());
            NamedData.StreamOpener fOpener = () -> new GZIPInputStream(oOpener.openStream());
            return new NamedData(fName, fOpener);
        }
        return original;
    }
}

