/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.bodies;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hipparchus.exception.Localizable;
import org.orekit.bodies.CelestialBody;
import org.orekit.bodies.CelestialBodyLoader;
import org.orekit.bodies.JPLEphemeridesLoader;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;

public class CelestialBodyFactory {
    public static final String SOLAR_SYSTEM_BARYCENTER = "solar system barycenter";
    public static final String SUN = "Sun";
    public static final String MERCURY = "Mercury";
    public static final String VENUS = "Venus";
    public static final String EARTH_MOON = "Earth-Moon barycenter";
    public static final String EARTH = "Earth";
    public static final String MOON = "Moon";
    public static final String MARS = "Mars";
    public static final String JUPITER = "Jupiter";
    public static final String SATURN = "Saturn";
    public static final String URANUS = "Uranus";
    public static final String NEPTUNE = "Neptune";
    public static final String PLUTO = "Pluto";
    private static final Map<String, List<CelestialBodyLoader>> LOADERS_MAP = new HashMap<String, List<CelestialBodyLoader>>();
    private static final Map<String, CelestialBody> CELESTIAL_BODIES_MAP = new HashMap<String, CelestialBody>();

    private CelestialBodyFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCelestialBodyLoader(String name, CelestialBodyLoader loader) {
        Map<String, List<CelestialBodyLoader>> map = LOADERS_MAP;
        synchronized (map) {
            List<CelestialBodyLoader> loaders = LOADERS_MAP.get(name);
            if (loaders == null) {
                loaders = new ArrayList<CelestialBodyLoader>();
                LOADERS_MAP.put(name, loaders);
            }
            loaders.add(loader);
        }
    }

    public static void addDefaultCelestialBodyLoader(String supportedNames) throws OrekitException {
        CelestialBodyFactory.addDefaultCelestialBodyLoader(SOLAR_SYSTEM_BARYCENTER, supportedNames);
        CelestialBodyFactory.addDefaultCelestialBodyLoader(SUN, supportedNames);
        CelestialBodyFactory.addDefaultCelestialBodyLoader(MERCURY, supportedNames);
        CelestialBodyFactory.addDefaultCelestialBodyLoader(VENUS, supportedNames);
        CelestialBodyFactory.addDefaultCelestialBodyLoader(EARTH_MOON, supportedNames);
        CelestialBodyFactory.addDefaultCelestialBodyLoader(EARTH, supportedNames);
        CelestialBodyFactory.addDefaultCelestialBodyLoader(MOON, supportedNames);
        CelestialBodyFactory.addDefaultCelestialBodyLoader(MARS, supportedNames);
        CelestialBodyFactory.addDefaultCelestialBodyLoader(JUPITER, supportedNames);
        CelestialBodyFactory.addDefaultCelestialBodyLoader(SATURN, supportedNames);
        CelestialBodyFactory.addDefaultCelestialBodyLoader(URANUS, supportedNames);
        CelestialBodyFactory.addDefaultCelestialBodyLoader(NEPTUNE, supportedNames);
        CelestialBodyFactory.addDefaultCelestialBodyLoader(PLUTO, supportedNames);
    }

    public static void addDefaultCelestialBodyLoader(String name, String supportedNames) throws OrekitException {
        JPLEphemeridesLoader loader = null;
        if (name.equalsIgnoreCase(SOLAR_SYSTEM_BARYCENTER)) {
            loader = new JPLEphemeridesLoader(supportedNames, JPLEphemeridesLoader.EphemerisType.SOLAR_SYSTEM_BARYCENTER);
        } else if (name.equalsIgnoreCase(SUN)) {
            loader = new JPLEphemeridesLoader(supportedNames, JPLEphemeridesLoader.EphemerisType.SUN);
        } else if (name.equalsIgnoreCase(MERCURY)) {
            loader = new JPLEphemeridesLoader(supportedNames, JPLEphemeridesLoader.EphemerisType.MERCURY);
        } else if (name.equalsIgnoreCase(VENUS)) {
            loader = new JPLEphemeridesLoader(supportedNames, JPLEphemeridesLoader.EphemerisType.VENUS);
        } else if (name.equalsIgnoreCase(EARTH_MOON)) {
            loader = new JPLEphemeridesLoader(supportedNames, JPLEphemeridesLoader.EphemerisType.EARTH_MOON);
        } else if (name.equalsIgnoreCase(EARTH)) {
            loader = new JPLEphemeridesLoader(supportedNames, JPLEphemeridesLoader.EphemerisType.EARTH);
        } else if (name.equalsIgnoreCase(MOON)) {
            loader = new JPLEphemeridesLoader(supportedNames, JPLEphemeridesLoader.EphemerisType.MOON);
        } else if (name.equalsIgnoreCase(MARS)) {
            loader = new JPLEphemeridesLoader(supportedNames, JPLEphemeridesLoader.EphemerisType.MARS);
        } else if (name.equalsIgnoreCase(JUPITER)) {
            loader = new JPLEphemeridesLoader(supportedNames, JPLEphemeridesLoader.EphemerisType.JUPITER);
        } else if (name.equalsIgnoreCase(SATURN)) {
            loader = new JPLEphemeridesLoader(supportedNames, JPLEphemeridesLoader.EphemerisType.SATURN);
        } else if (name.equalsIgnoreCase(URANUS)) {
            loader = new JPLEphemeridesLoader(supportedNames, JPLEphemeridesLoader.EphemerisType.URANUS);
        } else if (name.equalsIgnoreCase(NEPTUNE)) {
            loader = new JPLEphemeridesLoader(supportedNames, JPLEphemeridesLoader.EphemerisType.NEPTUNE);
        } else if (name.equalsIgnoreCase(PLUTO)) {
            loader = new JPLEphemeridesLoader(supportedNames, JPLEphemeridesLoader.EphemerisType.PLUTO);
        }
        if (loader != null) {
            CelestialBodyFactory.addCelestialBodyLoader(name, loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCelestialBodyLoaders(String name) {
        Map<String, CelestialBody> map = CELESTIAL_BODIES_MAP;
        synchronized (map) {
            CelestialBodyFactory.clearCelestialBodyCache(name);
            Map<String, List<CelestialBodyLoader>> map2 = LOADERS_MAP;
            synchronized (map2) {
                LOADERS_MAP.remove(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCelestialBodyLoaders() {
        Map<String, CelestialBody> map = CELESTIAL_BODIES_MAP;
        synchronized (map) {
            CelestialBodyFactory.clearCelestialBodyCache();
            Map<String, List<CelestialBodyLoader>> map2 = LOADERS_MAP;
            synchronized (map2) {
                LOADERS_MAP.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCelestialBodyCache(String name) {
        Map<String, CelestialBody> map = CELESTIAL_BODIES_MAP;
        synchronized (map) {
            CELESTIAL_BODIES_MAP.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCelestialBodyCache() {
        Map<String, CelestialBody> map = CELESTIAL_BODIES_MAP;
        synchronized (map) {
            CELESTIAL_BODIES_MAP.clear();
        }
    }

    public static CelestialBody getSolarSystemBarycenter() throws OrekitException {
        return CelestialBodyFactory.getBody(SOLAR_SYSTEM_BARYCENTER);
    }

    public static CelestialBody getSun() throws OrekitException {
        return CelestialBodyFactory.getBody(SUN);
    }

    public static CelestialBody getMercury() throws OrekitException {
        return CelestialBodyFactory.getBody(MERCURY);
    }

    public static CelestialBody getVenus() throws OrekitException {
        return CelestialBodyFactory.getBody(VENUS);
    }

    public static CelestialBody getEarthMoonBarycenter() throws OrekitException {
        return CelestialBodyFactory.getBody(EARTH_MOON);
    }

    public static CelestialBody getEarth() throws OrekitException {
        return CelestialBodyFactory.getBody(EARTH);
    }

    public static CelestialBody getMoon() throws OrekitException {
        return CelestialBodyFactory.getBody(MOON);
    }

    public static CelestialBody getMars() throws OrekitException {
        return CelestialBodyFactory.getBody(MARS);
    }

    public static CelestialBody getJupiter() throws OrekitException {
        return CelestialBodyFactory.getBody(JUPITER);
    }

    public static CelestialBody getSaturn() throws OrekitException {
        return CelestialBodyFactory.getBody(SATURN);
    }

    public static CelestialBody getUranus() throws OrekitException {
        return CelestialBodyFactory.getBody(URANUS);
    }

    public static CelestialBody getNeptune() throws OrekitException {
        return CelestialBodyFactory.getBody(NEPTUNE);
    }

    public static CelestialBody getPluto() throws OrekitException {
        return CelestialBodyFactory.getBody(PLUTO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CelestialBody getBody(String name) throws OrekitException {
        Map<String, CelestialBody> map = CELESTIAL_BODIES_MAP;
        synchronized (map) {
            CelestialBody body = CELESTIAL_BODIES_MAP.get(name);
            if (body == null) {
                Map<String, List<CelestialBodyLoader>> map2 = LOADERS_MAP;
                synchronized (map2) {
                    List<CelestialBodyLoader> loaders = LOADERS_MAP.get(name);
                    if (loaders == null || loaders.isEmpty()) {
                        CelestialBodyFactory.addDefaultCelestialBodyLoader(name, "^[lu]nx([mp](\\d\\d\\d\\d))+\\.(?:4\\d\\d)$");
                        CelestialBodyFactory.addDefaultCelestialBodyLoader(name, "^inpop.*\\.dat$");
                        loaders = LOADERS_MAP.get(name);
                    }
                    OrekitException delayedException = null;
                    for (CelestialBodyLoader loader : loaders) {
                        try {
                            body = loader.loadCelestialBody(name);
                            if (body == null) continue;
                            break;
                        }
                        catch (OrekitException oe) {
                            delayedException = oe;
                        }
                    }
                    if (body == null) {
                        throw delayedException != null ? delayedException : new OrekitException((Localizable)OrekitMessages.NO_DATA_LOADED_FOR_CELESTIAL_BODY, name);
                    }
                }
                CELESTIAL_BODIES_MAP.put(name, body);
            }
            return body;
        }
    }
}

