/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.attitudes;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.hipparchus.RealFieldElement;
import org.hipparchus.exception.Localizable;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.LOFType;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.AngularDerivativesFilter;
import org.orekit.utils.FieldAngularCoordinates;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.ImmutableTimeStampedCache;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.TimeStampedFieldAngularCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class TabulatedLofOffset
implements AttitudeProvider {
    private static final long serialVersionUID = 20151211L;
    private final Frame inertialFrame;
    private LOFType type;
    private final transient ImmutableTimeStampedCache<TimeStampedAngularCoordinates> table;
    private final AngularDerivativesFilter filter;

    public TabulatedLofOffset(Frame inertialFrame, LOFType type, List<TimeStampedAngularCoordinates> table, int n, AngularDerivativesFilter filter) throws OrekitException {
        if (!inertialFrame.isPseudoInertial()) {
            throw new OrekitException((Localizable)OrekitMessages.NON_PSEUDO_INERTIAL_FRAME, inertialFrame.getName());
        }
        this.inertialFrame = inertialFrame;
        this.type = type;
        this.table = new ImmutableTimeStampedCache<TimeStampedAngularCoordinates>(n, table);
        this.filter = filter;
    }

    public List<TimeStampedAngularCoordinates> getTable() {
        return this.table.getAll();
    }

    @Override
    public Attitude getAttitude(PVCoordinatesProvider pvProv, AbsoluteDate date, Frame frame) throws OrekitException {
        List<TimeStampedAngularCoordinates> sample = this.table.getNeighbors(date).collect(Collectors.toList());
        TimeStampedAngularCoordinates interpolated = TimeStampedAngularCoordinates.interpolate(date, this.filter, sample);
        TimeStampedPVCoordinates pv = pvProv.getPVCoordinates(date, this.inertialFrame);
        Transform inertialToLof = this.type.transformFromInertial(date, pv);
        Transform frameToInertial = frame.getTransformTo(this.inertialFrame, date);
        Transform frameToLof = new Transform(date, frameToInertial, inertialToLof);
        return new Attitude(date, frame, interpolated.addOffset(frameToLof.getAngular()));
    }

    @Override
    public <T extends RealFieldElement<T>> FieldAttitude<T> getAttitude(FieldPVCoordinatesProvider<T> pvProv, FieldAbsoluteDate<T> date, Frame frame) throws OrekitException {
        List sample = this.table.getNeighbors(date.toAbsoluteDate()).map(ac -> new TimeStampedFieldAngularCoordinates(date.getField(), (TimeStampedAngularCoordinates)ac)).collect(Collectors.toList());
        TimeStampedFieldAngularCoordinates<T> interpolated = TimeStampedFieldAngularCoordinates.interpolate(date, this.filter, sample);
        TimeStampedFieldPVCoordinates<T> pv = pvProv.getPVCoordinates(date, this.inertialFrame);
        FieldTransform<T> inertialToLof = this.type.transformFromInertial(date, pv);
        FieldTransform<T> frameToInertial = frame.getTransformTo(this.inertialFrame, date);
        FieldTransform<T> frameToLof = new FieldTransform<T>(date, frameToInertial, inertialToLof);
        return new FieldAttitude<T>(date, frame, interpolated.addOffset((FieldAngularCoordinates)frameToLof.getAngular()));
    }

    private Object writeReplace() throws NotSerializableException {
        return new DataTransferObject(this.inertialFrame, this.type, this.table.getAll(), this.table.getNeighborsSize(), this.filter);
    }

    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 20151211L;
        private final Frame inertialFrame;
        private LOFType type;
        private final List<TimeStampedAngularCoordinates> list;
        private final int n;
        private final AngularDerivativesFilter filter;

        DataTransferObject(Frame inertialFrame, LOFType type, List<TimeStampedAngularCoordinates> list, int n, AngularDerivativesFilter filter) {
            this.inertialFrame = inertialFrame;
            this.type = type;
            this.list = list;
            this.n = n;
            this.filter = filter;
        }

        private Object readResolve() {
            try {
                return new TabulatedLofOffset(this.inertialFrame, this.type, this.list, this.n, this.filter);
            }
            catch (OrekitException oe) {
                throw new OrekitInternalError(oe);
            }
        }
    }
}

