/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.spherical.oned;

import org.hipparchus.geometry.Point;
import org.hipparchus.geometry.partitioning.Hyperplane;
import org.hipparchus.geometry.spherical.oned.ArcsSet;
import org.hipparchus.geometry.spherical.oned.S1Point;
import org.hipparchus.geometry.spherical.oned.Sphere1D;
import org.hipparchus.geometry.spherical.oned.SubLimitAngle;

public class LimitAngle
implements Hyperplane<Sphere1D> {
    private final S1Point location;
    private final boolean direct;
    private final double tolerance;

    public LimitAngle(S1Point location, boolean direct, double tolerance) {
        this.location = location;
        this.direct = direct;
        this.tolerance = tolerance;
    }

    public LimitAngle copySelf() {
        return this;
    }

    @Override
    public double getOffset(Point<Sphere1D> point) {
        double delta = ((S1Point)point).getAlpha() - this.location.getAlpha();
        return this.direct ? delta : -delta;
    }

    public boolean isDirect() {
        return this.direct;
    }

    public LimitAngle getReverse() {
        return new LimitAngle(this.location, !this.direct, this.tolerance);
    }

    public SubLimitAngle wholeHyperplane() {
        return new SubLimitAngle(this, null);
    }

    public ArcsSet wholeSpace() {
        return new ArcsSet(this.tolerance);
    }

    @Override
    public boolean sameOrientationAs(Hyperplane<Sphere1D> other) {
        return !(this.direct ^ ((LimitAngle)other).direct);
    }

    public S1Point getLocation() {
        return this.location;
    }

    @Override
    public Point<Sphere1D> project(Point<Sphere1D> point) {
        return this.location;
    }

    @Override
    public double getTolerance() {
        return this.tolerance;
    }
}

