/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.euclidean.threed;

import org.hipparchus.RealFieldElement;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.Precision;

public class FieldLine<T extends RealFieldElement<T>> {
    private FieldVector3D<T> direction;
    private FieldVector3D<T> zero;
    private final double tolerance;

    public FieldLine(FieldVector3D<T> p1, FieldVector3D<T> p2, double tolerance) throws MathIllegalArgumentException {
        this.reset(p1, p2);
        this.tolerance = tolerance;
    }

    public FieldLine(FieldLine<T> line) {
        this.direction = line.direction;
        this.zero = line.zero;
        this.tolerance = line.tolerance;
    }

    public void reset(FieldVector3D<T> p1, FieldVector3D<T> p2) throws MathIllegalArgumentException {
        FieldVector3D<T> delta = p2.subtract(p1);
        T norm2 = delta.getNormSq();
        if (norm2.getReal() == 0.0) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.ZERO_NORM, new Object[0]);
        }
        this.direction = new FieldVector3D<RealFieldElement>((RealFieldElement)((RealFieldElement)norm2.sqrt()).reciprocal(), delta);
        this.zero = new FieldVector3D<RealFieldElement>((RealFieldElement)norm2.getField().getOne(), p1, (RealFieldElement)((RealFieldElement)p1.dotProduct(delta).negate()).divide(norm2), delta);
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public FieldLine<T> revert() {
        FieldLine<T> reverted = new FieldLine<T>(this);
        reverted.direction = reverted.direction.negate();
        return reverted;
    }

    public FieldVector3D<T> getDirection() {
        return this.direction;
    }

    public FieldVector3D<T> getOrigin() {
        return this.zero;
    }

    public T getAbscissa(FieldVector3D<T> point) {
        return point.subtract(this.zero).dotProduct(this.direction);
    }

    public T getAbscissa(Vector3D point) {
        return (T)((RealFieldElement)this.zero.subtract(point).dotProduct(this.direction).negate());
    }

    public FieldVector3D<T> pointAt(T abscissa) {
        return new FieldVector3D<RealFieldElement>((RealFieldElement)abscissa.getField().getOne(), (FieldVector3D<RealFieldElement>)this.zero, (RealFieldElement)abscissa, (FieldVector3D<RealFieldElement>)this.direction);
    }

    public FieldVector3D<T> pointAt(double abscissa) {
        return new FieldVector3D<T>(1.0, this.zero, abscissa, this.direction);
    }

    public boolean isSimilarTo(FieldLine<T> line) {
        double angle = FieldVector3D.angle(this.direction, line.direction).getReal();
        return (angle < this.tolerance || angle > Math.PI - this.tolerance) && this.contains(line.zero);
    }

    public boolean contains(FieldVector3D<T> p) {
        return this.distance(p).getReal() < this.tolerance;
    }

    public boolean contains(Vector3D p) {
        return this.distance(p).getReal() < this.tolerance;
    }

    public T distance(FieldVector3D<T> p) {
        FieldVector3D<T> d = p.subtract(this.zero);
        FieldVector3D<RealFieldElement> n = new FieldVector3D<RealFieldElement>((RealFieldElement)this.zero.getX().getField().getOne(), d, (RealFieldElement)d.dotProduct(this.direction).negate(), this.direction);
        return (T)n.getNorm();
    }

    public T distance(Vector3D p) {
        FieldVector3D<T> d = this.zero.subtract(p).negate();
        FieldVector3D<RealFieldElement> n = new FieldVector3D<RealFieldElement>((RealFieldElement)this.zero.getX().getField().getOne(), d, (RealFieldElement)d.dotProduct(this.direction).negate(), this.direction);
        return (T)n.getNorm();
    }

    public T distance(FieldLine<T> line) {
        FieldVector3D<T> normal = FieldVector3D.crossProduct(this.direction, line.direction);
        T n = normal.getNorm();
        if (n.getReal() < Precision.SAFE_MIN) {
            return this.distance(line.zero);
        }
        RealFieldElement offset = (RealFieldElement)line.zero.subtract(this.zero).dotProduct(normal).divide(n);
        return (T)((RealFieldElement)offset.abs());
    }

    public FieldVector3D<T> closestPoint(FieldLine<T> line) {
        T cos = this.direction.dotProduct(line.direction);
        RealFieldElement n = (RealFieldElement)((RealFieldElement)((RealFieldElement)cos.multiply(cos)).subtract(1.0)).negate();
        if (n.getReal() < Precision.EPSILON) {
            return this.zero;
        }
        FieldVector3D<T> delta0 = line.zero.subtract(this.zero);
        T a = delta0.dotProduct(this.direction);
        T b = delta0.dotProduct(line.direction);
        return new FieldVector3D<RealFieldElement>((RealFieldElement)a.getField().getOne(), this.zero, (RealFieldElement)((RealFieldElement)a.subtract((Object)((RealFieldElement)b.multiply(cos)))).divide((Object)n), this.direction);
    }

    public FieldVector3D<T> intersection(FieldLine<T> line) {
        FieldVector3D<T> closest = this.closestPoint(line);
        return line.contains(closest) ? closest : null;
    }
}

