/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.random;

import java.io.Serializable;
import org.hipparchus.random.IntRandomGenerator;
import org.hipparchus.util.FastMath;

public abstract class AbstractWell
extends IntRandomGenerator
implements Serializable {
    private static final long serialVersionUID = 20150223L;
    protected int index;
    protected final int[] v;

    protected AbstractWell(int k) {
        this(k, null);
    }

    protected AbstractWell(int k, int seed) {
        this(k, new int[]{seed});
    }

    protected AbstractWell(int k, int[] seed) {
        int r = AbstractWell.calculateBlockCount(k);
        this.v = new int[r];
        this.index = 0;
        this.setSeed(seed);
    }

    protected AbstractWell(int k, long seed) {
        this(k, new int[]{(int)(seed >>> 32), (int)(seed & 0xFFFFFFFFL)});
    }

    @Override
    public void setSeed(int[] seed) {
        if (seed == null) {
            this.setSeed(System.currentTimeMillis() + (long)System.identityHashCode(this));
            return;
        }
        System.arraycopy(seed, 0, this.v, 0, FastMath.min(seed.length, this.v.length));
        if (seed.length < this.v.length) {
            for (int i = seed.length; i < this.v.length; ++i) {
                long l = this.v[i - seed.length];
                this.v[i] = (int)(1812433253L * (l ^ l >> 30) + (long)i & 0xFFFFFFFFL);
            }
        }
        this.index = 0;
        this.clearCache();
    }

    private static int calculateBlockCount(int k) {
        int w = 32;
        int r = (k + 32 - 1) / 32;
        return r;
    }

    protected static final class IndexTable {
        private final int[] iRm1;
        private final int[] iRm2;
        private final int[] i1;
        private final int[] i2;
        private final int[] i3;

        public IndexTable(int k, int m1, int m2, int m3) {
            int r = AbstractWell.calculateBlockCount(k);
            this.iRm1 = new int[r];
            this.iRm2 = new int[r];
            this.i1 = new int[r];
            this.i2 = new int[r];
            this.i3 = new int[r];
            for (int j = 0; j < r; ++j) {
                this.iRm1[j] = (j + r - 1) % r;
                this.iRm2[j] = (j + r - 2) % r;
                this.i1[j] = (j + m1) % r;
                this.i2[j] = (j + m2) % r;
                this.i3[j] = (j + m3) % r;
            }
        }

        public int getIndexPred(int index) {
            return this.iRm1[index];
        }

        public int getIndexPred2(int index) {
            return this.iRm2[index];
        }

        public int getIndexM1(int index) {
            return this.i1[index];
        }

        public int getIndexM2(int index) {
            return this.i2[index];
        }

        public int getIndexM3(int index) {
            return this.i3[index];
        }
    }
}

