/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.linear;

import java.util.Arrays;
import org.hipparchus.FieldElement;
import org.hipparchus.RealFieldElement;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.linear.ArrayFieldVector;
import org.hipparchus.linear.BlockFieldMatrix;
import org.hipparchus.linear.FieldDecompositionSolver;
import org.hipparchus.linear.FieldMatrix;
import org.hipparchus.linear.FieldVector;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;

public class FieldQRDecomposition<T extends RealFieldElement<T>> {
    private T[][] qrt;
    private T[] rDiag;
    private FieldMatrix<T> cachedQ;
    private FieldMatrix<T> cachedQT;
    private FieldMatrix<T> cachedR;
    private FieldMatrix<T> cachedH;
    private final T threshold;

    public FieldQRDecomposition(FieldMatrix<T> matrix) {
        this(matrix, (RealFieldElement)matrix.getField().getZero());
    }

    public FieldQRDecomposition(FieldMatrix<T> matrix, T threshold) {
        this.threshold = threshold;
        int m = matrix.getRowDimension();
        int n = matrix.getColumnDimension();
        this.qrt = (RealFieldElement[][])matrix.transpose().getData();
        this.rDiag = (RealFieldElement[])MathArrays.buildArray(threshold.getField(), FastMath.min(m, n));
        this.cachedQ = null;
        this.cachedQT = null;
        this.cachedR = null;
        this.cachedH = null;
        this.decompose((RealFieldElement[][])this.qrt);
    }

    protected void decompose(T[][] matrix) {
        for (int minor = 0; minor < FastMath.min(matrix.length, matrix[0].length); ++minor) {
            this.performHouseholderReflection(minor, (RealFieldElement[][])matrix);
        }
    }

    protected void performHouseholderReflection(int minor, T[][] matrix) {
        RealFieldElement zero;
        T[] qrtMinor = matrix[minor];
        RealFieldElement xNormSqr = zero = (RealFieldElement)this.threshold.getField().getZero();
        for (int row = minor; row < qrtMinor.length; ++row) {
            T c = qrtMinor[row];
            xNormSqr = xNormSqr.add((RealFieldElement)c.multiply(c));
        }
        RealFieldElement a = qrtMinor[minor].getReal() > 0.0 ? (RealFieldElement)((RealFieldElement)xNormSqr.sqrt()).negate() : (RealFieldElement)xNormSqr.sqrt();
        this.rDiag[minor] = a;
        if (a.getReal() != 0.0) {
            qrtMinor[minor] = qrtMinor[minor].subtract((RealFieldElement)a);
            for (int col = minor + 1; col < matrix.length; ++col) {
                int row;
                T[] qrtCol = matrix[col];
                RealFieldElement alpha = zero;
                for (row = minor; row < qrtCol.length; ++row) {
                    alpha = alpha.subtract((RealFieldElement)qrtCol[row].multiply(qrtMinor[row]));
                }
                alpha = alpha.divide((RealFieldElement)a.multiply(qrtMinor[minor]));
                for (row = minor; row < qrtCol.length; ++row) {
                    qrtCol[row] = qrtCol[row].subtract((RealFieldElement)((RealFieldElement)alpha.multiply(qrtMinor[row])));
                }
            }
        }
    }

    public FieldMatrix<T> getR() {
        if (this.cachedR == null) {
            int n = this.qrt.length;
            int m = this.qrt[0].length;
            FieldElement[][] ra = (RealFieldElement[][])MathArrays.buildArray(this.threshold.getField(), m, n);
            for (int row = FastMath.min(m, n) - 1; row >= 0; --row) {
                ra[row][row] = this.rDiag[row];
                for (int col = row + 1; col < n; ++col) {
                    ra[row][col] = this.qrt[col][row];
                }
            }
            this.cachedR = MatrixUtils.createFieldMatrix((FieldElement[][])ra);
        }
        return this.cachedR;
    }

    public FieldMatrix<T> getQ() {
        if (this.cachedQ == null) {
            this.cachedQ = this.getQT().transpose();
        }
        return this.cachedQ;
    }

    public FieldMatrix<T> getQT() {
        if (this.cachedQT == null) {
            int minor;
            int n = this.qrt.length;
            int m = this.qrt[0].length;
            FieldElement[][] qta = (RealFieldElement[][])MathArrays.buildArray(this.threshold.getField(), m, m);
            for (minor = m - 1; minor >= FastMath.min(m, n); --minor) {
                qta[minor][minor] = (RealFieldElement)this.threshold.getField().getOne();
            }
            for (minor = FastMath.min(m, n) - 1; minor >= 0; --minor) {
                T[] qrtMinor = this.qrt[minor];
                qta[minor][minor] = (RealFieldElement)this.threshold.getField().getOne();
                if (qrtMinor[minor].getReal() == 0.0) continue;
                for (int col = minor; col < m; ++col) {
                    int row;
                    RealFieldElement alpha = (RealFieldElement)this.threshold.getField().getZero();
                    for (row = minor; row < m; ++row) {
                        alpha = alpha.subtract((RealFieldElement)qta[col][row].multiply(qrtMinor[row]));
                    }
                    alpha = alpha.divide((RealFieldElement)this.rDiag[minor].multiply(qrtMinor[minor]));
                    for (row = minor; row < m; ++row) {
                        qta[col][row] = qta[col][row].add((RealFieldElement)((RealFieldElement)alpha.negate()).multiply(qrtMinor[row]));
                    }
                }
            }
            this.cachedQT = MatrixUtils.createFieldMatrix((FieldElement[][])qta);
        }
        return this.cachedQT;
    }

    public FieldMatrix<T> getH() {
        if (this.cachedH == null) {
            int n = this.qrt.length;
            int m = this.qrt[0].length;
            FieldElement[][] ha = (RealFieldElement[][])MathArrays.buildArray(this.threshold.getField(), m, n);
            for (int i = 0; i < m; ++i) {
                for (int j = 0; j < FastMath.min(i + 1, n); ++j) {
                    ha[i][j] = this.qrt[j][i].divide((RealFieldElement)((RealFieldElement)this.rDiag[j].negate()));
                }
            }
            this.cachedH = MatrixUtils.createFieldMatrix((FieldElement[][])ha);
        }
        return this.cachedH;
    }

    public FieldDecompositionSolver<T> getSolver() {
        return new FieldSolver((RealFieldElement[][])this.qrt, (RealFieldElement[])this.rDiag, (RealFieldElement)this.threshold);
    }

    private static class FieldSolver<T extends RealFieldElement<T>>
    implements FieldDecompositionSolver<T> {
        private final T[][] qrt;
        private final T[] rDiag;
        private final T threshold;

        private FieldSolver(T[][] qrt, T[] rDiag, T threshold) {
            this.qrt = qrt;
            this.rDiag = rDiag;
            this.threshold = threshold;
        }

        @Override
        public boolean isNonSingular() {
            return !this.checkSingular((RealFieldElement[])this.rDiag, (RealFieldElement)this.threshold, false);
        }

        @Override
        public FieldVector<T> solve(FieldVector<T> b) {
            int n = this.qrt.length;
            int m = this.qrt[0].length;
            if (b.getDimension() != m) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, b.getDimension(), m);
            }
            this.checkSingular((RealFieldElement[])this.rDiag, (RealFieldElement)this.threshold, true);
            FieldElement[] x = (RealFieldElement[])MathArrays.buildArray(this.threshold.getField(), n);
            RealFieldElement[] y = (RealFieldElement[])b.toArray();
            for (int minor = 0; minor < FastMath.min(m, n); ++minor) {
                int row;
                T[] qrtMinor = this.qrt[minor];
                RealFieldElement dotProduct = (RealFieldElement)this.threshold.getField().getZero();
                for (row = minor; row < m; ++row) {
                    dotProduct = dotProduct.add((RealFieldElement)y[row].multiply(qrtMinor[row]));
                }
                dotProduct = dotProduct.divide((RealFieldElement)this.rDiag[minor].multiply(qrtMinor[minor]));
                for (row = minor; row < m; ++row) {
                    y[row] = y[row].add((RealFieldElement)dotProduct.multiply(qrtMinor[row]));
                }
            }
            for (int row = this.rDiag.length - 1; row >= 0; --row) {
                y[row] = (RealFieldElement)y[row].divide(this.rDiag[row]);
                RealFieldElement yRow = y[row];
                T[] qrtRow = this.qrt[row];
                x[row] = yRow;
                for (int i = 0; i < row; ++i) {
                    y[i] = y[i].subtract((RealFieldElement)yRow.multiply(qrtRow[i]));
                }
            }
            return new ArrayFieldVector(x, false);
        }

        @Override
        public FieldMatrix<T> solve(FieldMatrix<T> b) {
            int n = this.qrt.length;
            int m = this.qrt[0].length;
            if (b.getRowDimension() != m) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, b.getRowDimension(), m);
            }
            this.checkSingular((RealFieldElement[])this.rDiag, (RealFieldElement)this.threshold, true);
            int columns = b.getColumnDimension();
            int blockSize = 36;
            int cBlocks = (columns + 36 - 1) / 36;
            FieldElement[][] xBlocks = (RealFieldElement[][])BlockFieldMatrix.createBlocksLayout(this.threshold.getField(), (int)n, (int)columns);
            FieldElement[][] y = (RealFieldElement[][])MathArrays.buildArray(this.threshold.getField(), b.getRowDimension(), 36);
            Object[] alpha = (RealFieldElement[])MathArrays.buildArray(this.threshold.getField(), 36);
            for (int kBlock = 0; kBlock < cBlocks; ++kBlock) {
                int kStart = kBlock * 36;
                int kEnd = FastMath.min(kStart + 36, columns);
                int kWidth = kEnd - kStart;
                b.copySubMatrix(0, m - 1, kStart, kEnd - 1, y);
                for (int minor = 0; minor < FastMath.min(m, n); ++minor) {
                    int k;
                    FieldElement[] yRow;
                    FieldElement d;
                    int row;
                    T[] qrtMinor = this.qrt[minor];
                    RealFieldElement factor = (RealFieldElement)((RealFieldElement)this.rDiag[minor].multiply(qrtMinor[minor])).reciprocal();
                    Arrays.fill(alpha, 0, kWidth, this.threshold.getField().getZero());
                    for (row = minor; row < m; ++row) {
                        d = qrtMinor[row];
                        yRow = y[row];
                        for (k = 0; k < kWidth; ++k) {
                            alpha[k] = alpha[k].add((RealFieldElement)d.multiply((FieldElement)yRow[k]));
                        }
                    }
                    for (int k2 = 0; k2 < kWidth; ++k2) {
                        alpha[k2] = alpha[k2].multiply(factor);
                    }
                    for (row = minor; row < m; ++row) {
                        d = qrtMinor[row];
                        yRow = y[row];
                        for (k = 0; k < kWidth; ++k) {
                            yRow[k] = yRow[k].add((RealFieldElement)alpha[k].multiply(d));
                        }
                    }
                }
                for (int j = this.rDiag.length - 1; j >= 0; --j) {
                    int jBlock = j / 36;
                    int jStart = jBlock * 36;
                    RealFieldElement factor = (RealFieldElement)this.rDiag[j].reciprocal();
                    FieldElement[] yJ = y[j];
                    FieldElement[] xBlock = xBlocks[jBlock * cBlocks + kBlock];
                    int index = (j - jStart) * kWidth;
                    for (int k = 0; k < kWidth; ++k) {
                        yJ[k] = yJ[k].multiply(factor);
                        xBlock[index++] = yJ[k];
                    }
                    T[] qrtJ = this.qrt[j];
                    for (int i = 0; i < j; ++i) {
                        T rIJ = qrtJ[i];
                        FieldElement[] yI = y[i];
                        for (int k = 0; k < kWidth; ++k) {
                            yI[k] = yI[k].subtract((RealFieldElement)yJ[k].multiply(rIJ));
                        }
                    }
                }
            }
            return new BlockFieldMatrix(n, columns, xBlocks, false);
        }

        @Override
        public FieldMatrix<T> getInverse() {
            return this.solve(MatrixUtils.createFieldIdentityMatrix(this.threshold.getField(), this.qrt[0].length));
        }

        private boolean checkSingular(T[] diag, T min, boolean raise) {
            for (T d : diag) {
                if (!(FastMath.abs(d.getReal()) <= min.getReal())) continue;
                if (raise) {
                    throw new MathIllegalArgumentException(LocalizedCoreFormats.SINGULAR_MATRIX, new Object[0]);
                }
                return true;
            }
            return false;
        }
    }
}

