/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.distribution;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.Pair;
import org.hipparchus.util.Precision;

public class EnumeratedDistribution<T>
implements Serializable {
    private static final long serialVersionUID = 20123308L;
    private final List<T> singletons;
    private final double[] probabilities;
    private final double[] cumulativeProbabilities;

    public EnumeratedDistribution(List<Pair<T, Double>> pmf) throws MathIllegalArgumentException {
        this.singletons = new ArrayList<T>(pmf.size());
        double[] probs = new double[pmf.size()];
        for (int i = 0; i < pmf.size(); ++i) {
            double p;
            Pair<T, Double> sample = pmf.get(i);
            this.singletons.add(sample.getKey());
            probs[i] = p = sample.getValue().doubleValue();
        }
        this.probabilities = EnumeratedDistribution.checkAndNormalize(probs);
        this.cumulativeProbabilities = new double[this.probabilities.length];
        double sum = 0.0;
        for (int i = 0; i < this.probabilities.length; ++i) {
            this.cumulativeProbabilities[i] = sum += this.probabilities[i];
        }
    }

    public double probability(T x) {
        double probability = 0.0;
        for (int i = 0; i < this.probabilities.length; ++i) {
            if ((x != null || this.singletons.get(i) != null) && (x == null || !x.equals(this.singletons.get(i)))) continue;
            probability += this.probabilities[i];
        }
        return probability;
    }

    public List<Pair<T, Double>> getPmf() {
        ArrayList<Pair<T, Double>> samples = new ArrayList<Pair<T, Double>>(this.probabilities.length);
        for (int i = 0; i < this.probabilities.length; ++i) {
            samples.add(new Pair<T, Double>(this.singletons.get(i), this.probabilities[i]));
        }
        return samples;
    }

    public static double[] checkAndNormalize(double[] weights) {
        if (weights == null || weights.length == 0) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.ARRAY_ZERO_LENGTH_OR_NULL_NOT_ALLOWED, new Object[0]);
        }
        int len = weights.length;
        double sumWt = 0.0;
        boolean posWt = false;
        for (int i = 0; i < len; ++i) {
            if (weights[i] < 0.0) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_SMALL, weights[i], 0);
            }
            if (weights[i] > 0.0) {
                posWt = true;
            }
            if (Double.isNaN(weights[i])) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.NAN_ELEMENT_AT_INDEX, i);
            }
            if (Double.isInfinite(weights[i])) {
                throw new MathIllegalArgumentException(LocalizedCoreFormats.INFINITE_ARRAY_ELEMENT, weights[i], i);
            }
            sumWt += weights[i];
        }
        if (!posWt) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.WEIGHT_AT_LEAST_ONE_NON_ZERO, new Object[0]);
        }
        double[] normWt = null;
        if (Precision.equals(sumWt, 1.0, 10)) {
            normWt = weights;
        } else {
            normWt = new double[len];
            for (int i = 0; i < len; ++i) {
                normWt[i] = weights[i] / sumWt;
            }
        }
        return normWt;
    }
}

