/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.differentiation;

import org.hipparchus.analysis.MultivariateVectorFunction;
import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.analysis.differentiation.MultivariateDifferentiableFunction;

public class GradientFunction
implements MultivariateVectorFunction {
    private final MultivariateDifferentiableFunction f;

    public GradientFunction(MultivariateDifferentiableFunction f) {
        this.f = f;
    }

    @Override
    public double[] value(double[] point) {
        DSFactory factory = new DSFactory(point.length, 1);
        DerivativeStructure[] dsX = new DerivativeStructure[point.length];
        for (int i = 0; i < point.length; ++i) {
            dsX[i] = factory.variable(i, point[i]);
        }
        DerivativeStructure dsY = this.f.value(dsX);
        double[] y = new double[point.length];
        int[] orders = new int[point.length];
        for (int i = 0; i < point.length; ++i) {
            orders[i] = 1;
            y[i] = dsY.getPartialDerivative(orders);
            orders[i] = 0;
        }
        return y;
    }
}

