/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.EOPHistory;
import org.orekit.frames.FramesFactory;
import org.orekit.time.BDTScale;
import org.orekit.time.GLONASSScale;
import org.orekit.time.GMSTScale;
import org.orekit.time.GPSScale;
import org.orekit.time.GalileoScale;
import org.orekit.time.IRNSSScale;
import org.orekit.time.OffsetModel;
import org.orekit.time.QZSSScale;
import org.orekit.time.TAIScale;
import org.orekit.time.TAIUTCDatFilesLoader;
import org.orekit.time.TCBScale;
import org.orekit.time.TCGScale;
import org.orekit.time.TDBScale;
import org.orekit.time.TTScale;
import org.orekit.time.UT1Scale;
import org.orekit.time.UTCScale;
import org.orekit.time.UTCTAIHistoryFilesLoader;
import org.orekit.time.UTCTAIOffsetsLoader;
import org.orekit.utils.IERSConventions;

public class TimeScalesFactory
implements Serializable {
    private static final long serialVersionUID = 20130807L;
    private static TAIScale tai = null;
    private static UTCScale utc = null;
    private static Map<IERSConventions, UT1Scale> ut1MapSimpleEOP = new HashMap<IERSConventions, UT1Scale>();
    private static Map<IERSConventions, UT1Scale> ut1MapCompleteEOP = new HashMap<IERSConventions, UT1Scale>();
    private static TTScale tt = null;
    private static GalileoScale gst = null;
    private static GLONASSScale glonass = null;
    private static QZSSScale qzss = null;
    private static GPSScale gps = null;
    private static TCGScale tcg = null;
    private static TDBScale tdb = null;
    private static TCBScale tcb = null;
    private static GMSTScale gmst = null;
    private static List<UTCTAIOffsetsLoader> loaders = new ArrayList<UTCTAIOffsetsLoader>();
    private static IRNSSScale irnss = null;
    private static BDTScale bds = null;

    private TimeScalesFactory() {
    }

    public static void addUTCTAIOffsetsLoader(UTCTAIOffsetsLoader loader) {
        loaders.add(loader);
    }

    public static void addDefaultUTCTAIOffsetsLoaders() {
        TimeScalesFactory.addUTCTAIOffsetsLoader(new TAIUTCDatFilesLoader("^tai-utc\\.dat$"));
        TimeScalesFactory.addUTCTAIOffsetsLoader(new UTCTAIHistoryFilesLoader());
    }

    public static void clearUTCTAIOffsetsLoaders() {
        loaders.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TAIScale getTAI() {
        Class<TimeScalesFactory> clazz = TimeScalesFactory.class;
        synchronized (TimeScalesFactory.class) {
            if (tai == null) {
                tai = new TAIScale();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return tai;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UTCScale getUTC() throws OrekitException {
        Class<TimeScalesFactory> clazz = TimeScalesFactory.class;
        synchronized (TimeScalesFactory.class) {
            if (utc == null) {
                UTCTAIOffsetsLoader loader;
                List<OffsetModel> entries = null;
                if (loaders.isEmpty()) {
                    TimeScalesFactory.addDefaultUTCTAIOffsetsLoaders();
                }
                Iterator<UTCTAIOffsetsLoader> iterator = loaders.iterator();
                while (iterator.hasNext() && (entries = (loader = iterator.next()).loadOffsets()).isEmpty()) {
                }
                if (entries.isEmpty()) {
                    throw new OrekitException((Localizable)OrekitMessages.NO_IERS_UTC_TAI_HISTORY_DATA_LOADED, new Object[0]);
                }
                utc = new UTCScale(entries);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return utc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UT1Scale getUT1(IERSConventions conventions, boolean simpleEOP) throws OrekitException {
        Class<TimeScalesFactory> clazz = TimeScalesFactory.class;
        synchronized (TimeScalesFactory.class) {
            Map<IERSConventions, UT1Scale> map = simpleEOP ? ut1MapSimpleEOP : ut1MapCompleteEOP;
            UT1Scale ut1 = map.get((Object)conventions);
            if (ut1 == null) {
                ut1 = TimeScalesFactory.getUT1(FramesFactory.getEOPHistory(conventions, simpleEOP));
                map.put(conventions, ut1);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ut1;
        }
    }

    public static UT1Scale getUT1(EOPHistory history) throws OrekitException {
        return new UT1Scale(history, TimeScalesFactory.getUTC());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TTScale getTT() {
        Class<TimeScalesFactory> clazz = TimeScalesFactory.class;
        synchronized (TimeScalesFactory.class) {
            if (tt == null) {
                tt = new TTScale();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return tt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GalileoScale getGST() {
        Class<TimeScalesFactory> clazz = TimeScalesFactory.class;
        synchronized (TimeScalesFactory.class) {
            if (gst == null) {
                gst = new GalileoScale();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return gst;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GLONASSScale getGLONASS() throws OrekitException {
        Class<TimeScalesFactory> clazz = TimeScalesFactory.class;
        synchronized (TimeScalesFactory.class) {
            if (glonass == null) {
                glonass = new GLONASSScale(TimeScalesFactory.getUTC());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return glonass;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QZSSScale getQZSS() {
        Class<TimeScalesFactory> clazz = TimeScalesFactory.class;
        synchronized (TimeScalesFactory.class) {
            if (qzss == null) {
                qzss = new QZSSScale();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return qzss;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GPSScale getGPS() {
        Class<TimeScalesFactory> clazz = TimeScalesFactory.class;
        synchronized (TimeScalesFactory.class) {
            if (gps == null) {
                gps = new GPSScale();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return gps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TCGScale getTCG() {
        Class<TimeScalesFactory> clazz = TimeScalesFactory.class;
        synchronized (TimeScalesFactory.class) {
            if (tcg == null) {
                tcg = new TCGScale();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return tcg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TDBScale getTDB() {
        Class<TimeScalesFactory> clazz = TimeScalesFactory.class;
        synchronized (TimeScalesFactory.class) {
            if (tdb == null) {
                tdb = new TDBScale();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return tdb;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TCBScale getTCB() {
        Class<TimeScalesFactory> clazz = TimeScalesFactory.class;
        synchronized (TimeScalesFactory.class) {
            if (tcb == null) {
                tcb = new TCBScale(TimeScalesFactory.getTDB());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return tcb;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GMSTScale getGMST(IERSConventions conventions, boolean simpleEOP) throws OrekitException {
        Class<TimeScalesFactory> clazz = TimeScalesFactory.class;
        synchronized (TimeScalesFactory.class) {
            if (gmst == null) {
                gmst = new GMSTScale(TimeScalesFactory.getUT1(conventions, simpleEOP));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return gmst;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRNSSScale getIRNSS() {
        Class<TimeScalesFactory> clazz = TimeScalesFactory.class;
        synchronized (TimeScalesFactory.class) {
            if (irnss == null) {
                irnss = new IRNSSScale();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return irnss;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BDTScale getBDT() {
        Class<TimeScalesFactory> clazz = TimeScalesFactory.class;
        synchronized (TimeScalesFactory.class) {
            if (bds == null) {
                bds = new BDTScale();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return bds;
        }
    }
}

