/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.linear;

import org.hipparchus.FieldElement;
import org.hipparchus.complex.Complex;
import org.hipparchus.complex.ComplexField;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.linear.ArrayFieldVector;
import org.hipparchus.linear.FieldLUDecomposition;
import org.hipparchus.linear.FieldMatrix;
import org.hipparchus.linear.FieldVector;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.SchurTransformer;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.Precision;

public class ComplexEigenDecomposition {
    private static final double EPSILON = 1.0E-12;
    private static final double EPSILON_EQUALS = 1.0E-6;
    private Complex[] eigenvalues;
    private ArrayFieldVector<Complex>[] eigenvectors;
    private FieldMatrix<Complex> V;
    private FieldMatrix<Complex> D;

    public ComplexEigenDecomposition(RealMatrix matrix) {
        if (!matrix.isSquare()) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NON_SQUARE_MATRIX, matrix.getRowDimension(), matrix.getColumnDimension());
        }
        this.findEigenValues(matrix);
        this.findEigenVectors(this.convertToFieldComplex(matrix));
        int m = this.eigenvectors.length;
        this.V = MatrixUtils.createFieldMatrix(ComplexField.getInstance(), m, m);
        for (int k = 0; k < m; ++k) {
            this.V.setColumnVector(k, this.eigenvectors[k]);
        }
        this.D = MatrixUtils.createFieldDiagonalMatrix((FieldElement[])this.eigenvalues);
        this.checkDefinition(matrix);
    }

    public Complex[] getEigenvalues() {
        return (Complex[])this.eigenvalues.clone();
    }

    public FieldVector<Complex> getEigenvector(int i) {
        return this.eigenvectors[i].copy();
    }

    public boolean hasComplexEigenvalues() {
        for (int i = 0; i < this.eigenvalues.length; ++i) {
            if (Precision.equals(this.eigenvalues[i].getImaginary(), 0.0, 1.0E-12)) continue;
            return true;
        }
        return false;
    }

    public double getDeterminant() {
        Complex determinant = new Complex(1.0, 0.0);
        for (Complex lambda : this.eigenvalues) {
            determinant = determinant.multiply(lambda);
        }
        return determinant.getReal();
    }

    public FieldMatrix<Complex> getV() {
        return this.V;
    }

    public FieldMatrix<Complex> getD() {
        return this.D;
    }

    public FieldMatrix<Complex> getVT() {
        return this.V.transpose();
    }

    protected void findEigenValues(RealMatrix matrix) {
        SchurTransformer schurTransform = new SchurTransformer(matrix);
        double[][] matT = schurTransform.getT().getData();
        this.eigenvalues = new Complex[matT.length];
        for (int i = 0; i < this.eigenvalues.length; ++i) {
            if (i == this.eigenvalues.length - 1 || Precision.equals(matT[i + 1][i], 0.0, 1.0E-12)) {
                this.eigenvalues[i] = new Complex(matT[i][i]);
                continue;
            }
            double x = matT[i + 1][i + 1];
            double p = 0.5 * (matT[i][i] - x);
            double z = FastMath.sqrt(FastMath.abs(p * p + matT[i + 1][i] * matT[i][i + 1]));
            this.eigenvalues[i] = new Complex(x + p, z);
            this.eigenvalues[i + 1] = new Complex(x + p, -z);
            ++i;
        }
    }

    protected void findEigenVectors(FieldMatrix<Complex> matrix) {
        int n = this.eigenvalues.length;
        FieldMatrix<Complex> ident = MatrixUtils.createFieldIdentityMatrix(ComplexField.getInstance(), n);
        this.eigenvectors = new ArrayFieldVector[n];
        for (int i = 0; i < this.eigenvalues.length; ++i) {
            Complex eigenValue = this.eigenvalues[i];
            FieldMatrix<Complex> eigv = ident.scalarMultiply(eigenValue.add(1.0E-12));
            FieldMatrix<Complex> Aeigv = matrix.subtract(eigv);
            FieldLUDecomposition<Complex> luDecomp = new FieldLUDecomposition<Complex>(Aeigv);
            FieldMatrix<Complex> inv_Aeigv = luDecomp.getSolver().getInverse();
            FieldElement[] unityVector = new Complex[n];
            for (int k = 0; k < n; ++k) {
                unityVector[k] = new Complex(1.0, 0.0);
            }
            FieldVector<Complex> eigenVector = MatrixUtils.createFieldVector((FieldElement[])unityVector);
            for (int k = 0; k < 2; ++k) {
                FieldVector<Complex> eigenVector_new = inv_Aeigv.operate(eigenVector);
                Complex norm = this.getNormInf(eigenVector_new);
                eigenVector = eigenVector_new.mapDivide(norm);
            }
            eigenVector = eigenVector.mapAdd(Complex.ZERO);
            this.eigenvectors[i] = new ArrayFieldVector((FieldElement[])((Complex[])eigenVector.toArray()));
        }
    }

    private Complex getNormInf(FieldVector<Complex> vector) {
        Complex norm = null;
        for (int i = 0; i < vector.getDimension(); ++i) {
            if (norm == null) {
                norm = vector.getEntry(i);
                continue;
            }
            if (!(norm.abs() < vector.getEntry(i).abs())) continue;
            norm = vector.getEntry(i);
        }
        return norm;
    }

    protected void checkDefinition(RealMatrix matrix) {
        FieldMatrix<Complex> VD;
        FieldMatrix<Complex> matrixC = this.convertToFieldComplex(matrix);
        FieldMatrix<Complex> AV = matrixC.multiply(this.getV());
        if (!this.equalsWithPrecision(AV, VD = this.getV().multiply(this.getD()), 1.0E-6)) {
            throw new MathRuntimeException(LocalizedCoreFormats.FAILED_DECOMPOSITION, matrix.getRowDimension(), matrix.getColumnDimension());
        }
    }

    private boolean equalsWithPrecision(FieldMatrix<Complex> matrix1, FieldMatrix<Complex> matrix2, double tolerance) {
        boolean toRet = true;
        block0: for (int i = 0; i < matrix1.getRowDimension(); ++i) {
            for (int j = 0; j < matrix1.getColumnDimension(); ++j) {
                Complex c2;
                Complex c1 = matrix1.getEntry(i, j);
                if (!(c1.add((c2 = matrix2.getEntry(i, j)).negate()).abs() > tolerance)) continue;
                toRet = false;
                continue block0;
            }
        }
        return toRet;
    }

    private FieldMatrix<Complex> convertToFieldComplex(RealMatrix matrix) {
        FieldMatrix<Complex> toRet = MatrixUtils.createFieldIdentityMatrix(ComplexField.getInstance(), matrix.getRowDimension());
        for (int i = 0; i < toRet.getRowDimension(); ++i) {
            for (int j = 0; j < toRet.getColumnDimension(); ++j) {
                toRet.setEntry(i, j, new Complex(matrix.getEntry(i, j)));
            }
        }
        return toRet;
    }
}

