/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import java.io.Serializable;
import org.hipparchus.RealFieldElement;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeComponents;
import org.orekit.time.TimeScalesFactory;

public interface TimeScale
extends Serializable {
    public double offsetFromTAI(AbsoluteDate var1);

    public <T extends RealFieldElement<T>> T offsetFromTAI(FieldAbsoluteDate<T> var1);

    default public double offsetToTAI(DateComponents date, TimeComponents time) {
        AbsoluteDate reference = new AbsoluteDate(date, time, (TimeScale)TimeScalesFactory.getTAI());
        double offset = 0.0;
        for (int i = 0; i < 8; ++i) {
            offset = -this.offsetFromTAI(reference.shiftedBy(offset));
        }
        return offset;
    }

    default public boolean insideLeap(AbsoluteDate date) {
        return false;
    }

    default public <T extends RealFieldElement<T>> boolean insideLeap(FieldAbsoluteDate<T> date) {
        return false;
    }

    default public int minuteDuration(AbsoluteDate date) {
        return 60;
    }

    default public <T extends RealFieldElement<T>> int minuteDuration(FieldAbsoluteDate<T> date) {
        return 60;
    }

    default public double getLeap(AbsoluteDate date) {
        return 0.0;
    }

    default public <T extends RealFieldElement<T>> T getLeap(FieldAbsoluteDate<T> date) {
        return (T)((RealFieldElement)date.getField().getZero());
    }

    public String getName();
}

