/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.hipparchus.util.FastMath;
import org.orekit.frames.EOPEntry;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateComponents;
import org.orekit.time.TimeComponents;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScalesFactory;
import org.orekit.time.TimeStamped;
import org.orekit.time.UT1Scale;
import org.orekit.utils.IERSConventions;

public class GPSDate
implements Serializable,
TimeStamped {
    private static final long serialVersionUID = 20180633L;
    private static final int WEEK_D = 7;
    private static final double WEEK_S = 604800.0;
    private static final int CYCLE_W = 1024;
    private static final int CYCLE_D = 7168;
    private static final double S_TO_MS = 1000.0;
    private static AtomicReference<DateComponents> rolloverReference = new AtomicReference<Object>(null);
    private final int weekNumber;
    private final double milliInWeek;
    private final transient AbsoluteDate date;

    public GPSDate(int weekNumber, double milliInWeek) {
        int day = (int)FastMath.floor((double)(milliInWeek / 8.64E7));
        double secondsInDay = milliInWeek / 1000.0 - (double)day * 86400.0;
        int w = weekNumber;
        DateComponents dc = new DateComponents(DateComponents.GPS_EPOCH, weekNumber * 7 + day);
        if (weekNumber < 1024) {
            DateComponents reference = rolloverReference.get();
            if (reference == null) {
                UT1Scale ut1 = TimeScalesFactory.getUT1(IERSConventions.IERS_2010, true);
                List<EOPEntry> eop = ut1.getEOPHistory().getEntries();
                int lastMJD = eop.get(eop.size() - 1).getMjd();
                reference = new DateComponents(DateComponents.MODIFIED_JULIAN_EPOCH, lastMJD);
                rolloverReference.compareAndSet(null, reference);
            }
            while (dc.getJ2000Day() < reference.getJ2000Day() - 3584) {
                dc = new DateComponents(dc, 7168);
                w += 1024;
            }
        }
        this.weekNumber = w;
        this.milliInWeek = milliInWeek;
        this.date = new AbsoluteDate(dc, new TimeComponents(secondsInDay), (TimeScale)TimeScalesFactory.getGPS());
    }

    public GPSDate(AbsoluteDate date) {
        this.weekNumber = (int)FastMath.floor((double)(date.durationFrom(AbsoluteDate.GPS_EPOCH) / 604800.0));
        AbsoluteDate weekStart = new AbsoluteDate(AbsoluteDate.GPS_EPOCH, 604800.0 * (double)this.weekNumber);
        this.milliInWeek = date.durationFrom(weekStart) * 1000.0;
        this.date = date;
    }

    public static void setRolloverReference(DateComponents reference) {
        rolloverReference.set(reference);
    }

    public static DateComponents getRolloverReference() {
        return rolloverReference.get();
    }

    public int getWeekNumber() {
        return this.weekNumber;
    }

    public double getMilliInWeek() {
        return this.milliInWeek;
    }

    @Override
    public AbsoluteDate getDate() {
        return this.date;
    }

    private Object writeReplace() {
        return new DataTransferObject(this.weekNumber, this.milliInWeek);
    }

    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 20180633L;
        private final int weekNumber;
        private final double milliInWeek;

        DataTransferObject(int weekNumber, double milliInWeek) {
            this.weekNumber = weekNumber;
            this.milliInWeek = milliInWeek;
        }

        private Object readResolve() {
            return new GPSDate(this.weekNumber, this.milliInWeek);
        }
    }
}

