/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical.tle;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Comparator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.hipparchus.exception.Localizable;
import org.orekit.data.DataLoader;
import org.orekit.data.DataProvidersManager;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.propagation.analytical.tle.TLE;
import org.orekit.propagation.analytical.tle.TLEPropagator;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeStamped;
import org.orekit.utils.PVCoordinates;

@Deprecated
public class TLESeries
implements DataLoader {
    private static final String DEFAULT_SUPPORTED_NAMES = ".*\\.tle$";
    private final String supportedNames;
    private final Set<Integer> availableSatNums;
    private final SortedSet<TimeStamped> tles;
    private int filterSatelliteNumber;
    private int filterLaunchYear;
    private int filterLaunchNumber;
    private String filterLaunchPiece;
    private TLE previous;
    private TLE next;
    private TLE lastTLE;
    private TLEPropagator lastPropagator;
    private AbsoluteDate firstDate;
    private AbsoluteDate lastDate;
    private final boolean ignoreNonTLELines;

    public TLESeries(String supportedNames, boolean ignoreNonTLELines) {
        this.supportedNames = supportedNames == null ? DEFAULT_SUPPORTED_NAMES : supportedNames;
        this.availableSatNums = new TreeSet<Integer>();
        this.ignoreNonTLELines = ignoreNonTLELines;
        this.filterSatelliteNumber = -1;
        this.filterLaunchYear = -1;
        this.filterLaunchNumber = -1;
        this.filterLaunchPiece = null;
        this.tles = new TreeSet<TimeStamped>(new TLEComparator());
        this.previous = null;
        this.next = null;
    }

    public void loadTLEData() {
        this.availableSatNums.clear();
        this.filterSatelliteNumber = -1;
        this.filterLaunchYear = -1;
        this.filterLaunchNumber = -1;
        this.filterLaunchPiece = null;
        this.tles.clear();
        this.previous = null;
        this.next = null;
        DataProvidersManager.getInstance().feed(this.supportedNames, this);
        if (this.tles.isEmpty()) {
            throw new OrekitException((Localizable)OrekitMessages.NO_TLE_DATA_AVAILABLE, new Object[0]);
        }
    }

    public Set<Integer> getAvailableSatelliteNumbers() {
        if (this.availableSatNums.isEmpty()) {
            this.loadTLEData();
        }
        return this.availableSatNums;
    }

    public void loadTLEData(int satelliteNumber) {
        if (satelliteNumber < 0) {
            this.loadTLEData();
        } else {
            this.filterSatelliteNumber = satelliteNumber;
            this.filterLaunchYear = -1;
            this.filterLaunchNumber = -1;
            this.filterLaunchPiece = null;
            this.tles.clear();
            this.previous = null;
            this.next = null;
            DataProvidersManager.getInstance().feed(this.supportedNames, this);
            if (this.tles.isEmpty()) {
                throw new OrekitException((Localizable)OrekitMessages.NO_TLE_FOR_OBJECT, satelliteNumber);
            }
        }
    }

    public void loadTLEData(int launchYear, int launchNumber, String launchPiece) {
        if (launchYear < 0 || launchNumber < 0 || launchPiece == null || launchPiece.length() == 0) {
            this.loadTLEData();
        } else {
            this.filterSatelliteNumber = -1;
            this.filterLaunchYear = launchYear;
            this.filterLaunchNumber = launchNumber;
            this.filterLaunchPiece = launchPiece;
            this.tles.clear();
            this.previous = null;
            this.next = null;
            DataProvidersManager.getInstance().feed(this.supportedNames, this);
            if (this.tles.isEmpty()) {
                throw new OrekitException((Localizable)OrekitMessages.NO_TLE_FOR_LAUNCH_YEAR_NUMBER_PIECE, launchYear, launchNumber, launchPiece);
            }
        }
    }

    @Override
    public boolean stillAcceptsData() {
        return this.tles.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void loadData(InputStream input, String name) throws IOException, OrekitException {
        try (BufferedReader r = new BufferedReader(new InputStreamReader(input, "UTF-8"));){
            int lineNumber = 0;
            String pendingLine = null;
            String line = r.readLine();
            while (line != null) {
                ++lineNumber;
                if (pendingLine == null) {
                    pendingLine = line;
                } else if (!TLE.isFormatOK(pendingLine, line)) {
                    if (!this.ignoreNonTLELines) throw new OrekitException((Localizable)OrekitMessages.NOT_TLE_LINES, lineNumber - 1, lineNumber, pendingLine, line);
                    pendingLine = line;
                } else {
                    TLE tle = new TLE(pendingLine, line);
                    if (this.filterSatelliteNumber < 0 && (this.filterLaunchYear < 0 || tle.getLaunchYear() == this.filterLaunchYear && tle.getLaunchNumber() == this.filterLaunchNumber && tle.getLaunchPiece().equals(this.filterLaunchPiece))) {
                        this.filterSatelliteNumber = tle.getSatelliteNumber();
                    }
                    this.availableSatNums.add(tle.getSatelliteNumber());
                    if (tle.getSatelliteNumber() == this.filterSatelliteNumber) {
                        this.tles.add(tle);
                    }
                    pendingLine = null;
                }
                line = r.readLine();
            }
            if (pendingLine == null || this.ignoreNonTLELines) return;
            throw new OrekitException((Localizable)OrekitMessages.MISSING_SECOND_TLE_LINE, lineNumber, pendingLine);
        }
    }

    public PVCoordinates getPVCoordinates(AbsoluteDate date) {
        TLE toExtrapolate = this.getClosestTLE(date);
        if (toExtrapolate != this.lastTLE) {
            this.lastTLE = toExtrapolate;
            this.lastPropagator = TLEPropagator.selectExtrapolator(this.lastTLE);
        }
        return this.lastPropagator.getPVCoordinates(date);
    }

    public TLE getClosestTLE(AbsoluteDate date) {
        if (this.previous != null && date.durationFrom(this.previous.getDate()) >= 0.0 && this.next != null && date.durationFrom(this.next.getDate()) <= 0.0) {
            if (this.next.getDate().durationFrom(date) > date.durationFrom(this.previous.getDate())) {
                return this.previous;
            }
            return this.next;
        }
        this.previous = null;
        this.next = null;
        SortedSet<TimeStamped> headSet = this.tles.headSet(date);
        SortedSet<TimeStamped> tailSet = this.tles.tailSet(date);
        if (headSet.isEmpty()) {
            return (TLE)tailSet.first();
        }
        if (tailSet.isEmpty()) {
            return (TLE)headSet.last();
        }
        this.previous = (TLE)headSet.last();
        this.next = (TLE)tailSet.first();
        if (this.next.getDate().durationFrom(date) > date.durationFrom(this.previous.getDate())) {
            return this.previous;
        }
        return this.next;
    }

    public AbsoluteDate getFirstDate() {
        if (this.firstDate == null) {
            this.firstDate = this.tles.first().getDate();
        }
        return this.firstDate;
    }

    public AbsoluteDate getLastDate() {
        if (this.lastDate == null) {
            this.lastDate = this.tles.last().getDate();
        }
        return this.lastDate;
    }

    public TLE getFirst() {
        return (TLE)this.tles.first();
    }

    public TLE getLast() {
        return (TLE)this.tles.last();
    }

    private static class TLEComparator
    implements Comparator<TimeStamped> {
        private TLEComparator() {
        }

        @Override
        public int compare(TimeStamped timeStamped1, TimeStamped timeStamped2) {
            int dateCompare = timeStamped1.getDate().compareTo(timeStamped2.getDate());
            if (dateCompare == 0 && timeStamped1 instanceof TLE && timeStamped2 instanceof TLE) {
                try {
                    TLE tle1 = (TLE)timeStamped1;
                    TLE tle2 = (TLE)timeStamped2;
                    int line1Compare = tle1.getLine1().compareTo(tle2.getLine1());
                    return line1Compare == 0 ? tle1.getLine2().compareTo(tle2.getLine2()) : line1Compare;
                }
                catch (OrekitException oe) {
                    throw new OrekitInternalError(oe);
                }
            }
            return dateCompare;
        }
    }
}

