/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.FastMath;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.BoundedPropagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.analytical.AbstractAnalyticalPropagator;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ImmutableTimeStampedCache;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedPVCoordinates;

public class Ephemeris
extends AbstractAnalyticalPropagator
implements BoundedPropagator,
Serializable {
    public static final double DEFAULT_EXTRAPOLATION_THRESHOLD_SEC = 0.001;
    private static final long serialVersionUID = 20170606L;
    private final AbsoluteDate minDate;
    private final AbsoluteDate maxDate;
    private final double extrapolationThreshold;
    private final Frame frame;
    private final String[] additional;
    private LocalPVProvider pvProvider;
    private final transient ImmutableTimeStampedCache<SpacecraftState> cache;

    public Ephemeris(List<SpacecraftState> states, int interpolationPoints) throws MathIllegalArgumentException {
        this(states, interpolationPoints, 0.001);
    }

    public Ephemeris(List<SpacecraftState> states, int interpolationPoints, double extrapolationThreshold) throws MathIllegalArgumentException {
        super(DEFAULT_LAW);
        if (states.size() < interpolationPoints) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.INSUFFICIENT_DIMENSION, new Object[]{states.size(), interpolationPoints});
        }
        SpacecraftState s0 = states.get(0);
        this.minDate = s0.getDate();
        this.maxDate = states.get(states.size() - 1).getDate();
        this.frame = s0.getFrame();
        Set<String> names0 = s0.getAdditionalStates().keySet();
        this.additional = names0.toArray(new String[names0.size()]);
        for (SpacecraftState state : states) {
            s0.ensureCompatibleAdditionalStates(state);
        }
        this.pvProvider = new LocalPVProvider();
        this.setAttitudeProvider(null);
        this.cache = new ImmutableTimeStampedCache<SpacecraftState>(interpolationPoints, states);
        this.extrapolationThreshold = extrapolationThreshold;
    }

    @Override
    public AbsoluteDate getMinDate() {
        return this.minDate;
    }

    @Override
    public AbsoluteDate getMaxDate() {
        return this.maxDate;
    }

    public double getExtrapolationThreshold() {
        return this.extrapolationThreshold;
    }

    @Override
    public Frame getFrame() {
        return this.frame;
    }

    @Override
    public SpacecraftState basicPropagate(AbsoluteDate date) {
        AbsoluteDate central = date.compareTo(this.minDate) < 0 && FastMath.abs((double)date.durationFrom(this.minDate)) <= this.extrapolationThreshold ? this.minDate : (date.compareTo(this.maxDate) > 0 && FastMath.abs((double)date.durationFrom(this.maxDate)) <= this.extrapolationThreshold ? this.maxDate : date);
        List neighbors = this.cache.getNeighbors(central).collect(Collectors.toList());
        SpacecraftState evaluatedState = (SpacecraftState)((SpacecraftState)neighbors.get(0)).interpolate(date, neighbors);
        AttitudeProvider attitudeProvider = this.getAttitudeProvider();
        if (attitudeProvider == null) {
            return evaluatedState;
        }
        this.pvProvider.setCurrentState(evaluatedState);
        Attitude calculatedAttitude = attitudeProvider.getAttitude(this.pvProvider, date, evaluatedState.getFrame());
        return new SpacecraftState(evaluatedState.getOrbit(), calculatedAttitude, evaluatedState.getMass());
    }

    @Override
    protected Orbit propagateOrbit(AbsoluteDate date) {
        return this.basicPropagate(date).getOrbit();
    }

    @Override
    protected double getMass(AbsoluteDate date) {
        return this.basicPropagate(date).getMass();
    }

    @Override
    public TimeStampedPVCoordinates getPVCoordinates(AbsoluteDate date, Frame f) {
        return this.propagate(date).getPVCoordinates(f);
    }

    @Override
    public void resetInitialState(SpacecraftState state) {
        throw new OrekitException((Localizable)OrekitMessages.NON_RESETABLE_STATE, new Object[0]);
    }

    @Override
    protected void resetIntermediateState(SpacecraftState state, boolean forward) {
        throw new OrekitException((Localizable)OrekitMessages.NON_RESETABLE_STATE, new Object[0]);
    }

    @Override
    public SpacecraftState getInitialState() {
        return this.basicPropagate(this.getMinDate());
    }

    @Override
    public boolean isAdditionalStateManaged(String name) {
        if (super.isAdditionalStateManaged(name)) {
            return true;
        }
        for (String a : this.additional) {
            if (!a.equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getManagedAdditionalStates() {
        String[] upperManaged = super.getManagedAdditionalStates();
        String[] managed = new String[upperManaged.length + this.additional.length];
        System.arraycopy(upperManaged, 0, managed, 0, upperManaged.length);
        System.arraycopy(this.additional, 0, managed, upperManaged.length, this.additional.length);
        return managed;
    }

    private Object writeReplace() {
        return new DataTransferObject(this.cache.getAll(), this.cache.getNeighborsSize(), this.extrapolationThreshold);
    }

    private static class LocalPVProvider
    implements PVCoordinatesProvider,
    Serializable {
        private static final long serialVersionUID = 20160115L;
        private SpacecraftState currentState;

        private LocalPVProvider() {
        }

        public SpacecraftState getCurrentState() {
            return this.currentState;
        }

        public void setCurrentState(SpacecraftState state) {
            this.currentState = state;
        }

        @Override
        public TimeStampedPVCoordinates getPVCoordinates(AbsoluteDate date, Frame f) {
            double dt = this.getCurrentState().getDate().durationFrom(date);
            double closeEnoughTimeInSec = 1.0E-9;
            if (FastMath.abs((double)dt) > 1.0E-9) {
                throw new OrekitException((Localizable)LocalizedCoreFormats.OUT_OF_RANGE_SIMPLE, FastMath.abs((double)dt), 0.0, 1.0E-9);
            }
            return this.getCurrentState().getPVCoordinates(f);
        }
    }

    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 20170606L;
        private final List<SpacecraftState> states;
        private final int interpolationPoints;
        private final double extrapolationThreshold;

        private DataTransferObject(List<SpacecraftState> states, int interpolationPoints, double extrapolationThreshold) {
            this.states = states;
            this.interpolationPoints = interpolationPoints;
            this.extrapolationThreshold = extrapolationThreshold;
        }

        private Object readResolve() {
            try {
                return new Ephemeris(this.states, this.interpolationPoints, this.extrapolationThreshold);
            }
            catch (OrekitException oe) {
                throw new OrekitInternalError(oe);
            }
        }
    }
}

