/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth;

import java.util.Collections;
import java.util.List;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.util.MathArrays;
import org.orekit.models.earth.DiscreteTroposphericModel;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ParameterDriver;

public interface TroposphericModel
extends DiscreteTroposphericModel {
    public double pathDelay(double var1, double var3);

    default public <T extends RealFieldElement<T>> T pathDelay(T elevation, T height) {
        RealFieldElement zero = (RealFieldElement)height.getField().getZero();
        return (T)((RealFieldElement)zero.add(this.pathDelay(elevation.getReal(), height.getReal())));
    }

    @Override
    default public double pathDelay(double elevation, double height, double[] parameters, AbsoluteDate date) {
        return this.pathDelay(elevation, height);
    }

    @Override
    default public <T extends RealFieldElement<T>> T pathDelay(T elevation, T height, T[] parameters, FieldAbsoluteDate<T> date) {
        return this.pathDelay(elevation, height);
    }

    @Override
    default public double[] computeZenithDelay(double height, double[] parameters, AbsoluteDate date) {
        return new double[]{this.pathDelay(1.5707963267948966, height), 0.0};
    }

    @Override
    default public <T extends RealFieldElement<T>> T[] computeZenithDelay(T height, T[] parameters, FieldAbsoluteDate<T> date) {
        Field field = height.getField();
        RealFieldElement zero = (RealFieldElement)field.getZero();
        RealFieldElement[] delay = (RealFieldElement[])MathArrays.buildArray((Field)field, (int)2);
        delay[0] = this.pathDelay((RealFieldElement)zero.add(1.5707963267948966), height);
        delay[1] = zero;
        return delay;
    }

    @Override
    default public double[] mappingFactors(double elevation, double height, double[] parameters, AbsoluteDate date) {
        return new double[]{1.0, 1.0};
    }

    @Override
    default public <T extends RealFieldElement<T>> T[] mappingFactors(T elevation, T height, T[] parameters, FieldAbsoluteDate<T> date) {
        Field<T> field = date.getField();
        RealFieldElement one = (RealFieldElement)field.getOne();
        RealFieldElement[] factors = (RealFieldElement[])MathArrays.buildArray(field, (int)2);
        factors[0] = one;
        factors[1] = one;
        return factors;
    }

    @Override
    default public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }
}

