/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth;

import java.io.Serializable;
import java.util.Arrays;
import org.hipparchus.analysis.BivariateFunction;
import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.analysis.interpolation.LinearInterpolator;
import org.hipparchus.analysis.polynomials.PolynomialFunction;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.data.DataProvidersManager;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.models.earth.TroposphericModel;
import org.orekit.utils.InterpolationTableLoader;

public class SaastamoinenModel
implements TroposphericModel {
    public static final String DELTA_R_FILE_NAME = "^saastamoinen-correction\\.txt$";
    private static final long serialVersionUID = 20160126L;
    private static final double[] X_VALUES_FOR_B = new double[]{0.0, 0.5, 1.0, 1.5, 2.0, 2.5, 3.0, 4.0, 5.0};
    private static final double[] Y_VALUES_FOR_B = new double[]{1.156, 1.079, 1.006, 0.938, 0.874, 0.813, 0.757, 0.654, 0.563};
    private static final double[] E_COEFFICIENTS = new double[]{-37.2465, 0.213166, -2.56908E-4};
    private final transient UnivariateFunction bFunction;
    private final transient PolynomialFunction eFunction;
    private final transient BilinearInterpolatingFunction deltaRFunction;
    private double t0;
    private double p0;
    private double r0;

    public SaastamoinenModel(double t0, double p0, double r0, String deltaRFileName) {
        this(t0, p0, r0, deltaRFileName == null ? SaastamoinenModel.defaultDeltaR() : SaastamoinenModel.loadDeltaR(deltaRFileName));
    }

    private SaastamoinenModel(double t0, double p0, double r0, BilinearInterpolatingFunction deltaR) {
        this.t0 = t0;
        this.p0 = p0;
        this.r0 = r0;
        this.bFunction = new LinearInterpolator().interpolate(X_VALUES_FOR_B, Y_VALUES_FOR_B);
        this.eFunction = new PolynomialFunction(E_COEFFICIENTS);
        this.deltaRFunction = deltaR;
    }

    public static SaastamoinenModel getStandardModel() {
        return new SaastamoinenModel(291.16, 1013.25, 0.5, (String)null);
    }

    @Override
    public double pathDelay(double elevation, double height) {
        double fixedHeight = FastMath.max((double)0.0, (double)height);
        double T = this.t0 - 0.0065 * fixedHeight;
        double P = this.p0 * FastMath.pow((double)(1.0 - 2.26E-5 * fixedHeight), (double)5.225);
        double R = this.r0 * FastMath.exp((double)(-6.396E-4 * fixedHeight));
        double B = this.bFunction.value(fixedHeight / 1000.0);
        double e = R * FastMath.exp((double)this.eFunction.value(T));
        double z = FastMath.abs((double)(1.5707963267948966 - elevation));
        double deltaR = this.getDeltaR(fixedHeight, z);
        double tan = FastMath.tan((double)z);
        double delta = 0.002277 / FastMath.cos((double)z) * (P + (1255.0 / T + 0.05) * e - B * tan * tan) + deltaR;
        return delta;
    }

    private double getDeltaR(double height, double zenith) {
        double h = FastMath.min((double)FastMath.max((double)0.0, (double)height), (double)5000.0);
        double z = FastMath.min((double)Math.abs(zenith), (double)1.5707963267948966);
        return this.deltaRFunction.value(h, z);
    }

    private static BilinearInterpolatingFunction loadDeltaR(String deltaRFileName) {
        InterpolationTableLoader loader = new InterpolationTableLoader();
        DataProvidersManager.getInstance().feed(deltaRFileName, loader);
        if (!loader.stillAcceptsData()) {
            double[] elevations = loader.getOrdinateGrid();
            for (int i = 0; i < elevations.length; ++i) {
                elevations[i] = FastMath.toRadians((double)elevations[i]);
            }
            return new BilinearInterpolatingFunction(loader.getAbscissaGrid(), elevations, loader.getValuesSamples());
        }
        throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_FIND_FILE, deltaRFileName.replaceAll("^\\^", "").replaceAll("\\$$", ""));
    }

    private static BilinearInterpolatingFunction defaultDeltaR() {
        double[] xValForR = new double[]{0.0, 500.0, 1000.0, 1500.0, 2000.0, 3000.0, 4000.0, 5000.0};
        double[] yValForR = new double[]{FastMath.toRadians((double)0.0), FastMath.toRadians((double)60.0), FastMath.toRadians((double)66.0), FastMath.toRadians((double)70.0), FastMath.toRadians((double)73.0), FastMath.toRadians((double)75.0), FastMath.toRadians((double)76.0), FastMath.toRadians((double)77.0), FastMath.toRadians((double)78.0), FastMath.toRadians((double)78.5), FastMath.toRadians((double)79.0), FastMath.toRadians((double)79.5), FastMath.toRadians((double)79.75), FastMath.toRadians((double)80.0), FastMath.toRadians((double)90.0)};
        double[][] fval = new double[][]{{0.0, 0.003, 0.006, 0.012, 0.02, 0.031, 0.039, 0.05, 0.065, 0.075, 0.087, 0.102, 0.111, 0.121, 0.121}, {0.0, 0.003, 0.006, 0.011, 0.018, 0.028, 0.035, 0.045, 0.059, 0.068, 0.079, 0.093, 0.101, 0.11, 0.11}, {0.0, 0.002, 0.005, 0.01, 0.017, 0.025, 0.032, 0.041, 0.054, 0.062, 0.072, 0.085, 0.092, 0.1, 0.1}, {0.0, 0.002, 0.005, 0.009, 0.015, 0.023, 0.029, 0.037, 0.049, 0.056, 0.065, 0.077, 0.083, 0.091, 0.091}, {0.0, 0.002, 0.004, 0.008, 0.013, 0.021, 0.026, 0.033, 0.044, 0.051, 0.059, 0.07, 0.076, 0.083, 0.083}, {0.0, 0.002, 0.003, 0.006, 0.011, 0.017, 0.021, 0.027, 0.036, 0.042, 0.049, 0.058, 0.063, 0.068, 0.068}, {0.0, 0.001, 0.003, 0.005, 0.009, 0.014, 0.017, 0.022, 0.03, 0.034, 0.04, 0.047, 0.052, 0.056, 0.056}, {0.0, 0.001, 0.002, 0.004, 0.007, 0.011, 0.014, 0.018, 0.024, 0.028, 0.033, 0.039, 0.043, 0.047, 0.047}};
        return new BilinearInterpolatingFunction(xValForR, yValForR, fval);
    }

    private Object writeReplace() {
        return new DataTransferObject(this);
    }

    private static class BilinearInterpolatingFunction
    implements BivariateFunction {
        private static final int MIN_NUM_POINTS = 2;
        private final double[] xval;
        private final double[] yval;
        private final double[][] fval;

        BilinearInterpolatingFunction(double[] x, double[] y, double[][] f) throws MathIllegalArgumentException {
            if (x == null || y == null || f == null || f[0] == null) {
                throw new IllegalArgumentException("All arguments must be non-null");
            }
            int xLen = x.length;
            int yLen = y.length;
            if (xLen == 0 || yLen == 0 || f.length == 0 || f[0].length == 0) {
                throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.NO_DATA, new Object[0]);
            }
            if (xLen < 2 || yLen < 2 || f.length < 2 || f[0].length < 2) {
                throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.INSUFFICIENT_DATA, new Object[0]);
            }
            if (xLen != f.length) {
                throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, new Object[]{xLen, f.length});
            }
            if (yLen != f[0].length) {
                throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, new Object[]{yLen, f[0].length});
            }
            MathArrays.checkOrder((double[])x);
            MathArrays.checkOrder((double[])y);
            this.xval = (double[])x.clone();
            this.yval = (double[])y.clone();
            this.fval = (double[][])f.clone();
        }

        public double value(double x, double y) {
            boolean offset = true;
            int count = 2;
            int i = this.searchIndex(x, this.xval, 1, 2);
            int j = this.searchIndex(y, this.yval, 1, 2);
            double x1 = this.xval[i];
            double x2 = this.xval[i + 1];
            double y1 = this.yval[j];
            double y2 = this.yval[j + 1];
            double fQ11 = this.fval[i][j];
            double fQ21 = this.fval[i + 1][j];
            double fQ12 = this.fval[i][j + 1];
            double fQ22 = this.fval[i + 1][j + 1];
            double f = (fQ11 * (x2 - x) * (y2 - y) + fQ21 * (x - x1) * (y2 - y) + fQ12 * (x2 - x) * (y - y1) + fQ22 * (x - x1) * (y - y1)) / ((x2 - x1) * (y2 - y1));
            return f;
        }

        private int searchIndex(double c, double[] val, int offset, int count) throws MathIllegalArgumentException {
            int r = Arrays.binarySearch(val, c);
            if (r == -1 || r == -val.length - 1) {
                throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.OUT_OF_RANGE_SIMPLE, new Object[]{c, val[0], val[val.length - 1]});
            }
            r = r < 0 ? -r - offset - 1 : (r -= offset);
            if (r < 0) {
                r = 0;
            }
            if (r + count >= val.length) {
                r = val.length - count;
            }
            return r;
        }
    }

    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 20160126L;
        private double t0;
        private double p0;
        private double r0;
        private final double[] xval;
        private final double[] yval;
        private final double[][] fval;

        DataTransferObject(SaastamoinenModel model) {
            this.t0 = model.t0;
            this.p0 = model.p0;
            this.r0 = model.r0;
            this.xval = (double[])model.deltaRFunction.xval.clone();
            this.yval = (double[])model.deltaRFunction.yval.clone();
            this.fval = (double[][])model.deltaRFunction.fval.clone();
        }

        private Object readResolve() {
            return new SaastamoinenModel(this.t0, this.p0, this.r0, new BilinearInterpolatingFunction(this.xval, this.yval, this.fval));
        }
    }
}

