/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.Keyword;

class KeyValue {
    private final Pattern PATTERN = Pattern.compile("\\p{Space}*([A-Z][A-Z_0-9]*)\\p{Space}*=?\\p{Space}*(.*?)\\p{Space}*(?:\\[.*\\])?\\p{Space}*");
    private final Pattern USER_DEFINED_KEYWORDS = Pattern.compile("USER_DEFINED_[A-Z][A-Z_]*");
    private final String line;
    private final int lineNumber;
    private final String fileName;
    private final Keyword keyword;
    private final String key;
    private final String value;

    KeyValue(String line, int lineNumber, String fileName) {
        this.line = line;
        this.lineNumber = lineNumber;
        this.fileName = fileName;
        Matcher matcher = this.PATTERN.matcher(line);
        if (matcher.matches()) {
            Keyword recognized;
            this.key = matcher.group(1);
            String rawValue = matcher.group(2);
            try {
                recognized = Keyword.valueOf(this.key);
            }
            catch (IllegalArgumentException iae) {
                recognized = this.USER_DEFINED_KEYWORDS.matcher(this.key).matches() ? Keyword.USER_DEFINED_X : null;
            }
            this.keyword = recognized;
            this.value = recognized == Keyword.COMMENT ? rawValue : rawValue.toUpperCase(Locale.US).replace('_', ' ').replaceAll("\\p{Space}+", " ");
        } else {
            this.value = this.key = "";
            this.keyword = null;
        }
    }

    KeyValue(Keyword keyword, String value, String line, int lineNumber, String fileName) {
        this.keyword = keyword;
        this.key = keyword.name();
        this.value = value;
        this.lineNumber = lineNumber;
        this.line = line;
        this.fileName = fileName;
    }

    public Keyword getKeyword() {
        return this.keyword;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public double getDoubleValue() {
        try {
            return Double.parseDouble(this.value);
        }
        catch (NumberFormatException nfe) {
            throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, this.lineNumber, this.fileName, this.line);
        }
    }

    public int getIntegerValue() {
        try {
            return Integer.parseInt(this.value);
        }
        catch (NumberFormatException nfe) {
            throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_PARSE_LINE_IN_FILE, this.lineNumber, this.fileName, this.line);
        }
    }
}

