/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.euclidean.twod;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.VectorFormat;
import org.hipparchus.geometry.euclidean.twod.Euclidean2D;
import org.hipparchus.geometry.euclidean.twod.Vector2D;
import org.hipparchus.util.CompositeFormat;

public class Vector2DFormat
extends VectorFormat<Euclidean2D> {
    public Vector2DFormat() {
        super("{", "}", "; ", CompositeFormat.getDefaultNumberFormat());
    }

    public Vector2DFormat(NumberFormat format) {
        super("{", "}", "; ", format);
    }

    public Vector2DFormat(String prefix, String suffix, String separator) {
        super(prefix, suffix, separator, CompositeFormat.getDefaultNumberFormat());
    }

    public Vector2DFormat(String prefix, String suffix, String separator, NumberFormat format) {
        super(prefix, suffix, separator, format);
    }

    public static Vector2DFormat getVector2DFormat() {
        return Vector2DFormat.getVector2DFormat(Locale.getDefault());
    }

    @Deprecated
    public static Vector2DFormat getInstance() {
        return Vector2DFormat.getVector2DFormat();
    }

    public static Vector2DFormat getVector2DFormat(Locale locale) {
        return new Vector2DFormat(CompositeFormat.getDefaultNumberFormat((Locale)locale));
    }

    @Deprecated
    public static Vector2DFormat getInstance(Locale locale) {
        return Vector2DFormat.getVector2DFormat(locale);
    }

    @Override
    public StringBuffer format(Vector<Euclidean2D> vector, StringBuffer toAppendTo, FieldPosition pos) {
        Vector2D p2 = (Vector2D)vector;
        return this.format(toAppendTo, pos, p2.getX(), p2.getY());
    }

    public Vector2D parse(String source) throws MathIllegalStateException {
        ParsePosition parsePosition = new ParsePosition(0);
        Vector2D result = this.parse(source, parsePosition);
        if (parsePosition.getIndex() == 0) {
            throw new MathIllegalStateException((Localizable)LocalizedCoreFormats.CANNOT_PARSE_AS_TYPE, new Object[]{source, parsePosition.getErrorIndex(), Vector2D.class});
        }
        return result;
    }

    public Vector2D parse(String source, ParsePosition pos) {
        double[] coordinates = this.parseCoordinates(2, source, pos);
        if (coordinates == null) {
            return null;
        }
        return new Vector2D(coordinates[0], coordinates[1]);
    }
}

