/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.NavigableSet;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.AdditionalStateProvider;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.analytical.AbstractAnalyticalPropagator;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.TimeSpanMap;

public class KeplerianPropagator
extends AbstractAnalyticalPropagator
implements Serializable {
    private static final long serialVersionUID = 20151117L;
    private SpacecraftState initialState;
    private transient TimeSpanMap<SpacecraftState> states;

    public KeplerianPropagator(Orbit initialOrbit) {
        this(initialOrbit, DEFAULT_LAW, initialOrbit.getMu(), 1000.0);
    }

    public KeplerianPropagator(Orbit initialOrbit, double mu) {
        this(initialOrbit, DEFAULT_LAW, mu, 1000.0);
    }

    public KeplerianPropagator(Orbit initialOrbit, AttitudeProvider attitudeProv) {
        this(initialOrbit, attitudeProv, initialOrbit.getMu(), 1000.0);
    }

    public KeplerianPropagator(Orbit initialOrbit, AttitudeProvider attitudeProv, double mu) {
        this(initialOrbit, attitudeProv, mu, 1000.0);
    }

    public KeplerianPropagator(Orbit initialOrbit, AttitudeProvider attitudeProv, double mu, double mass) {
        super(attitudeProv);
        this.initialState = this.fixState(initialOrbit, this.getAttitudeProvider().getAttitude(initialOrbit, initialOrbit.getDate(), initialOrbit.getFrame()), mass, mu, Collections.emptyMap());
        this.states = new TimeSpanMap<SpacecraftState>(this.initialState);
        super.resetInitialState(this.initialState);
    }

    private SpacecraftState fixState(Orbit orbit, Attitude attitude, double mass, double mu, Map<String, double[]> additionalStates) {
        OrbitType type = orbit.getType();
        double[] stateVector = new double[6];
        type.mapOrbitToArray(orbit, PositionAngle.TRUE, stateVector, null);
        Orbit fixedOrbit = type.mapArrayToOrbit(stateVector, null, PositionAngle.TRUE, orbit.getDate(), mu, orbit.getFrame());
        SpacecraftState fixedState = new SpacecraftState(fixedOrbit, attitude, mass);
        for (Map.Entry<String, double[]> entry : additionalStates.entrySet()) {
            fixedState = fixedState.addAdditionalState(entry.getKey(), entry.getValue());
        }
        return fixedState;
    }

    @Override
    public void resetInitialState(SpacecraftState state) {
        SpacecraftState fixedState;
        double mu = this.initialState == null ? state.getMu() : this.initialState.getMu();
        this.initialState = fixedState = this.fixState(state.getOrbit(), state.getAttitude(), state.getMass(), mu, state.getAdditionalStates());
        this.states = new TimeSpanMap<SpacecraftState>(this.initialState);
        super.resetInitialState(fixedState);
    }

    @Override
    protected void resetIntermediateState(SpacecraftState state, boolean forward) {
        if (forward) {
            this.states.addValidAfter(state, state.getDate());
        } else {
            this.states.addValidBefore(state, state.getDate());
        }
    }

    @Override
    protected Orbit propagateOrbit(AbsoluteDate date) {
        Orbit orbit = this.states.get(date).getOrbit();
        while (!date.equals((orbit = orbit.shiftedBy(date.durationFrom(orbit.getDate()))).getDate())) {
        }
        return orbit;
    }

    @Override
    protected double getMass(AbsoluteDate date) {
        return this.states.get(date).getMass();
    }

    private Object writeReplace() throws NotSerializableException {
        try {
            SpacecraftState[] allStates;
            AbsoluteDate[] transitionDates;
            ArrayList<AdditionalStateProvider> serializableProviders = new ArrayList<AdditionalStateProvider>();
            for (AdditionalStateProvider provider : this.getAdditionalStateProviders()) {
                if (provider instanceof Serializable) {
                    serializableProviders.add(provider);
                    continue;
                }
                throw new NotSerializableException(provider.getClass().getName());
            }
            NavigableSet<TimeSpanMap.Transition<SpacecraftState>> transitions = this.states.getTransitions();
            if (transitions.size() == 1 && ((TimeSpanMap.Transition)transitions.first()).getBefore() == ((TimeSpanMap.Transition)transitions.first()).getAfter()) {
                transitionDates = null;
                allStates = null;
            } else {
                transitionDates = new AbsoluteDate[transitions.size()];
                allStates = new SpacecraftState[transitions.size() + 1];
                int i = 0;
                for (TimeSpanMap.Transition transition : transitions) {
                    if (i == 0) {
                        allStates[i] = (SpacecraftState)transition.getBefore();
                    }
                    transitionDates[i] = transition.getDate();
                    allStates[++i] = (SpacecraftState)transition.getAfter();
                }
            }
            return new DataTransferObject(this.getInitialState().getOrbit(), this.getAttitudeProvider(), this.getInitialState().getMu(), this.getInitialState().getMass(), transitionDates, allStates, serializableProviders.toArray(new AdditionalStateProvider[serializableProviders.size()]));
        }
        catch (OrekitException orekitException) {
            throw new OrekitInternalError(null);
        }
    }

    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 20151202L;
        private final Orbit orbit;
        private final AttitudeProvider attitudeProvider;
        private final double mu;
        private final double mass;
        private final AbsoluteDate[] transitionDates;
        private final SpacecraftState[] allStates;
        private final AdditionalStateProvider[] providers;

        DataTransferObject(Orbit orbit, AttitudeProvider attitudeProvider, double mu, double mass, AbsoluteDate[] transitionDates, SpacecraftState[] allStates, AdditionalStateProvider[] providers) {
            this.orbit = orbit;
            this.attitudeProvider = attitudeProvider;
            this.mu = mu;
            this.mass = mass;
            this.transitionDates = transitionDates;
            this.allStates = allStates;
            this.providers = providers;
        }

        private Object readResolve() {
            try {
                KeplerianPropagator propagator = new KeplerianPropagator(this.orbit, this.attitudeProvider, this.mu, this.mass);
                for (AdditionalStateProvider provider : this.providers) {
                    propagator.addAdditionalStateProvider(provider);
                }
                if (this.transitionDates != null) {
                    propagator.states = new TimeSpanMap<SpacecraftState>(this.allStates[0]);
                    for (int i = 0; i < this.transitionDates.length; ++i) {
                        propagator.states.addValidAfter(this.allStates[i + 1], this.transitionDates[i]);
                    }
                }
                return propagator;
            }
            catch (OrekitException oe) {
                throw new OrekitInternalError(oe);
            }
        }
    }
}

