/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.orbits;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.FDSFactory;
import org.hipparchus.analysis.differentiation.FieldDerivativeStructure;
import org.hipparchus.analysis.interpolation.FieldHermiteInterpolator;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.CircularOrbit;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public class FieldCircularOrbit<T extends RealFieldElement<T>>
extends FieldOrbit<T> {
    private static final Map<Field<? extends RealFieldElement<?>>, FDSFactory<? extends RealFieldElement<?>>> FACTORIES = new HashMap();
    private final T a;
    private final T ex;
    private final T ey;
    private final T i;
    private final T raan;
    private final T alphaV;
    private final T aDot;
    private final T exDot;
    private final T eyDot;
    private final T iDot;
    private final T raanDot;
    private final T alphaVDot;
    private FieldPVCoordinates<T> partialPV;
    private final T one;
    private final T zero;

    public FieldCircularOrbit(T a, T ex, T ey, T i, T raan, T alpha, PositionAngle type, Frame frame, FieldAbsoluteDate<T> date, double mu) throws IllegalArgumentException {
        this(a, ex, ey, i, raan, alpha, null, null, null, null, null, null, type, frame, (FieldAbsoluteDate<Object>)date, mu);
    }

    public FieldCircularOrbit(T a, T ex, T ey, T i, T raan, T alpha, T aDot, T exDot, T eyDot, T iDot, T raanDot, T alphaDot, PositionAngle type, Frame frame, FieldAbsoluteDate<T> date, double mu) throws IllegalArgumentException {
        super(frame, date, mu);
        if (ex.getReal() * ex.getReal() + ey.getReal() * ey.getReal() >= 1.0) {
            throw new OrekitIllegalArgumentException(OrekitMessages.HYPERBOLIC_ORBIT_NOT_HANDLED_AS, this.getClass().getName());
        }
        if (!FACTORIES.containsKey(a.getField())) {
            FACTORIES.put(a.getField(), new FDSFactory(a.getField(), 1, 1));
        }
        this.a = a;
        this.aDot = aDot;
        this.ex = ex;
        this.exDot = exDot;
        this.ey = ey;
        this.eyDot = eyDot;
        this.i = i;
        this.iDot = iDot;
        this.raan = raan;
        this.raanDot = raanDot;
        this.one = (RealFieldElement)a.getField().getOne();
        this.zero = (RealFieldElement)a.getField().getZero();
        if (this.hasDerivatives()) {
            FieldDerivativeStructure alphavDS;
            FDSFactory<? extends RealFieldElement<?>> factory = FACTORIES.get(a.getField());
            FieldDerivativeStructure exDS = factory.build(new RealFieldElement[]{ex, exDot});
            FieldDerivativeStructure eyDS = factory.build(new RealFieldElement[]{ey, eyDot});
            FieldDerivativeStructure alphaDS = factory.build(new RealFieldElement[]{alpha, alphaDot});
            switch (type) {
                case MEAN: {
                    alphavDS = FieldCircularOrbit.eccentricToTrue(FieldCircularOrbit.meanToEccentric(alphaDS, exDS, eyDS), exDS, eyDS);
                    break;
                }
                case ECCENTRIC: {
                    alphavDS = FieldCircularOrbit.eccentricToTrue(alphaDS, exDS, eyDS);
                    break;
                }
                case TRUE: {
                    alphavDS = alphaDS;
                    break;
                }
                default: {
                    throw new OrekitInternalError(null);
                }
            }
            this.alphaV = alphavDS.getValue();
            this.alphaVDot = alphavDS.getPartialDerivative(new int[]{1});
        } else {
            switch (type) {
                case MEAN: {
                    this.alphaV = FieldCircularOrbit.eccentricToTrue(FieldCircularOrbit.meanToEccentric(alpha, ex, ey), ex, ey);
                    break;
                }
                case ECCENTRIC: {
                    this.alphaV = FieldCircularOrbit.eccentricToTrue(alpha, ex, ey);
                    break;
                }
                case TRUE: {
                    this.alphaV = alpha;
                    break;
                }
                default: {
                    throw new OrekitInternalError(null);
                }
            }
            this.alphaVDot = null;
        }
        this.partialPV = null;
    }

    public FieldCircularOrbit(TimeStampedFieldPVCoordinates<T> pvCoordinates, Frame frame, double mu) throws IllegalArgumentException {
        super(pvCoordinates, frame, mu);
        FieldVector3D pvP = pvCoordinates.getPosition();
        FieldVector3D pvV = pvCoordinates.getVelocity();
        FieldVector3D pvA = pvCoordinates.getAcceleration();
        RealFieldElement r2 = pvP.getNormSq();
        RealFieldElement r = (RealFieldElement)r2.sqrt();
        RealFieldElement V2 = pvV.getNormSq();
        RealFieldElement rV2OnMu = (RealFieldElement)((RealFieldElement)r.multiply((Object)V2)).divide(mu);
        this.zero = (RealFieldElement)r.getField().getZero();
        this.one = (RealFieldElement)r.getField().getOne();
        if (rV2OnMu.getReal() > 2.0) {
            throw new OrekitIllegalArgumentException(OrekitMessages.HYPERBOLIC_ORBIT_NOT_HANDLED_AS, this.getClass().getName());
        }
        this.a = (RealFieldElement)r.divide(((RealFieldElement)rV2OnMu.negate()).add(2.0));
        FieldVector3D momentum = pvCoordinates.getMomentum();
        FieldVector3D plusK = FieldVector3D.getPlusK((Field)r.getField());
        this.i = FieldVector3D.angle(momentum, (FieldVector3D)plusK);
        FieldVector3D node = FieldVector3D.crossProduct((FieldVector3D)plusK, momentum);
        this.raan = (RealFieldElement)node.getY().atan2((Object)node.getX());
        RealFieldElement cosRaan = (RealFieldElement)this.raan.cos();
        RealFieldElement sinRaan = (RealFieldElement)this.raan.sin();
        RealFieldElement cosI = (RealFieldElement)this.i.cos();
        RealFieldElement sinI = (RealFieldElement)this.i.sin();
        RealFieldElement xP = pvP.getX();
        RealFieldElement yP = pvP.getY();
        RealFieldElement zP = pvP.getZ();
        RealFieldElement x2 = (RealFieldElement)((RealFieldElement)((RealFieldElement)xP.multiply((Object)cosRaan)).add(yP.multiply((Object)sinRaan))).divide(this.a);
        RealFieldElement y2 = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)yP.multiply((Object)cosRaan)).subtract(xP.multiply((Object)sinRaan))).multiply((Object)cosI)).add(zP.multiply((Object)sinI))).divide(this.a);
        RealFieldElement eSE = (RealFieldElement)FieldVector3D.dotProduct(pvP, pvV).divide(((RealFieldElement)this.a.multiply(mu)).sqrt());
        RealFieldElement eCE = (RealFieldElement)rV2OnMu.subtract(1.0);
        RealFieldElement e2 = (RealFieldElement)((RealFieldElement)eCE.multiply((Object)eCE)).add(eSE.multiply((Object)eSE));
        RealFieldElement f = (RealFieldElement)eCE.subtract((Object)e2);
        RealFieldElement g = (RealFieldElement)eSE.multiply(((RealFieldElement)((RealFieldElement)e2.negate()).add(1.0)).sqrt());
        RealFieldElement aOnR = (RealFieldElement)this.a.divide((Object)r);
        RealFieldElement a2OnR2 = (RealFieldElement)aOnR.multiply((Object)aOnR);
        this.ex = (RealFieldElement)a2OnR2.multiply(((RealFieldElement)f.multiply((Object)x2)).add(g.multiply((Object)y2)));
        this.ey = (RealFieldElement)a2OnR2.multiply(((RealFieldElement)f.multiply((Object)y2)).subtract(g.multiply((Object)x2)));
        RealFieldElement beta = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.ex.multiply(this.ex)).add(this.ey.multiply(this.ey))).negate()).add(1.0)).sqrt()).add(1.0)).reciprocal();
        this.alphaV = FieldCircularOrbit.eccentricToTrue((RealFieldElement)((RealFieldElement)((RealFieldElement)y2.add(this.ey)).add(((RealFieldElement)eSE.multiply((Object)beta)).multiply(this.ex))).atan2(((RealFieldElement)x2.add(this.ex)).subtract(((RealFieldElement)eSE.multiply((Object)beta)).multiply(this.ey))), this.ex, this.ey);
        this.partialPV = pvCoordinates;
        if (!FACTORIES.containsKey(this.a.getField())) {
            FACTORIES.put(this.a.getField(), new FDSFactory(this.a.getField(), 1, 1));
        }
        if (FieldCircularOrbit.hasNonKeplerianAcceleration(pvCoordinates, mu)) {
            RealFieldElement[][] jacobian = (RealFieldElement[][])MathArrays.buildArray((Field)this.a.getField(), (int)6, (int)6);
            this.getJacobianWrtCartesian(PositionAngle.MEAN, jacobian);
            FieldVector3D keplerianAcceleration = new FieldVector3D((RealFieldElement)((RealFieldElement)((RealFieldElement)r.multiply((Object)r2)).reciprocal()).multiply(-mu), pvP);
            FieldVector3D nonKeplerianAcceleration = pvA.subtract(keplerianAcceleration);
            RealFieldElement aX = nonKeplerianAcceleration.getX();
            RealFieldElement aY = nonKeplerianAcceleration.getY();
            RealFieldElement aZ = nonKeplerianAcceleration.getZ();
            this.aDot = (RealFieldElement)((RealFieldElement)((RealFieldElement)jacobian[0][3].multiply((Object)aX)).add(jacobian[0][4].multiply((Object)aY))).add(jacobian[0][5].multiply((Object)aZ));
            this.exDot = (RealFieldElement)((RealFieldElement)((RealFieldElement)jacobian[1][3].multiply((Object)aX)).add(jacobian[1][4].multiply((Object)aY))).add(jacobian[1][5].multiply((Object)aZ));
            this.eyDot = (RealFieldElement)((RealFieldElement)((RealFieldElement)jacobian[2][3].multiply((Object)aX)).add(jacobian[2][4].multiply((Object)aY))).add(jacobian[2][5].multiply((Object)aZ));
            this.iDot = (RealFieldElement)((RealFieldElement)((RealFieldElement)jacobian[3][3].multiply((Object)aX)).add(jacobian[3][4].multiply((Object)aY))).add(jacobian[3][5].multiply((Object)aZ));
            this.raanDot = (RealFieldElement)((RealFieldElement)((RealFieldElement)jacobian[4][3].multiply((Object)aX)).add(jacobian[4][4].multiply((Object)aY))).add(jacobian[4][5].multiply((Object)aZ));
            RealFieldElement alphaMDot = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.getKeplerianMeanMotion().add(jacobian[5][3].multiply((Object)aX))).add(jacobian[5][4].multiply((Object)aY))).add(jacobian[5][5].multiply((Object)aZ));
            FDSFactory<? extends RealFieldElement<?>> factory = FACTORIES.get(this.a.getField());
            FieldDerivativeStructure exDS = factory.build(new RealFieldElement[]{this.ex, this.exDot});
            FieldDerivativeStructure eyDS = factory.build(new RealFieldElement[]{this.ey, this.eyDot});
            FieldDerivativeStructure alphaMDS = factory.build(new RealFieldElement[]{this.getAlphaM(), alphaMDot});
            FieldDerivativeStructure alphavDS = FieldCircularOrbit.eccentricToTrue(FieldCircularOrbit.meanToEccentric(alphaMDS, exDS, eyDS), exDS, eyDS);
            this.alphaVDot = alphavDS.getPartialDerivative(new int[]{1});
        } else {
            this.aDot = null;
            this.exDot = null;
            this.eyDot = null;
            this.iDot = null;
            this.raanDot = null;
            this.alphaVDot = null;
        }
    }

    public FieldCircularOrbit(FieldPVCoordinates<T> PVCoordinates2, Frame frame, FieldAbsoluteDate<T> date, double mu) throws IllegalArgumentException {
        this(new TimeStampedFieldPVCoordinates<T>(date, PVCoordinates2), frame, mu);
    }

    public FieldCircularOrbit(FieldOrbit<T> op) {
        super(op.getFrame(), op.getDate(), op.getMu());
        this.a = op.getA();
        this.i = op.getI();
        T hx = op.getHx();
        T hy = op.getHy();
        RealFieldElement h2 = (RealFieldElement)((RealFieldElement)hx.multiply(hx)).add(hy.multiply(hy));
        RealFieldElement h = (RealFieldElement)h2.sqrt();
        this.raan = (RealFieldElement)hy.atan2(hx);
        RealFieldElement cosRaan = h.getReal() == 0.0 ? (RealFieldElement)this.raan.cos() : (RealFieldElement)hx.divide((Object)h);
        RealFieldElement sinRaan = h.getReal() == 0.0 ? (RealFieldElement)this.raan.sin() : (RealFieldElement)hy.divide((Object)h);
        T equiEx = op.getEquinoctialEx();
        T equiEy = op.getEquinoctialEy();
        this.ex = (RealFieldElement)((RealFieldElement)equiEx.multiply((Object)cosRaan)).add(equiEy.multiply((Object)sinRaan));
        this.ey = (RealFieldElement)((RealFieldElement)equiEy.multiply((Object)cosRaan)).subtract(equiEx.multiply((Object)sinRaan));
        this.alphaV = (RealFieldElement)op.getLv().subtract(this.raan);
        if (!FACTORIES.containsKey(this.a.getField())) {
            FACTORIES.put(this.a.getField(), new FDSFactory(this.a.getField(), 1, 1));
        }
        if (op.hasDerivatives()) {
            this.aDot = op.getADot();
            T hxDot = op.getHxDot();
            T hyDot = op.getHyDot();
            this.iDot = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)cosRaan.multiply(hxDot)).add(sinRaan.multiply(hyDot))).multiply(2)).divide(h2.add(1.0));
            this.raanDot = (RealFieldElement)((RealFieldElement)((RealFieldElement)hx.multiply(hyDot)).subtract(hy.multiply(hxDot))).divide((Object)h2);
            T equiExDot = op.getEquinoctialExDot();
            T equiEyDot = op.getEquinoctialEyDot();
            this.exDot = (RealFieldElement)((RealFieldElement)((RealFieldElement)equiExDot.add(equiEy.multiply(this.raanDot))).multiply((Object)cosRaan)).add(((RealFieldElement)equiEyDot.subtract(equiEx.multiply(this.raanDot))).multiply((Object)sinRaan));
            this.eyDot = (RealFieldElement)((RealFieldElement)((RealFieldElement)equiEyDot.subtract(equiEx.multiply(this.raanDot))).multiply((Object)cosRaan)).subtract(((RealFieldElement)equiExDot.add(equiEy.multiply(this.raanDot))).multiply((Object)sinRaan));
            this.alphaVDot = (RealFieldElement)op.getLvDot().subtract(this.raanDot);
        } else {
            this.aDot = null;
            this.exDot = null;
            this.eyDot = null;
            this.iDot = null;
            this.raanDot = null;
            this.alphaVDot = null;
        }
        this.partialPV = null;
        this.one = (RealFieldElement)this.a.getField().getOne();
        this.zero = (RealFieldElement)this.a.getField().getZero();
    }

    @Override
    public OrbitType getType() {
        return OrbitType.CIRCULAR;
    }

    @Override
    public T getA() {
        return this.a;
    }

    @Override
    public T getADot() {
        return this.aDot;
    }

    @Override
    public T getEquinoctialEx() {
        return (T)((RealFieldElement)((RealFieldElement)this.ex.multiply(this.raan.cos())).subtract(this.ey.multiply(this.raan.sin())));
    }

    @Override
    public T getEquinoctialExDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        RealFieldElement cosRaan = (RealFieldElement)this.raan.cos();
        RealFieldElement sinRaan = (RealFieldElement)this.raan.sin();
        return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.exDot.subtract(this.ey.multiply(this.raanDot))).multiply((Object)cosRaan)).subtract(((RealFieldElement)this.eyDot.add(this.ex.multiply(this.raanDot))).multiply((Object)sinRaan)));
    }

    @Override
    public T getEquinoctialEy() {
        return (T)((RealFieldElement)((RealFieldElement)this.ey.multiply(this.raan.cos())).add(this.ex.multiply(this.raan.sin())));
    }

    @Override
    public T getEquinoctialEyDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        RealFieldElement cosRaan = (RealFieldElement)this.raan.cos();
        RealFieldElement sinRaan = (RealFieldElement)this.raan.sin();
        return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.eyDot.add(this.ex.multiply(this.raanDot))).multiply((Object)cosRaan)).add(((RealFieldElement)this.exDot.subtract(this.ey.multiply(this.raanDot))).multiply((Object)sinRaan)));
    }

    public T getCircularEx() {
        return this.ex;
    }

    public T getCircularExDot() {
        return this.exDot;
    }

    public T getCircularEy() {
        return this.ey;
    }

    public T getCircularEyDot() {
        return this.eyDot;
    }

    @Override
    public T getHx() {
        if (FastMath.abs((double)(this.i.getReal() - Math.PI)) < 1.0E-10) {
            return (T)((RealFieldElement)this.zero.add(Double.NaN));
        }
        return (T)((RealFieldElement)((RealFieldElement)this.raan.cos()).multiply(((RealFieldElement)this.i.divide(2.0)).tan()));
    }

    @Override
    public T getHxDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        if (FastMath.abs((double)(this.i.getReal() - Math.PI)) < 1.0E-10) {
            return (T)((RealFieldElement)this.zero.add(Double.NaN));
        }
        RealFieldElement cosRaan = (RealFieldElement)this.raan.cos();
        RealFieldElement sinRaan = (RealFieldElement)this.raan.sin();
        RealFieldElement tan = (RealFieldElement)((RealFieldElement)this.i.multiply(0.5)).tan();
        return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)cosRaan.multiply(0.5)).multiply(((RealFieldElement)tan.multiply((Object)tan)).add(1.0))).multiply(this.iDot)).subtract(((RealFieldElement)sinRaan.multiply((Object)tan)).multiply(this.raanDot)));
    }

    @Override
    public T getHy() {
        if (FastMath.abs((double)(this.i.getReal() - Math.PI)) < 1.0E-10) {
            return (T)((RealFieldElement)this.zero.add(Double.NaN));
        }
        return (T)((RealFieldElement)((RealFieldElement)this.raan.sin()).multiply(((RealFieldElement)this.i.divide(2.0)).tan()));
    }

    @Override
    public T getHyDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        if (FastMath.abs((double)(this.i.getReal() - Math.PI)) < 1.0E-10) {
            return (T)((RealFieldElement)this.zero.add(Double.NaN));
        }
        RealFieldElement cosRaan = (RealFieldElement)this.raan.cos();
        RealFieldElement sinRaan = (RealFieldElement)this.raan.sin();
        RealFieldElement tan = (RealFieldElement)((RealFieldElement)this.i.multiply(0.5)).tan();
        return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)sinRaan.multiply(0.5)).multiply(((RealFieldElement)tan.multiply((Object)tan)).add(1.0))).multiply(this.iDot)).add(((RealFieldElement)cosRaan.multiply((Object)tan)).multiply(this.raanDot)));
    }

    public T getAlphaV() {
        return this.alphaV;
    }

    public T getAlphaVDot() {
        return this.alphaVDot;
    }

    public T getAlphaE() {
        return FieldCircularOrbit.trueToEccentric(this.alphaV, this.ex, this.ey);
    }

    public T getAlphaEDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        FDSFactory<? extends RealFieldElement<?>> factory = FACTORIES.get(this.a.getField());
        FieldDerivativeStructure alphaVDS = factory.build(new RealFieldElement[]{this.alphaV, this.alphaVDot});
        FieldDerivativeStructure exDS = factory.build(new RealFieldElement[]{this.ex, this.exDot});
        FieldDerivativeStructure eyDS = factory.build(new RealFieldElement[]{this.ey, this.eyDot});
        FieldDerivativeStructure alphaEDS = FieldCircularOrbit.trueToEccentric(alphaVDS, exDS, eyDS);
        return (T)alphaEDS.getPartialDerivative(new int[]{1});
    }

    public T getAlphaM() {
        return FieldCircularOrbit.eccentricToMean(FieldCircularOrbit.trueToEccentric(this.alphaV, this.ex, this.ey), this.ex, this.ey);
    }

    public T getAlphaMDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        FDSFactory<? extends RealFieldElement<?>> factory = FACTORIES.get(this.a.getField());
        FieldDerivativeStructure alphaVDS = factory.build(new RealFieldElement[]{this.alphaV, this.alphaVDot});
        FieldDerivativeStructure exDS = factory.build(new RealFieldElement[]{this.ex, this.exDot});
        FieldDerivativeStructure eyDS = factory.build(new RealFieldElement[]{this.ey, this.eyDot});
        FieldDerivativeStructure alphaMDS = FieldCircularOrbit.eccentricToMean(FieldCircularOrbit.trueToEccentric(alphaVDS, exDS, eyDS), exDS, eyDS);
        return (T)alphaMDS.getPartialDerivative(new int[]{1});
    }

    public T getAlpha(PositionAngle type) {
        return type == PositionAngle.MEAN ? this.getAlphaM() : (type == PositionAngle.ECCENTRIC ? this.getAlphaE() : this.getAlphaV());
    }

    public T getAlphaDot(PositionAngle type) {
        return type == PositionAngle.MEAN ? this.getAlphaMDot() : (type == PositionAngle.ECCENTRIC ? this.getAlphaEDot() : this.getAlphaVDot());
    }

    public static <T extends RealFieldElement<T>> T eccentricToTrue(T alphaE, T ex, T ey) {
        RealFieldElement epsilon = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)ex.multiply(ex)).add(ey.multiply(ey))).negate()).add(1.0)).sqrt();
        RealFieldElement cosAlphaE = (RealFieldElement)alphaE.cos();
        RealFieldElement sinAlphaE = (RealFieldElement)alphaE.sin();
        return (T)((RealFieldElement)alphaE.add(((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)ex.multiply((Object)sinAlphaE)).subtract(ey.multiply((Object)cosAlphaE))).divide(((RealFieldElement)((RealFieldElement)epsilon.add(1.0)).subtract(ex.multiply((Object)cosAlphaE))).subtract(ey.multiply((Object)sinAlphaE)))).atan()).multiply(2)));
    }

    public static <T extends RealFieldElement<T>> T trueToEccentric(T alphaV, T ex, T ey) {
        RealFieldElement epsilon = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)ex.multiply(ex)).add(ey.multiply(ey))).negate()).add(1.0)).sqrt();
        RealFieldElement cosAlphaV = (RealFieldElement)alphaV.cos();
        RealFieldElement sinAlphaV = (RealFieldElement)alphaV.sin();
        return (T)((RealFieldElement)alphaV.add(((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)ey.multiply((Object)cosAlphaV)).subtract(ex.multiply((Object)sinAlphaV))).divide(((RealFieldElement)epsilon.add(1.0)).add(((RealFieldElement)ex.multiply((Object)cosAlphaV)).add(ey.multiply((Object)sinAlphaV))))).atan()).multiply(2)));
    }

    public static <T extends RealFieldElement<T>> T meanToEccentric(T alphaM, T ex, T ey) {
        Object alphaE = alphaM;
        RealFieldElement shift = (RealFieldElement)alphaM.getField().getZero();
        RealFieldElement alphaEMalphaM = (RealFieldElement)alphaM.getField().getZero();
        RealFieldElement cosAlphaE = (RealFieldElement)alphaE.cos();
        RealFieldElement sinAlphaE = (RealFieldElement)alphaE.sin();
        int iter = 0;
        do {
            RealFieldElement f2 = (RealFieldElement)((RealFieldElement)ex.multiply((Object)sinAlphaE)).subtract(ey.multiply((Object)cosAlphaE));
            RealFieldElement f1 = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)ex.negate()).multiply((Object)cosAlphaE)).subtract(ey.multiply((Object)sinAlphaE))).add(1.0);
            RealFieldElement f0 = (RealFieldElement)alphaEMalphaM.subtract((Object)f2);
            RealFieldElement f12 = (RealFieldElement)f1.multiply(2);
            shift = (RealFieldElement)((RealFieldElement)f0.multiply((Object)f12)).divide(((RealFieldElement)f1.multiply((Object)f12)).subtract(f0.multiply((Object)f2)));
            alphaEMalphaM = (RealFieldElement)alphaEMalphaM.subtract((Object)shift);
            alphaE = (RealFieldElement)alphaM.add((Object)alphaEMalphaM);
            cosAlphaE = (RealFieldElement)alphaE.cos();
            sinAlphaE = (RealFieldElement)alphaE.sin();
        } while (++iter < 50 && FastMath.abs((double)shift.getReal()) > 1.0E-12);
        return alphaE;
    }

    public static <T extends RealFieldElement<T>> T eccentricToMean(T alphaE, T ex, T ey) {
        return (T)((RealFieldElement)alphaE.subtract(((RealFieldElement)ex.multiply(alphaE.sin())).subtract(ey.multiply(alphaE.cos()))));
    }

    @Deprecated
    public static <T extends RealFieldElement<T>> FieldVector3D<T> circularToPosition(T a, T ex, T ey, T i, T raan, T alphaV, double mu) {
        RealFieldElement hy;
        RealFieldElement hx;
        RealFieldElement zero = (RealFieldElement)a.getField().getZero();
        RealFieldElement equEx = (RealFieldElement)((RealFieldElement)ex.multiply(raan.cos())).subtract(ey.multiply(raan.sin()));
        RealFieldElement equEy = (RealFieldElement)((RealFieldElement)ey.multiply(raan.cos())).add(ex.multiply(raan.sin()));
        if (FastMath.abs((double)(i.getReal() - Math.PI)) < 1.0E-10) {
            hx = (RealFieldElement)zero.add(Double.NaN);
            hy = (RealFieldElement)zero.add(Double.NaN);
        } else {
            RealFieldElement tan = (RealFieldElement)((RealFieldElement)i.divide(2.0)).tan();
            hx = (RealFieldElement)((RealFieldElement)raan.cos()).multiply((Object)tan);
            hy = (RealFieldElement)((RealFieldElement)raan.sin()).multiply((Object)tan);
        }
        RealFieldElement lE = (RealFieldElement)FieldCircularOrbit.trueToEccentric(alphaV, ex, ey).add(raan);
        RealFieldElement hx2 = (RealFieldElement)hx.multiply((Object)hx);
        RealFieldElement hy2 = (RealFieldElement)hy.multiply((Object)hy);
        RealFieldElement factH = (RealFieldElement)((RealFieldElement)((RealFieldElement)hx2.add(1.0)).add((Object)hy2)).reciprocal();
        RealFieldElement ux = (RealFieldElement)((RealFieldElement)((RealFieldElement)hx2.add(1.0)).subtract((Object)hy2)).multiply((Object)factH);
        RealFieldElement uy = (RealFieldElement)((RealFieldElement)((RealFieldElement)hx.multiply(2)).multiply((Object)hy)).multiply((Object)factH);
        RealFieldElement uz = (RealFieldElement)((RealFieldElement)hy.multiply(-2)).multiply((Object)factH);
        RealFieldElement vx = uy;
        RealFieldElement vy = (RealFieldElement)((RealFieldElement)((RealFieldElement)hy2.subtract((Object)hx2)).add(1.0)).multiply((Object)factH);
        RealFieldElement vz = (RealFieldElement)((RealFieldElement)hx.multiply((Object)factH)).multiply(2);
        RealFieldElement exey = (RealFieldElement)equEx.multiply((Object)equEy);
        RealFieldElement ex2 = (RealFieldElement)equEx.multiply((Object)equEx);
        RealFieldElement ey2 = (RealFieldElement)equEy.multiply((Object)equEy);
        RealFieldElement e2 = (RealFieldElement)ex2.add((Object)ey2);
        RealFieldElement eta = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)e2.negate()).add(1.0)).sqrt()).add(1.0);
        RealFieldElement beta = (RealFieldElement)eta.reciprocal();
        RealFieldElement cLe = (RealFieldElement)lE.cos();
        RealFieldElement sLe = (RealFieldElement)lE.sin();
        RealFieldElement x = (RealFieldElement)a.multiply(((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)beta.negate()).multiply((Object)ey2)).add(1.0)).multiply((Object)cLe)).add(((RealFieldElement)beta.multiply((Object)exey)).multiply((Object)sLe))).subtract((Object)equEx));
        RealFieldElement y = (RealFieldElement)a.multiply(((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)beta.negate()).multiply((Object)ex2)).add(1.0)).multiply((Object)sLe)).add(((RealFieldElement)beta.multiply((Object)exey)).multiply((Object)cLe))).subtract((Object)equEy));
        return new FieldVector3D((RealFieldElement)((RealFieldElement)x.multiply((Object)ux)).add(y.multiply((Object)vx)), (RealFieldElement)((RealFieldElement)x.multiply((Object)uy)).add(y.multiply((Object)vy)), (RealFieldElement)((RealFieldElement)x.multiply((Object)uz)).add(y.multiply((Object)vz)));
    }

    @Override
    public T getE() {
        return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.ex.multiply(this.ex)).add(this.ey.multiply(this.ey))).sqrt());
    }

    @Override
    public T getEDot() {
        if (!this.hasDerivatives()) {
            return null;
        }
        return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.ex.multiply(this.exDot)).add(this.ey.multiply(this.eyDot))).divide(this.getE()));
    }

    @Override
    public T getI() {
        return this.i;
    }

    @Override
    public T getIDot() {
        return this.iDot;
    }

    public T getRightAscensionOfAscendingNode() {
        return this.raan;
    }

    public T getRightAscensionOfAscendingNodeDot() {
        return this.raanDot;
    }

    @Override
    public T getLv() {
        return (T)((RealFieldElement)this.alphaV.add(this.raan));
    }

    @Override
    public T getLvDot() {
        return (T)(this.hasDerivatives() ? (RealFieldElement)this.alphaVDot.add(this.raanDot) : null);
    }

    @Override
    public T getLE() {
        return (T)((RealFieldElement)this.getAlphaE().add(this.raan));
    }

    @Override
    public T getLEDot() {
        return (T)(this.hasDerivatives() ? (RealFieldElement)this.getAlphaEDot().add(this.raanDot) : null);
    }

    @Override
    public T getLM() {
        return (T)((RealFieldElement)this.getAlphaM().add(this.raan));
    }

    @Override
    public T getLMDot() {
        return (T)(this.hasDerivatives() ? (RealFieldElement)this.getAlphaMDot().add(this.raanDot) : null);
    }

    @Override
    public boolean hasDerivatives() {
        return this.aDot != null;
    }

    private void computePVWithoutA() {
        if (this.partialPV != null) {
            return;
        }
        T equEx = this.getEquinoctialEx();
        T equEy = this.getEquinoctialEy();
        T hx = this.getHx();
        T hy = this.getHy();
        T lE = this.getLE();
        RealFieldElement hx2 = (RealFieldElement)hx.multiply(hx);
        RealFieldElement hy2 = (RealFieldElement)hy.multiply(hy);
        RealFieldElement factH = (RealFieldElement)((RealFieldElement)((RealFieldElement)hx2.add(1.0)).add((Object)hy2)).reciprocal();
        RealFieldElement ux = (RealFieldElement)((RealFieldElement)((RealFieldElement)hx2.add(1.0)).subtract((Object)hy2)).multiply((Object)factH);
        RealFieldElement uy = (RealFieldElement)((RealFieldElement)((RealFieldElement)hx.multiply(2)).multiply(hy)).multiply((Object)factH);
        RealFieldElement uz = (RealFieldElement)((RealFieldElement)hy.multiply(-2)).multiply((Object)factH);
        RealFieldElement vx = uy;
        RealFieldElement vy = (RealFieldElement)((RealFieldElement)((RealFieldElement)hy2.subtract((Object)hx2)).add(1.0)).multiply((Object)factH);
        RealFieldElement vz = (RealFieldElement)((RealFieldElement)hx.multiply((Object)factH)).multiply(2);
        RealFieldElement exey = (RealFieldElement)equEx.multiply(equEy);
        RealFieldElement ex2 = (RealFieldElement)equEx.multiply(equEx);
        RealFieldElement ey2 = (RealFieldElement)equEy.multiply(equEy);
        RealFieldElement e2 = (RealFieldElement)ex2.add((Object)ey2);
        RealFieldElement eta = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)e2.negate()).add(1.0)).sqrt()).add(1.0);
        RealFieldElement beta = (RealFieldElement)eta.reciprocal();
        RealFieldElement cLe = (RealFieldElement)lE.cos();
        RealFieldElement sLe = (RealFieldElement)lE.sin();
        RealFieldElement exCeyS = (RealFieldElement)((RealFieldElement)equEx.multiply((Object)cLe)).add(equEy.multiply((Object)sLe));
        RealFieldElement x = (RealFieldElement)this.a.multiply(((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)beta.negate()).multiply((Object)ey2)).add(1.0)).multiply((Object)cLe)).add(((RealFieldElement)beta.multiply((Object)exey)).multiply((Object)sLe))).subtract(equEx));
        RealFieldElement y = (RealFieldElement)this.a.multiply(((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)beta.negate()).multiply((Object)ex2)).add(1.0)).multiply((Object)sLe)).add(((RealFieldElement)beta.multiply((Object)exey)).multiply((Object)cLe))).subtract(equEy));
        RealFieldElement factor = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.one.add(this.getMu())).divide(this.a)).sqrt()).divide(((RealFieldElement)exCeyS.negate()).add(1.0));
        RealFieldElement xdot = (RealFieldElement)factor.multiply(((RealFieldElement)((RealFieldElement)beta.multiply(equEy)).multiply((Object)exCeyS)).subtract((Object)sLe));
        RealFieldElement ydot = (RealFieldElement)factor.multiply(cLe.subtract(((RealFieldElement)beta.multiply(equEx)).multiply((Object)exCeyS)));
        FieldVector3D position = new FieldVector3D((RealFieldElement)((RealFieldElement)x.multiply((Object)ux)).add(y.multiply((Object)vx)), (RealFieldElement)((RealFieldElement)x.multiply((Object)uy)).add(y.multiply((Object)vy)), (RealFieldElement)((RealFieldElement)x.multiply((Object)uz)).add(y.multiply((Object)vz)));
        FieldVector3D velocity = new FieldVector3D((RealFieldElement)((RealFieldElement)xdot.multiply((Object)ux)).add(ydot.multiply((Object)vx)), (RealFieldElement)((RealFieldElement)xdot.multiply((Object)uy)).add(ydot.multiply((Object)vy)), (RealFieldElement)((RealFieldElement)xdot.multiply((Object)uz)).add(ydot.multiply((Object)vz)));
        this.partialPV = new FieldPVCoordinates(position, velocity);
    }

    private FieldVector3D<T> nonKeplerianAcceleration() {
        RealFieldElement[][] dCdP = (RealFieldElement[][])MathArrays.buildArray((Field)this.a.getField(), (int)6, (int)6);
        this.getJacobianWrtParameters(PositionAngle.MEAN, dCdP);
        RealFieldElement nonKeplerianMeanMotion = (RealFieldElement)this.getAlphaMDot().subtract(this.getKeplerianMeanMotion());
        RealFieldElement nonKeplerianAx = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)dCdP[3][0].multiply(this.aDot)).add(dCdP[3][1].multiply(this.exDot))).add(dCdP[3][2].multiply(this.eyDot))).add(dCdP[3][3].multiply(this.iDot))).add(dCdP[3][4].multiply(this.raanDot))).add(dCdP[3][5].multiply((Object)nonKeplerianMeanMotion));
        RealFieldElement nonKeplerianAy = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)dCdP[4][0].multiply(this.aDot)).add(dCdP[4][1].multiply(this.exDot))).add(dCdP[4][2].multiply(this.eyDot))).add(dCdP[4][3].multiply(this.iDot))).add(dCdP[4][4].multiply(this.raanDot))).add(dCdP[4][5].multiply((Object)nonKeplerianMeanMotion));
        RealFieldElement nonKeplerianAz = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)dCdP[5][0].multiply(this.aDot)).add(dCdP[5][1].multiply(this.exDot))).add(dCdP[5][2].multiply(this.eyDot))).add(dCdP[5][3].multiply(this.iDot))).add(dCdP[5][4].multiply(this.raanDot))).add(dCdP[5][5].multiply((Object)nonKeplerianMeanMotion));
        return new FieldVector3D(nonKeplerianAx, nonKeplerianAy, nonKeplerianAz);
    }

    @Override
    protected TimeStampedFieldPVCoordinates<T> initPVCoordinates() {
        this.computePVWithoutA();
        RealFieldElement r2 = this.partialPV.getPosition().getNormSq();
        FieldVector3D keplerianAcceleration = new FieldVector3D((RealFieldElement)((RealFieldElement)((RealFieldElement)r2.multiply(r2.sqrt())).reciprocal()).multiply(-this.getMu()), this.partialPV.getPosition());
        FieldVector3D acceleration = this.hasDerivatives() ? keplerianAcceleration.add(this.nonKeplerianAcceleration()) : keplerianAcceleration;
        return new TimeStampedFieldPVCoordinates(this.getDate(), this.partialPV.getPosition(), this.partialPV.getVelocity(), acceleration);
    }

    @Override
    public FieldCircularOrbit<T> shiftedBy(double dt) {
        return this.shiftedBy((RealFieldElement)((RealFieldElement)this.getDate().getField().getZero()).add(dt));
    }

    @Override
    public FieldCircularOrbit<T> shiftedBy(T dt) {
        FieldCircularOrbit<RealFieldElement> keplerianShifted = new FieldCircularOrbit<RealFieldElement>((RealFieldElement)this.a, (RealFieldElement)this.ex, (RealFieldElement)this.ey, (RealFieldElement)this.i, (RealFieldElement)this.raan, (RealFieldElement)this.getAlphaM().add(this.getKeplerianMeanMotion().multiply(dt)), PositionAngle.MEAN, this.getFrame(), this.getDate().shiftedBy(dt), this.getMu());
        if (this.hasDerivatives()) {
            FieldVector3D<T> nonKeplerianAcceleration = this.nonKeplerianAcceleration();
            super.computePVWithoutA();
            FieldVector3D fixedP = new FieldVector3D(this.one, keplerianShifted.partialPV.getPosition(), (RealFieldElement)((RealFieldElement)dt.multiply(dt)).multiply(0.5), nonKeplerianAcceleration);
            RealFieldElement fixedR2 = fixedP.getNormSq();
            RealFieldElement fixedR = (RealFieldElement)fixedR2.sqrt();
            FieldVector3D fixedV = new FieldVector3D(this.one, keplerianShifted.partialPV.getVelocity(), dt, nonKeplerianAcceleration);
            FieldVector3D fixedA = new FieldVector3D((RealFieldElement)((RealFieldElement)((RealFieldElement)fixedR2.multiply((Object)fixedR)).reciprocal()).multiply(-this.getMu()), keplerianShifted.partialPV.getPosition(), this.one, nonKeplerianAcceleration);
            return new FieldCircularOrbit(new TimeStampedFieldPVCoordinates(keplerianShifted.getDate(), fixedP, fixedV, fixedA), keplerianShifted.getFrame(), keplerianShifted.getMu());
        }
        return keplerianShifted;
    }

    @Override
    public FieldCircularOrbit<T> interpolate(FieldAbsoluteDate<T> date, Stream<FieldOrbit<T>> sample) {
        List list = sample.collect(Collectors.toList());
        boolean useDerivatives = true;
        for (FieldOrbit orbit : list) {
            useDerivatives = useDerivatives && orbit.hasDerivatives();
        }
        FieldHermiteInterpolator interpolator = new FieldHermiteInterpolator();
        FieldAbsoluteDate previousDate = null;
        Object previousRAAN = (RealFieldElement)this.zero.add(Double.NaN);
        Object previousAlphaM = (RealFieldElement)this.zero.add(Double.NaN);
        for (FieldOrbit orbit : list) {
            Object continuousAlphaM;
            Object continuousRAAN;
            FieldCircularOrbit circ = (FieldCircularOrbit)OrbitType.CIRCULAR.convertType(orbit);
            if (previousDate == null) {
                continuousRAAN = circ.getRightAscensionOfAscendingNode();
                continuousAlphaM = circ.getAlphaM();
            } else {
                Object dt = circ.getDate().durationFrom(previousDate);
                RealFieldElement keplerAM = (RealFieldElement)previousAlphaM.add(circ.getKeplerianMeanMotion().multiply(dt));
                continuousRAAN = FieldCircularOrbit.normalizeAngle(circ.getRightAscensionOfAscendingNode(), previousRAAN);
                continuousAlphaM = FieldCircularOrbit.normalizeAngle(circ.getAlphaM(), keplerAM);
            }
            previousDate = circ.getDate();
            previousRAAN = continuousRAAN;
            previousAlphaM = continuousAlphaM;
            RealFieldElement[] toAdd = (RealFieldElement[])MathArrays.buildArray((Field)this.one.getField(), (int)6);
            toAdd[0] = circ.getA();
            toAdd[1] = circ.getCircularEx();
            toAdd[2] = circ.getCircularEy();
            toAdd[3] = circ.getI();
            toAdd[4] = continuousRAAN;
            toAdd[5] = continuousAlphaM;
            if (useDerivatives) {
                RealFieldElement[] toAddDot = (RealFieldElement[])MathArrays.buildArray((Field)this.one.getField(), (int)6);
                toAddDot[0] = circ.getADot();
                toAddDot[1] = circ.getCircularExDot();
                toAddDot[2] = circ.getCircularEyDot();
                toAddDot[3] = circ.getIDot();
                toAddDot[4] = circ.getRightAscensionOfAscendingNodeDot();
                toAddDot[5] = circ.getAlphaMDot();
                interpolator.addSamplePoint(circ.getDate().durationFrom(date), (FieldElement[][])new RealFieldElement[][]{toAdd, toAddDot});
                continue;
            }
            interpolator.addSamplePoint(circ.getDate().durationFrom(date), (FieldElement[][])new RealFieldElement[][]{toAdd});
        }
        RealFieldElement[][] interpolated = (RealFieldElement[][])interpolator.derivatives(this.zero, 1);
        return new FieldCircularOrbit<RealFieldElement>(interpolated[0][0], interpolated[0][1], interpolated[0][2], interpolated[0][3], interpolated[0][4], interpolated[0][5], interpolated[1][0], interpolated[1][1], interpolated[1][2], interpolated[1][3], interpolated[1][4], interpolated[1][5], PositionAngle.MEAN, this.getFrame(), date, this.getMu());
    }

    @Override
    protected T[][] computeJacobianMeanWrtCartesian() {
        RealFieldElement[][] jacobian = (RealFieldElement[][])MathArrays.buildArray((Field)this.one.getField(), (int)6, (int)6);
        this.computePVWithoutA();
        FieldVector3D<T> position = this.partialPV.getPosition();
        FieldVector3D<T> velocity = this.partialPV.getVelocity();
        RealFieldElement x = position.getX();
        RealFieldElement y = position.getY();
        RealFieldElement z = position.getZ();
        RealFieldElement vx = velocity.getX();
        RealFieldElement vy = velocity.getY();
        RealFieldElement vz = velocity.getZ();
        RealFieldElement pv = FieldVector3D.dotProduct(position, velocity);
        RealFieldElement r2 = position.getNormSq();
        RealFieldElement r = (RealFieldElement)r2.sqrt();
        RealFieldElement v2 = velocity.getNormSq();
        double mu = this.getMu();
        RealFieldElement oOsqrtMuA = (RealFieldElement)this.one.divide(((RealFieldElement)this.a.multiply(mu)).sqrt());
        RealFieldElement rOa = (RealFieldElement)r.divide(this.a);
        RealFieldElement aOr = (RealFieldElement)this.a.divide((Object)r);
        RealFieldElement aOr2 = (RealFieldElement)this.a.divide((Object)r2);
        RealFieldElement a2 = (RealFieldElement)this.a.multiply(this.a);
        RealFieldElement ex2 = (RealFieldElement)this.ex.multiply(this.ex);
        RealFieldElement ey2 = (RealFieldElement)this.ey.multiply(this.ey);
        RealFieldElement e2 = (RealFieldElement)ex2.add((Object)ey2);
        RealFieldElement epsilon = (RealFieldElement)((RealFieldElement)((RealFieldElement)e2.negate()).add(1.0)).sqrt();
        RealFieldElement beta = (RealFieldElement)((RealFieldElement)epsilon.add(1.0)).reciprocal();
        RealFieldElement eCosE = (RealFieldElement)((RealFieldElement)rOa.negate()).add(1.0);
        RealFieldElement eSinE = (RealFieldElement)pv.multiply((Object)oOsqrtMuA);
        RealFieldElement cosI = (RealFieldElement)this.i.cos();
        RealFieldElement sinI = (RealFieldElement)this.i.sin();
        RealFieldElement cosRaan = (RealFieldElement)this.raan.cos();
        RealFieldElement sinRaan = (RealFieldElement)this.raan.sin();
        this.fillHalfRow((RealFieldElement)((RealFieldElement)aOr.multiply(2.0)).multiply((Object)aOr2), position, jacobian[0], 0);
        this.fillHalfRow((RealFieldElement)a2.multiply(2.0 / mu), velocity, jacobian[0], 3);
        FieldVector3D danP = new FieldVector3D(v2, position, (RealFieldElement)pv.negate(), velocity);
        FieldVector3D danV = new FieldVector3D(r2, velocity, (RealFieldElement)pv.negate(), position);
        RealFieldElement recip = (RealFieldElement)this.partialPV.getMomentum().getNorm().reciprocal();
        RealFieldElement recip2 = (RealFieldElement)recip.multiply((Object)recip);
        RealFieldElement recip2N = (RealFieldElement)recip2.negate();
        FieldVector3D dwXP = new FieldVector3D(recip, new FieldVector3D(this.zero, vz, (RealFieldElement)vy.negate()), (RealFieldElement)((RealFieldElement)recip2N.multiply((Object)sinRaan)).multiply((Object)sinI), danP);
        FieldVector3D dwYP = new FieldVector3D(recip, new FieldVector3D((RealFieldElement)vz.negate(), this.zero, vx), (RealFieldElement)((RealFieldElement)recip2.multiply((Object)cosRaan)).multiply((Object)sinI), danP);
        FieldVector3D dwZP = new FieldVector3D(recip, new FieldVector3D(vy, (RealFieldElement)vx.negate(), this.zero), (RealFieldElement)recip2N.multiply((Object)cosI), danP);
        FieldVector3D dwXV = new FieldVector3D(recip, new FieldVector3D(this.zero, (RealFieldElement)z.negate(), y), (RealFieldElement)((RealFieldElement)recip2N.multiply((Object)sinRaan)).multiply((Object)sinI), danV);
        FieldVector3D dwYV = new FieldVector3D(recip, new FieldVector3D(z, this.zero, (RealFieldElement)x.negate()), (RealFieldElement)((RealFieldElement)recip2.multiply((Object)cosRaan)).multiply((Object)sinI), danV);
        FieldVector3D dwZV = new FieldVector3D(recip, new FieldVector3D((RealFieldElement)y.negate(), x, this.zero), (RealFieldElement)recip2N.multiply((Object)cosI), danV);
        this.fillHalfRow((RealFieldElement)sinRaan.multiply((Object)cosI), dwXP, (RealFieldElement)((RealFieldElement)cosRaan.negate()).multiply((Object)cosI), dwYP, (RealFieldElement)sinI.negate(), dwZP, jacobian[3], 0);
        this.fillHalfRow((RealFieldElement)sinRaan.multiply((Object)cosI), dwXV, (RealFieldElement)((RealFieldElement)cosRaan.negate()).multiply((Object)cosI), dwYV, (RealFieldElement)sinI.negate(), dwZV, jacobian[3], 3);
        this.fillHalfRow((RealFieldElement)sinRaan.divide((Object)sinI), dwYP, (RealFieldElement)cosRaan.divide((Object)sinI), dwXP, jacobian[4], 0);
        this.fillHalfRow((RealFieldElement)sinRaan.divide((Object)sinI), dwYV, (RealFieldElement)cosRaan.divide((Object)sinI), dwXV, jacobian[4], 3);
        RealFieldElement u = (RealFieldElement)((RealFieldElement)x.multiply((Object)cosRaan)).add(y.multiply((Object)sinRaan));
        RealFieldElement cv = (RealFieldElement)((RealFieldElement)((RealFieldElement)x.negate()).multiply((Object)sinRaan)).add(y.multiply((Object)cosRaan));
        RealFieldElement v = (RealFieldElement)((RealFieldElement)cv.multiply((Object)cosI)).add(z.multiply((Object)sinI));
        FieldVector3D duP = new FieldVector3D((RealFieldElement)((RealFieldElement)cv.multiply((Object)cosRaan)).divide((Object)sinI), dwXP, (RealFieldElement)((RealFieldElement)cv.multiply((Object)sinRaan)).divide((Object)sinI), dwYP, this.one, new FieldVector3D(cosRaan, sinRaan, this.zero));
        FieldVector3D duV = new FieldVector3D((RealFieldElement)((RealFieldElement)cv.multiply((Object)cosRaan)).divide((Object)sinI), dwXV, (RealFieldElement)((RealFieldElement)cv.multiply((Object)sinRaan)).divide((Object)sinI), dwYV);
        FieldVector3D dvP = new FieldVector3D((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)u.negate()).multiply((Object)cosRaan)).multiply((Object)cosI)).divide((Object)sinI)).add(sinRaan.multiply((Object)z)), dwXP, (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)u.negate()).multiply((Object)sinRaan)).multiply((Object)cosI)).divide((Object)sinI)).subtract(cosRaan.multiply((Object)z)), dwYP, cv, dwZP, this.one, new FieldVector3D((RealFieldElement)((RealFieldElement)sinRaan.negate()).multiply((Object)cosI), (RealFieldElement)cosRaan.multiply((Object)cosI), sinI));
        FieldVector3D dvV = new FieldVector3D((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)u.negate()).multiply((Object)cosRaan)).multiply((Object)cosI)).divide((Object)sinI)).add(sinRaan.multiply((Object)z)), dwXV, (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)u.negate()).multiply((Object)sinRaan)).multiply((Object)cosI)).divide((Object)sinI)).subtract(cosRaan.multiply((Object)z)), dwYV, cv, dwZV);
        FieldVector3D dc1P = new FieldVector3D((RealFieldElement)((RealFieldElement)aOr2.multiply(((RealFieldElement)((RealFieldElement)((RealFieldElement)eSinE.multiply((Object)eSinE)).multiply(2)).add(1.0)).subtract((Object)eCosE))).divide((Object)r2), position, (RealFieldElement)((RealFieldElement)((RealFieldElement)aOr2.multiply(-2)).multiply((Object)eSinE)).multiply((Object)oOsqrtMuA), velocity);
        FieldVector3D dc1V = new FieldVector3D((RealFieldElement)((RealFieldElement)((RealFieldElement)aOr2.multiply(-2)).multiply((Object)eSinE)).multiply((Object)oOsqrtMuA), position, (RealFieldElement)((RealFieldElement)this.zero.add(2.0)).divide(mu), velocity);
        FieldVector3D dc2P = new FieldVector3D((RealFieldElement)((RealFieldElement)((RealFieldElement)aOr2.multiply((Object)eSinE)).multiply(((RealFieldElement)eSinE.multiply((Object)eSinE)).subtract(((RealFieldElement)e2.negate()).add(1.0)))).divide(r2.multiply((Object)epsilon)), position, (RealFieldElement)((RealFieldElement)((RealFieldElement)aOr2.multiply(((RealFieldElement)((RealFieldElement)e2.negate()).add(1.0)).subtract(eSinE.multiply((Object)eSinE)))).multiply((Object)oOsqrtMuA)).divide((Object)epsilon), velocity);
        FieldVector3D dc2V = new FieldVector3D((RealFieldElement)((RealFieldElement)((RealFieldElement)aOr2.multiply(((RealFieldElement)((RealFieldElement)e2.negate()).add(1.0)).subtract(eSinE.multiply((Object)eSinE)))).multiply((Object)oOsqrtMuA)).divide((Object)epsilon), position, (RealFieldElement)eSinE.divide(epsilon.multiply(mu)), velocity);
        RealFieldElement cof1 = (RealFieldElement)aOr2.multiply(eCosE.subtract((Object)e2));
        RealFieldElement cof2 = (RealFieldElement)((RealFieldElement)aOr2.multiply((Object)epsilon)).multiply((Object)eSinE);
        FieldVector3D dexP = new FieldVector3D(u, dc1P, v, dc2P, cof1, duP, cof2, dvP);
        FieldVector3D dexV = new FieldVector3D(u, dc1V, v, dc2V, cof1, duV, cof2, dvV);
        FieldVector3D deyP = new FieldVector3D(v, dc1P, (RealFieldElement)u.negate(), dc2P, cof1, dvP, (RealFieldElement)cof2.negate(), duP);
        FieldVector3D deyV = new FieldVector3D(v, dc1V, (RealFieldElement)u.negate(), dc2V, cof1, dvV, (RealFieldElement)cof2.negate(), duV);
        this.fillHalfRow((RealFieldElement)this.one, dexP, jacobian[1], 0);
        this.fillHalfRow((RealFieldElement)this.one, dexV, jacobian[1], 3);
        this.fillHalfRow((RealFieldElement)this.one, deyP, jacobian[2], 0);
        this.fillHalfRow((RealFieldElement)this.one, deyV, jacobian[2], 3);
        RealFieldElement cle = (RealFieldElement)((RealFieldElement)((RealFieldElement)u.divide(this.a)).add(this.ex)).subtract(((RealFieldElement)eSinE.multiply((Object)beta)).multiply(this.ey));
        RealFieldElement sle = (RealFieldElement)((RealFieldElement)((RealFieldElement)v.divide(this.a)).add(this.ey)).add(((RealFieldElement)eSinE.multiply((Object)beta)).multiply(this.ex));
        RealFieldElement m1 = (RealFieldElement)beta.multiply((Object)eCosE);
        RealFieldElement m2 = (RealFieldElement)((RealFieldElement)((RealFieldElement)m1.multiply((Object)eCosE)).negate()).add(1.0);
        RealFieldElement m3 = (RealFieldElement)((RealFieldElement)((RealFieldElement)u.multiply(this.ey)).subtract(v.multiply(this.ex))).add(((RealFieldElement)eSinE.multiply((Object)beta)).multiply(((RealFieldElement)u.multiply(this.ex)).add(v.multiply(this.ey))));
        RealFieldElement m4 = (RealFieldElement)((RealFieldElement)sle.negate()).add(((RealFieldElement)cle.multiply((Object)eSinE)).multiply((Object)beta));
        RealFieldElement m5 = (RealFieldElement)cle.add(((RealFieldElement)sle.multiply((Object)eSinE)).multiply((Object)beta));
        RealFieldElement kk = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)m3.multiply(2)).divide((Object)r)).add(aOr.multiply((Object)eSinE))).add(((RealFieldElement)((RealFieldElement)m1.multiply((Object)eSinE)).multiply(((RealFieldElement)m1.add(1.0)).subtract(((RealFieldElement)aOr.add(1.0)).multiply((Object)m2)))).divide((Object)epsilon))).divide((Object)r2);
        RealFieldElement jj = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)m1.multiply((Object)m2)).divide((Object)epsilon)).subtract(1.0)).multiply((Object)oOsqrtMuA);
        this.fillHalfRow(kk, position, jj, velocity, m4, dexP, m5, deyP, (RealFieldElement)((RealFieldElement)sle.negate()).divide(this.a), duP, (RealFieldElement)cle.divide(this.a), dvP, jacobian[5], 0);
        RealFieldElement ll = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)m1.multiply((Object)m2)).divide((Object)epsilon)).subtract(1.0)).multiply((Object)oOsqrtMuA);
        RealFieldElement mm = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)m3.multiply(2)).add(eSinE.multiply(this.a))).add(((RealFieldElement)((RealFieldElement)((RealFieldElement)m1.multiply((Object)eSinE)).multiply((Object)r)).multiply(((RealFieldElement)((RealFieldElement)eCosE.multiply((Object)beta)).multiply(2)).subtract(aOr.multiply((Object)m2)))).divide((Object)epsilon))).divide(mu);
        this.fillHalfRow(ll, position, mm, velocity, m4, dexV, m5, deyV, (RealFieldElement)((RealFieldElement)sle.negate()).divide(this.a), duV, (RealFieldElement)cle.divide(this.a), dvV, jacobian[5], 3);
        return jacobian;
    }

    @Override
    protected T[][] computeJacobianEccentricWrtCartesian() {
        RealFieldElement[][] jacobian = this.computeJacobianMeanWrtCartesian();
        T alphaE = this.getAlphaE();
        RealFieldElement cosAe = (RealFieldElement)alphaE.cos();
        RealFieldElement sinAe = (RealFieldElement)alphaE.sin();
        RealFieldElement aOr = (RealFieldElement)this.one.divide(((RealFieldElement)this.one.subtract(this.ex.multiply((Object)cosAe))).subtract(this.ey.multiply((Object)sinAe)));
        RealFieldElement[] rowEx = jacobian[1];
        RealFieldElement[] rowEy = jacobian[2];
        RealFieldElement[] rowL = jacobian[5];
        for (int j = 0; j < 6; ++j) {
            rowL[j] = (RealFieldElement)aOr.multiply(((RealFieldElement)rowL[j].add(sinAe.multiply((Object)rowEx[j]))).subtract(cosAe.multiply((Object)rowEy[j])));
        }
        jacobian[5] = rowL;
        return jacobian;
    }

    @Override
    protected T[][] computeJacobianTrueWrtCartesian() {
        RealFieldElement[][] jacobian = this.computeJacobianEccentricWrtCartesian();
        T alphaE = this.getAlphaE();
        RealFieldElement cosAe = (RealFieldElement)alphaE.cos();
        RealFieldElement sinAe = (RealFieldElement)alphaE.sin();
        RealFieldElement eSinE = (RealFieldElement)((RealFieldElement)this.ex.multiply((Object)sinAe)).subtract(this.ey.multiply((Object)cosAe));
        RealFieldElement ecosE = (RealFieldElement)((RealFieldElement)this.ex.multiply((Object)cosAe)).add(this.ey.multiply((Object)sinAe));
        RealFieldElement e2 = (RealFieldElement)((RealFieldElement)this.ex.multiply(this.ex)).add(this.ey.multiply(this.ey));
        RealFieldElement epsilon = (RealFieldElement)((RealFieldElement)this.one.subtract((Object)e2)).sqrt();
        RealFieldElement onePeps = (RealFieldElement)this.one.add((Object)epsilon);
        RealFieldElement d = (RealFieldElement)onePeps.subtract((Object)ecosE);
        RealFieldElement cT = (RealFieldElement)((RealFieldElement)((RealFieldElement)d.multiply((Object)d)).add(eSinE.multiply((Object)eSinE))).divide(2.0);
        RealFieldElement cE = (RealFieldElement)((RealFieldElement)ecosE.multiply((Object)onePeps)).subtract((Object)e2);
        RealFieldElement cX = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.ex.multiply((Object)eSinE)).divide((Object)epsilon)).subtract(this.ey)).add(sinAe.multiply((Object)onePeps));
        RealFieldElement cY = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.ey.multiply((Object)eSinE)).divide((Object)epsilon)).add(this.ex)).subtract(cosAe.multiply((Object)onePeps));
        RealFieldElement factorLe = (RealFieldElement)((RealFieldElement)cT.add((Object)cE)).divide((Object)cT);
        RealFieldElement factorEx = (RealFieldElement)cX.divide((Object)cT);
        RealFieldElement factorEy = (RealFieldElement)cY.divide((Object)cT);
        RealFieldElement[] rowEx = jacobian[1];
        RealFieldElement[] rowEy = jacobian[2];
        RealFieldElement[] rowA = jacobian[5];
        for (int j = 0; j < 6; ++j) {
            rowA[j] = (RealFieldElement)((RealFieldElement)((RealFieldElement)factorLe.multiply((Object)rowA[j])).add(factorEx.multiply((Object)rowEx[j]))).add(factorEy.multiply((Object)rowEy[j]));
        }
        return jacobian;
    }

    @Override
    public void addKeplerContribution(PositionAngle type, double gm, T[] pDot) {
        RealFieldElement n = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.a.reciprocal()).multiply(gm)).sqrt()).divide(this.a);
        switch (type) {
            case MEAN: {
                pDot[5] = (RealFieldElement)pDot[5].add((Object)n);
                break;
            }
            case ECCENTRIC: {
                RealFieldElement oMe2 = (RealFieldElement)((RealFieldElement)this.one.subtract(this.ex.multiply(this.ex))).subtract(this.ey.multiply(this.ey));
                RealFieldElement ksi = (RealFieldElement)((RealFieldElement)this.one.add(this.ex.multiply(this.alphaV.cos()))).add(this.ey.multiply(this.alphaV.sin()));
                pDot[5] = (RealFieldElement)pDot[5].add(((RealFieldElement)n.multiply((Object)ksi)).divide((Object)oMe2));
                break;
            }
            case TRUE: {
                RealFieldElement oMe2 = (RealFieldElement)((RealFieldElement)this.one.subtract(this.ex.multiply(this.ex))).subtract(this.ey.multiply(this.ey));
                RealFieldElement ksi = (RealFieldElement)((RealFieldElement)this.one.add(this.ex.multiply(this.alphaV.cos()))).add(this.ey.multiply(this.alphaV.sin()));
                pDot[5] = (RealFieldElement)pDot[5].add(((RealFieldElement)((RealFieldElement)n.multiply((Object)ksi)).multiply((Object)ksi)).divide(oMe2.multiply(oMe2.sqrt())));
                break;
            }
            default: {
                throw new OrekitInternalError(null);
            }
        }
    }

    public String toString() {
        return new StringBuffer().append("circular parameters: ").append('{').append("a: ").append(this.a.getReal()).append(", ex: ").append(this.ex.getReal()).append(", ey: ").append(this.ey.getReal()).append(", i: ").append(FastMath.toDegrees((double)this.i.getReal())).append(", raan: ").append(FastMath.toDegrees((double)this.raan.getReal())).append(", alphaV: ").append(FastMath.toDegrees((double)this.alphaV.getReal())).append(";}").toString();
    }

    public static <T extends RealFieldElement<T>> T normalizeAngle(T a, T center) {
        return (T)((RealFieldElement)a.subtract(Math.PI * 2 * FastMath.floor((double)((a.getReal() + Math.PI - center.getReal()) / (Math.PI * 2)))));
    }

    @Override
    public CircularOrbit toOrbit() {
        if (this.hasDerivatives()) {
            return new CircularOrbit(this.a.getReal(), this.ex.getReal(), this.ey.getReal(), this.i.getReal(), this.raan.getReal(), this.alphaV.getReal(), this.aDot.getReal(), this.exDot.getReal(), this.eyDot.getReal(), this.iDot.getReal(), this.raanDot.getReal(), this.alphaVDot.getReal(), PositionAngle.TRUE, this.getFrame(), this.getDate().toAbsoluteDate(), this.getMu());
        }
        return new CircularOrbit(this.a.getReal(), this.ex.getReal(), this.ey.getReal(), this.i.getReal(), this.raan.getReal(), this.alphaV.getReal(), PositionAngle.TRUE, this.getFrame(), this.getDate().toAbsoluteDate(), this.getMu());
    }
}

