/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.gnss.attitude;

import java.io.Serializable;
import org.hipparchus.util.FastMath;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeStamped;

class TurnSpan
implements Serializable,
TimeStamped {
    private static final long serialVersionUID = 20180626L;
    private final double endMargin;
    private AbsoluteDate start;
    private AbsoluteDate end;
    private AbsoluteDate endPlusMargin;
    private double startProjection;
    private double endProjection;
    private double duration;

    TurnSpan(AbsoluteDate start, AbsoluteDate end, AbsoluteDate estimationDate, double endMargin) {
        this.endMargin = endMargin;
        this.start = start;
        this.end = end;
        this.endPlusMargin = end.shiftedBy(endMargin);
        this.startProjection = FastMath.abs((double)start.durationFrom(estimationDate));
        this.endProjection = FastMath.abs((double)this.endPlusMargin.durationFrom(estimationDate));
        this.duration = end.durationFrom(start);
    }

    public void updateStart(AbsoluteDate newStart, AbsoluteDate estimationDate) {
        double newStartProjection = FastMath.abs((double)newStart.durationFrom(estimationDate));
        if (newStartProjection <= this.startProjection) {
            this.start = newStart;
            this.startProjection = newStartProjection;
            this.duration = this.end.durationFrom(this.start);
        }
    }

    public void updateEnd(AbsoluteDate newEnd, AbsoluteDate estimationDate) {
        double newEndProjection = FastMath.abs((double)newEnd.durationFrom(estimationDate));
        if (newEndProjection <= this.endProjection) {
            this.end = newEnd;
            this.endPlusMargin = newEnd.shiftedBy(this.endMargin);
            this.endProjection = newEndProjection;
            this.duration = this.end.durationFrom(this.start);
        }
    }

    @Override
    public AbsoluteDate getDate() {
        return this.endPlusMargin;
    }

    public double getTurnDuration() {
        return this.duration;
    }

    public AbsoluteDate getTurnStartDate() {
        return this.start;
    }

    public AbsoluteDate getTurnEndDate() {
        return this.end;
    }

    public boolean inTurnTimeRange(AbsoluteDate date) {
        return date.durationFrom(this.start) >= 0.0 && date.durationFrom(this.endPlusMargin) <= 0.0;
    }
}

