/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.gravity.potential;

import org.hipparchus.util.FastMath;
import org.orekit.data.BodiesElements;

public class OceanTidesWave {
    private static final int START_DEGREE = 2;
    private final int degree;
    private final int order;
    private final int doodson;
    private final int cGamma;
    private final int cL;
    private final int cLPrime;
    private final int cF;
    private final int cD;
    private final int cOmega;
    private final double[][] cPlus;
    private final double[][] sPlus;
    private final double[][] cMinus;
    private final double[][] sMinus;

    public OceanTidesWave(int doodson, int degree, int order, double[][][] coefficients) {
        int cTau;
        this.doodson = doodson;
        int cPs = doodson % 10 - 5;
        int cNPrime = doodson / 10 % 10 - 5;
        int cP = doodson / 100 % 10 - 5;
        int cH = doodson / 1000 % 10 - 5;
        int cS = doodson / 10000 % 10 - 5;
        this.cGamma = cTau = doodson / 100000 % 10;
        this.cL = -cP;
        this.cLPrime = -cPs;
        this.cF = -cTau + cS + cH + cP + cPs;
        this.cD = -cH - cPs;
        this.cOmega = -cTau + cS + cH + cP - cNPrime + cPs;
        this.degree = degree;
        this.order = order;
        int rows = degree + 1;
        this.cPlus = new double[rows][];
        this.sPlus = new double[rows][];
        this.cMinus = new double[rows][];
        this.sMinus = new double[rows][];
        for (int i = 0; i <= degree; ++i) {
            int m = FastMath.min((int)i, (int)order) + 1;
            double[][] row = coefficients[i];
            this.cPlus[i] = new double[m];
            this.sPlus[i] = new double[m];
            this.cMinus[i] = new double[m];
            this.sMinus[i] = new double[m];
            for (int j = 0; j < m; ++j) {
                this.cPlus[i][j] = row[j][0];
                this.sPlus[i][j] = row[j][1];
                this.cMinus[i][j] = row[j][2];
                this.sMinus[i][j] = row[j][3];
            }
        }
    }

    public int getMaxDegree() {
        return this.degree;
    }

    public int getMaxOrder() {
        return this.order;
    }

    public int getDoodson() {
        return this.doodson;
    }

    public void addContribution(BodiesElements elements, double[][] cnm, double[][] snm) {
        double thetaF = (double)this.cGamma * elements.getGamma() + (double)this.cL * elements.getL() + (double)this.cLPrime * elements.getLPrime() + (double)this.cF * elements.getF() + (double)this.cD * elements.getD() + (double)this.cOmega * elements.getOmega();
        double cos = FastMath.cos((double)thetaF);
        double sin = FastMath.sin((double)thetaF);
        for (int i = 2; i <= this.degree; ++i) {
            for (int j = 0; j <= FastMath.min((int)i, (int)this.order); ++j) {
                double[] dArray = cnm[i];
                int n = j;
                dArray[n] = dArray[n] + ((this.cPlus[i][j] + this.cMinus[i][j]) * cos + (this.sPlus[i][j] + this.sMinus[i][j]) * sin);
                double[] dArray2 = snm[i];
                int n2 = j;
                dArray2[n2] = dArray2[n2] + ((this.sPlus[i][j] - this.sMinus[i][j]) * cos - (this.cPlus[i][j] - this.cMinus[i][j]) * sin);
            }
        }
    }
}

