/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.generation;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.estimation.measurements.generation.Scheduler;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.PropagatorsParallelizer;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.sampling.MultiSatStepHandler;
import org.orekit.propagation.sampling.OrekitStepInterpolator;
import org.orekit.time.AbsoluteDate;

public class Generator {
    private final List<Propagator> propagators = new ArrayList<Propagator>();
    private final List<Scheduler<?>> schedulers = new ArrayList();

    public ObservableSatellite addPropagator(Propagator propagator) {
        this.propagators.add(propagator);
        return new ObservableSatellite(this.propagators.size() - 1);
    }

    public Propagator getPropagator(ObservableSatellite satellite) {
        return this.propagators.get(satellite.getPropagatorIndex());
    }

    public <T extends ObservedMeasurement<T>> void addScheduler(Scheduler<T> scheduler) {
        this.schedulers.add(scheduler);
    }

    public SortedSet<ObservedMeasurement<?>> generate(AbsoluteDate start, AbsoluteDate end) {
        for (Scheduler<?> scheduler : this.schedulers) {
            scheduler.init(start, end);
        }
        GeneratorHandler handler = new GeneratorHandler(this.schedulers);
        PropagatorsParallelizer parallelizer = new PropagatorsParallelizer(this.propagators, handler);
        parallelizer.propagate(start, end);
        return handler.getMeasurements();
    }

    private static class GeneratorHandler
    implements MultiSatStepHandler {
        private final List<Scheduler<?>> schedulers;
        private final SortedSet<ObservedMeasurement<?>> measurements;

        GeneratorHandler(List<Scheduler<?>> schedulers) {
            this.schedulers = schedulers;
            this.measurements = new TreeSet();
        }

        @Override
        public void init(List<SpacecraftState> states0, AbsoluteDate t) {
            for (Scheduler<?> scheduler : this.schedulers) {
                scheduler.init(states0.get(0).getDate(), t);
            }
        }

        @Override
        public void handleStep(List<OrekitStepInterpolator> interpolators, boolean isLast) {
            for (Scheduler<?> scheduler : this.schedulers) {
                this.measurements.addAll(scheduler.generate(interpolators));
            }
        }

        public SortedSet<ObservedMeasurement<?>> getMeasurements() {
            return this.measurements;
        }
    }
}

