/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.analysis.interpolation;

import org.hipparchus.analysis.interpolation.UnivariateInterpolator;
import org.hipparchus.analysis.polynomials.PolynomialFunction;
import org.hipparchus.analysis.polynomials.PolynomialSplineFunction;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.util.MathArrays;

public class LinearInterpolator
implements UnivariateInterpolator {
    @Override
    public PolynomialSplineFunction interpolate(double[] x, double[] y) throws MathIllegalArgumentException {
        if (x.length != y.length) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, x.length, y.length);
        }
        if (x.length < 2) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_OF_POINTS, x.length, 2, true);
        }
        int n = x.length - 1;
        MathArrays.checkOrder(x);
        double[] m = new double[n];
        for (int i = 0; i < n; ++i) {
            m[i] = (y[i + 1] - y[i]) / (x[i + 1] - x[i]);
        }
        PolynomialFunction[] polynomials = new PolynomialFunction[n];
        double[] coefficients = new double[2];
        for (int i = 0; i < n; ++i) {
            coefficients[0] = y[i];
            coefficients[1] = m[i];
            polynomials[i] = new PolynomialFunction(coefficients);
        }
        return new PolynomialSplineFunction(x, polynomials);
    }
}

