/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.ode.ODEJacobiansProvider;
import org.hipparchus.ode.OrdinaryDifferentialEquation;
import org.hipparchus.ode.ParameterConfiguration;
import org.hipparchus.ode.ParametersController;

class ParameterJacobianWrapper
implements ODEJacobiansProvider {
    private final OrdinaryDifferentialEquation ode;
    private final double[] hY;
    private final ParametersController controller;
    private final Map<String, Double> hParam;

    ParameterJacobianWrapper(OrdinaryDifferentialEquation ode, double[] hY, ParametersController controller, ParameterConfiguration[] paramsAndSteps) {
        this.ode = ode;
        this.hY = (double[])hY.clone();
        this.controller = controller;
        this.hParam = new HashMap<String, Double>();
        for (ParameterConfiguration param : paramsAndSteps) {
            String name = param.getParameterName();
            if (!controller.isSupported(name)) continue;
            this.hParam.put(name, param.getHP());
        }
    }

    public OrdinaryDifferentialEquation getODE() {
        return this.ode;
    }

    @Override
    public int getDimension() {
        return this.ode.getDimension();
    }

    @Override
    public double[] computeDerivatives(double t, double[] y) throws MathIllegalArgumentException, MathIllegalStateException {
        return this.ode.computeDerivatives(t, y);
    }

    @Override
    public double[][] computeMainStateJacobian(double t, double[] y, double[] yDot) throws MathIllegalArgumentException, MathIllegalStateException {
        int n = this.ode.getDimension();
        double[][] dFdY = new double[n][n];
        for (int j = 0; j < n; ++j) {
            double savedYj = y[j];
            int n2 = j;
            y[n2] = y[n2] + this.hY[j];
            double[] tmpDot = this.ode.computeDerivatives(t, y);
            for (int i = 0; i < n; ++i) {
                dFdY[i][j] = (tmpDot[i] - yDot[i]) / this.hY[j];
            }
            y[j] = savedYj;
        }
        return dFdY;
    }

    @Override
    public List<String> getParametersNames() {
        return this.controller.getParametersNames();
    }

    @Override
    public boolean isSupported(String name) {
        return this.controller.isSupported(name);
    }

    @Override
    public double[] computeParameterJacobian(double t, double[] y, double[] yDot, String paramName) throws MathIllegalArgumentException, MathIllegalStateException {
        int n = this.ode.getDimension();
        double[] dFdP = new double[n];
        if (this.controller.isSupported(paramName)) {
            double p = this.controller.getParameter(paramName);
            double hP = this.hParam.get(paramName);
            this.controller.setParameter(paramName, p + hP);
            double[] tmpDot = this.ode.computeDerivatives(t, y);
            for (int i = 0; i < n; ++i) {
                dFdP[i] = (tmpDot[i] - yDot[i]) / hP;
            }
            this.controller.setParameter(paramName, p);
        } else {
            Arrays.fill(dFdP, 0, n, 0.0);
        }
        return dFdP;
    }
}

