/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode;

import java.util.Collection;
import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.analysis.solvers.BracketedUnivariateSolver;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.ode.ExpandableODE;
import org.hipparchus.ode.ODEState;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.hipparchus.ode.OrdinaryDifferentialEquation;
import org.hipparchus.ode.events.ODEEventHandler;
import org.hipparchus.ode.sampling.ODEStepHandler;

public interface ODEIntegrator {
    public String getName();

    public void addStepHandler(ODEStepHandler var1);

    public Collection<ODEStepHandler> getStepHandlers();

    public void clearStepHandlers();

    public void addEventHandler(ODEEventHandler var1, double var2, double var4, int var6);

    public void addEventHandler(ODEEventHandler var1, double var2, double var4, int var6, BracketedUnivariateSolver<UnivariateFunction> var7);

    public Collection<ODEEventHandler> getEventHandlers();

    public void clearEventHandlers();

    @Deprecated
    public double getCurrentStepStart();

    public ODEStateAndDerivative getStepStart();

    public double getCurrentSignedStepsize();

    public void setMaxEvaluations(int var1);

    public int getMaxEvaluations();

    public int getEvaluations();

    public ODEStateAndDerivative integrate(ExpandableODE var1, ODEState var2, double var3) throws MathIllegalArgumentException, MathIllegalStateException;

    default public ODEStateAndDerivative integrate(OrdinaryDifferentialEquation equations, ODEState initialState, double finalTime) throws MathIllegalArgumentException, MathIllegalStateException {
        return this.integrate(new ExpandableODE(equations), initialState, finalTime);
    }

    @Deprecated
    default public double integrate(OrdinaryDifferentialEquation equations, double t0, double[] y0, double t, double[] y) throws MathIllegalArgumentException, MathIllegalStateException {
        if (y0.length != equations.getDimension()) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, new Object[]{y0.length, equations.getDimension()});
        }
        if (y.length != equations.getDimension()) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, new Object[]{y.length, equations.getDimension()});
        }
        ExpandableODE expandableODE = new ExpandableODE(equations);
        ODEState initialState = new ODEState(t0, y0);
        ODEStateAndDerivative finalState = this.integrate(expandableODE, initialState, t);
        System.arraycopy(finalState.getPrimaryState(), 0, y, 0, y.length);
        return finalState.getTime();
    }
}

