/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.forces;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.forces.gravity.potential.UnnormalizedSphericalHarmonicsProvider;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.semianalytical.dsst.forces.DSSTForceModel;
import org.orekit.propagation.semianalytical.dsst.forces.ShortPeriodTerms;
import org.orekit.propagation.semianalytical.dsst.utilities.AuxiliaryElements;
import org.orekit.propagation.semianalytical.dsst.utilities.CoefficientsFactory;
import org.orekit.propagation.semianalytical.dsst.utilities.GHmsjPolynomials;
import org.orekit.propagation.semianalytical.dsst.utilities.GammaMnsFunction;
import org.orekit.propagation.semianalytical.dsst.utilities.JacobiPolynomials;
import org.orekit.propagation.semianalytical.dsst.utilities.ShortPeriodicsInterpolatedCoefficient;
import org.orekit.propagation.semianalytical.dsst.utilities.hansen.HansenTesseralLinear;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.TimeSpanMap;

public class DSSTTesseral
implements DSSTForceModel {
    private static final double MIN_PERIOD_IN_SECONDS = 864000.0;
    private static final double MIN_PERIOD_IN_SAT_REV = 10.0;
    private static final int INTERPOLATION_POINTS = 3;
    private static final int I = 1;
    private final UnnormalizedSphericalHarmonicsProvider provider;
    private final Frame bodyFrame;
    private final double centralBodyRotationRate;
    private final double bodyPeriod;
    private final int maxDegree;
    private final int maxDegreeTesseralSP;
    private final int maxDegreeMdailyTesseralSP;
    private final int maxOrder;
    private final int maxOrderTesseralSP;
    private final int maxOrderMdailyTesseralSP;
    private final List<Integer> resOrders;
    private int maxEccPow;
    private final int maxEccPowTesseralSP;
    private final int maxEccPowMdailyTesseralSP;
    private final int maxFrequencyShortPeriodics;
    private int maxHansen;
    private double orbitPeriod;
    private double ratio;
    private double a;
    private double k;
    private double h;
    private double q;
    private double p;
    private double lm;
    private double ecc;
    private double chi;
    private double chi2;
    private Vector3D f;
    private Vector3D g;
    private double theta;
    private double alpha;
    private double beta;
    private double gamma;
    private double ax2oA;
    private double ooAB;
    private double BoA;
    private double BoABpo;
    private double Co2AB;
    private double moa;
    private double roa;
    private double e2;
    private double meanMotion;
    private final SortedMap<Integer, List<Integer>> nonResOrders;
    private HansenTesseralLinear[][] hansenObjects;
    private FourierCjSjCoefficients cjsjFourier;
    private TesseralShortPeriodicCoefficients shortPeriodTerms;
    private final DSFactory factory;

    public DSSTTesseral(Frame centralBodyFrame, double centralBodyRotationRate, UnnormalizedSphericalHarmonicsProvider provider, int maxDegreeTesseralSP, int maxOrderTesseralSP, int maxEccPowTesseralSP, int maxFrequencyShortPeriodics, int maxDegreeMdailyTesseralSP, int maxOrderMdailyTesseralSP, int maxEccPowMdailyTesseralSP) {
        this.bodyFrame = centralBodyFrame;
        this.centralBodyRotationRate = centralBodyRotationRate;
        this.bodyPeriod = Math.PI * 2 / centralBodyRotationRate;
        this.provider = provider;
        this.maxDegree = provider.getMaxDegree();
        this.maxOrder = provider.getMaxOrder();
        this.checkIndexRange(maxDegreeTesseralSP, 2, this.maxDegree);
        this.maxDegreeTesseralSP = maxDegreeTesseralSP;
        this.checkIndexRange(maxDegreeMdailyTesseralSP, 2, this.maxDegree);
        this.maxDegreeMdailyTesseralSP = maxDegreeMdailyTesseralSP;
        this.checkIndexRange(maxOrderTesseralSP, 0, this.maxOrder);
        this.maxOrderTesseralSP = maxOrderTesseralSP;
        this.checkIndexRange(maxOrderMdailyTesseralSP, 0, this.maxOrder);
        this.maxOrderMdailyTesseralSP = maxOrderMdailyTesseralSP;
        this.maxEccPowTesseralSP = maxEccPowTesseralSP;
        this.checkIndexRange(maxEccPowMdailyTesseralSP, 0, maxDegreeMdailyTesseralSP - 2);
        this.maxEccPowMdailyTesseralSP = maxEccPowMdailyTesseralSP;
        this.maxFrequencyShortPeriodics = maxFrequencyShortPeriodics;
        this.resOrders = new ArrayList<Integer>();
        this.nonResOrders = new TreeMap<Integer, List<Integer>>();
        this.maxEccPow = 0;
        this.maxHansen = 0;
        this.factory = new DSFactory(1, 1);
    }

    private void checkIndexRange(int index, int min, int max) {
        if (index < min || index > max) {
            throw new OrekitException((Localizable)LocalizedCoreFormats.OUT_OF_RANGE_SIMPLE, index, min, max);
        }
    }

    @Override
    public List<ShortPeriodTerms> initialize(AuxiliaryElements aux, boolean meanOnly) {
        this.orbitPeriod = aux.getKeplerianPeriod();
        double e = aux.getEcc();
        this.maxEccPow = e <= 0.005 ? 3 : (e <= 0.02 ? 4 : (e <= 0.1 ? 7 : (e <= 0.2 ? 10 : (e <= 0.3 ? 12 : (e <= 0.4 ? 15 : 20)))));
        this.maxHansen = this.maxEccPow / 2;
        this.ratio = this.orbitPeriod / this.bodyPeriod;
        this.getResonantAndNonResonantTerms(meanOnly);
        this.createHansenObjects(meanOnly);
        int mMax = FastMath.max((int)this.maxOrderTesseralSP, (int)this.maxOrderMdailyTesseralSP);
        this.cjsjFourier = new FourierCjSjCoefficients(this.maxFrequencyShortPeriodics, mMax);
        this.shortPeriodTerms = new TesseralShortPeriodicCoefficients(this.bodyFrame, this.maxOrderMdailyTesseralSP, this.maxDegreeTesseralSP < 0, this.nonResOrders, mMax, this.maxFrequencyShortPeriodics, 3, new TimeSpanMap<Slot>(new Slot(mMax, this.maxFrequencyShortPeriodics, 3)));
        ArrayList<ShortPeriodTerms> list = new ArrayList<ShortPeriodTerms>();
        list.add(this.shortPeriodTerms);
        return list;
    }

    private void createHansenObjects(boolean meanOnly) {
        int rows = 2 * this.maxDegree + 1;
        int columns = this.maxFrequencyShortPeriodics + 1;
        this.hansenObjects = new HansenTesseralLinear[rows][columns];
        if (meanOnly) {
            for (int m : this.resOrders) {
                int j = FastMath.max((int)1, (int)((int)FastMath.round((double)(this.ratio * (double)m))));
                int sMin = FastMath.min((int)(this.maxEccPow - j), (int)this.maxDegree);
                int sMax = FastMath.min((int)(this.maxEccPow + j), (int)this.maxDegree);
                for (int s = 0; s <= sMax; ++s) {
                    int n0 = FastMath.max((int)FastMath.max((int)2, (int)m), (int)s);
                    this.hansenObjects[s + this.maxDegree][j] = new HansenTesseralLinear(this.maxDegree, s, j, n0, this.maxHansen);
                    if (s <= 0 || s > sMin) continue;
                    this.hansenObjects[this.maxDegree - s][j] = new HansenTesseralLinear(this.maxDegree, -s, j, n0, this.maxHansen);
                }
            }
        } else {
            for (int j = 0; j <= this.maxFrequencyShortPeriodics; ++j) {
                for (int s = -this.maxDegree; s <= this.maxDegree; ++s) {
                    int n0 = FastMath.max((int)2, (int)FastMath.abs((int)s));
                    this.hansenObjects[s + this.maxDegree][j] = new HansenTesseralLinear(this.maxDegree, s, j, n0, this.maxHansen);
                }
            }
        }
    }

    @Override
    public void initializeStep(AuxiliaryElements aux) {
        this.a = aux.getSma();
        this.k = aux.getK();
        this.h = aux.getH();
        this.q = aux.getQ();
        this.p = aux.getP();
        this.lm = aux.getLM();
        this.ecc = aux.getEcc();
        this.e2 = this.ecc * this.ecc;
        this.f = aux.getVectorF();
        this.g = aux.getVectorG();
        Transform t = this.bodyFrame.getTransformTo(aux.getFrame(), aux.getDate());
        Vector3D xB = t.transformVector(Vector3D.PLUS_I);
        Vector3D yB = t.transformVector(Vector3D.PLUS_J);
        this.theta = FastMath.atan2((double)(-this.f.dotProduct((Vector)yB) + 1.0 * this.g.dotProduct((Vector)xB)), (double)(this.f.dotProduct((Vector)xB) + 1.0 * this.g.dotProduct((Vector)yB)));
        this.alpha = aux.getAlpha();
        this.beta = aux.getBeta();
        this.gamma = aux.getGamma();
        double A = aux.getA();
        double B = aux.getB();
        double C = aux.getC();
        this.ax2oA = 2.0 * this.a / A;
        this.BoA = B / A;
        this.ooAB = 1.0 / (A * B);
        this.Co2AB = C * this.ooAB / 2.0;
        this.BoABpo = this.BoA / (1.0 + B);
        this.moa = this.provider.getMu() / this.a;
        this.roa = this.provider.getAe() / this.a;
        this.chi = 1.0 / B;
        this.chi2 = this.chi * this.chi;
        this.meanMotion = aux.getMeanMotion();
    }

    @Override
    public double[] getMeanElementRate(SpacecraftState spacecraftState) {
        double[] dU = this.computeUDerivatives(spacecraftState.getDate());
        double dUda = dU[0];
        double dUdh = dU[1];
        double dUdk = dU[2];
        double dUdl = dU[3];
        double dUdAl = dU[4];
        double dUdBe = dU[5];
        double dUdGa = dU[6];
        double UAlphaGamma = this.alpha * dUdGa - this.gamma * dUdAl;
        double UAlphaBeta = this.alpha * dUdBe - this.beta * dUdAl;
        double UBetaGamma = this.beta * dUdGa - this.gamma * dUdBe;
        double Uhk = this.h * dUdk - this.k * dUdh;
        double pUagmIqUbgoAB = (this.p * UAlphaGamma - 1.0 * this.q * UBetaGamma) * this.ooAB;
        double UhkmUabmdUdl = Uhk - UAlphaBeta - dUdl;
        double da = this.ax2oA * dUdl;
        double dh = this.BoA * dUdk + this.k * pUagmIqUbgoAB - this.h * this.BoABpo * dUdl;
        double dk = -(this.BoA * dUdh + this.h * pUagmIqUbgoAB + this.k * this.BoABpo * dUdl);
        double dp = this.Co2AB * (this.p * UhkmUabmdUdl - UBetaGamma);
        double dq = this.Co2AB * (this.q * UhkmUabmdUdl - 1.0 * UAlphaGamma);
        double dM = -this.ax2oA * dUda + this.BoABpo * (this.h * dUdh + this.k * dUdk) + pUagmIqUbgoAB;
        return new double[]{da, dk, dh, dq, dp, dM};
    }

    @Override
    public void updateShortPeriodTerms(SpacecraftState ... meanStates) {
        Slot slot = this.shortPeriodTerms.createSlot(meanStates);
        for (SpacecraftState meanState : meanStates) {
            this.initializeStep(new AuxiliaryElements(meanState.getOrbit(), 1));
            for (int s = -this.maxDegree; s <= this.maxDegree; ++s) {
                this.hansenObjects[s + this.maxDegree][0].computeInitValues(this.e2, this.chi, this.chi2);
                if (this.maxDegreeTesseralSP < 0) continue;
                for (int j = 1; j <= this.maxFrequencyShortPeriodics; ++j) {
                    this.hansenObjects[s + this.maxDegree][j].computeInitValues(this.e2, this.chi, this.chi2);
                }
            }
            if (this.nonResOrders.isEmpty() && this.maxDegreeTesseralSP >= 0) continue;
            this.cjsjFourier.generateCoefficients(meanState.getDate());
            double tnota = 1.5 * this.meanMotion / this.a;
            for (int m = 1; m <= this.maxOrderMdailyTesseralSP; ++m) {
                this.buildCoefficients(meanState.getDate(), slot, m, 0, tnota);
            }
            if (this.maxDegreeTesseralSP < 0) continue;
            for (Map.Entry<Integer, List<Integer>> entry : this.nonResOrders.entrySet()) {
                for (int j : entry.getValue()) {
                    this.buildCoefficients(meanState.getDate(), slot, entry.getKey(), j, tnota);
                }
            }
        }
    }

    private void buildCoefficients(AbsoluteDate date, Slot slot, int m, int j, double tnota) {
        int i;
        double[] currentCijm = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] currentSijm = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double oojnmt = 1.0 / ((double)j * this.meanMotion - (double)m * this.centralBodyRotationRate);
        for (i = 0; i < 6; ++i) {
            currentCijm[i] = -this.cjsjFourier.getSijm(i, j, m);
            currentSijm[i] = this.cjsjFourier.getCijm(i, j, m);
        }
        currentCijm[5] = currentCijm[5] + tnota * oojnmt * this.cjsjFourier.getCijm(0, j, m);
        currentSijm[5] = currentSijm[5] + tnota * oojnmt * this.cjsjFourier.getSijm(0, j, m);
        i = 0;
        while (i < 6) {
            int n = i;
            currentCijm[n] = currentCijm[n] * oojnmt;
            int n2 = i++;
            currentSijm[n2] = currentSijm[n2] * oojnmt;
        }
        slot.cijm[m][j + this.maxFrequencyShortPeriodics].addGridPoint(date, currentCijm);
        slot.sijm[m][j + this.maxFrequencyShortPeriodics].addGridPoint(date, currentSijm);
    }

    @Override
    public EventDetector[] getEventsDetectors() {
        return null;
    }

    private void getResonantAndNonResonantTerms(boolean resonantOnly) {
        double tolerance = 1.0 / FastMath.max((double)10.0, (double)(864000.0 / this.orbitPeriod));
        this.resOrders.clear();
        this.nonResOrders.clear();
        for (int m = 1; m <= this.maxOrder; ++m) {
            double resonance = this.ratio * (double)m;
            int jRes = 0;
            int jComputedRes = (int)FastMath.round((double)resonance);
            if (jComputedRes > 0 && jComputedRes <= this.maxFrequencyShortPeriodics && FastMath.abs((double)(resonance - (double)jComputedRes)) <= tolerance) {
                this.resOrders.add(m);
                jRes = jComputedRes;
            }
            if (resonantOnly || this.maxDegreeTesseralSP < 0 || m > this.maxOrderTesseralSP) continue;
            ArrayList<Integer> listJofM = new ArrayList<Integer>();
            for (int j = -this.maxFrequencyShortPeriodics; j <= this.maxFrequencyShortPeriodics; ++j) {
                if (j == 0 || j == jRes) continue;
                listJofM.add(j);
            }
            this.nonResOrders.put(m, listJofM);
        }
    }

    private double[] computeUDerivatives(AbsoluteDate date) {
        double dUda = 0.0;
        double dUdh = 0.0;
        double dUdk = 0.0;
        double dUdl = 0.0;
        double dUdAl = 0.0;
        double dUdBe = 0.0;
        double dUdGa = 0.0;
        if (!this.resOrders.isEmpty()) {
            GHmsjPolynomials ghMSJ = new GHmsjPolynomials(this.k, this.h, this.alpha, this.beta, 1);
            GammaMnsFunction gammaMNS = new GammaMnsFunction(this.maxDegree, this.gamma, 1);
            double[] roaPow = new double[this.maxDegree + 1];
            roaPow[0] = 1.0;
            for (int i = 1; i <= this.maxDegree; ++i) {
                roaPow[i] = this.roa * roaPow[i - 1];
            }
            for (int m : this.resOrders) {
                int j = FastMath.max((int)1, (int)((int)FastMath.round((double)(this.ratio * (double)m))));
                double jlMmt = (double)j * this.lm - (double)m * this.theta;
                double sinPhi = FastMath.sin((double)jlMmt);
                double cosPhi = FastMath.cos((double)jlMmt);
                double dUdaCos = 0.0;
                double dUdaSin = 0.0;
                double dUdhCos = 0.0;
                double dUdhSin = 0.0;
                double dUdkCos = 0.0;
                double dUdkSin = 0.0;
                double dUdlCos = 0.0;
                double dUdlSin = 0.0;
                double dUdAlCos = 0.0;
                double dUdAlSin = 0.0;
                double dUdBeCos = 0.0;
                double dUdBeSin = 0.0;
                double dUdGaCos = 0.0;
                double dUdGaSin = 0.0;
                int sMin = FastMath.min((int)(this.maxEccPow - j), (int)this.maxDegree);
                int sMax = FastMath.min((int)(this.maxEccPow + j), (int)this.maxDegree);
                for (int s = 0; s <= sMax; ++s) {
                    this.hansenObjects[s + this.maxDegree][j].computeInitValues(this.e2, this.chi, this.chi2);
                    double[][] nSumSpos = this.computeNSum(date, j, m, s, this.maxDegree, roaPow, ghMSJ, gammaMNS);
                    dUdaCos += nSumSpos[0][0];
                    dUdaSin += nSumSpos[0][1];
                    dUdhCos += nSumSpos[1][0];
                    dUdhSin += nSumSpos[1][1];
                    dUdkCos += nSumSpos[2][0];
                    dUdkSin += nSumSpos[2][1];
                    dUdlCos += nSumSpos[3][0];
                    dUdlSin += nSumSpos[3][1];
                    dUdAlCos += nSumSpos[4][0];
                    dUdAlSin += nSumSpos[4][1];
                    dUdBeCos += nSumSpos[5][0];
                    dUdBeSin += nSumSpos[5][1];
                    dUdGaCos += nSumSpos[6][0];
                    dUdGaSin += nSumSpos[6][1];
                    if (s <= 0 || s > sMin) continue;
                    this.hansenObjects[this.maxDegree - s][j].computeInitValues(this.e2, this.chi, this.chi2);
                    double[][] nSumSneg = this.computeNSum(date, j, m, -s, this.maxDegree, roaPow, ghMSJ, gammaMNS);
                    dUdaCos += nSumSneg[0][0];
                    dUdaSin += nSumSneg[0][1];
                    dUdhCos += nSumSneg[1][0];
                    dUdhSin += nSumSneg[1][1];
                    dUdkCos += nSumSneg[2][0];
                    dUdkSin += nSumSneg[2][1];
                    dUdlCos += nSumSneg[3][0];
                    dUdlSin += nSumSneg[3][1];
                    dUdAlCos += nSumSneg[4][0];
                    dUdAlSin += nSumSneg[4][1];
                    dUdBeCos += nSumSneg[5][0];
                    dUdBeSin += nSumSneg[5][1];
                    dUdGaCos += nSumSneg[6][0];
                    dUdGaSin += nSumSneg[6][1];
                }
                dUda += cosPhi * dUdaCos + sinPhi * dUdaSin;
                dUdh += cosPhi * dUdhCos + sinPhi * dUdhSin;
                dUdk += cosPhi * dUdkCos + sinPhi * dUdkSin;
                dUdl += cosPhi * dUdlCos + sinPhi * dUdlSin;
                dUdAl += cosPhi * dUdAlCos + sinPhi * dUdAlSin;
                dUdBe += cosPhi * dUdBeCos + sinPhi * dUdBeSin;
                dUdGa += cosPhi * dUdGaCos + sinPhi * dUdGaSin;
            }
            dUda *= -this.moa / this.a;
            dUdh *= this.moa;
            dUdk *= this.moa;
            dUdl *= this.moa;
            dUdAl *= this.moa;
            dUdBe *= this.moa;
            dUdGa *= this.moa;
        }
        return new double[]{dUda, dUdh, dUdk, dUdl, dUdAl, dUdBe, dUdGa};
    }

    private double[][] computeNSum(AbsoluteDate date, int j, int m, int s, int maxN, double[] roaPow, GHmsjPolynomials ghMSJ, GammaMnsFunction gammaMNS) {
        UnnormalizedSphericalHarmonicsProvider.UnnormalizedSphericalHarmonics harmonics = this.provider.onDate(date);
        double dUdaCos = 0.0;
        double dUdaSin = 0.0;
        double dUdhCos = 0.0;
        double dUdhSin = 0.0;
        double dUdkCos = 0.0;
        double dUdkSin = 0.0;
        double dUdlCos = 0.0;
        double dUdlSin = 0.0;
        double dUdAlCos = 0.0;
        double dUdAlSin = 0.0;
        double dUdBeCos = 0.0;
        double dUdBeSin = 0.0;
        double dUdGaCos = 0.0;
        double dUdGaSin = 0.0;
        boolean Im = true;
        int v = FastMath.abs((int)(m - s));
        int w = FastMath.abs((int)(m + s));
        int nmin = FastMath.max((int)FastMath.max((int)2, (int)m), (int)FastMath.abs((int)s));
        int sIndex = this.maxDegree + (j < 0 ? -s : s);
        int jIndex = FastMath.abs((int)j);
        HansenTesseralLinear hans = this.hansenObjects[sIndex][jIndex];
        for (int n = nmin; n <= maxN; ++n) {
            if ((n - s) % 2 != 0) continue;
            double vMNS = CoefficientsFactory.getVmns(m, n, s);
            double gaMNS = gammaMNS.getValue(m, n, s);
            double dGaMNS = gammaMNS.getDerivative(m, n, s);
            double kJNS = hans.getValue(-n - 1, this.chi);
            double dkJNS = hans.getDerivative(-n - 1, this.chi);
            double gMSJ = ghMSJ.getGmsj(m, s, j);
            double hMSJ = ghMSJ.getHmsj(m, s, j);
            double dGdh = ghMSJ.getdGmsdh(m, s, j);
            double dGdk = ghMSJ.getdGmsdk(m, s, j);
            double dGdA = ghMSJ.getdGmsdAlpha(m, s, j);
            double dGdB = ghMSJ.getdGmsdBeta(m, s, j);
            double dHdh = ghMSJ.getdHmsdh(m, s, j);
            double dHdk = ghMSJ.getdHmsdk(m, s, j);
            double dHdA = ghMSJ.getdHmsdAlpha(m, s, j);
            double dHdB = ghMSJ.getdHmsdBeta(m, s, j);
            int l = FastMath.min((int)(n - m), (int)(n - FastMath.abs((int)s)));
            DerivativeStructure jacobi = JacobiPolynomials.getValue(l, v, w, this.factory.variable(0, this.gamma));
            double cnm = harmonics.getUnnormalizedCnm(n, m);
            double snm = harmonics.getUnnormalizedSnm(n, m);
            double cf_0 = roaPow[n] * (double)Im * vMNS;
            double cf_1 = cf_0 * gaMNS * jacobi.getValue();
            double cf_2 = cf_1 * kJNS;
            double gcPhs = gMSJ * cnm + hMSJ * snm;
            double gsMhc = gMSJ * snm - hMSJ * cnm;
            double dKgcPhsx2 = 2.0 * dkJNS * gcPhs;
            double dKgsMhcx2 = 2.0 * dkJNS * gsMhc;
            double dUdaCoef = (double)(n + 1) * cf_2;
            double dUdlCoef = (double)j * cf_2;
            double dUdGaCoef = cf_0 * kJNS * (jacobi.getValue() * dGaMNS + gaMNS * jacobi.getPartialDerivative(new int[]{1}));
            dUdaCos += dUdaCoef * gcPhs;
            dUdaSin += dUdaCoef * gsMhc;
            dUdhCos += cf_1 * (kJNS * (cnm * dGdh + snm * dHdh) + this.h * dKgcPhsx2);
            dUdhSin += cf_1 * (kJNS * (snm * dGdh - cnm * dHdh) + this.h * dKgsMhcx2);
            dUdkCos += cf_1 * (kJNS * (cnm * dGdk + snm * dHdk) + this.k * dKgcPhsx2);
            dUdkSin += cf_1 * (kJNS * (snm * dGdk - cnm * dHdk) + this.k * dKgsMhcx2);
            dUdlCos += dUdlCoef * gsMhc;
            dUdlSin += -dUdlCoef * gcPhs;
            dUdAlCos += cf_2 * (dGdA * cnm + dHdA * snm);
            dUdAlSin += cf_2 * (dGdA * snm - dHdA * cnm);
            dUdBeCos += cf_2 * (dGdB * cnm + dHdB * snm);
            dUdBeSin += cf_2 * (dGdB * snm - dHdB * cnm);
            dUdGaCos += dUdGaCoef * gcPhs;
            dUdGaSin += dUdGaCoef * gsMhc;
        }
        return new double[][]{{dUdaCos, dUdaSin}, {dUdhCos, dUdhSin}, {dUdkCos, dUdkSin}, {dUdlCos, dUdlSin}, {dUdAlCos, dUdAlSin}, {dUdBeCos, dUdBeSin}, {dUdGaCos, dUdGaSin}};
    }

    @Override
    public void registerAttitudeProvider(AttitudeProvider attitudeProvider) {
    }

    private static class Slot
    implements Serializable {
        private static final long serialVersionUID = 20160319L;
        private final ShortPeriodicsInterpolatedCoefficient[][] cijm;
        private final ShortPeriodicsInterpolatedCoefficient[][] sijm;

        Slot(int mMax, int jMax, int interpolationPoints) {
            int rows = mMax + 1;
            int columns = 2 * jMax + 1;
            this.cijm = new ShortPeriodicsInterpolatedCoefficient[rows][columns];
            this.sijm = new ShortPeriodicsInterpolatedCoefficient[rows][columns];
            for (int m = 1; m <= mMax; ++m) {
                for (int j = -jMax; j <= jMax; ++j) {
                    this.cijm[m][j + jMax] = new ShortPeriodicsInterpolatedCoefficient(interpolationPoints);
                    this.sijm[m][j + jMax] = new ShortPeriodicsInterpolatedCoefficient(interpolationPoints);
                }
            }
        }

        double[] getCijm(int j, int m, AbsoluteDate date) {
            int jMax = (this.cijm[m].length - 1) / 2;
            return this.cijm[m][j + jMax].value(date);
        }

        double[] getSijm(int j, int m, AbsoluteDate date) {
            int jMax = (this.cijm[m].length - 1) / 2;
            return this.sijm[m][j + jMax].value(date);
        }
    }

    private static class TesseralShortPeriodicCoefficients
    implements ShortPeriodTerms {
        private static final long serialVersionUID = 20151119L;
        private static final int I = 1;
        private final Frame bodyFrame;
        private final int maxOrderMdailyTesseralSP;
        private final boolean mDailiesOnly;
        private final SortedMap<Integer, List<Integer>> nonResOrders;
        private final int mMax;
        private final int jMax;
        private final int interpolationPoints;
        private final transient TimeSpanMap<Slot> slots;

        TesseralShortPeriodicCoefficients(Frame bodyFrame, int maxOrderMdailyTesseralSP, boolean mDailiesOnly, SortedMap<Integer, List<Integer>> nonResOrders, int mMax, int jMax, int interpolationPoints, TimeSpanMap<Slot> slots) {
            this.bodyFrame = bodyFrame;
            this.maxOrderMdailyTesseralSP = maxOrderMdailyTesseralSP;
            this.mDailiesOnly = mDailiesOnly;
            this.nonResOrders = nonResOrders;
            this.mMax = mMax;
            this.jMax = jMax;
            this.interpolationPoints = interpolationPoints;
            this.slots = slots;
        }

        public Slot createSlot(SpacecraftState ... meanStates) {
            AbsoluteDate last;
            Slot slot = new Slot(this.mMax, this.jMax, this.interpolationPoints);
            AbsoluteDate first = meanStates[0].getDate();
            if (first.compareTo(last = meanStates[meanStates.length - 1].getDate()) <= 0) {
                this.slots.addValidAfter(slot, first);
            } else {
                this.slots.addValidBefore(slot, first);
            }
            return slot;
        }

        @Override
        public double[] value(Orbit meanOrbit) {
            Slot slot = this.slots.get(meanOrbit.getDate());
            double[] shortPeriodicVariation = new double[6];
            if (!this.nonResOrders.isEmpty() || this.mDailiesOnly) {
                AuxiliaryElements aux = new AuxiliaryElements(meanOrbit, 1);
                Transform t = this.bodyFrame.getTransformTo(aux.getFrame(), aux.getDate());
                Vector3D xB = t.transformVector(Vector3D.PLUS_I);
                Vector3D yB = t.transformVector(Vector3D.PLUS_J);
                Vector3D f = aux.getVectorF();
                Vector3D g = aux.getVectorG();
                double currentTheta = FastMath.atan2((double)(-f.dotProduct((Vector)yB) + 1.0 * g.dotProduct((Vector)xB)), (double)(f.dotProduct((Vector)xB) + 1.0 * g.dotProduct((Vector)yB)));
                for (int m = 1; m <= this.maxOrderMdailyTesseralSP; ++m) {
                    double jlMmt = (double)(-m) * currentTheta;
                    double sinPhi = FastMath.sin((double)jlMmt);
                    double cosPhi = FastMath.cos((double)jlMmt);
                    double[] c = slot.getCijm(0, m, meanOrbit.getDate());
                    double[] s = slot.getSijm(0, m, meanOrbit.getDate());
                    for (int i = 0; i < 6; ++i) {
                        int n = i;
                        shortPeriodicVariation[n] = shortPeriodicVariation[n] + (c[i] * cosPhi + s[i] * sinPhi);
                    }
                }
                for (Map.Entry<Integer, List<Integer>> entry : this.nonResOrders.entrySet()) {
                    int m = entry.getKey();
                    List<Integer> listJ = entry.getValue();
                    for (int j : listJ) {
                        double jlMmt = (double)j * meanOrbit.getLM() - (double)m * currentTheta;
                        double sinPhi = FastMath.sin((double)jlMmt);
                        double cosPhi = FastMath.cos((double)jlMmt);
                        double[] c = slot.getCijm(j, m, meanOrbit.getDate());
                        double[] s = slot.getSijm(j, m, meanOrbit.getDate());
                        for (int i = 0; i < 6; ++i) {
                            int n = i;
                            shortPeriodicVariation[n] = shortPeriodicVariation[n] + (c[i] * cosPhi + s[i] * sinPhi);
                        }
                    }
                }
            }
            return shortPeriodicVariation;
        }

        @Override
        public String getCoefficientsKeyPrefix() {
            return "DSST-central-body-tesseral-";
        }

        @Override
        public Map<String, double[]> getCoefficients(AbsoluteDate date, Set<String> selected) {
            Slot slot = this.slots.get(date);
            if (!this.nonResOrders.isEmpty() || this.mDailiesOnly) {
                HashMap<String, double[]> coefficients = new HashMap<String, double[]>(12 * this.maxOrderMdailyTesseralSP + 12 * this.nonResOrders.size());
                for (int m = 1; m <= this.maxOrderMdailyTesseralSP; ++m) {
                    this.storeIfSelected(coefficients, selected, slot.getCijm(0, m, date), "cM", m);
                    this.storeIfSelected(coefficients, selected, slot.getSijm(0, m, date), "sM", m);
                }
                for (Map.Entry<Integer, List<Integer>> entry : this.nonResOrders.entrySet()) {
                    int m = entry.getKey();
                    List<Integer> listJ = entry.getValue();
                    for (int j : listJ) {
                        for (int i = 0; i < 6; ++i) {
                            this.storeIfSelected(coefficients, selected, slot.getCijm(j, m, date), "c", j, m);
                            this.storeIfSelected(coefficients, selected, slot.getSijm(j, m, date), "s", j, m);
                        }
                    }
                }
                return coefficients;
            }
            return Collections.emptyMap();
        }

        private void storeIfSelected(Map<String, double[]> map, Set<String> selected, double[] value, String id, int ... indices) {
            StringBuilder keyBuilder = new StringBuilder(this.getCoefficientsKeyPrefix());
            keyBuilder.append(id);
            for (int index : indices) {
                keyBuilder.append('[').append(index).append(']');
            }
            String key = keyBuilder.toString();
            if (selected.isEmpty() || selected.contains(key)) {
                map.put(key, value);
            }
        }

        private Object writeReplace() throws NotSerializableException {
            NavigableSet<TimeSpanMap.Transition<Slot>> transitions = this.slots.getTransitions();
            AbsoluteDate[] transitionDates = new AbsoluteDate[transitions.size()];
            Slot[] allSlots = new Slot[transitions.size() + 1];
            int i = 0;
            for (TimeSpanMap.Transition transition : transitions) {
                if (i == 0) {
                    allSlots[i] = (Slot)transition.getBefore();
                }
                if (i >= transitionDates.length) continue;
                transitionDates[i] = transition.getDate();
                allSlots[++i] = (Slot)transition.getAfter();
            }
            return new DataTransferObject(this.bodyFrame, this.maxOrderMdailyTesseralSP, this.mDailiesOnly, this.nonResOrders, this.mMax, this.jMax, this.interpolationPoints, transitionDates, allSlots);
        }

        private static class DataTransferObject
        implements Serializable {
            private static final long serialVersionUID = 20160319L;
            private final Frame bodyFrame;
            private final int maxOrderMdailyTesseralSP;
            private final boolean mDailiesOnly;
            private final SortedMap<Integer, List<Integer>> nonResOrders;
            private final int mMax;
            private final int jMax;
            private final int interpolationPoints;
            private final AbsoluteDate[] transitionDates;
            private final Slot[] allSlots;

            DataTransferObject(Frame bodyFrame, int maxOrderMdailyTesseralSP, boolean mDailiesOnly, SortedMap<Integer, List<Integer>> nonResOrders, int mMax, int jMax, int interpolationPoints, AbsoluteDate[] transitionDates, Slot[] allSlots) {
                this.bodyFrame = bodyFrame;
                this.maxOrderMdailyTesseralSP = maxOrderMdailyTesseralSP;
                this.mDailiesOnly = mDailiesOnly;
                this.nonResOrders = nonResOrders;
                this.mMax = mMax;
                this.jMax = jMax;
                this.interpolationPoints = interpolationPoints;
                this.transitionDates = transitionDates;
                this.allSlots = allSlots;
            }

            private Object readResolve() {
                TimeSpanMap<Slot> slots = new TimeSpanMap<Slot>(this.allSlots[0]);
                for (int i = 0; i < this.transitionDates.length; ++i) {
                    slots.addValidAfter(this.allSlots[i + 1], this.transitionDates[i]);
                }
                return new TesseralShortPeriodicCoefficients(this.bodyFrame, this.maxOrderMdailyTesseralSP, this.mDailiesOnly, this.nonResOrders, this.mMax, this.jMax, this.interpolationPoints, slots);
            }
        }
    }

    private class FourierCjSjCoefficients {
        private final int jMax;
        private final double[][][] cCoef;
        private final double[][][] sCoef;
        private GHmsjPolynomials ghMSJ;
        private GammaMnsFunction gammaMNS;
        private final double[] roaPow;

        FourierCjSjCoefficients(int jMax, int mMax) {
            int rows = mMax + 1;
            int columns = 2 * jMax + 1;
            this.jMax = jMax;
            this.cCoef = new double[rows][columns][6];
            this.sCoef = new double[rows][columns][6];
            this.roaPow = new double[DSSTTesseral.this.maxDegree + 1];
            this.roaPow[0] = 1.0;
        }

        public void generateCoefficients(AbsoluteDate date) {
            if (!DSSTTesseral.this.nonResOrders.isEmpty() || DSSTTesseral.this.maxDegreeTesseralSP < 0) {
                this.ghMSJ = new GHmsjPolynomials(DSSTTesseral.this.k, DSSTTesseral.this.h, DSSTTesseral.this.alpha, DSSTTesseral.this.beta, 1);
                this.gammaMNS = new GammaMnsFunction(DSSTTesseral.this.maxDegree, DSSTTesseral.this.gamma, 1);
                int maxRoaPower = FastMath.max((int)DSSTTesseral.this.maxDegreeTesseralSP, (int)DSSTTesseral.this.maxDegreeMdailyTesseralSP);
                for (int i = 1; i <= maxRoaPower; ++i) {
                    this.roaPow[i] = DSSTTesseral.this.roa * this.roaPow[i - 1];
                }
                for (int m = 1; m <= DSSTTesseral.this.maxOrderMdailyTesseralSP; ++m) {
                    this.buildFourierCoefficients(date, m, 0, DSSTTesseral.this.maxDegreeMdailyTesseralSP);
                }
                if (DSSTTesseral.this.maxDegreeTesseralSP >= 0) {
                    Iterator iterator = DSSTTesseral.this.nonResOrders.keySet().iterator();
                    while (iterator.hasNext()) {
                        int m = (Integer)iterator.next();
                        List listJ = (List)DSSTTesseral.this.nonResOrders.get(m);
                        Iterator iterator2 = listJ.iterator();
                        while (iterator2.hasNext()) {
                            int j = (Integer)iterator2.next();
                            this.buildFourierCoefficients(date, m, j, DSSTTesseral.this.maxDegreeTesseralSP);
                        }
                    }
                }
            }
        }

        private void buildFourierCoefficients(AbsoluteDate date, int m, int j, int maxN) {
            double dRdaCos = 0.0;
            double dRdaSin = 0.0;
            double dRdhCos = 0.0;
            double dRdhSin = 0.0;
            double dRdkCos = 0.0;
            double dRdkSin = 0.0;
            double dRdlCos = 0.0;
            double dRdlSin = 0.0;
            double dRdAlCos = 0.0;
            double dRdAlSin = 0.0;
            double dRdBeCos = 0.0;
            double dRdBeSin = 0.0;
            double dRdGaCos = 0.0;
            double dRdGaSin = 0.0;
            int sMin = j == 0 ? DSSTTesseral.this.maxEccPowMdailyTesseralSP : DSSTTesseral.this.maxEccPowTesseralSP;
            int sMax = j == 0 ? DSSTTesseral.this.maxEccPowMdailyTesseralSP : DSSTTesseral.this.maxEccPowTesseralSP;
            for (int s = 0; s <= sMax; ++s) {
                double[][] nSumSpos = DSSTTesseral.this.computeNSum(date, j, m, s, maxN, this.roaPow, this.ghMSJ, this.gammaMNS);
                dRdaCos += nSumSpos[0][0];
                dRdaSin += nSumSpos[0][1];
                dRdhCos += nSumSpos[1][0];
                dRdhSin += nSumSpos[1][1];
                dRdkCos += nSumSpos[2][0];
                dRdkSin += nSumSpos[2][1];
                dRdlCos += nSumSpos[3][0];
                dRdlSin += nSumSpos[3][1];
                dRdAlCos += nSumSpos[4][0];
                dRdAlSin += nSumSpos[4][1];
                dRdBeCos += nSumSpos[5][0];
                dRdBeSin += nSumSpos[5][1];
                dRdGaCos += nSumSpos[6][0];
                dRdGaSin += nSumSpos[6][1];
                if (s <= 0 || s > sMin) continue;
                double[][] nSumSneg = DSSTTesseral.this.computeNSum(date, j, m, -s, maxN, this.roaPow, this.ghMSJ, this.gammaMNS);
                dRdaCos += nSumSneg[0][0];
                dRdaSin += nSumSneg[0][1];
                dRdhCos += nSumSneg[1][0];
                dRdhSin += nSumSneg[1][1];
                dRdkCos += nSumSneg[2][0];
                dRdkSin += nSumSneg[2][1];
                dRdlCos += nSumSneg[3][0];
                dRdlSin += nSumSneg[3][1];
                dRdAlCos += nSumSneg[4][0];
                dRdAlSin += nSumSneg[4][1];
                dRdBeCos += nSumSneg[5][0];
                dRdBeSin += nSumSneg[5][1];
                dRdGaCos += nSumSneg[6][0];
                dRdGaSin += nSumSneg[6][1];
            }
            dRdaCos *= -DSSTTesseral.this.moa / DSSTTesseral.this.a;
            dRdaSin *= -DSSTTesseral.this.moa / DSSTTesseral.this.a;
            dRdhCos *= DSSTTesseral.this.moa;
            dRdhSin *= DSSTTesseral.this.moa;
            dRdkCos *= DSSTTesseral.this.moa;
            dRdkSin *= DSSTTesseral.this.moa;
            dRdlCos *= DSSTTesseral.this.moa;
            dRdlSin *= DSSTTesseral.this.moa;
            double RAlphaGammaCos = DSSTTesseral.this.alpha * (dRdGaCos *= DSSTTesseral.this.moa) - DSSTTesseral.this.gamma * (dRdAlCos *= DSSTTesseral.this.moa);
            double RAlphaGammaSin = DSSTTesseral.this.alpha * (dRdGaSin *= DSSTTesseral.this.moa) - DSSTTesseral.this.gamma * (dRdAlSin *= DSSTTesseral.this.moa);
            double RAlphaBetaCos = DSSTTesseral.this.alpha * (dRdBeCos *= DSSTTesseral.this.moa) - DSSTTesseral.this.beta * dRdAlCos;
            double RAlphaBetaSin = DSSTTesseral.this.alpha * (dRdBeSin *= DSSTTesseral.this.moa) - DSSTTesseral.this.beta * dRdAlSin;
            double RBetaGammaCos = DSSTTesseral.this.beta * dRdGaCos - DSSTTesseral.this.gamma * dRdBeCos;
            double RBetaGammaSin = DSSTTesseral.this.beta * dRdGaSin - DSSTTesseral.this.gamma * dRdBeSin;
            double RhkCos = DSSTTesseral.this.h * dRdkCos - DSSTTesseral.this.k * dRdhCos;
            double RhkSin = DSSTTesseral.this.h * dRdkSin - DSSTTesseral.this.k * dRdhSin;
            double pRagmIqRbgoABCos = (DSSTTesseral.this.p * RAlphaGammaCos - 1.0 * DSSTTesseral.this.q * RBetaGammaCos) * DSSTTesseral.this.ooAB;
            double pRagmIqRbgoABSin = (DSSTTesseral.this.p * RAlphaGammaSin - 1.0 * DSSTTesseral.this.q * RBetaGammaSin) * DSSTTesseral.this.ooAB;
            double RhkmRabmdRdlCos = RhkCos - RAlphaBetaCos - dRdlCos;
            double RhkmRabmdRdlSin = RhkSin - RAlphaBetaSin - dRdlSin;
            this.cCoef[m][j + this.jMax][0] = DSSTTesseral.this.ax2oA * dRdlCos;
            this.sCoef[m][j + this.jMax][0] = DSSTTesseral.this.ax2oA * dRdlSin;
            this.cCoef[m][j + this.jMax][1] = -(DSSTTesseral.this.BoA * dRdhCos + DSSTTesseral.this.h * pRagmIqRbgoABCos + DSSTTesseral.this.k * DSSTTesseral.this.BoABpo * dRdlCos);
            this.sCoef[m][j + this.jMax][1] = -(DSSTTesseral.this.BoA * dRdhSin + DSSTTesseral.this.h * pRagmIqRbgoABSin + DSSTTesseral.this.k * DSSTTesseral.this.BoABpo * dRdlSin);
            this.cCoef[m][j + this.jMax][2] = DSSTTesseral.this.BoA * dRdkCos + DSSTTesseral.this.k * pRagmIqRbgoABCos - DSSTTesseral.this.h * DSSTTesseral.this.BoABpo * dRdlCos;
            this.sCoef[m][j + this.jMax][2] = DSSTTesseral.this.BoA * dRdkSin + DSSTTesseral.this.k * pRagmIqRbgoABSin - DSSTTesseral.this.h * DSSTTesseral.this.BoABpo * dRdlSin;
            this.cCoef[m][j + this.jMax][3] = DSSTTesseral.this.Co2AB * (DSSTTesseral.this.q * RhkmRabmdRdlCos - 1.0 * RAlphaGammaCos);
            this.sCoef[m][j + this.jMax][3] = DSSTTesseral.this.Co2AB * (DSSTTesseral.this.q * RhkmRabmdRdlSin - 1.0 * RAlphaGammaSin);
            this.cCoef[m][j + this.jMax][4] = DSSTTesseral.this.Co2AB * (DSSTTesseral.this.p * RhkmRabmdRdlCos - RBetaGammaCos);
            this.sCoef[m][j + this.jMax][4] = DSSTTesseral.this.Co2AB * (DSSTTesseral.this.p * RhkmRabmdRdlSin - RBetaGammaSin);
            this.cCoef[m][j + this.jMax][5] = -DSSTTesseral.this.ax2oA * dRdaCos + DSSTTesseral.this.BoABpo * (DSSTTesseral.this.h * dRdhCos + DSSTTesseral.this.k * dRdkCos) + pRagmIqRbgoABCos;
            this.sCoef[m][j + this.jMax][5] = -DSSTTesseral.this.ax2oA * dRdaSin + DSSTTesseral.this.BoABpo * (DSSTTesseral.this.h * dRdhSin + DSSTTesseral.this.k * dRdkSin) + pRagmIqRbgoABSin;
        }

        public double getCijm(int i, int j, int m) {
            return this.cCoef[m][j + this.jMax][i];
        }

        public double getSijm(int i, int j, int m) {
            return this.sCoef[m][j + this.jMax][i];
        }
    }
}

