/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.forces;

import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.orekit.forces.drag.DragForce;
import org.orekit.forces.drag.DragSensitive;
import org.orekit.forces.drag.IsotropicDrag;
import org.orekit.forces.drag.atmosphere.Atmosphere;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.semianalytical.dsst.forces.AbstractGaussianContribution;

public class DSSTAtmosphericDrag
extends AbstractGaussianContribution {
    private static final double GAUSS_THRESHOLD = 6.0E-10;
    private static final double ATMOSPHERE_ALTITUDE_MAX = 1000000.0;
    private final Atmosphere atmosphere;
    private final DragSensitive spacecraft;
    private final double rbar;

    public DSSTAtmosphericDrag(Atmosphere atmosphere, double cd, double area) {
        this(atmosphere, new IsotropicDrag(area, cd));
    }

    public DSSTAtmosphericDrag(Atmosphere atmosphere, DragSensitive spacecraft) {
        super("DSST-drag-", 6.0E-10, new DragForce(atmosphere, spacecraft));
        this.atmosphere = atmosphere;
        this.spacecraft = spacecraft;
        this.rbar = 7378137.0;
    }

    public Atmosphere getAtmosphere() {
        return this.atmosphere;
    }

    public double getRbar() {
        return this.rbar;
    }

    @Override
    public EventDetector[] getEventsDetectors() {
        return null;
    }

    @Override
    protected double[] getLLimits(SpacecraftState state) {
        double perigee = this.a * (1.0 - this.ecc);
        if (perigee > this.rbar) {
            return new double[2];
        }
        double apogee = this.a * (1.0 + this.ecc);
        if (apogee < this.rbar) {
            return new double[]{-Math.PI + MathUtils.normalizeAngle((double)state.getLv(), (double)0.0), Math.PI + MathUtils.normalizeAngle((double)state.getLv(), (double)0.0)};
        }
        double fb = FastMath.acos((double)((this.a * (1.0 - this.ecc * this.ecc) / this.rbar - 1.0) / this.ecc));
        double wW = FastMath.atan2((double)this.h, (double)this.k);
        return new double[]{wW - fb, wW + fb};
    }

    public DragSensitive getSpacecraft() {
        return this.spacecraft;
    }
}

