/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.numerical;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.ode.ODEIntegrator;
import org.hipparchus.util.FastMath;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.ForceModel;
import org.orekit.forces.gravity.NewtonianAttraction;
import org.orekit.frames.Frame;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.integration.AbstractIntegratedPropagator;
import org.orekit.propagation.integration.StateMapper;
import org.orekit.propagation.numerical.TimeDerivativesEquations;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterObserver;
import org.orekit.utils.TimeStampedPVCoordinates;

public class NumericalPropagator
extends AbstractIntegratedPropagator {
    private final List<ForceModel> forceModels = new ArrayList<ForceModel>();

    public NumericalPropagator(ODEIntegrator integrator) {
        super(integrator, true);
        this.initMapper();
        this.setAttitudeProvider(DEFAULT_LAW);
        this.setSlaveMode();
        this.setOrbitType(OrbitType.EQUINOCTIAL);
        this.setPositionAngleType(PositionAngle.TRUE);
    }

    @Override
    public void setMu(double mu) {
        this.addForceModel(new NewtonianAttraction(mu));
    }

    private void superSetMu(double mu) {
        super.setMu(mu);
    }

    private boolean hasNewtonianAttraction() {
        int last = this.forceModels.size() - 1;
        return last >= 0 && this.forceModels.get(last) instanceof NewtonianAttraction;
    }

    public void addForceModel(ForceModel model) {
        if (model instanceof NewtonianAttraction) {
            try {
                model.getParametersDrivers()[0].addObserver(new ParameterObserver(){

                    @Override
                    public void valueChanged(double previousValue, ParameterDriver driver) {
                        NumericalPropagator.this.superSetMu(driver.getValue());
                    }
                });
            }
            catch (OrekitException oe) {
                throw new OrekitInternalError(oe);
            }
            if (this.hasNewtonianAttraction()) {
                this.forceModels.set(this.forceModels.size() - 1, model);
            } else {
                this.forceModels.add(model);
            }
        } else if (this.hasNewtonianAttraction()) {
            this.forceModels.add(this.forceModels.size() - 1, model);
        } else {
            this.forceModels.add(model);
        }
    }

    public void removeForceModels() {
        int last = this.forceModels.size() - 1;
        if (this.hasNewtonianAttraction()) {
            ForceModel newton = this.forceModels.get(last);
            this.forceModels.clear();
            this.forceModels.add(newton);
        } else {
            this.forceModels.clear();
        }
    }

    public List<ForceModel> getAllForceModels() {
        return Collections.unmodifiableList(this.forceModels);
    }

    @Override
    public void setOrbitType(OrbitType orbitType) {
        super.setOrbitType(orbitType);
    }

    @Override
    public OrbitType getOrbitType() {
        return super.getOrbitType();
    }

    @Override
    public void setPositionAngleType(PositionAngle positionAngleType) {
        super.setPositionAngleType(positionAngleType);
    }

    @Override
    public PositionAngle getPositionAngleType() {
        return super.getPositionAngleType();
    }

    public void setInitialState(SpacecraftState initialState) {
        this.resetInitialState(initialState);
    }

    @Override
    public void resetInitialState(SpacecraftState state) {
        super.resetInitialState(state);
        if (!this.hasNewtonianAttraction()) {
            this.setMu(state.getMu());
        }
        this.setStartDate(state.getDate());
    }

    @Override
    public TimeStampedPVCoordinates getPVCoordinates(AbsoluteDate date, Frame frame) {
        return this.propagate(date).getPVCoordinates(frame);
    }

    @Override
    protected StateMapper createMapper(AbsoluteDate referenceDate, double mu, OrbitType orbitType, PositionAngle positionAngleType, AttitudeProvider attitudeProvider, Frame frame) {
        return new OsculatingMapper(referenceDate, mu, orbitType, positionAngleType, attitudeProvider, frame);
    }

    @Override
    protected AbstractIntegratedPropagator.MainStateEquations getMainStateEquations(ODEIntegrator integrator) {
        return new Main(integrator);
    }

    public static double[][] tolerances(double dP, Orbit orbit, OrbitType type) {
        TimeStampedPVCoordinates pv = orbit.getPVCoordinates();
        double r2 = pv.getPosition().getNormSq();
        double v = pv.getVelocity().getNorm();
        double dV = orbit.getMu() * dP / (v * r2);
        double[] absTol = new double[7];
        double[] relTol = new double[7];
        absTol[6] = 1.0E-6;
        if (type == OrbitType.CARTESIAN) {
            absTol[0] = dP;
            absTol[1] = dP;
            absTol[2] = dP;
            absTol[3] = dV;
            absTol[4] = dV;
            absTol[5] = dV;
        } else {
            double[][] jacobian = new double[6][6];
            Orbit converted = type.convertType(orbit);
            converted.getJacobianWrtCartesian(PositionAngle.TRUE, jacobian);
            for (int i = 0; i < 6; ++i) {
                double[] row = jacobian[i];
                absTol[i] = FastMath.abs((double)row[0]) * dP + FastMath.abs((double)row[1]) * dP + FastMath.abs((double)row[2]) * dP + FastMath.abs((double)row[3]) * dV + FastMath.abs((double)row[4]) * dV + FastMath.abs((double)row[5]) * dV;
                if (!Double.isNaN(absTol[i])) continue;
                throw new OrekitException((Localizable)OrekitMessages.SINGULAR_JACOBIAN_FOR_ORBIT_TYPE, new Object[]{type});
            }
        }
        Arrays.fill(relTol, dP / FastMath.sqrt((double)r2));
        return new double[][]{absTol, relTol};
    }

    private class Main
    implements AbstractIntegratedPropagator.MainStateEquations,
    TimeDerivativesEquations {
        private final double[] yDot = new double[7];
        private Orbit orbit;
        private double[][] jacobian = new double[6][6];

        Main(ODEIntegrator integrator) {
            for (ForceModel forceModel : NumericalPropagator.this.forceModels) {
                forceModel.getEventsDetectors().forEach(detector -> NumericalPropagator.this.setUpEventDetector(integrator, detector));
            }
        }

        @Override
        public void init(SpacecraftState initialState, AbsoluteDate target) {
            for (ForceModel forceModel : NumericalPropagator.this.forceModels) {
                forceModel.init(initialState, target);
            }
        }

        @Override
        public double[] computeDerivatives(SpacecraftState state) {
            this.orbit = state.getOrbit();
            Arrays.fill(this.yDot, 0.0);
            this.orbit.getJacobianWrtCartesian(NumericalPropagator.this.getPositionAngleType(), this.jacobian);
            for (ForceModel forceModel : NumericalPropagator.this.forceModels) {
                forceModel.addContribution(state, this);
            }
            return (double[])this.yDot.clone();
        }

        @Override
        public void addKeplerContribution(double mu) {
            this.orbit.addKeplerContribution(NumericalPropagator.this.getPositionAngleType(), mu, this.yDot);
        }

        @Override
        public void addNonKeplerianAcceleration(Vector3D gamma) {
            int i = 0;
            while (i < 6) {
                double[] jRow = this.jacobian[i];
                int n = i++;
                this.yDot[n] = this.yDot[n] + (jRow[3] * gamma.getX() + jRow[4] * gamma.getY() + jRow[5] * gamma.getZ());
            }
        }

        @Override
        public void addMassDerivative(double q) {
            if (q > 0.0) {
                throw new OrekitIllegalArgumentException(OrekitMessages.POSITIVE_FLOW_RATE, q);
            }
            this.yDot[6] = this.yDot[6] + q;
        }
    }

    private static class OsculatingMapper
    extends StateMapper
    implements Serializable {
        private static final long serialVersionUID = 20130621L;

        OsculatingMapper(AbsoluteDate referenceDate, double mu, OrbitType orbitType, PositionAngle positionAngleType, AttitudeProvider attitudeProvider, Frame frame) {
            super(referenceDate, mu, orbitType, positionAngleType, attitudeProvider, frame);
        }

        @Override
        public SpacecraftState mapArrayToState(AbsoluteDate date, double[] y, double[] yDot, boolean meanOnly) {
            double mass = y[6];
            if (mass <= 0.0) {
                throw new OrekitException((Localizable)OrekitMessages.SPACECRAFT_MASS_BECOMES_NEGATIVE, mass);
            }
            Orbit orbit = this.getOrbitType().mapArrayToOrbit(y, yDot, this.getPositionAngleType(), date, this.getMu(), this.getFrame());
            Attitude attitude = this.getAttitudeProvider().getAttitude(orbit, date, this.getFrame());
            return new SpacecraftState(orbit, attitude, mass);
        }

        @Override
        public void mapStateToArray(SpacecraftState state, double[] y, double[] yDot) {
            this.getOrbitType().mapOrbitToArray(state.getOrbit(), this.getPositionAngleType(), y, yDot);
            y[6] = state.getMass();
        }

        private Object writeReplace() throws NotSerializableException {
            return new DataTransferObject(this.getReferenceDate(), this.getMu(), this.getOrbitType(), this.getPositionAngleType(), this.getAttitudeProvider(), this.getFrame());
        }

        private static class DataTransferObject
        implements Serializable {
            private static final long serialVersionUID = 20130621L;
            private final AbsoluteDate referenceDate;
            private final double mu;
            private final OrbitType orbitType;
            private final PositionAngle positionAngleType;
            private final AttitudeProvider attitudeProvider;
            private final Frame frame;

            DataTransferObject(AbsoluteDate referenceDate, double mu, OrbitType orbitType, PositionAngle positionAngleType, AttitudeProvider attitudeProvider, Frame frame) {
                this.referenceDate = referenceDate;
                this.mu = mu;
                this.orbitType = orbitType;
                this.positionAngleType = positionAngleType;
                this.attitudeProvider = attitudeProvider;
                this.frame = frame;
            }

            private Object readResolve() {
                return new OsculatingMapper(this.referenceDate, this.mu, this.orbitType, this.positionAngleType, this.attitudeProvider, this.frame);
            }
        }
    }
}

