/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.integration;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hipparchus.exception.Localizable;
import org.hipparchus.ode.DenseOutputModel;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.AdditionalStateProvider;
import org.orekit.propagation.BoundedPropagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.analytical.AbstractAnalyticalPropagator;
import org.orekit.propagation.integration.StateMapper;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.TimeStampedPVCoordinates;

public class IntegratedEphemeris
extends AbstractAnalyticalPropagator
implements BoundedPropagator,
Serializable {
    private static final long serialVersionUID = 20140213L;
    private static final double EXTRAPOLATION_TOLERANCE = 1.0;
    private final StateMapper mapper;
    private boolean meanOrbit;
    private final AbsoluteDate startDate;
    private final AbsoluteDate minDate;
    private final AbsoluteDate maxDate;
    private DenseOutputModel model;
    private final Map<String, double[]> unmanaged;

    public IntegratedEphemeris(AbsoluteDate startDate, AbsoluteDate minDate, AbsoluteDate maxDate, StateMapper mapper, boolean meanOrbit, DenseOutputModel model, Map<String, double[]> unmanaged, List<AdditionalStateProvider> providers, String[] equations) {
        super(mapper.getAttitudeProvider());
        this.startDate = startDate;
        this.minDate = minDate;
        this.maxDate = maxDate;
        this.mapper = mapper;
        this.meanOrbit = meanOrbit;
        this.model = model;
        this.unmanaged = unmanaged;
        for (AdditionalStateProvider provider : providers) {
            this.addAdditionalStateProvider(provider);
        }
        for (int i = 0; i < equations.length; ++i) {
            this.addAdditionalStateProvider(new LocalProvider(equations[i], i));
        }
    }

    private ODEStateAndDerivative getInterpolatedState(AbsoluteDate date) {
        if (date.compareTo(this.minDate.shiftedBy(-1.0)) < 0 || date.compareTo(this.maxDate.shiftedBy(1.0)) > 0) {
            throw new OrekitException((Localizable)OrekitMessages.OUT_OF_RANGE_EPHEMERIDES_DATE, date, this.minDate, this.maxDate);
        }
        return this.model.getInterpolatedState(date.durationFrom(this.startDate));
    }

    @Override
    protected SpacecraftState basicPropagate(AbsoluteDate date) {
        ODEStateAndDerivative os = this.getInterpolatedState(date);
        SpacecraftState state = this.mapper.mapArrayToState(this.mapper.mapDoubleToDate(os.getTime(), date), os.getPrimaryState(), os.getPrimaryDerivative(), this.meanOrbit);
        for (Map.Entry<String, double[]> initial : this.unmanaged.entrySet()) {
            state = state.addAdditionalState(initial.getKey(), initial.getValue());
        }
        return state;
    }

    @Override
    protected Orbit propagateOrbit(AbsoluteDate date) {
        return this.basicPropagate(date).getOrbit();
    }

    @Override
    protected double getMass(AbsoluteDate date) {
        return this.basicPropagate(date).getMass();
    }

    @Override
    public TimeStampedPVCoordinates getPVCoordinates(AbsoluteDate date, Frame frame) {
        return this.propagate(date).getPVCoordinates(frame);
    }

    @Override
    public AbsoluteDate getMinDate() {
        return this.minDate;
    }

    @Override
    public AbsoluteDate getMaxDate() {
        return this.maxDate;
    }

    @Override
    public Frame getFrame() {
        return this.mapper.getFrame();
    }

    @Override
    public void resetInitialState(SpacecraftState state) {
        throw new OrekitException((Localizable)OrekitMessages.NON_RESETABLE_STATE, new Object[0]);
    }

    @Override
    protected void resetIntermediateState(SpacecraftState state, boolean forward) {
        throw new OrekitException((Localizable)OrekitMessages.NON_RESETABLE_STATE, new Object[0]);
    }

    @Override
    public SpacecraftState getInitialState() {
        return this.updateAdditionalStates(this.basicPropagate(this.getMinDate()));
    }

    private Object writeReplace() throws NotSerializableException {
        String[] unmanagedNames = new String[this.unmanaged.size()];
        double[][] unmanagedValues = new double[this.unmanaged.size()][];
        int i = 0;
        for (Map.Entry<String, double[]> entry : this.unmanaged.entrySet()) {
            unmanagedNames[i] = entry.getKey();
            unmanagedValues[i] = entry.getValue();
            ++i;
        }
        ArrayList<AdditionalStateProvider> serializableProviders = new ArrayList<AdditionalStateProvider>();
        ArrayList<String> equationNames = new ArrayList<String>();
        for (AdditionalStateProvider provider : this.getAdditionalStateProviders()) {
            if (provider instanceof LocalProvider) {
                equationNames.add(((LocalProvider)provider).getName());
                continue;
            }
            if (!(provider instanceof Serializable)) continue;
            serializableProviders.add(provider);
        }
        return new DataTransferObject(this.startDate, this.minDate, this.maxDate, this.mapper, this.meanOrbit, this.model, unmanagedNames, unmanagedValues, serializableProviders.toArray(new AdditionalStateProvider[serializableProviders.size()]), equationNames.toArray(new String[equationNames.size()]));
    }

    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 20140213L;
        private final StateMapper mapper;
        private final boolean meanOrbit;
        private final AbsoluteDate startDate;
        private final AbsoluteDate minDate;
        private final AbsoluteDate maxDate;
        private final DenseOutputModel model;
        private final String[] unmanagedNames;
        private final double[][] unmanagedValues;
        private final String[] equations;
        private final AdditionalStateProvider[] providers;

        DataTransferObject(AbsoluteDate startDate, AbsoluteDate minDate, AbsoluteDate maxDate, StateMapper mapper, boolean meanOrbit, DenseOutputModel model, String[] unmanagedNames, double[][] unmanagedValues, AdditionalStateProvider[] providers, String[] equations) {
            this.startDate = startDate;
            this.minDate = minDate;
            this.maxDate = maxDate;
            this.mapper = mapper;
            this.meanOrbit = meanOrbit;
            this.model = model;
            this.unmanagedNames = unmanagedNames;
            this.unmanagedValues = unmanagedValues;
            this.providers = providers;
            this.equations = equations;
        }

        private Object readResolve() {
            try {
                HashMap<String, double[]> unmanaged = new HashMap<String, double[]>(this.unmanagedNames.length);
                for (int i = 0; i < this.unmanagedNames.length; ++i) {
                    unmanaged.put(this.unmanagedNames[i], this.unmanagedValues[i]);
                }
                return new IntegratedEphemeris(this.startDate, this.minDate, this.maxDate, this.mapper, this.meanOrbit, this.model, unmanaged, Arrays.asList(this.providers), this.equations);
            }
            catch (OrekitException oe) {
                throw new OrekitInternalError(oe);
            }
        }
    }

    private class LocalProvider
    implements AdditionalStateProvider {
        private final String name;
        private final int index;

        LocalProvider(String name, int index) {
            this.name = name;
            this.index = index;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public double[] getAdditionalState(SpacecraftState state) {
            return IntegratedEphemeris.this.getInterpolatedState(state.getDate()).getSecondaryState(this.index + 1);
        }
    }
}

