/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.frames.Frame;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.FieldOfView;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.StopOnIncreasing;

public class GroundFieldOfViewDetector
extends AbstractDetector<GroundFieldOfViewDetector> {
    private static final long serialVersionUID = 20160114L;
    private final Frame frame;
    private final FieldOfView fov;

    public GroundFieldOfViewDetector(Frame frame, FieldOfView fov) {
        this(600.0, 1.0E-6, 100, new StopOnIncreasing(), frame, fov);
    }

    private GroundFieldOfViewDetector(double maxCheck, double threshold, int maxIter, EventHandler<? super GroundFieldOfViewDetector> handler, Frame frame, FieldOfView fov) {
        super(maxCheck, threshold, maxIter, handler);
        this.frame = frame;
        this.fov = fov;
    }

    @Override
    protected GroundFieldOfViewDetector create(double newMaxCheck, double newThreshold, int newMaxIter, EventHandler<? super GroundFieldOfViewDetector> newHandler) {
        return new GroundFieldOfViewDetector(newMaxCheck, newThreshold, newMaxIter, newHandler, this.frame, this.fov);
    }

    public Frame getFrame() {
        return this.frame;
    }

    public FieldOfView getFieldOfView() {
        return this.fov;
    }

    @Override
    public double g(SpacecraftState s) {
        Vector3D los = s.getPVCoordinates(this.frame).getPosition();
        return this.fov.offsetFromBoundary(los);
    }
}

