/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hipparchus.ode.ODEIntegrator;
import org.orekit.attitudes.Attitude;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.forces.ForceModel;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.conversion.AbstractPropagatorBuilder;
import org.orekit.propagation.conversion.ODEIntegratorBuilder;
import org.orekit.propagation.numerical.NumericalPropagator;
import org.orekit.utils.ParameterDriver;

public class NumericalPropagatorBuilder
extends AbstractPropagatorBuilder {
    private final ODEIntegratorBuilder builder;
    private final List<ForceModel> forceModels;
    private double mass;
    private AttitudeProvider attProvider;

    public NumericalPropagatorBuilder(Orbit referenceOrbit, ODEIntegratorBuilder builder, PositionAngle positionAngle, double positionScale) {
        super(referenceOrbit, positionAngle, positionScale, true);
        this.builder = builder;
        this.forceModels = new ArrayList<ForceModel>();
        this.mass = 1000.0;
        this.attProvider = Propagator.DEFAULT_LAW;
    }

    public NumericalPropagatorBuilder copy() {
        NumericalPropagatorBuilder copyBuilder = new NumericalPropagatorBuilder(this.createInitialOrbit(), this.builder, this.getPositionAngle(), this.getPositionScale());
        copyBuilder.setAttitudeProvider(this.attProvider);
        copyBuilder.setMass(this.mass);
        for (ForceModel model : this.forceModels) {
            copyBuilder.addForceModel(model);
        }
        return copyBuilder;
    }

    public ODEIntegratorBuilder getIntegratorBuilder() {
        return this.builder;
    }

    public List<ForceModel> getAllForceModels() {
        return Collections.unmodifiableList(this.forceModels);
    }

    public void addForceModel(ForceModel model) {
        this.forceModels.add(model);
        for (ParameterDriver driver : model.getParametersDrivers()) {
            this.addSupportedParameter(driver);
        }
    }

    public double getMass() {
        return this.mass;
    }

    public void setMass(double mass) {
        this.mass = mass;
    }

    public AttitudeProvider getAttitudeProvider() {
        return this.attProvider;
    }

    public void setAttitudeProvider(AttitudeProvider attitudeProvider) {
        this.attProvider = attitudeProvider;
    }

    @Override
    public NumericalPropagator buildPropagator(double[] normalizedParameters) {
        this.setParameters(normalizedParameters);
        Orbit orbit = this.createInitialOrbit();
        Attitude attitude = this.attProvider.getAttitude(orbit, orbit.getDate(), this.getFrame());
        SpacecraftState state = new SpacecraftState(orbit, attitude, this.mass);
        NumericalPropagator propagator = new NumericalPropagator((ODEIntegrator)this.builder.buildIntegrator(orbit, this.getOrbitType()));
        propagator.setOrbitType(this.getOrbitType());
        propagator.setPositionAngleType(this.getPositionAngle());
        propagator.setAttitudeProvider(this.attProvider);
        for (ForceModel model : this.forceModels) {
            propagator.addForceModel(model);
        }
        propagator.resetInitialState(state);
        return propagator;
    }
}

