/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.models.earth;

import java.io.Serializable;
import java.util.List;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.util.MathArrays;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ParameterDriver;

public interface MappingFunction
extends Serializable {
    public double[] mappingFactors(double var1, double var3, double[] var5, AbsoluteDate var6);

    public <T extends RealFieldElement<T>> T[] mappingFactors(T var1, T var2, T[] var3, FieldAbsoluteDate<T> var4);

    public List<ParameterDriver> getParametersDrivers();

    default public double[] getParameters() {
        List<ParameterDriver> drivers = this.getParametersDrivers();
        double[] parameters = new double[drivers.size()];
        for (int i = 0; i < drivers.size(); ++i) {
            parameters[i] = drivers.get(i).getValue();
        }
        return parameters;
    }

    default public <T extends RealFieldElement<T>> T[] getParameters(Field<T> field) {
        List<ParameterDriver> drivers = this.getParametersDrivers();
        RealFieldElement[] parameters = (RealFieldElement[])MathArrays.buildArray(field, (int)drivers.size());
        for (int i = 0; i < drivers.size(); ++i) {
            parameters[i] = (RealFieldElement)((RealFieldElement)field.getZero()).add(drivers.get(i).getValue());
        }
        return parameters;
    }
}

