/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.drag.atmosphere;

import java.util.Arrays;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.bodies.BodyShape;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.drag.atmosphere.Atmosphere;
import org.orekit.forces.drag.atmosphere.NRLMSISE00InputParameters;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DateTimeComponents;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeComponents;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScalesFactory;
import org.orekit.time.UT1Scale;
import org.orekit.utils.IERSConventions;
import org.orekit.utils.PVCoordinatesProvider;

public class NRLMSISE00
implements Atmosphere {
    private static final long serialVersionUID = -7923498628122574334L;
    private static final int HELIUM = 0;
    private static final int ATOMIC_OXYGEN = 1;
    private static final int MOLECULAR_NITROGEN = 2;
    private static final int MOLECULAR_OXYGEN = 3;
    private static final int ARGON = 4;
    private static final int TOTAL_MASS = 5;
    private static final int HYDROGEN = 6;
    private static final int ATOMIC_NITROGEN = 7;
    private static final int ANOMALOUS_OXYGEN = 8;
    private static final int EXOSPHERIC = 0;
    private static final int ALTITUDE = 1;
    private static final double DEG_TO_RAD = 0.0174533;
    private static final double DAY_TO_RAD = 0.0172142;
    private static final double HOUR_TO_RAD = 0.2618;
    private static final double SEC_TO_RAD = 7.2722E-5;
    private static final double LAT_REF = 45.0;
    private static final double G_REF = 980.616;
    private static final double AMU = 1.66E-27;
    private static final double R_GAS = 831.4;
    private static final double H_MASS = 1.0;
    private static final double HE_MASS = 4.0;
    private static final double N_MASS = 14.0;
    private static final double N2_MASS = 28.0;
    private static final double O_MASS = 16.0;
    private static final double O2_MASS = 32.0;
    private static final double AR_MASS = 40.0;
    private static final double FLUX_REF = 150.0;
    private static final double[] ZN1 = new double[]{123.435, 110.0, 100.0, 90.0, 72.5};
    private static final double[] ZN2 = new double[]{72.5, 55.0, 45.0, 32.5};
    private static final double[] ZN3 = new double[]{32.5, 20.0, 15.0, 10.0, 0.0};
    private static final double ZMIX = 62.5;
    private static final double[] PT = new double[]{0.986573, 0.0162228, 0.015527, -0.104323, -0.00375801, -0.00118538, -0.124043, 0.0045682, 0.00876018, -0.136235, -0.0352427, 0.00884181, -0.00592127, -8.6165, 0.0, 0.0128492, 0.0, 130.096, 0.0104567, 0.00165686, -5.53887E-6, 0.0029781, 0.0, 0.00513122, 0.0866784, 0.158727, 0.0, 0.0, 0.0, -7.27026E-6, 0.0, 6.74494, 0.00493933, 0.00221656, 0.00250802, 0.0, 0.0, -0.0208841, -1.79873, 0.00145103, 2.81769E-4, -0.00144703, -5.16394E-5, 0.0847001, 0.170147, 0.00572562, 5.07493E-5, 0.00436148, 1.17863E-4, 0.00474364, 0.00661278, 4.34292E-5, 0.00144373, 2.4147E-5, 0.00284426, 8.5656E-4, 0.00204028, 0.0, -3159.94, -0.00246423, 0.00113843, 4.20512E-4, 0.0, -97.7214, 0.00677794, 0.00527499, 0.00114936, 0.0, -0.00661311, -0.0184255, -0.0196259, 29861.8, 0.0, 0.0, 0.0, 644.574, 8.84668E-4, 5.05066E-4, 0.0, 4028.81, -0.00189503, 0.0, 0.0, 8.21407E-4, 0.0020678, 0.0, 0.0, 0.0, 0.0, 0.0, -0.012041, -0.00363963, 9.9207E-5, -1.15284E-4, -6.33059E-5, -0.605545, 0.00834218, -91.3036, 3.71042E-4, 0.0, 4.19E-4, 0.00270928, 0.00331507, -0.00444508, -0.00496334, -0.00160449, 0.00395119, 0.00248924, 5.09815E-4, 0.00405302, 0.00224076, 0.0, 0.00684256, 4.66354E-4, 0.0, -3.68328E-4, 0.0, 0.0, -146.87, 0.0, 0.0, 0.00109501, 4.65156E-4, 5.62583E-4, 3.21596, 6.43168E-4, 0.0031486, 0.00340738, 0.00178481, 9.62532E-4, 5.58171E-4, 3.43731, -0.233195, 5.10289E-4, 0.0, 0.0, -92534.7, 0.0, -0.00199639, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    private static final double[][] PD = new double[][]{{1.09979, -0.048806, -0.197501, -0.091028, -0.00696558, 0.0242136, 0.391333, -0.00720068, -0.0322718, 1.41508, 0.168194, 0.0185282, 0.109384, -7.24282, 0.0, 0.296377, -0.049721, 104.114, -0.0861108, -7.29177E-4, 1.48998E-6, 0.00108629, 0.0, 0.0, 0.083109, 0.112818, -0.0575005, -0.0129919, -0.0178849, -2.86343E-6, 0.0, -151.187, -0.00665902, 0.0, -0.00202069, 0.0, 0.0, 0.0432264, -28.0444, -0.00326789, 0.00247461, 0.0, 0.0, 0.09821, 0.122714, -0.039645, 0.0, -0.00276489, 0.0, 0.00187723, -0.00809813, 4.34428E-5, -0.00770932, 0.0, -0.00228894, -0.0056907, -0.00522193, 0.00600692, -7804.34, -0.00348336, -0.00638362, -0.0018219, 0.0, -75.8976, -0.0217875, -0.0172524, -0.00906287, 0.0, 0.0244725, 0.086604, 0.105712, 30254.3, 0.0, 0.0, 0.0, -6013.64, -0.00564668, -0.00254157, 0.0, 315.611, -0.00569158, 0.0, 0.0, -0.00447216, -0.00449523, 0.00464428, 0.0, 0.0, 0.0, 0.0, 0.0451236, 0.024652, 0.00617794, 0.0, 0.0, -0.362944, -0.0480022, -75.723, -0.00199656, 0.0, -0.0051878, -0.017399, -0.00903485, 0.00748465, 0.0153267, 0.0106296, 0.0118655, 0.00255569, 0.0016902, 0.0351936, -0.0181242, 0.0, -0.100529, -0.00510574, 0.0, 0.00210228, 0.0, 0.0, -173.255, 0.507833, -0.241408, 0.00875414, 0.00277527, -8.90353E-5, -5.25148, -0.00583899, -0.0209122, -0.0096353, 0.00977164, 0.00407051, 2.53555E-4, -5.52875, -0.355993, -0.00249231, 0.0, 0.0, 28.6026, 0.0, 3.42722E-4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.02315, -0.15971, -0.10663, -0.0177074, -0.00442726, 0.0344803, 0.0445613, -0.0333751, -0.0573598, 0.35036, 0.0633053, 0.0216221, 0.0542577, -5.74193, 0.0, 0.190891, -0.0139194, 101.102, 0.0816363, 1.33717E-4, 6.54403E-6, 0.00310295, 0.0, 0.0, 0.0538205, 0.12391, -0.0139831, 0.0, 0.0, -3.95915E-6, 0.0, -0.714651, -0.00501027, 0.0, -0.00324756, 0.0, 0.0, 0.0442173, -13.1598, -0.00315626, 0.00124574, -0.00147626, -0.00155461, 0.0640682, 0.134898, -0.0242415, 0.0, 0.0, 0.0, 6.13666E-4, -0.00540373, 2.61635E-5, -0.00333012, 0.0, -0.00308101, -0.00242679, -0.00336086, 0.0, -1189.79, -0.0504738, -0.00261547, -0.00103132, 1.91583E-4, -83.8132, -0.0140517, -0.0114167, -0.00408012, 1.73522E-4, -0.0139644, -0.0664128, -0.0685152, -13441.4, 0.0, 0.0, 0.0, 607.916, -0.0041222, -0.00220996, 0.0, 1702.77, -0.00463015, 0.0, 0.0, -0.0022536, -0.00296204, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0392786, 0.0131186, -0.00178086, 0.0, 0.0, -0.390083, -0.0284741, -77.84, -0.00102601, 0.0, -7.26485E-4, -0.00542181, -0.00559305, 0.0122825, 0.0123868, 0.00668835, -0.0103303, -0.00951903, 2.70021E-4, -0.0257084, -0.013243, 0.0, -0.0381, -0.0031681, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -9.05762E-4, -0.0021459, -0.00117824, 3.66732, -3.79729E-4, -0.00613966, -0.00509082, -0.00196332, -0.0030828, -9.75222E-4, 4.03315, -0.25271, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.16112, 0.0, 0.0, 0.0333725, 0.0, 0.0348637, -0.00544368, 0.0, -0.067394, 0.174754, 0.0, 0.0, 0.0, 174.712, 0.0, 0.126733, 0.0, 103.154, 0.0552075, 0.0, 0.0, 8.13525E-4, 0.0, 0.0, 0.0866784, 0.158727, 0.0, 0.0, 0.0, 0.0, 0.0, -25.0482, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.00248894, 6.16053E-4, -5.79716E-4, 0.00295482, 0.0847001, 0.170147, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.47425E-5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.944846, 0.0, 0.0, -0.0308617, 0.0, -0.0244019, 0.00648607, 0.0, 0.0308181, 0.0459392, 0.0, 0.0, 0.0, 174.712, 0.0, 0.021326, 0.0, -356.958, 0.0, 1.82278E-4, 0.0, 3.07472E-4, 0.0, 0.0, 0.0866784, 0.158727, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00383054, 0.0, 0.0, -0.00193065, -0.0014509, 0.0, 0.0, 0.0, 0.0, -0.00123493, 0.00136736, 0.0847001, 0.170147, 0.00371469, 0.0, 0.0, 0.0, 0.0, 0.0051025, 2.47425E-5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00368756, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.3558, 0.144816, 0.0, 0.0607767, 0.0, 0.0294777, 0.07469, 0.0, -0.0923822, 0.0857342, 0.0, 0.0, 0.0, 23.8636, 0.0, 0.0771653, 0.0, 81.8751, 0.0187736, 0.0, 0.0, 0.0149667, 0.0, 0.0, 0.0866784, 0.158727, 0.0, 0.0, 0.0, 0.0, 0.0, -367.874, 0.00548158, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0847001, 0.170147, 0.0122631, 0.0, 0.0, 0.0, 0.0, 0.00817187, 3.71617E-5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.00210826, -0.0031364, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0735742, -0.0500266, 0.0, 0.0, 0.0, 0.0, 0.0194965, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.04761, 0.200165, 0.237697, 0.0368552, 0.0, 0.0357202, -0.214075, 0.0, -0.108018, -0.373981, 0.0, 0.0310022, -0.00116305, -20.7596, 0.0, 0.0864502, 0.0, 97.4908, 0.0516707, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0866784, 0.158727, 0.0, 0.0, 0.0, 0.0, 0.0, 346.193, 0.0134297, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.00348509, -1.54689E-4, 0.0, 0.0, 0.0847001, 0.170147, 0.0147753, 0.0, 0.0, 0.0, 0.0, 0.018932, 3.68181E-5, 0.013257, 0.0, 0.0, 0.00359719, 0.00744328, -0.00100023, -6505.28, 0.0, 0.0103485, -0.00100983, -0.00406916, -66.0864, -0.0171533, 0.0110605, 0.01203, -0.00520034, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -2627.69, 0.00713755, 0.00417999, 0.0, 12591.0, 0.0, 0.0, 0.0, -0.00223595, 0.00460217, 0.00571794, 0.0, 0.0, 0.0, 0.0, -0.0318353, -0.0235526, -0.0136189, 0.0, 0.0, 0.0, 0.0203522, -66.7837, -0.00109724, 0.0, -0.0138821, 0.0160468, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0151574, -5.4447E-4, 0.0, 0.0728224, 0.0659413, 0.0, -0.00515692, 0.0, 0.0, -3703.67, 0.0, 0.0, 0.0136131, 0.00538153, 0.0, 4.76285, -0.0175677, 0.0226301, 0.0, 0.0176631, 0.00477162, 0.0, 5.39354, 0.0, -0.0075171, 0.0, 0.0, -88.2736, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.26376, -0.214304, -0.149984, 0.230404, 0.0298237, 0.0268673, 0.296228, 0.02219, -0.0207655, 0.452506, 0.120105, 0.032442, 0.0424816, -9.14313, 0.0, 0.0247178, -0.0288229, 81.2805, 0.051038, -0.00580611, 2.51236E-5, -0.0124083, 0.0, 0.0, 0.0866784, 0.158727, -0.034819, 0.0, 0.0, 2.89885E-5, 0.0, 153.595, -0.0168604, 0.0, 0.0101015, 0.0, 0.0, 0.0, 0.0, 2.84552E-4, -0.00122181, 0.0, 0.0, 0.0847001, 0.170147, -0.0104927, 0.0, 0.0, 0.0, -0.00591313, -0.0230501, 3.14758E-5, 0.0, 0.0, 0.0126956, 0.00835489, 3.10513E-4, 0.0, 3421.19, -0.00245017, -4.27154E-4, 5.45152E-4, 0.00189896, 28.9121, -0.00649973, -0.0193855, -0.0148492, 0.0, -0.0510576, 0.0787306, 0.0951981, -14942.2, 0.0, 0.0, 0.0, 265.503, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0063711, 3.24789E-4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0614274, 0.0100376, -8.41083E-4, 0.0, 0.0, 0.0, -0.0127099, 0.0, 0.0, 0.0, -0.00394077, -0.0128601, -0.00797616, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.00671465, -0.00169799, 0.00193772, 3.8114, -0.0077929, -0.0182589, -0.012586, -0.0104311, -0.00302465, 0.00243063, 3.63237, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {70.9557, -0.32674, 0.0, -0.516829, -0.00171664, 0.090931, -0.6715, -0.147771, -0.0927471, -0.230862, -0.15641, 0.0134455, -0.119717, 2.52151, 0.0, -0.241582, 0.0592939, 4.39756, 0.091528, 0.00441292, 0.0, 0.00866807, 0.0, 0.0, 0.0866784, 0.158727, 0.0974701, 0.0, 0.0, 0.0, 0.0, 67.0217, -0.0013166, 0.0, -0.0165317, 0.0, 0.0, 0.0850247, 27.7428, 0.00498658, 0.00615115, 0.00950156, -0.0212723, 0.0847001, 0.170147, -0.0238645, 0.0, 0.0, 0.0, 0.0013738, -0.00841918, 2.80145E-5, 0.00712383, 0.0, -0.0166209, 1.03533E-4, -0.0168898, 0.0, 3645.26, 0.0, 0.00654077, 3.6913E-4, 9.94419E-4, 84.2803, -0.0116124, -0.00774414, -0.00168844, 0.00142809, -0.00192955, 0.117225, -0.0241512, 15052.1, 0.0, 0.0, 0.0, 1602.61, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -3.54403E-4, -0.018727, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0276439, 0.00643207, -0.03543, 0.0, 0.0, 0.0, -0.0280221, 81.1228, -6.75255E-4, 0.0, -0.0105162, -0.00348292, -0.00697321, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.00145546, -0.013197, -0.00357751, -1.09021, -0.0150181, -0.00712841, -0.0066459, -0.0035261, -0.0187773, -0.00222432, -0.393895, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.060405, 1.57034, 0.0299387, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.51018, 0.0, 0.0, 0.0, -8.6165, 0.0126454, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00550878, 0.0, 0.0, 0.0866784, 0.158727, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0623881, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0847001, 0.170147, -0.0945934, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
    private static final double[] PS = new double[]{0.956827, 0.0620637, 0.0318433, 0.0, 0.0, 0.03949, 0.0, 0.0, -0.00924882, -0.00794023, 0.0, 0.0, 0.0, 174.712, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00274677, 0.0, 0.0154951, 0.0866784, 0.158727, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -6.99007E-4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0124362, -0.00528756, 0.0847001, 0.170147, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.47425E-5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    private static final double[][] PDL = new double[][]{{1.0993, 3.90631, 3.07165, 0.986161, 16.3536, 4.6383, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.2884, 0.0310302, 0.118339}, {1.0, 0.7, 1.1502, 3.44689, 1.2884, 1.0, 1.08738, 1.22947, 1.10016, 0.734129, 1.15241, 2.22784, 0.795046, 4.01612, 4.47749, 123.435, -0.0760535, 1.68986E-6, 0.744294, 1.03604, 172.783, 1.1502, 3.44689, -0.74623, 0.949154}};
    private static final double[] PTM = new double[]{1041.3, 386.0, 195.0, 16.6728, 213.0, 120.0, 240.0, 187.0, -2.0, 0.0};
    private static final double[][] PDM = new double[][]{{2.456E7, 6.71072E-6, 100.0, 0.0, 110.0, 10.0, 0.0, 0.0, 0.0, 0.0}, {8.594E10, 1.0, 105.0, -8.0, 110.0, 10.0, 90.0, 2.0, 0.0, 0.0}, {2.81E11, 0.0, 105.0, 28.0, 28.95, 0.0, 0.0, 0.0, 0.0, 0.0}, {3.3E10, 0.26827, 105.0, 1.0, 110.0, 10.0, 110.0, -10.0, 0.0, 0.0}, {1.33E9, 0.0119615, 105.0, 0.0, 110.0, 10.0, 0.0, 0.0, 0.0, 0.0}, {176100.0, 1.0, 95.0, -8.0, 110.0, 10.0, 90.0, 2.0, 0.0, 0.0}, {1.0E7, 1.0, 105.0, -8.0, 110.0, 10.0, 90.0, 2.0, 0.0, 0.0}, {1000000.0, 1.0, 105.0, -8.0, 550.0, 76.0, 90.0, 2.0, 0.0, 4000.0}};
    private static final double[][] PTL = new double[][]{{1.00858, 0.0456011, -0.0222972, -0.0544388, 5.23136E-4, -0.0188849, 0.0523707, -0.00943646, 0.00631707, -0.078046, -0.048843, 0.0, 0.0, -7.6025, 0.0, -0.0144635, -0.0176843, -121.517, 0.0285647, 0.0, 0.0, 6.31792E-4, 0.0, 0.00577197, 0.0866784, 0.158727, 0.0, 0.0, 0.0, 0.0, 0.0, -8902.72, 0.00330611, 0.00302172, 0.0, -0.00213673, -3.2091E-4, 0.0, 0.0, 0.00276034, 0.00282487, -2.97592E-4, -0.00421534, 0.0847001, 0.170147, 0.00896456, 0.0, -0.0108596, 0.0, 0.0, 0.00557917, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00965405, 0.0, 0.0, 2.0}, {0.939664, 0.0856514, -0.00679989, 0.0265929, -0.00474283, 0.0121855, -0.0214905, 0.00649651, -0.0205477, -0.0424952, 0.0, 0.0, 0.0, 11.9148, 0.0, 0.0118777, -0.072823, -81.5965, 0.0173887, 0.0, 0.0, 0.0, -0.0144691, 2.80259E-4, 0.0866784, 0.158727, 0.0, 0.0, 0.0, 0.0, 0.0, 216.584, 0.00318713, 0.00737479, 0.0, -0.00255018, -0.00392806, 0.0, 0.0, -0.00289757, -0.00133549, 0.00102661, 3.53775E-4, 0.0847001, 0.170147, -0.00917497, 0.0, 0.0, 0.0, 0.0, 0.00356082, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0100902, 0.0, 0.0, 2.0}, {0.985982, -0.0455435, 0.0121106, 0.0204127, -0.00240836, 0.0111383, -0.0451926, 0.0135074, -0.00654139, 0.115275, 0.128247, 0.0, 0.0, -5.30705, 0.0, -0.0379332, -0.0624741, 0.771062, 0.0296315, 0.0, 0.0, 0.0, 0.00681051, -0.00434767, 0.0866784, 0.158727, 0.0, 0.0, 0.0, 0.0, 0.0, 10.7003, -0.00276907, 4.32474E-4, 0.0, 0.00131497, -6.47517E-4, 0.0, -22.0621, -0.00110804, -8.09338E-4, 4.18184E-4, 0.0042965, 0.0847001, 0.170147, 0.0, 0.0, 0.0, 0.0, 0.0, -0.00404337, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -9.5255E-4, 8.56253E-4, 4.33114E-4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00121223, 2.38694E-4, 9.15245E-4, 0.00128385, 8.67668E-4, -5.61425E-6, 1.04445, 34.1112, 0.0, -0.840704, -239.639, 0.706668, -20.5873, -0.363696, 23.9245, 0.0, -0.00106657, -7.67292E-4, 1.54534E-4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0}, {1.0032, 0.0383501, -0.00238983, 0.0028395, 0.00420956, 5.86619E-4, 0.0219054, -0.0100946, -0.00350259, 0.0417392, -0.00844404, 0.0, 0.0, 4.96949, 0.0, -0.00706478, -0.0146494, 31.3258, -0.00186493, 0.0, -0.0167499, 0.0, 0.0, 5.12686E-4, 0.0866784, 0.158727, -0.00464167, 0.0, 0.0, 0.0, 0.00437353, -199.069, 0.0, -0.00534884, 0.0, 0.00162458, 0.00293016, 0.00267926, 590.449, 0.0, 0.0, -0.00117266, -3.5889E-4, 0.0847001, 0.170147, 0.0, 0.0, 0.0138673, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00160571, 6.28078E-4, 5.05469E-5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.00157829, -4.00855E-4, 5.04077E-5, -0.00139001, -0.00233406, -4.81197E-4, 1.46758, 6.20332, 0.0, 0.366476, -61.976, 0.309198, -19.8999, 0.0, -329.933, 0.0, -0.0011008, -9.3931E-5, 1.39638E-4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0}};
    private static final double[][] PMA = new double[][]{{0.981637, -0.00141317, 0.0387323, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0358707, -0.00863658, 0.0, 0.0, -2.02226, 0.0, -0.00869424, -0.0191397, 87.6779, 0.00452188, 0.0, 0.022376, 0.0, 0.0, 0.0, 0.0, 0.0, -0.00707572, 0.0, 0.0, 0.0, -0.0041121, 35.006, 0.0, 0.0, 0.0, 0.0, 0.0, -0.00836657, 16.1347, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.014513, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00124152, 6.43365E-4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00133255, 0.00242657, 0.00160666, -0.00185728, -0.00146874, -4.79163E-6, 1.22464, 35.351, 0.0, 0.449223, -47.7466, 0.470681, 8.41861, -0.288198, 167.854, 0.0, 7.11493E-4, 6.05601E-4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0}, {1.00422, -0.00711212, 0.0052448, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0528914, -0.0241301, 0.0, 0.0, -21.2219, -0.010383, -0.00328077, 0.0165727, 1.68564, -0.00668154, 0.0, 0.0145155, 0.0, 0.00842365, 0.0, 0.0, 0.0, -0.00434645, 0.0, 0.0, 0.021678, 0.0, -138.459, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00704573, -47.3204, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0108767, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.00808279, 0.0, 0.0, 0.0, 0.0, 5.21769E-4, -2.27387E-4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00326769, 0.00316901, 4.60316E-4, -1.01431E-4, 0.00102131, 9.96601E-4, 1.25707, 25.0114, 0.0, 0.424472, -27.7655, 0.344625, 27.5412, 0.0, 794.251, 0.0, 0.00245835, 0.00138871, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0}, {1.0189, -0.0246603, 0.0100078, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0670977, -0.0402286, 0.0, 0.0, -22.9466, -0.00747019, 0.0022658, 0.0263931, 37.2625, -0.00639041, 0.0, 0.00958383, 0.0, 0.0, 0.0, 0.0, 0.0, -0.00185291, 0.0, 0.0, 0.0, 0.0, 139.717, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00919771, -369.121, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0157067, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.00707265, 0.0, 0.0, 0.0, 0.0, -0.00292953, -0.00277739, -4.40092E-4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0024728, 2.95035E-4, -0.00181246, 0.00281945, 0.00427296, 9.78863E-4, 1.40545, -6.19173, 0.0, 0.0, -79.3632, 0.444643, -403.085, 0.0, 11.5603, 0.0, 0.00225068, 8.48557E-4, -2.98493E-4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0}, {0.975801, 0.038068, -0.0305198, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0385575, 0.0504057, 0.0, 0.0, -176.046, 0.0144594, -0.00148297, -0.0036856, 30.2185, -0.00323338, 0.0, 0.0153569, 0.0, -0.0115558, 0.0, 0.0, 0.0, 0.0048962, 0.0, 0.0, -0.0100616, -0.00821324, -157.757, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00663564, 45.841, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.025128, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00991215, 0.0, 0.0, 0.0, 0.0, -8.73148E-4, -0.00129648, -7.32026E-5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0046811, -0.00466003, -0.00131567, -7.3939E-4, 6.32499E-4, -4.65588E-4, -1.29785, -157.139, 0.0, 0.25835, -36.9453, 0.410672, 9.78196, -0.152064, -3850.84, 0.0, -8.52706E-4, -0.00140945, -7.26786E-4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0}, {0.960722, 0.0703757, -0.0300266, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0222671, 0.0410423, 0.0, 0.0, -163.07, 0.0106073, 5.40747E-4, 0.00779481, 144.908, 1.51484E-4, 0.0, 0.0197547, 0.0, -0.0141844, 0.0, 0.0, 0.0, 0.00577884, 0.0, 0.0, 0.00974319, 0.0, -2880.15, 0.0, 0.0, 0.0, 0.0, 0.0, -0.00444902, -29.276, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0234419, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00536685, 0.0, 0.0, 0.0, 0.0, -4.65325E-4, -5.50628E-4, 3.31465E-4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.00206179, -0.00308575, -7.93589E-4, -1.08629E-4, 5.95511E-4, -9.0505E-4, 1.18997, 41.5924, 0.0, -0.472064, -947.15, 0.398723, 19.8304, 0.0, 3732.19, 0.0, -0.0015004, -0.00114933, -1.56769E-4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0}, {1.03123, -0.0705124, 0.00871615, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0382621, -0.00980975, 0.0, 0.0, 28.9286, 0.00957341, 0.0, 0.0, 86.6153, 7.91938E-4, 0.0, 0.0, 0.0, 0.00468917, 0.0, 0.0, 0.0, 0.00786638, 0.0, 0.0, 0.00990827, 0.0, 65.5573, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -40.02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00707457, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00572268, 0.0, 0.0, 0.0, 0.0, -2.0497E-4, 0.0012156, -8.05579E-6, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.00249941, -4.57256E-4, -1.59311E-4, 2.96481E-4, -0.00177318, -6.37918E-4, 1.02395, 12.8172, 0.0, 0.149903, -26.3818, 0.0, 47.0628, -0.222139, 0.0482292, 0.0, -8.67075E-4, -5.86479E-4, 5.32462E-4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0}, {1.00828, -0.0910404, -0.0226549, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.023242, -0.00908925, 0.0, 0.0, 33.6105, 0.0, 0.0, 0.0, -12.4957, -0.00587939, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 27.9765, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2012.37, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0175553, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00329699, 0.00126659, 2.68402E-4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.00117894, 0.00148746, 1.06478E-4, 1.34743E-4, -0.00220939, -6.23523E-4, 0.636539, 11.3621, 0.0, -0.393777, 2386.87, 0.0, 661.865, -0.121434, 9.27608, 0.0, 1.68478E-4, 0.00124892, 0.00171345, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0}, {1.57293, -0.6784, 0.6475, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0762974, -0.360423, 0.0, 0.0, 128.358, 0.0, 0.0, 0.0, 46.8038, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.167898, 0.0, 0.0, 0.0, 0.0, 29099.4, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 31.5706, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0}, {0.860028, 0.377052, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.1757, 0.0, 0.0, 0.0, 0.00777757, 0.0, 0.0, 0.0, 101.024, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 654.251, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0156959, 0.0191001, 0.0315971, 0.0100982, -0.00671565, 0.00257693, 1.38692, 0.282132, 0.0, 0.0, 381.511, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0}, {1.06029, -0.0525231, 0.373034, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0331072, -0.388409, 0.0, 0.0, -165.295, -0.213801, -0.0438916, -0.322716, -88.2393, 0.118458, 0.0, -0.435863, 0.0, 0.0, 0.0, 0.0, 0.0, -0.119782, 0.0, 0.0, 0.0, 0.0, 26.2229, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -53.7443, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.455788, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0384009, 0.0396733, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0505494, 0.0739617, 0.01922, -0.00846151, -0.0134244, 0.0196338, 1.50421, 18.8368, 0.0, 0.0, -51.3114, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0511923, 0.0361225, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.0}};
    private static final double[] PAVGM = new double[]{261.0, 264.0, 229.0, 217.0, 217.0, 223.0, 286.76, -2.9394, 2.5, 0.0};
    private final NRLMSISE00InputParameters inputParams;
    private PVCoordinatesProvider sun;
    private final BodyShape earth;
    private final int[] sw;
    private final int[] swc;

    public NRLMSISE00(NRLMSISE00InputParameters parameters, PVCoordinatesProvider sun, BodyShape earth) {
        this(parameters, sun, earth, NRLMSISE00.allOnes(), NRLMSISE00.allOnes());
    }

    private NRLMSISE00(NRLMSISE00InputParameters parameters, PVCoordinatesProvider sun, BodyShape earth, int[] sw, int[] swc) {
        this.inputParams = parameters;
        this.sun = sun;
        this.earth = earth;
        this.sw = sw;
        this.swc = swc;
    }

    public NRLMSISE00 withSwitch(int number, int value) {
        if (number < 1 || number > 23) {
            throw new OrekitException((Localizable)LocalizedCoreFormats.OUT_OF_RANGE_SIMPLE, number, 1, 23);
        }
        int[] newSw = (int[])this.sw.clone();
        int[] newSwc = (int[])this.swc.clone();
        if (number != 9) {
            newSw[number] = value == 1 ? 1 : 0;
            newSwc[number] = value > 0 ? 1 : 0;
        } else {
            newSw[number] = value == -1 || value == 1 ? value : 0;
            newSwc[number] = newSw[number];
        }
        return new NRLMSISE00(this.inputParams, this.sun, this.earth, newSwc, newSwc);
    }

    private static int[] allOnes() {
        int[] array = new int[24];
        Arrays.fill(array, 1);
        return array;
    }

    @Override
    public Frame getFrame() {
        return this.earth.getBodyFrame();
    }

    @Override
    public double getDensity(AbsoluteDate date, Vector3D position, Frame frame) {
        if (date.compareTo(this.inputParams.getMaxDate()) > 0 || date.compareTo(this.inputParams.getMinDate()) < 0) {
            throw new OrekitException((Localizable)OrekitMessages.NO_SOLAR_ACTIVITY_AT_DATE, date, this.inputParams.getMinDate(), this.inputParams.getMaxDate());
        }
        DateTimeComponents dtc = date.getComponents(TimeScalesFactory.getUT1(IERSConventions.IERS_2010, true));
        int doy = dtc.getDate().getDayOfYear();
        double sec = dtc.getTime().getSecondsInLocalDay();
        GeodeticPoint inBody = this.earth.transform(position, frame, date);
        double alt = inBody.getAltitude() / 1000.0;
        double lon = FastMath.toDegrees((double)inBody.getLongitude());
        double lat = FastMath.toDegrees((double)inBody.getLatitude());
        double lst = this.localSolarTime(date, position, frame);
        Output out = new Output(doy, sec, lat, lon, lst, this.inputParams.getAverageFlux(date), this.inputParams.getDailyFlux(date), this.inputParams.getAp(date));
        out.gtd7d(alt);
        return out.getDensity(5);
    }

    @Override
    public <T extends RealFieldElement<T>> T getDensity(FieldAbsoluteDate<T> date, FieldVector3D<T> position, Frame frame) {
        AbsoluteDate dateD = date.toAbsoluteDate();
        if (dateD.compareTo(this.inputParams.getMaxDate()) > 0 || dateD.compareTo(this.inputParams.getMinDate()) < 0) {
            throw new OrekitException((Localizable)OrekitMessages.NO_SOLAR_ACTIVITY_AT_DATE, dateD, this.inputParams.getMinDate(), this.inputParams.getMaxDate());
        }
        UT1Scale ut1 = TimeScalesFactory.getUT1(IERSConventions.IERS_2010, true);
        DateTimeComponents dtc = dateD.getComponents(ut1);
        int doy = dtc.getDate().getDayOfYear();
        T sec = date.durationFrom(new AbsoluteDate(dtc.getDate(), TimeComponents.H00, (TimeScale)ut1));
        FieldGeodeticPoint<T> inBody = this.earth.transform(position, frame, date);
        RealFieldElement alt = (RealFieldElement)inBody.getAltitude().divide(1000.0);
        RealFieldElement lon = (RealFieldElement)inBody.getLongitude().multiply(57.29577951308232);
        RealFieldElement lat = (RealFieldElement)inBody.getLatitude().multiply(57.29577951308232);
        T lst = this.localSolarTime(dateD, position, frame);
        FieldOutput out = new FieldOutput(this, doy, sec, lat, lon, lst, this.inputParams.getAverageFlux(dateD), this.inputParams.getDailyFlux(dateD), this.inputParams.getAp(dateD));
        out.gtd7d(alt);
        return out.getDensity(5);
    }

    private double localSolarTime(AbsoluteDate date, Vector3D position, Frame frame) {
        Vector3D sunPos = this.sun.getPVCoordinates(date, frame).getPosition();
        double lst = Math.PI + FastMath.atan2((double)(sunPos.getX() * position.getY() - sunPos.getY() * position.getX()), (double)(sunPos.getX() * position.getX() + sunPos.getY() * position.getY()));
        return lst * 12.0 / Math.PI;
    }

    private <T extends RealFieldElement<T>> T localSolarTime(AbsoluteDate date, FieldVector3D<T> position, Frame frame) {
        Vector3D sunPos = this.sun.getPVCoordinates(date, frame).getPosition();
        RealFieldElement y = (RealFieldElement)((RealFieldElement)position.getY().multiply(sunPos.getX())).subtract(position.getX().multiply(sunPos.getY()));
        RealFieldElement x = (RealFieldElement)((RealFieldElement)position.getX().multiply(sunPos.getX())).add(position.getY().multiply(sunPos.getY()));
        RealFieldElement hl = (RealFieldElement)((RealFieldElement)y.atan2((Object)x)).add(Math.PI);
        return (T)((RealFieldElement)hl.multiply(3.819718634205488));
    }

    public class FieldOutput<T extends RealFieldElement<T>> {
        private final Field<T> field;
        private final T zero;
        private final int doy;
        private final T sec;
        private final T lat;
        private final T lon;
        private final T hl;
        private final double f107a;
        private final double f107;
        private final double[] ap;
        private final T glat;
        private final T rlat;
        private T dm28;
        private final T[][] plg;
        private final T ctloc;
        private final T stloc;
        private final T c2tloc;
        private final T s2tloc;
        private final T c3tloc;
        private final T s3tloc;
        private double apdf;
        private T apt;
        private final T[] meso_tn1;
        private final T[] meso_tn2;
        private final T[] meso_tn3;
        private final T[] meso_tgn1;
        private final T[] meso_tgn2;
        private final T[] meso_tgn3;
        private final T[] densities;
        private final T[] temperatures;
        final /* synthetic */ NRLMSISE00 this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        FieldOutput(int hl, T f107a, T t, T f107, T t2, double ap, double d, double[] dArray) {
            void lat;
            void doy;
            this.this$0 = (NRLMSISE00)this$0;
            this.field = sec.getField();
            this.zero = (RealFieldElement)this.field.getZero();
            this.doy = doy;
            this.sec = sec;
            this.lat = lat;
            this.lon = lon;
            this.hl = hl;
            this.f107a = f107a;
            this.f107 = f107;
            this.ap = (double[])ap.clone();
            this.plg = (RealFieldElement[][])MathArrays.buildArray(this.field, (int)4, (int)8);
            this.meso_tn1 = (RealFieldElement[])MathArrays.buildArray(this.field, (int)ZN1.length);
            this.meso_tn2 = (RealFieldElement[])MathArrays.buildArray(this.field, (int)ZN2.length);
            this.meso_tn3 = (RealFieldElement[])MathArrays.buildArray(this.field, (int)ZN3.length);
            this.meso_tgn1 = (RealFieldElement[])MathArrays.buildArray(this.field, (int)2);
            this.meso_tgn2 = (RealFieldElement[])MathArrays.buildArray(this.field, (int)2);
            this.meso_tgn3 = (RealFieldElement[])MathArrays.buildArray(this.field, (int)2);
            this.densities = (RealFieldElement[])MathArrays.buildArray(this.field, (int)9);
            this.temperatures = (RealFieldElement[])MathArrays.buildArray(this.field, (int)2);
            void xlat = ((NRLMSISE00)this$0).sw[2] == 0 ? (RealFieldElement)this.zero.add(45.0) : lat;
            RealFieldElement c2 = (RealFieldElement)((RealFieldElement)xlat.multiply(0.0349066)).cos();
            this.glat = (RealFieldElement)((RealFieldElement)((RealFieldElement)c2.multiply(-0.0026373)).add(1.0)).multiply(980.616);
            this.rlat = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.glat.multiply(2)).divide(((RealFieldElement)c2.multiply(2.27E-9)).add(3.085462E-6))).multiply(1.0E-5);
            RealFieldElement latr = (RealFieldElement)lat.multiply(0.0174533);
            RealFieldElement c = (RealFieldElement)latr.sin();
            RealFieldElement s = (RealFieldElement)latr.cos();
            this.plg[0][1] = c;
            this.plg[0][2] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)c.multiply(3.0)).multiply(this.plg[0][1])).subtract(1.0)).divide(2.0);
            this.plg[0][3] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)c.multiply(5.0)).multiply(this.plg[0][2])).subtract(this.plg[0][1].multiply(2.0))).divide(3.0);
            this.plg[0][4] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)c.multiply(7.0)).multiply(this.plg[0][3])).subtract(this.plg[0][2].multiply(3.0))).divide(4.0);
            this.plg[0][5] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)c.multiply(9.0)).multiply(this.plg[0][4])).subtract(this.plg[0][3].multiply(4.0))).divide(5.0);
            this.plg[0][6] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)c.multiply(11.0)).multiply(this.plg[0][5])).subtract(this.plg[0][4].multiply(5.0))).divide(6.0);
            this.plg[1][1] = s;
            this.plg[1][2] = (RealFieldElement)((RealFieldElement)c.multiply(3.0)).multiply(this.plg[1][1]);
            this.plg[1][3] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)c.multiply(5.0)).multiply(this.plg[1][2])).subtract(this.plg[1][1].multiply(3.0))).divide(2.0);
            this.plg[1][4] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)c.multiply(7.0)).multiply(this.plg[1][3])).subtract(this.plg[1][2].multiply(4.0))).divide(3.0);
            this.plg[1][5] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)c.multiply(9.0)).multiply(this.plg[1][4])).subtract(this.plg[1][3].multiply(5.0))).divide(4.0);
            this.plg[1][6] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)c.multiply(11.0)).multiply(this.plg[1][5])).subtract(this.plg[1][4].multiply(6.0))).divide(5.0);
            this.plg[2][2] = (RealFieldElement)((RealFieldElement)s.multiply(3.0)).multiply(this.plg[1][1]);
            this.plg[2][3] = (RealFieldElement)((RealFieldElement)c.multiply(5.0)).multiply(this.plg[2][2]);
            this.plg[2][4] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)c.multiply(7.0)).multiply(this.plg[2][3])).subtract(this.plg[2][2].multiply(5.0))).divide(2.0);
            this.plg[2][5] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)c.multiply(9.0)).multiply(this.plg[2][4])).subtract(this.plg[2][3].multiply(6.0))).divide(3.0);
            this.plg[2][6] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)c.multiply(11.0)).multiply(this.plg[2][5])).subtract(this.plg[2][4].multiply(7.0))).divide(4.0);
            this.plg[2][7] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)c.multiply(13.0)).multiply(this.plg[2][6])).subtract(this.plg[2][5].multiply(8.0))).divide(5.0);
            this.plg[3][3] = (RealFieldElement)((RealFieldElement)s.multiply(5.0)).multiply(this.plg[2][2]);
            this.plg[3][4] = (RealFieldElement)((RealFieldElement)c.multiply(7.0)).multiply(this.plg[3][3]);
            this.plg[3][5] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)c.multiply(9.0)).multiply(this.plg[3][4])).subtract(this.plg[3][3].multiply(7.0))).divide(2.0);
            this.plg[3][6] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)c.multiply(11.0)).multiply(this.plg[3][5])).subtract(this.plg[3][4].multiply(8.0))).divide(3.0);
            if (((NRLMSISE00)this$0).sw[7] != 0 || ((NRLMSISE00)this$0).sw[8] != 0 || ((NRLMSISE00)this$0).sw[14] != 0) {
                RealFieldElement tloc = (RealFieldElement)hl.multiply(0.2618);
                RealFieldElement tlx2 = (RealFieldElement)tloc.add((Object)tloc);
                RealFieldElement tlx3 = (RealFieldElement)tloc.add((Object)tlx2);
                this.stloc = (RealFieldElement)tloc.sin();
                this.ctloc = (RealFieldElement)tloc.cos();
                this.s2tloc = (RealFieldElement)tlx2.sin();
                this.c2tloc = (RealFieldElement)tlx2.cos();
                this.s3tloc = (RealFieldElement)tlx3.sin();
                this.c3tloc = (RealFieldElement)tlx3.cos();
            } else {
                this.stloc = this.zero;
                this.ctloc = this.zero;
                this.s2tloc = this.zero;
                this.c2tloc = this.zero;
                this.s3tloc = this.zero;
                this.c3tloc = this.zero;
            }
        }

        void gts7(T alt) {
            double[] alpha = new double[]{-0.38, 0.0, 0.0, 0.0, 0.17, 0.0, -0.38, 0.0, 0.0};
            double[] altl = new double[]{200.0, 300.0, 160.0, 250.0, 240.0, 450.0, 320.0, 450.0};
            double xmm = PDM[2][4];
            RealFieldElement tinf = (RealFieldElement)this.zero.add(PTM[0] * PT[0]);
            if (alt.getReal() > ZN1[0]) {
                tinf = (RealFieldElement)tinf.multiply(((RealFieldElement)this.globe7(PT).multiply(this.this$0.sw[16])).add(1.0));
            }
            this.setTemperature(0, tinf);
            RealFieldElement g0 = (RealFieldElement)this.zero.add(PTM[3] * PS[0]);
            if (alt.getReal() > ZN1[4]) {
                g0 = (RealFieldElement)g0.multiply(((RealFieldElement)this.globe7(PS).multiply(this.this$0.sw[19])).add(1.0));
            }
            RealFieldElement tlb = (RealFieldElement)this.zero.add(PTM[1] * PD[3][0]);
            tlb = (RealFieldElement)tlb.multiply(((RealFieldElement)this.globe7(PD[3]).multiply(this.this$0.sw[17])).add(1.0));
            RealFieldElement s = (RealFieldElement)g0.divide(tinf.subtract((Object)tlb));
            this.meso_tn1[1] = (RealFieldElement)this.zero.add(PTM[6] * PTL[0][0]);
            this.meso_tn1[2] = (RealFieldElement)this.zero.add(PTM[2] * PTL[1][0]);
            this.meso_tn1[3] = (RealFieldElement)this.zero.add(PTM[7] * PTL[2][0]);
            this.meso_tn1[4] = (RealFieldElement)this.zero.add(PTM[4] * PTL[3][0]);
            this.meso_tgn1[1] = (RealFieldElement)this.zero.add(PTM[8] * PMA[8][0]);
            if (alt.getReal() < 300.0) {
                double r = PTM[4] * PTL[3][0];
                this.meso_tn1[1] = (RealFieldElement)this.meso_tn1[1].divide(((RealFieldElement)((RealFieldElement)this.glob7s(PTL[0]).multiply(this.this$0.sw[18])).negate()).add(1.0));
                this.meso_tn1[2] = (RealFieldElement)this.meso_tn1[2].divide(((RealFieldElement)((RealFieldElement)this.glob7s(PTL[1]).multiply(this.this$0.sw[18])).negate()).add(1.0));
                this.meso_tn1[3] = (RealFieldElement)this.meso_tn1[3].divide(((RealFieldElement)((RealFieldElement)this.glob7s(PTL[2]).multiply(this.this$0.sw[18])).negate()).add(1.0));
                this.meso_tn1[4] = (RealFieldElement)this.meso_tn1[4].divide(((RealFieldElement)((RealFieldElement)this.glob7s(PTL[3]).multiply(this.this$0.sw[18] * this.this$0.sw[20])).negate()).add(1.0));
                this.meso_tgn1[1] = (RealFieldElement)this.meso_tgn1[1].multiply(((RealFieldElement)this.glob7s(PMA[8]).multiply(this.this$0.sw[18] * this.this$0.sw[20])).add(1.0));
                this.meso_tgn1[1] = (RealFieldElement)this.meso_tgn1[1].multiply(((RealFieldElement)this.meso_tn1[4].multiply(this.meso_tn1[4])).divide(r * r));
            }
            this.setTemperature(1, this.densu(alt, (RealFieldElement)this.zero.add(1.0), tinf, tlb, 0.0, 0.0, PTM[5], s));
            RealFieldElement g28 = (RealFieldElement)this.globe7(PD[2]).multiply(this.this$0.sw[21]);
            RealFieldElement db28 = (RealFieldElement)((RealFieldElement)g28.exp()).multiply(PDM[2][0] * PD[2][0]);
            RealFieldElement diffusiveDensity = this.densu(alt, db28, tinf, tlb, 28.0, alpha[2], PTM[5], s);
            this.setDensity(2, diffusiveDensity);
            RealFieldElement zhf = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.lat.multiply(0.0174533)).sin()).multiply((double)this.this$0.sw[5] * PDL[0][24] * FastMath.cos((double)(0.0172142 * ((double)this.doy - PT[13]))))).add(1.0)).multiply(PDL[1][24]);
            RealFieldElement zh28 = (RealFieldElement)zhf.multiply(PDM[2][2]);
            double zhm28 = PDM[2][3] * PDL[1][5];
            RealFieldElement b28 = this.densu(zh28, db28, tinf, tlb, 28.0 - xmm, alpha[2] - 1.0, PTM[5], s);
            if (this.this$0.sw[15] != 0 && alt.getReal() <= altl[2]) {
                this.dm28 = this.densu(alt, b28, tinf, tlb, xmm, alpha[2], PTM[5], s);
                this.setDensity(2, this.dnet(diffusiveDensity, this.dm28, zhm28, xmm, 28.0));
            } else {
                this.dm28 = this.zero;
            }
            RealFieldElement g4 = (RealFieldElement)this.globe7(PD[0]).multiply(this.this$0.sw[21]);
            RealFieldElement db04 = (RealFieldElement)((RealFieldElement)g4.exp()).multiply(PDM[0][0] * PD[0][0]);
            diffusiveDensity = this.densu(alt, db04, tinf, tlb, 4.0, alpha[0], PTM[5], s);
            this.setDensity(0, diffusiveDensity);
            if (this.this$0.sw[15] != 0 && alt.getReal() < altl[0]) {
                double zh04 = PDM[0][2];
                RealFieldElement b04 = this.densu((RealFieldElement)this.zero.add(zh04), db04, tinf, tlb, 4.0 - xmm, alpha[0] - 1.0, PTM[5], s);
                RealFieldElement dm04 = this.densu(alt, b04, tinf, tlb, xmm, 0.0, PTM[5], s);
                double zhm04 = zhm28;
                diffusiveDensity = this.dnet(diffusiveDensity, dm04, zhm04, xmm, 4.0);
                RealFieldElement rl = (RealFieldElement)((RealFieldElement)((RealFieldElement)b28.multiply(PDM[0][1])).divide((Object)b04)).log();
                double zc04 = PDM[0][4] * PDL[1][0];
                double hc04 = PDM[0][5] * PDL[1][1];
                this.setDensity(0, (RealFieldElement)diffusiveDensity.multiply((Object)this.ccor(alt, rl, hc04, zc04)));
            }
            RealFieldElement g16 = (RealFieldElement)this.globe7(PD[1]).multiply(this.this$0.sw[21]);
            RealFieldElement db16 = (RealFieldElement)((RealFieldElement)g16.exp()).multiply(PDM[1][0] * PD[1][0]);
            diffusiveDensity = this.densu(alt, db16, tinf, tlb, 16.0, alpha[1], PTM[5], s);
            this.setDensity(1, diffusiveDensity);
            if (this.this$0.sw[15] != 0 && alt.getReal() < altl[1]) {
                double zh16 = PDM[1][2];
                RealFieldElement b16 = this.densu((RealFieldElement)this.zero.add(zh16), db16, tinf, tlb, 16.0 - xmm, alpha[1] - 1.0, PTM[5], s);
                RealFieldElement dm16 = this.densu(alt, b16, tinf, tlb, xmm, 0.0, PTM[5], s);
                double zhm16 = zhm28;
                diffusiveDensity = this.dnet(diffusiveDensity, dm16, zhm16, xmm, 16.0);
                double rl = PDM[1][1] * PDL[1][16] * (1.0 + (double)this.this$0.sw[1] * PDL[0][23] * (this.f107a - 150.0));
                double hc16 = PDM[1][5] * PDL[1][3];
                double zc16 = PDM[1][4] * PDL[1][2];
                double hc216 = PDM[1][5] * PDL[1][4];
                diffusiveDensity = (RealFieldElement)diffusiveDensity.multiply(this.ccor2(alt, rl, hc16, zc16, hc216));
                double hcc16 = PDM[1][7] * PDL[1][13];
                double zcc16 = PDM[1][6] * PDL[1][12];
                double rc16 = PDM[1][3] * PDL[1][14];
                this.setDensity(1, (RealFieldElement)diffusiveDensity.multiply((Object)this.ccor(alt, (RealFieldElement)this.zero.add(rc16), hcc16, zcc16)));
            }
            RealFieldElement g32 = (RealFieldElement)this.globe7(PD[4]).multiply(this.this$0.sw[21]);
            RealFieldElement db32 = (RealFieldElement)((RealFieldElement)g32.exp()).multiply(PDM[3][0] * PD[4][0]);
            diffusiveDensity = this.densu(alt, db32, tinf, tlb, 32.0, alpha[3], PTM[5], s);
            this.setDensity(3, diffusiveDensity);
            if (this.this$0.sw[15] != 0) {
                if (alt.getReal() <= altl[3]) {
                    double zh32 = PDM[3][2];
                    RealFieldElement b32 = this.densu((RealFieldElement)this.zero.add(zh32), db32, tinf, tlb, 32.0 - xmm, alpha[3] - 1.0, PTM[5], s);
                    RealFieldElement dm32 = this.densu(alt, b32, tinf, tlb, xmm, 0.0, PTM[5], s);
                    double zhm32 = zhm28;
                    diffusiveDensity = this.dnet(diffusiveDensity, dm32, zhm32, xmm, 32.0);
                    RealFieldElement rl = (RealFieldElement)((RealFieldElement)((RealFieldElement)b28.multiply(PDM[3][1])).divide((Object)b32)).log();
                    double hc32 = PDM[3][5] * PDL[1][7];
                    double zc32 = PDM[3][4] * PDL[1][6];
                    diffusiveDensity = (RealFieldElement)diffusiveDensity.multiply((Object)this.ccor(alt, rl, hc32, zc32));
                }
                double hcc32 = PDM[3][7] * PDL[1][22];
                double hcc232 = PDM[3][7] * PDL[0][22];
                double zcc32 = PDM[3][6] * PDL[1][21];
                double rc32 = PDM[3][3] * PDL[1][23] * (1.0 + (double)this.this$0.sw[1] * PDL[0][23] * (this.f107a - 150.0));
                this.setDensity(3, (RealFieldElement)diffusiveDensity.multiply(this.ccor2(alt, rc32, hcc32, zcc32, hcc232)));
            }
            RealFieldElement g40 = (RealFieldElement)this.globe7(PD[5]).multiply(this.this$0.sw[21]);
            RealFieldElement db40 = (RealFieldElement)((RealFieldElement)g40.exp()).multiply(PDM[4][0] * PD[5][0]);
            diffusiveDensity = this.densu(alt, db40, tinf, tlb, 40.0, alpha[4], PTM[5], s);
            this.setDensity(4, diffusiveDensity);
            if (this.this$0.sw[15] != 0 && alt.getReal() <= altl[4]) {
                double zh40 = PDM[4][2];
                RealFieldElement b40 = this.densu((RealFieldElement)this.zero.add(zh40), db40, tinf, tlb, 40.0 - xmm, alpha[4] - 1.0, PTM[5], s);
                RealFieldElement dm40 = this.densu(alt, b40, tinf, tlb, xmm, 0.0, PTM[5], s);
                double zhm40 = zhm28;
                diffusiveDensity = this.dnet(diffusiveDensity, dm40, zhm40, xmm, 40.0);
                RealFieldElement rl = (RealFieldElement)((RealFieldElement)((RealFieldElement)b28.multiply(PDM[4][1])).divide((Object)b40)).log();
                double hc40 = PDM[4][5] * PDL[1][9];
                double zc40 = PDM[4][4] * PDL[1][8];
                this.setDensity(4, (RealFieldElement)diffusiveDensity.multiply((Object)this.ccor(alt, rl, hc40, zc40)));
            }
            RealFieldElement g1 = (RealFieldElement)this.globe7(PD[6]).multiply(this.this$0.sw[21]);
            RealFieldElement db01 = (RealFieldElement)((RealFieldElement)g1.exp()).multiply(PDM[5][0] * PD[6][0]);
            diffusiveDensity = this.densu(alt, db01, tinf, tlb, 1.0, alpha[6], PTM[5], s);
            this.setDensity(6, diffusiveDensity);
            if (this.this$0.sw[15] != 0 && alt.getReal() <= altl[6]) {
                double zh01 = PDM[5][2];
                RealFieldElement b01 = this.densu((RealFieldElement)this.zero.add(zh01), db01, tinf, tlb, 1.0 - xmm, alpha[6] - 1.0, PTM[5], s);
                RealFieldElement dm01 = this.densu(alt, b01, tinf, tlb, xmm, 0.0, PTM[5], s);
                double zhm01 = zhm28;
                diffusiveDensity = this.dnet(diffusiveDensity, dm01, zhm01, xmm, 1.0);
                RealFieldElement rl = (RealFieldElement)((RealFieldElement)((RealFieldElement)b28.multiply(PDM[5][1] * FastMath.sqrt((double)(PDL[1][17] * PDL[1][17])))).divide((Object)b01)).log();
                double hc01 = PDM[5][5] * PDL[1][11];
                double zc01 = PDM[5][4] * PDL[1][10];
                diffusiveDensity = (RealFieldElement)diffusiveDensity.multiply((Object)this.ccor(alt, rl, hc01, zc01));
                double hcc01 = PDM[5][7] * PDL[1][19];
                double zcc01 = PDM[5][6] * PDL[1][18];
                double rc01 = PDM[5][3] * PDL[1][20];
                this.setDensity(6, (RealFieldElement)diffusiveDensity.multiply((Object)this.ccor(alt, (RealFieldElement)this.zero.add(rc01), hcc01, zcc01)));
            }
            RealFieldElement g14 = (RealFieldElement)this.globe7(PD[7]).multiply(this.this$0.sw[21]);
            RealFieldElement db14 = (RealFieldElement)((RealFieldElement)g14.exp()).multiply(PDM[6][0] * PD[7][0]);
            diffusiveDensity = this.densu(alt, db14, tinf, tlb, 14.0, alpha[7], PTM[5], s);
            this.setDensity(7, diffusiveDensity);
            if (this.this$0.sw[15] != 0 && alt.getReal() <= altl[7]) {
                double zh14 = PDM[6][2];
                RealFieldElement b14 = this.densu((RealFieldElement)this.zero.add(zh14), db14, tinf, tlb, 14.0 - xmm, alpha[7] - 1.0, PTM[5], s);
                RealFieldElement dm14 = this.densu(alt, b14, tinf, tlb, xmm, 0.0, PTM[5], s);
                double zhm14 = zhm28;
                diffusiveDensity = this.dnet(diffusiveDensity, dm14, zhm14, xmm, 14.0);
                RealFieldElement rl = (RealFieldElement)((RealFieldElement)((RealFieldElement)b28.multiply(PDM[6][1] * PDL[0][2])).divide((Object)b14)).log();
                double hc14 = PDM[6][5] * PDL[0][1];
                double zc14 = PDM[6][4] * PDL[0][0];
                diffusiveDensity = (RealFieldElement)diffusiveDensity.multiply((Object)this.ccor(alt, rl, hc14, zc14));
                double hcc14 = PDM[6][7] * PDL[0][4];
                double zcc14 = PDM[6][6] * PDL[0][3];
                double rc14 = PDM[6][3] * PDL[0][5];
                this.setDensity(7, (RealFieldElement)diffusiveDensity.multiply((Object)this.ccor(alt, (RealFieldElement)this.zero.add(rc14), hcc14, zcc14)));
            }
            RealFieldElement g16h = (RealFieldElement)this.globe7(PD[8]).multiply(this.this$0.sw[21]);
            RealFieldElement db16h = (RealFieldElement)((RealFieldElement)g16h.exp()).multiply(PDM[7][0] * PD[8][0]);
            double tho = PDM[7][9] * PDL[0][6];
            diffusiveDensity = this.densu(alt, db16h, (RealFieldElement)this.zero.add(tho), (RealFieldElement)this.zero.add(tho), 16.0, alpha[8], PTM[5], s);
            double zsht = PDM[7][5];
            double zmho = PDM[7][4];
            T zsho = this.scalh(zmho, 16.0, tho);
            diffusiveDensity = (RealFieldElement)diffusiveDensity.multiply(((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)alt.negate()).add(zmho)).divide(zsht)).exp()).subtract(1.0)).multiply(-zsht)).divide(zsho)).exp());
            this.setDensity(8, diffusiveDensity);
            for (int i = 0; i < 9; ++i) {
                this.setDensity(i, (RealFieldElement)this.getDensity(i).multiply(1000000.0));
            }
            RealFieldElement tmd = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.getDensity(0).multiply(4.0)).add(this.getDensity(1).multiply(16.0))).add(this.getDensity(2).multiply(28.0))).add(this.getDensity(3).multiply(32.0))).add(this.getDensity(4).multiply(40.0))).add(this.getDensity(6).multiply(1.0))).add(this.getDensity(7).multiply(14.0))).multiply(1.66E-27);
            this.setDensity(5, tmd);
        }

        void gtd7(T alt) {
            T altt = alt.getReal() > ZN2[0] ? alt : (RealFieldElement)this.zero.add(ZN2[0]);
            this.gts7(altt);
            if (alt.getReal() >= ZN2[0]) {
                return;
            }
            double r = PMA[2][0] * PAVGM[2];
            this.meso_tgn2[0] = this.meso_tgn1[1];
            this.meso_tn2[0] = this.meso_tn1[4];
            this.meso_tn2[1] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.glob7s(PMA[0]).multiply(this.this$0.sw[20])).negate()).add(1.0)).reciprocal()).multiply(PMA[0][0] * PAVGM[0]);
            this.meso_tn2[2] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.glob7s(PMA[1]).multiply(this.this$0.sw[20])).negate()).add(1.0)).reciprocal()).multiply(PMA[1][0] * PAVGM[1]);
            this.meso_tn2[3] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.glob7s(PMA[2]).multiply(this.this$0.sw[20] * this.this$0.sw[22])).negate()).add(1.0)).reciprocal()).multiply(PMA[2][0] * PAVGM[2]);
            this.meso_tgn2[1] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.glob7s(PMA[9]).multiply(this.this$0.sw[20] * this.this$0.sw[22])).add(1.0)).multiply(PMA[9][0] * PAVGM[8])).multiply(this.meso_tn2[3])).multiply(this.meso_tn2[3])).divide(r * r);
            this.meso_tn3[0] = this.meso_tn2[3];
            if (alt.getReal() < ZN3[0]) {
                double q = PMA[6][0] * PAVGM[6];
                this.meso_tgn3[0] = this.meso_tgn2[1];
                this.meso_tn3[1] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.glob7s(PMA[3]).multiply(this.this$0.sw[22])).negate()).add(1.0)).reciprocal()).multiply(PMA[3][0] * PAVGM[3]);
                this.meso_tn3[2] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.glob7s(PMA[4]).multiply(this.this$0.sw[22])).negate()).add(1.0)).reciprocal()).multiply(PMA[4][0] * PAVGM[4]);
                this.meso_tn3[3] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.glob7s(PMA[5]).multiply(this.this$0.sw[22])).negate()).add(1.0)).reciprocal()).multiply(PMA[5][0] * PAVGM[5]);
                this.meso_tn3[4] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.glob7s(PMA[6]).multiply(this.this$0.sw[22])).negate()).add(1.0)).reciprocal()).multiply(PMA[6][0] * PAVGM[6]);
                this.meso_tgn3[1] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.glob7s(PMA[7]).multiply(this.this$0.sw[22])).add(1.0)).multiply(PMA[7][0] * PAVGM[7])).multiply(this.meso_tn3[4])).multiply(this.meso_tn3[4])).divide(q * q);
            }
            T dmc = alt.getReal() > 62.5 ? (RealFieldElement)((RealFieldElement)((RealFieldElement)alt.subtract(ZN2[0])).divide(ZN2[0] - 62.5)).add(1.0) : this.zero;
            T dz28 = this.getDensity(2);
            RealFieldElement dm28m = (RealFieldElement)this.dm28.multiply(1000000.0);
            RealFieldElement dmr = (RealFieldElement)((RealFieldElement)dz28.divide((Object)dm28m)).subtract(1.0);
            RealFieldElement dst = (RealFieldElement)this.densm(alt, dm28m, PDM[2][4]).multiply(((RealFieldElement)dmr.multiply(dmc)).add(1.0));
            this.setDensity(2, dst);
            dmr = (RealFieldElement)((RealFieldElement)this.getDensity(0).divide(dz28.multiply(PDM[0][1]))).subtract(1.0);
            dst = (RealFieldElement)((RealFieldElement)this.getDensity(2).multiply(PDM[0][1])).multiply(((RealFieldElement)dmr.multiply(dmc)).add(1.0));
            this.setDensity(0, dst);
            this.setDensity(1, this.zero);
            this.setDensity(8, this.zero);
            dmr = (RealFieldElement)((RealFieldElement)this.getDensity(3).divide(dz28.multiply(PDM[3][1]))).subtract(1.0);
            dst = (RealFieldElement)((RealFieldElement)this.getDensity(2).multiply(PDM[3][1])).multiply(((RealFieldElement)dmr.multiply(dmc)).add(1.0));
            this.setDensity(3, dst);
            dmr = (RealFieldElement)((RealFieldElement)this.getDensity(4).divide(dz28.multiply(PDM[4][1]))).subtract(1.0);
            dst = (RealFieldElement)((RealFieldElement)this.getDensity(2).multiply(PDM[4][1])).multiply(((RealFieldElement)dmr.multiply(dmc)).add(1.0));
            this.setDensity(4, dst);
            this.setDensity(6, this.zero);
            this.setDensity(7, this.zero);
            RealFieldElement tmd = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.getDensity(0).multiply(4.0)).add(this.getDensity(1).multiply(16.0))).add(this.getDensity(2).multiply(28.0))).add(this.getDensity(3).multiply(32.0))).add(this.getDensity(4).multiply(40.0))).add(this.getDensity(6).multiply(1.0))).add(this.getDensity(7).multiply(14.0))).multiply(1.66E-27);
            this.setDensity(5, tmd);
            this.setTemperature(1, this.densm(alt, (RealFieldElement)this.field.getOne(), 0.0));
        }

        void gtd7d(T alt) {
            this.gtd7(alt);
            RealFieldElement dTot = (RealFieldElement)this.getDensity(5).add(this.getDensity(8).multiply(2.656E-26));
            this.setDensity(5, dTot);
        }

        void setDensity(int index, T d) {
            this.densities[index] = d;
        }

        void setTemperature(int index, T t) {
            this.temperatures[index] = t;
        }

        public T getDensity(int index) {
            return this.densities[index];
        }

        private T globe7(double[] p) {
            RealFieldElement[] t = (RealFieldElement[])MathArrays.buildArray(this.field, (int)14);
            double cd32 = FastMath.cos((double)(0.0172142 * ((double)this.doy - p[31])));
            double cd18 = FastMath.cos((double)(0.0344284 * ((double)this.doy - p[17])));
            double cd14 = FastMath.cos((double)(0.0172142 * ((double)this.doy - p[13])));
            double cd39 = FastMath.cos((double)(0.0344284 * ((double)this.doy - p[38])));
            double df = this.f107 - this.f107a;
            double dfa = this.f107a - 150.0;
            t[0] = (RealFieldElement)this.zero.add(p[19] * df * (1.0 + p[59] * dfa) + p[20] * df * df + p[21] * dfa + p[29] * dfa * dfa);
            double f1 = 1.0 + (p[47] * dfa + p[19] * df + p[20] * df * df) * (double)this.this$0.swc[1];
            double f2 = 1.0 + (p[49] * dfa + p[19] * df + p[20] * df * df) * (double)this.this$0.swc[1];
            t[1] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.plg[0][2].multiply(p[1])).add(this.plg[0][4].multiply(p[2]))).add(this.plg[0][6].multiply(p[22]))).add(this.plg[0][2].multiply(p[14] * dfa * (double)this.this$0.swc[1]))).add(this.plg[0][1].multiply(p[26]));
            t[2] = (RealFieldElement)this.zero.add(p[18] * cd32);
            t[3] = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.plg[0][2].multiply(p[16])).add(p[15])).multiply(cd18);
            t[4] = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.plg[0][1].multiply(p[9])).add(this.plg[0][3].multiply(p[10]))).multiply(f1 * cd14);
            t[5] = (RealFieldElement)this.plg[0][1].multiply(p[37] * cd39);
            if (this.this$0.sw[7] != 0) {
                RealFieldElement t71 = (RealFieldElement)this.plg[1][2].multiply(p[11] * cd14 * (double)this.this$0.swc[5]);
                RealFieldElement t72 = (RealFieldElement)this.plg[1][2].multiply(p[12] * cd14 * (double)this.this$0.swc[5]);
                t[6] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.plg[1][1].multiply(p[3])).add(this.plg[1][3].multiply(p[4]))).add(this.plg[1][5].multiply(p[27]))).add((Object)t71)).multiply(this.ctloc)).add(((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.plg[1][1].multiply(p[6])).add(this.plg[1][3].multiply(p[7]))).add(this.plg[1][5].multiply(p[28]))).add((Object)t72)).multiply(this.stloc))).multiply(f2);
            }
            if (this.this$0.sw[8] != 0) {
                RealFieldElement t81 = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.plg[2][3].multiply(p[23])).add(this.plg[2][5].multiply(p[35]))).multiply(cd14 * (double)this.this$0.swc[5]);
                RealFieldElement t82 = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.plg[2][3].multiply(p[33])).add(this.plg[2][5].multiply(p[36]))).multiply(cd14 * (double)this.this$0.swc[5]);
                t[7] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.plg[2][2].multiply(p[5])).add(this.plg[2][4].multiply(p[41]))).add((Object)t81)).multiply(this.c2tloc)).add(((RealFieldElement)((RealFieldElement)((RealFieldElement)this.plg[2][2].multiply(p[8])).add(this.plg[2][4].multiply(p[42]))).add((Object)t82)).multiply(this.s2tloc))).multiply(f2);
            }
            if (this.this$0.sw[14] != 0) {
                t[13] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.plg[3][3].multiply(p[39])).add(((RealFieldElement)((RealFieldElement)this.plg[3][4].multiply(p[93])).add(this.plg[3][6].multiply(p[46]))).multiply(cd14 * (double)this.this$0.swc[5]))).multiply(this.s3tloc)).add(((RealFieldElement)((RealFieldElement)this.plg[3][3].multiply(p[40])).add(((RealFieldElement)((RealFieldElement)this.plg[3][4].multiply(p[94])).add(this.plg[3][6].multiply(p[48]))).multiply(cd14 * (double)this.this$0.swc[5]))).multiply(this.c3tloc))).multiply(f2);
            }
            if (this.this$0.sw[9] == -1) {
                if (p[51] != 0.0) {
                    RealFieldElement exp1 = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.lat.abs()).negate()).add(45.0)).multiply(p[138])).add(1.0)).reciprocal()).multiply(-10800.0 * FastMath.abs((double)p[51]))).exp();
                    double p24 = FastMath.max((double)p[24], (double)1.0E-4);
                    this.apt = this.sg0(this.min(0.99999, exp1), p24, p[25]);
                    t[8] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.plg[0][2].multiply(p[96])).add(this.plg[0][4].multiply(p[54]))).add(p[50])).add(((RealFieldElement)((RealFieldElement)((RealFieldElement)this.plg[0][1].multiply(p[125])).add(this.plg[0][3].multiply(p[126]))).add(this.plg[0][5].multiply(p[127]))).multiply(cd14 * (double)this.this$0.swc[5]))).add(((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.plg[1][1].multiply(p[128])).add(this.plg[1][3].multiply(p[129]))).add(this.plg[1][5].multiply(p[130]))).multiply(this.this$0.swc[7])).multiply(((RealFieldElement)((RealFieldElement)this.hl.subtract(p[131])).multiply(0.2618)).cos()))).multiply(this.apt);
                }
            } else {
                double apd = this.ap[0] - 4.0;
                double p44 = p[43] < 0.0 ? 1.0E-5 : p[43];
                double p45 = p[44];
                this.apdf = apd + (p45 - 1.0) * (apd + (FastMath.exp((double)(-p44 * apd)) - 1.0) / p44);
                if (this.this$0.sw[9] != 0) {
                    t[8] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.plg[0][2].multiply(p[45])).add(this.plg[0][4].multiply(p[34]))).add(p[32])).add(((RealFieldElement)((RealFieldElement)((RealFieldElement)this.plg[0][1].multiply(p[100])).add(this.plg[0][3].multiply(p[101]))).add(this.plg[0][5].multiply(p[102]))).multiply(cd14 * (double)this.this$0.swc[5]))).add(((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.plg[1][1].multiply(p[121])).add(this.plg[1][3].multiply(p[122]))).add(this.plg[1][5].multiply(p[123]))).multiply(this.this$0.swc[7])).multiply(((RealFieldElement)((RealFieldElement)this.hl.subtract(p[124])).multiply(0.2618)).cos()))).multiply(this.apdf);
                }
            }
            if (this.this$0.sw[10] != 0) {
                RealFieldElement lonr = (RealFieldElement)this.lon.multiply(0.0174533);
                if (this.this$0.sw[11] != 0) {
                    t[10] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.plg[1][2].multiply(p[64])).add(this.plg[1][4].multiply(p[65]))).add(this.plg[1][6].multiply(p[66]))).add(this.plg[1][1].multiply(p[103]))).add(this.plg[1][3].multiply(p[104]))).add(this.plg[1][5].multiply(p[105]))).add(((RealFieldElement)((RealFieldElement)((RealFieldElement)this.plg[1][1].multiply(p[109])).add(this.plg[1][3].multiply(p[110]))).add(this.plg[1][5].multiply(p[111]))).multiply((double)this.this$0.swc[5] * cd14))).multiply(lonr.cos())).add(((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.plg[1][2].multiply(p[90])).add(this.plg[1][4].multiply(p[91]))).add(this.plg[1][6].multiply(p[92]))).add(this.plg[1][1].multiply(p[106]))).add(this.plg[1][3].multiply(p[107]))).add(this.plg[1][5].multiply(p[108]))).add(((RealFieldElement)((RealFieldElement)((RealFieldElement)this.plg[1][1].multiply(p[112])).add(this.plg[1][3].multiply(p[113]))).add(this.plg[1][5].multiply(p[114]))).multiply((double)this.this$0.swc[5] * cd14))).multiply(lonr.sin()))).multiply(1.0 + p[80] * dfa * (double)this.this$0.swc[1]);
                }
                if (this.this$0.sw[12] != 0) {
                    t[11] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.plg[0][1].multiply(p[95])).add(1.0)).multiply(1.0 + p[81] * dfa * (double)this.this$0.swc[1])).multiply(((RealFieldElement)this.plg[0][1].multiply(p[119] * (double)this.this$0.swc[5] * cd14)).add(1.0))).multiply(((RealFieldElement)((RealFieldElement)this.plg[0][1].multiply(p[68])).add(this.plg[0][3].multiply(p[69]))).add(this.plg[0][5].multiply(p[70])))).multiply(((RealFieldElement)((RealFieldElement)this.sec.subtract(p[71])).multiply(7.2722E-5)).cos());
                    t[11] = (RealFieldElement)t[11].add(((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.plg[2][3].multiply(p[76])).add(this.plg[2][5].multiply(p[77]))).add(this.plg[2][7].multiply(p[78]))).multiply((double)this.this$0.swc[11] * (1.0 + p[137] * dfa * (double)this.this$0.swc[1]))).multiply(((RealFieldElement)((RealFieldElement)((RealFieldElement)this.sec.subtract(p[79])).multiply(7.2722E-5)).add(lonr.multiply(2))).cos()));
                }
                if (this.this$0.sw[13] != 0) {
                    if (this.this$0.sw[9] == -1) {
                        if (p[51] != 0.0) {
                            t[12] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.apt.multiply(this.this$0.swc[11])).multiply(((RealFieldElement)this.plg[0][1].multiply(p[132])).add(1.0))).multiply(((RealFieldElement)((RealFieldElement)this.plg[1][2].multiply(p[52])).add(this.plg[1][4].multiply(p[98]))).add(this.plg[1][6].multiply(p[67])))).multiply(((RealFieldElement)((RealFieldElement)this.lon.subtract(p[97])).multiply(0.0174533)).cos())).add(((RealFieldElement)((RealFieldElement)this.apt.multiply((double)(this.this$0.swc[11] * this.this$0.swc[5]) * cd14)).multiply(((RealFieldElement)((RealFieldElement)this.plg[1][1].multiply(p[133])).add(this.plg[1][3].multiply(p[134]))).add(this.plg[1][5].multiply(p[135])))).multiply(((RealFieldElement)((RealFieldElement)this.lon.subtract(p[136])).multiply(0.0174533)).cos()))).add(((RealFieldElement)((RealFieldElement)this.apt.multiply(this.this$0.swc[12])).multiply(((RealFieldElement)((RealFieldElement)this.plg[0][1].multiply(p[55])).add(this.plg[0][3].multiply(p[56]))).add(this.plg[0][5].multiply(p[57])))).multiply(((RealFieldElement)((RealFieldElement)this.sec.subtract(p[58])).multiply(7.2722E-5)).cos()));
                        }
                    } else {
                        t[12] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.plg[0][1].multiply(p[120])).add(1.0)).multiply(this.apdf * (double)this.this$0.swc[11])).multiply(((RealFieldElement)((RealFieldElement)this.plg[1][2].multiply(p[60])).add(this.plg[1][4].multiply(p[61]))).add(this.plg[1][6].multiply(p[62])))).multiply(((RealFieldElement)((RealFieldElement)this.lon.subtract(p[63])).multiply(0.0174533)).cos())).add(((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.plg[1][1].multiply(p[115])).add(this.plg[1][3].multiply(p[116]))).add(this.plg[1][5].multiply(p[117]))).multiply(this.apdf * (double)this.this$0.swc[11] * (double)this.this$0.swc[5] * cd14)).multiply(((RealFieldElement)((RealFieldElement)this.lon.subtract(p[118])).multiply(0.0174533)).cos()))).add(((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.plg[0][1].multiply(p[83])).add(this.plg[0][3].multiply(p[84]))).add(this.plg[0][5].multiply(p[85]))).multiply(this.apdf * (double)this.this$0.swc[12])).multiply(((RealFieldElement)((RealFieldElement)this.sec.subtract(p[75])).multiply(7.2722E-5)).cos()));
                    }
                }
            }
            RealFieldElement tinf = (RealFieldElement)this.zero.add(p[30]);
            for (int i = 0; i < 14; ++i) {
                tinf = (RealFieldElement)tinf.add(t[i].multiply(FastMath.abs((int)this.this$0.sw[i + 1])));
            }
            return (T)tinf;
        }

        private T glob7s(double[] p) {
            RealFieldElement[] t = (RealFieldElement[])MathArrays.buildArray(this.field, (int)14);
            double cd32 = FastMath.cos((double)(0.0172142 * ((double)this.doy - p[31])));
            double cd18 = FastMath.cos((double)(0.0344284 * ((double)this.doy - p[17])));
            double cd14 = FastMath.cos((double)(0.0172142 * ((double)this.doy - p[13])));
            double cd39 = FastMath.cos((double)(0.0344284 * ((double)this.doy - p[38])));
            t[0] = (RealFieldElement)this.zero.add(p[21] * (this.f107a - 150.0));
            t[1] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.plg[0][2].multiply(p[1])).add(this.plg[0][4].multiply(p[2]))).add(this.plg[0][6].multiply(p[22]))).add(this.plg[0][1].multiply(p[26]))).add(this.plg[0][3].multiply(p[14]))).add(this.plg[0][5].multiply(p[59]));
            t[2] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.plg[0][2].multiply(p[47])).add(this.plg[0][4].multiply(p[29]))).add(p[18])).multiply(cd32);
            t[3] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.plg[0][2].multiply(p[16])).add(this.plg[0][4].multiply(p[30]))).add(p[15])).multiply(cd18);
            t[4] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.plg[0][1].multiply(p[9])).add(this.plg[0][3].multiply(p[10]))).add(this.plg[0][5].multiply(p[20]))).multiply(cd14);
            t[5] = (RealFieldElement)((RealFieldElement)this.plg[0][1].multiply(p[37])).multiply(cd39);
            if (this.this$0.sw[7] != 0) {
                RealFieldElement t71 = (RealFieldElement)((RealFieldElement)this.plg[1][2].multiply(p[11])).multiply(cd14 * (double)this.this$0.swc[5]);
                RealFieldElement t72 = (RealFieldElement)((RealFieldElement)this.plg[1][2].multiply(p[12])).multiply(cd14 * (double)this.this$0.swc[5]);
                t[6] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.plg[1][1].multiply(p[3])).add(this.plg[1][3].multiply(p[4]))).add((Object)t71)).multiply(this.ctloc)).add(((RealFieldElement)((RealFieldElement)((RealFieldElement)this.plg[1][1].multiply(p[6])).add(this.plg[1][3].multiply(p[7]))).add((Object)t72)).multiply(this.stloc));
            }
            if (this.this$0.sw[8] != 0) {
                RealFieldElement t81 = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.plg[2][3].multiply(p[23])).add(this.plg[2][5].multiply(p[35]))).multiply(cd14 * (double)this.this$0.swc[5]);
                RealFieldElement t82 = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.plg[2][3].multiply(p[33])).add(this.plg[2][5].multiply(p[36]))).multiply(cd14 * (double)this.this$0.swc[5]);
                t[7] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.plg[2][2].multiply(p[5])).add(this.plg[2][4].multiply(p[41]))).add((Object)t81)).multiply(this.c2tloc)).add(((RealFieldElement)((RealFieldElement)((RealFieldElement)this.plg[2][2].multiply(p[8])).add(this.plg[2][4].multiply(p[42]))).add((Object)t82)).multiply(this.s2tloc));
            }
            if (this.this$0.sw[14] != 0) {
                t[13] = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.plg[3][3].multiply(p[39])).multiply(this.s3tloc)).add(((RealFieldElement)this.plg[3][3].multiply(p[40])).multiply(this.c3tloc));
            }
            if (this.this$0.sw[9] == 1) {
                t[8] = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.plg[0][2].multiply(p[45] * (double)this.this$0.swc[2])).add(p[32])).multiply(this.apdf);
            } else if (this.this$0.sw[9] == -1) {
                t[8] = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.plg[0][2].multiply(p[96] * (double)this.this$0.swc[2])).add(p[50])).multiply(this.apt);
            }
            if (this.this$0.sw[10] != 0 && this.this$0.sw[11] != 0) {
                RealFieldElement lonr = (RealFieldElement)this.lon.multiply(0.0174533);
                t[10] = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.plg[0][1].multiply(p[80] * (double)this.this$0.swc[5] * FastMath.cos((double)(0.0172142 * ((double)this.doy - p[81]))) + p[85] * (double)this.this$0.swc[6] * FastMath.cos((double)(0.0344284 * ((double)this.doy - p[86]))))).add(1.0 + p[83] * (double)this.this$0.swc[3] * FastMath.cos((double)(0.0172142 * ((double)this.doy - p[84]))) + p[87] * (double)this.this$0.swc[4] * FastMath.cos((double)(0.0344284 * ((double)this.doy - p[88]))))).multiply(((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.plg[1][2].multiply(p[64])).add(this.plg[1][4].multiply(p[65]))).add(this.plg[1][6].multiply(p[66]))).add(this.plg[1][1].multiply(p[74]))).add(this.plg[1][3].multiply(p[75]))).add(this.plg[1][5].multiply(p[76]))).multiply(lonr.cos())).add(((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.plg[1][2].multiply(p[90])).add(this.plg[1][4].multiply(p[91]))).add(this.plg[1][6].multiply(p[92]))).add(this.plg[1][1].multiply(p[77]))).add(this.plg[1][3].multiply(p[78]))).add(this.plg[1][5].multiply(p[79]))).multiply(lonr.sin())));
            }
            Object gl = this.zero;
            for (int i = 0; i < 14; ++i) {
                gl = (RealFieldElement)gl.add(t[i].multiply(FastMath.abs((int)this.this$0.sw[i + 1])));
            }
            return gl;
        }

        private T sg0(T ex, double p24, double p25) {
            double g01 = this.g0(this.ap[1], p24, p25);
            double g02 = this.g0(this.ap[2], p24, p25);
            double g03 = this.g0(this.ap[3], p24, p25);
            double g04 = this.g0(this.ap[4], p24, p25);
            double g05 = this.g0(this.ap[5], p24, p25);
            double g06 = this.g0(this.ap[6], p24, p25);
            RealFieldElement ex2 = (RealFieldElement)ex.multiply(ex);
            RealFieldElement ex3 = (RealFieldElement)ex.multiply((Object)ex2);
            RealFieldElement ex4 = (RealFieldElement)ex2.multiply((Object)ex2);
            RealFieldElement ex8 = (RealFieldElement)ex4.multiply((Object)ex4);
            RealFieldElement ex12 = (RealFieldElement)ex4.multiply((Object)ex8);
            RealFieldElement g234 = (RealFieldElement)((RealFieldElement)((RealFieldElement)ex.multiply(g02)).add(ex2.multiply(g03))).add(ex3.multiply(g04));
            RealFieldElement g56 = (RealFieldElement)((RealFieldElement)ex4.multiply(g05)).add(ex12.multiply(g06));
            RealFieldElement ex19 = (RealFieldElement)((RealFieldElement)ex3.multiply((Object)ex4)).multiply((Object)ex12);
            RealFieldElement omex = (RealFieldElement)((RealFieldElement)ex.negate()).add(1.0);
            RealFieldElement sumex = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)ex19.negate()).add(1.0)).divide((Object)omex)).multiply(ex.sqrt())).add(1.0);
            return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)ex8.negate()).add(1.0)).multiply((Object)g56)).divide((Object)omex)).add((Object)g234)).add(g01)).divide((Object)sumex));
        }

        private double g0(double apI, double p24, double p25) {
            double am4 = apI - 4.0;
            return am4 + (p25 - 1.0) * (am4 + (FastMath.exp((double)(-p24 * am4)) - 1.0) / p24);
        }

        private T ccor(T alt, T r, double h1, double zh) {
            RealFieldElement e = (RealFieldElement)((RealFieldElement)alt.subtract(zh)).divide(h1);
            if (e.getReal() > 70.0) {
                return (T)((RealFieldElement)this.field.getOne());
            }
            if (e.getReal() < -70.0) {
                return (T)((RealFieldElement)r.exp());
            }
            return (T)((RealFieldElement)((RealFieldElement)r.divide(((RealFieldElement)e.exp()).add(1.0))).exp());
        }

        private T ccor2(T alt, double r, double h1, double zh, double h2) {
            RealFieldElement e1 = (RealFieldElement)((RealFieldElement)alt.subtract(zh)).divide(h1);
            RealFieldElement e2 = (RealFieldElement)((RealFieldElement)alt.subtract(zh)).divide(h2);
            if (e1.getReal() > 70.0 || e2.getReal() > 70.0) {
                return (T)((RealFieldElement)this.field.getOne());
            }
            if (e1.getReal() < -70.0 && e2.getReal() < -70.0) {
                return (T)((RealFieldElement)this.zero.add(FastMath.exp((double)r)));
            }
            RealFieldElement ex1 = (RealFieldElement)e1.exp();
            RealFieldElement ex2 = (RealFieldElement)e2.exp();
            return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)ex1.add((Object)ex2)).multiply(0.5)).add(1.0)).reciprocal()).multiply(r)).exp());
        }

        private T scalh(double alt, double xm, double temp) {
            RealFieldElement denom = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.rlat.reciprocal()).multiply(alt)).add(1.0);
            RealFieldElement galt = (RealFieldElement)this.glat.divide(denom.multiply((Object)denom));
            return (T)((RealFieldElement)((RealFieldElement)galt.reciprocal()).multiply(831.4 * temp / xm));
        }

        private T dnet(T dd, T dm, double zhm, double xmm, double xm) {
            if (!(dm.getReal() > 0.0) || !(dd.getReal() > 0.0)) {
                Object ddd = dd;
                if (dd.getReal() == 0.0 && dm.getReal() == 0.0) {
                    ddd = (RealFieldElement)this.field.getOne();
                }
                if (dm.getReal() == 0.0) {
                    return ddd;
                }
                if (dd.getReal() == 0.0) {
                    return dm;
                }
            }
            double a = zhm / (xmm - xm);
            RealFieldElement ylog = (RealFieldElement)((RealFieldElement)((RealFieldElement)dm.divide(dd)).log()).multiply(a);
            if (ylog.getReal() < -10.0) {
                return dd;
            }
            if (ylog.getReal() > 10.0) {
                return dm;
            }
            return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)ylog.exp()).add(1.0)).pow(1.0 / a)).multiply(dd));
        }

        private T splini(T[] xa, T[] ya, T[] y2a, T x) {
            int n = xa.length;
            Object yi = this.zero;
            int klo = 0;
            for (int khi = 1; x.getReal() > xa[klo].getReal() && khi < n; ++khi) {
                T xx = x;
                if (khi < n - 1) {
                    xx = x.getReal() < xa[khi].getReal() ? x : xa[khi];
                }
                RealFieldElement h = (RealFieldElement)xa[khi].subtract(xa[klo]);
                RealFieldElement a = (RealFieldElement)((RealFieldElement)xa[khi].subtract(xx)).divide((Object)h);
                RealFieldElement b = (RealFieldElement)((RealFieldElement)xx.subtract(xa[klo])).divide((Object)h);
                RealFieldElement a2 = (RealFieldElement)a.multiply((Object)a);
                RealFieldElement b2 = (RealFieldElement)b.multiply((Object)b);
                RealFieldElement z = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)a2.divide(2.0)).subtract(((RealFieldElement)((RealFieldElement)a2.multiply((Object)a2)).add(1.0)).divide(4.0))).multiply(y2a[klo])).add(((RealFieldElement)((RealFieldElement)((RealFieldElement)b2.multiply((Object)b2)).divide(4.0)).subtract(b2.divide(2.0))).multiply(y2a[khi]));
                yi = (RealFieldElement)yi.add(((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)a2.negate()).add(1.0)).multiply(ya[klo])).divide(2.0)).add(((RealFieldElement)b2.multiply(ya[khi])).divide(2.0))).add(((RealFieldElement)((RealFieldElement)z.multiply((Object)h)).multiply((Object)h)).divide(6.0))).multiply((Object)h));
                ++klo;
            }
            return yi;
        }

        private T splint(T[] xa, T[] ya, T[] y2a, T x) {
            int n = xa.length;
            int klo = 0;
            int khi = n - 1;
            while (khi - klo > 1) {
                int k = khi + klo >>> 1;
                if (xa[k].getReal() > x.getReal()) {
                    khi = k;
                    continue;
                }
                klo = k;
            }
            RealFieldElement h = (RealFieldElement)xa[khi].subtract(xa[klo]);
            RealFieldElement a = (RealFieldElement)((RealFieldElement)xa[khi].subtract(x)).divide((Object)h);
            RealFieldElement b = (RealFieldElement)((RealFieldElement)x.subtract(xa[klo])).divide((Object)h);
            return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)a.multiply(ya[klo])).add(b.multiply(ya[khi]))).add(((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)a.multiply((Object)a)).multiply((Object)a)).subtract((Object)a)).multiply(y2a[klo])).add(((RealFieldElement)((RealFieldElement)((RealFieldElement)b.multiply((Object)b)).multiply((Object)b)).subtract((Object)b)).multiply(y2a[khi]))).multiply((Object)h)).multiply((Object)h)).divide(6.0)));
        }

        private T[] spline(T[] x, T[] y, T yp1, T ypn) {
            int n = x.length;
            RealFieldElement[] y2 = (RealFieldElement[])MathArrays.buildArray(this.field, (int)n);
            RealFieldElement[] u = (RealFieldElement[])MathArrays.buildArray(this.field, (int)n);
            if (yp1.getReal() < 1.0E30) {
                y2[0] = (RealFieldElement)this.zero.add(-0.5);
                RealFieldElement dx = (RealFieldElement)x[1].subtract(x[0]);
                RealFieldElement dy = (RealFieldElement)y[1].subtract(y[0]);
                u[0] = (RealFieldElement)((RealFieldElement)((RealFieldElement)dx.reciprocal()).multiply(3.0)).multiply(((RealFieldElement)dy.divide((Object)dx)).subtract(yp1));
            }
            for (int i = 1; i < n - 1; ++i) {
                RealFieldElement dx0m = (RealFieldElement)x[i].subtract(x[i - 1]);
                RealFieldElement dy0m = (RealFieldElement)y[i].subtract(y[i - 1]);
                RealFieldElement dxpm = (RealFieldElement)x[i + 1].subtract(x[i - 1]);
                RealFieldElement dxp0 = (RealFieldElement)x[i + 1].subtract(x[i]);
                RealFieldElement dyp0 = (RealFieldElement)y[i + 1].subtract(y[i]);
                RealFieldElement sig = (RealFieldElement)dx0m.divide((Object)dxpm);
                RealFieldElement p = (RealFieldElement)((RealFieldElement)sig.multiply((Object)y2[i - 1])).add(2.0);
                y2[i] = (RealFieldElement)((RealFieldElement)sig.subtract(1.0)).divide((Object)p);
                u[i] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)dyp0.divide((Object)dxp0)).subtract(dy0m.divide((Object)dx0m))).multiply(6)).divide((Object)dxpm)).subtract(sig.multiply((Object)u[i - 1]))).divide((Object)p);
            }
            double qn = 0.0;
            Object un = this.zero;
            if (ypn.getReal() < 1.0E30) {
                RealFieldElement dx12 = (RealFieldElement)x[n - 1].subtract(x[n - 2]);
                RealFieldElement dy12 = (RealFieldElement)y[n - 1].subtract(y[n - 2]);
                qn = 0.5;
                un = (RealFieldElement)((RealFieldElement)((RealFieldElement)dx12.reciprocal()).multiply(3.0)).multiply(ypn.subtract(dy12.divide((Object)dx12)));
            }
            y2[n - 1] = (RealFieldElement)((RealFieldElement)un.subtract(u[n - 2].multiply(qn))).divide(((RealFieldElement)y2[n - 2].multiply(qn)).add(1.0));
            for (int k = n - 2; k >= 0; --k) {
                y2[k] = (RealFieldElement)((RealFieldElement)y2[k].multiply((Object)y2[k + 1])).add((Object)u[k]);
            }
            return y2;
        }

        private T densm(T alt, T d0, double xm) {
            Object densm = d0;
            int mn = ZN2.length;
            T z = alt.getReal() > ZN2[mn - 1] ? alt : (RealFieldElement)this.zero.add(ZN2[mn - 1]);
            double z1 = ZN2[0];
            double z2 = ZN2[mn - 1];
            T t1 = this.meso_tn2[0];
            T t2 = this.meso_tn2[mn - 1];
            T zg = this.zeta(z, z1);
            RealFieldElement zgdif = this.zeta((RealFieldElement)this.zero.add(z2), z1);
            RealFieldElement[] xs = (RealFieldElement[])MathArrays.buildArray(this.field, (int)mn);
            RealFieldElement[] ys = (RealFieldElement[])MathArrays.buildArray(this.field, (int)mn);
            for (int k = 0; k < mn; ++k) {
                xs[k] = (RealFieldElement)this.zeta((RealFieldElement)this.zero.add(ZN2[k]), z1).divide((Object)zgdif);
                ys[k] = (RealFieldElement)this.meso_tn2[k].reciprocal();
            }
            RealFieldElement qSM = (RealFieldElement)((RealFieldElement)this.rlat.add(z2)).divide(this.rlat.add(z1));
            RealFieldElement yd1 = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.meso_tgn2[0].negate()).divide(t1.multiply(t1))).multiply((Object)zgdif);
            RealFieldElement yd2 = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.meso_tgn2[1].negate()).divide(t2.multiply(t2))).multiply((Object)zgdif)).multiply((Object)qSM)).multiply((Object)qSM);
            RealFieldElement[] y2out = this.spline(xs, ys, yd1, yd2);
            RealFieldElement x = (RealFieldElement)zg.divide((Object)zgdif);
            RealFieldElement y = this.splint(xs, ys, y2out, x);
            RealFieldElement tz = (RealFieldElement)y.reciprocal();
            if (xm != 0.0) {
                RealFieldElement glb = this.galt((RealFieldElement)this.zero.add(z1));
                RealFieldElement gamm = (RealFieldElement)((RealFieldElement)glb.multiply((Object)zgdif)).multiply(xm / 831.4);
                RealFieldElement yi = this.splini(xs, ys, y2out, x);
                RealFieldElement expl = this.min(50.0, (RealFieldElement)gamm.multiply((Object)yi));
                densm = (RealFieldElement)densm.multiply(((RealFieldElement)t1.divide((Object)tz)).multiply(((RealFieldElement)expl.negate()).exp()));
            }
            if (alt.getReal() > ZN3[0]) {
                return (T)(xm == 0.0 ? tz : densm);
            }
            z = alt;
            mn = ZN3.length;
            z1 = ZN3[0];
            z2 = ZN3[mn - 1];
            t1 = this.meso_tn3[0];
            t2 = this.meso_tn3[mn - 1];
            zg = this.zeta(z, z1);
            zgdif = this.zeta((RealFieldElement)this.zero.add(z2), z1);
            xs = (RealFieldElement[])MathArrays.buildArray(this.field, (int)mn);
            ys = (RealFieldElement[])MathArrays.buildArray(this.field, (int)mn);
            for (int k = 0; k < mn; ++k) {
                xs[k] = (RealFieldElement)this.zeta((RealFieldElement)this.zero.add(ZN3[k]), z1).divide((Object)zgdif);
                ys[k] = (RealFieldElement)this.meso_tn3[k].reciprocal();
            }
            RealFieldElement qTS = (RealFieldElement)((RealFieldElement)this.rlat.add(z2)).divide(this.rlat.add(z1));
            yd1 = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.meso_tgn3[0].negate()).divide(t1.multiply(t1))).multiply((Object)zgdif);
            yd2 = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.meso_tgn3[1].negate()).divide(t2.multiply(t2))).multiply((Object)zgdif)).multiply((Object)qTS)).multiply((Object)qTS);
            y2out = this.spline(xs, ys, yd1, yd2);
            x = (RealFieldElement)zg.divide((Object)zgdif);
            y = this.splint(xs, ys, y2out, x);
            tz = (RealFieldElement)y.reciprocal();
            if (xm != 0.0) {
                RealFieldElement glb = this.galt((RealFieldElement)this.zero.add(z1));
                RealFieldElement gamm = (RealFieldElement)((RealFieldElement)glb.multiply((Object)zgdif)).multiply(xm / 831.4);
                RealFieldElement yi = this.splini(xs, ys, y2out, x);
                RealFieldElement expl = this.min(50.0, (RealFieldElement)gamm.multiply((Object)yi));
                densm = (RealFieldElement)densm.multiply(((RealFieldElement)t1.divide((Object)tz)).multiply(((RealFieldElement)expl.negate()).exp()));
            }
            return (T)(xm == 0.0 ? tz : densm);
        }

        private T densu(T alt, T dlb, T tinf, T tlb, double xm, double alpha, double zlb, T s2) {
            RealFieldElement tt;
            T z = alt.getReal() > ZN1[0] ? alt : (RealFieldElement)this.zero.add(ZN1[0]);
            T zg2 = this.zeta(z, zlb);
            RealFieldElement ta = tt = (RealFieldElement)tinf.subtract(((RealFieldElement)tinf.subtract(tlb)).multiply(((RealFieldElement)((RealFieldElement)s2.negate()).multiply(zg2)).exp()));
            RealFieldElement tz = tt;
            int mn = ZN1.length;
            RealFieldElement[] xs = (RealFieldElement[])MathArrays.buildArray(this.field, (int)mn);
            RealFieldElement[] ys = (RealFieldElement[])MathArrays.buildArray(this.field, (int)mn);
            Object x = this.zero;
            RealFieldElement[] y2out = (RealFieldElement[])MathArrays.buildArray(this.field, (int)mn);
            Object zgdif = this.zero;
            if (alt.getReal() < ZN1[0]) {
                RealFieldElement p = (RealFieldElement)((RealFieldElement)this.rlat.add(zlb)).divide(this.rlat.add(ZN1[0]));
                RealFieldElement dta = (RealFieldElement)((RealFieldElement)((RealFieldElement)tinf.subtract((Object)ta)).multiply(s2)).multiply(p.multiply((Object)p));
                this.meso_tgn1[0] = dta;
                this.meso_tn1[0] = ta;
                RealFieldElement tzn1mn1 = (RealFieldElement)this.zero.add(ZN1[mn - 1]);
                z = alt.getReal() > ZN1[mn - 1] ? alt : tzn1mn1;
                T t1 = this.meso_tn1[0];
                T t2 = this.meso_tn1[mn - 1];
                T zg = this.zeta(z, ZN1[0]);
                zgdif = this.zeta(tzn1mn1, ZN1[0]);
                for (int k = 0; k < mn; ++k) {
                    xs[k] = (RealFieldElement)this.zeta((RealFieldElement)this.zero.add(ZN1[k]), ZN1[0]).divide(zgdif);
                    ys[k] = (RealFieldElement)this.meso_tn1[k].reciprocal();
                }
                RealFieldElement q = (RealFieldElement)((RealFieldElement)this.rlat.add(ZN1[mn - 1])).divide(this.rlat.add(ZN1[0]));
                RealFieldElement yd1 = (RealFieldElement)((RealFieldElement)((RealFieldElement)this.meso_tgn1[0].negate()).divide(t1.multiply(t1))).multiply(zgdif);
                RealFieldElement yd2 = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)this.meso_tgn1[1].negate()).divide(t2.multiply(t2))).multiply(zgdif)).multiply(q.multiply((Object)q));
                y2out = this.spline(xs, ys, yd1, yd2);
                x = (RealFieldElement)zg.divide(zgdif);
                RealFieldElement y = this.splint(xs, ys, y2out, (RealFieldElement)x);
                tz = (RealFieldElement)y.reciprocal();
            }
            if (xm == 0.0) {
                return (T)tz;
            }
            RealFieldElement glb = this.galt((RealFieldElement)this.zero.add(zlb));
            RealFieldElement gamma = (RealFieldElement)((RealFieldElement)glb.divide(s2.multiply(tinf))).multiply(xm / 831.4);
            RealFieldElement expl = tt.getReal() <= 0.0 ? (RealFieldElement)this.zero.add(50.0) : this.min(50.0, (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)s2.negate()).multiply((Object)gamma)).multiply(zg2)).exp());
            RealFieldElement densu = (RealFieldElement)((RealFieldElement)dlb.multiply(((RealFieldElement)tlb.divide((Object)tt)).pow(gamma.add(alpha + 1.0)))).multiply((Object)expl);
            if (alt.getReal() < ZN1[0]) {
                glb = this.galt((RealFieldElement)this.zero.add(ZN1[0]));
                gamma = (RealFieldElement)((RealFieldElement)glb.multiply(zgdif)).multiply(xm / 831.4);
                expl = tz.getReal() <= 0.0 ? (RealFieldElement)this.zero.add(50.0) : this.min(50.0, (RealFieldElement)gamma.multiply((Object)this.splini(xs, ys, y2out, (RealFieldElement)x)));
                densu = (RealFieldElement)densu.multiply(((RealFieldElement)((RealFieldElement)this.meso_tn1[0].divide((Object)tz)).pow(alpha + 1.0)).multiply(((RealFieldElement)expl.negate()).exp()));
            }
            return (T)densu;
        }

        private T min(double d, T f) {
            return (T)(f.getReal() > d ? (RealFieldElement)this.zero.add(d) : f);
        }

        private T galt(T alt) {
            RealFieldElement r = (RealFieldElement)((RealFieldElement)alt.divide(this.rlat)).add(1.0);
            return (T)((RealFieldElement)this.glat.divide(r.multiply((Object)r)));
        }

        private T zeta(T zz, double zl) {
            return (T)((RealFieldElement)((RealFieldElement)((RealFieldElement)zz.subtract(zl)).multiply(this.rlat.add(zl))).divide(this.rlat.add(zz)));
        }
    }

    private class Output {
        private final int doy;
        private final double sec;
        private final double lat;
        private final double lon;
        private final double hl;
        private final double f107a;
        private final double f107;
        private final double[] ap;
        private final double glat;
        private final double rlat;
        private double dm28;
        private final double[][] plg;
        private final double ctloc;
        private final double stloc;
        private final double c2tloc;
        private final double s2tloc;
        private final double c3tloc;
        private final double s3tloc;
        private double apdf;
        private double apt;
        private final double[] meso_tn1;
        private final double[] meso_tn2;
        private final double[] meso_tn3;
        private final double[] meso_tgn1;
        private final double[] meso_tgn2;
        private final double[] meso_tgn3;
        private final double[] densities;
        private final double[] temperatures;

        Output(int doy, double sec, double lat, double lon, double hl, double f107a, double f107, double[] ap) {
            this.doy = doy;
            this.sec = sec;
            this.lat = lat;
            this.lon = lon;
            this.hl = hl;
            this.f107a = f107a;
            this.f107 = f107;
            this.ap = (double[])ap.clone();
            this.plg = new double[4][8];
            this.meso_tn1 = new double[ZN1.length];
            this.meso_tn2 = new double[ZN2.length];
            this.meso_tn3 = new double[ZN3.length];
            this.meso_tgn1 = new double[2];
            this.meso_tgn2 = new double[2];
            this.meso_tgn3 = new double[2];
            this.densities = new double[9];
            this.temperatures = new double[2];
            double xlat = NRLMSISE00.this.sw[2] == 0 ? 45.0 : lat;
            double c2 = FastMath.cos((double)(0.0349066 * xlat));
            this.glat = 980.616 * (1.0 - 0.0026373 * c2);
            this.rlat = 2.0 * this.glat / (3.085462E-6 + 2.27E-9 * c2) * 1.0E-5;
            double latr = 0.0174533 * lat;
            double c = FastMath.sin((double)latr);
            double s = FastMath.cos((double)latr);
            this.plg[0][1] = c;
            this.plg[0][2] = (3.0 * c * this.plg[0][1] - 1.0) / 2.0;
            this.plg[0][3] = (5.0 * c * this.plg[0][2] - 2.0 * this.plg[0][1]) / 3.0;
            this.plg[0][4] = (7.0 * c * this.plg[0][3] - 3.0 * this.plg[0][2]) / 4.0;
            this.plg[0][5] = (9.0 * c * this.plg[0][4] - 4.0 * this.plg[0][3]) / 5.0;
            this.plg[0][6] = (11.0 * c * this.plg[0][5] - 5.0 * this.plg[0][4]) / 6.0;
            this.plg[1][1] = s;
            this.plg[1][2] = 3.0 * c * this.plg[1][1];
            this.plg[1][3] = (5.0 * c * this.plg[1][2] - 3.0 * this.plg[1][1]) / 2.0;
            this.plg[1][4] = (7.0 * c * this.plg[1][3] - 4.0 * this.plg[1][2]) / 3.0;
            this.plg[1][5] = (9.0 * c * this.plg[1][4] - 5.0 * this.plg[1][3]) / 4.0;
            this.plg[1][6] = (11.0 * c * this.plg[1][5] - 6.0 * this.plg[1][4]) / 5.0;
            this.plg[2][2] = 3.0 * s * this.plg[1][1];
            this.plg[2][3] = 5.0 * c * this.plg[2][2];
            this.plg[2][4] = (7.0 * c * this.plg[2][3] - 5.0 * this.plg[2][2]) / 2.0;
            this.plg[2][5] = (9.0 * c * this.plg[2][4] - 6.0 * this.plg[2][3]) / 3.0;
            this.plg[2][6] = (11.0 * c * this.plg[2][5] - 7.0 * this.plg[2][4]) / 4.0;
            this.plg[2][7] = (13.0 * c * this.plg[2][6] - 8.0 * this.plg[2][5]) / 5.0;
            this.plg[3][3] = 5.0 * s * this.plg[2][2];
            this.plg[3][4] = 7.0 * c * this.plg[3][3];
            this.plg[3][5] = (9.0 * c * this.plg[3][4] - 7.0 * this.plg[3][3]) / 2.0;
            this.plg[3][6] = (11.0 * c * this.plg[3][5] - 8.0 * this.plg[3][4]) / 3.0;
            if (NRLMSISE00.this.sw[7] != 0 || NRLMSISE00.this.sw[8] != 0 || NRLMSISE00.this.sw[14] != 0) {
                double tloc = 0.2618 * hl;
                double tlx2 = tloc + tloc;
                double tlx3 = tloc + tlx2;
                this.stloc = FastMath.sin((double)tloc);
                this.ctloc = FastMath.cos((double)tloc);
                this.s2tloc = FastMath.sin((double)tlx2);
                this.c2tloc = FastMath.cos((double)tlx2);
                this.s3tloc = FastMath.sin((double)tlx3);
                this.c3tloc = FastMath.cos((double)tlx3);
            } else {
                this.stloc = 0.0;
                this.ctloc = 0.0;
                this.s2tloc = 0.0;
                this.c2tloc = 0.0;
                this.s3tloc = 0.0;
                this.c3tloc = 0.0;
            }
        }

        void gts7(double alt) {
            double[] alpha = new double[]{-0.38, 0.0, 0.0, 0.0, 0.17, 0.0, -0.38, 0.0, 0.0};
            double[] altl = new double[]{200.0, 300.0, 160.0, 250.0, 240.0, 450.0, 320.0, 450.0};
            double xmm = PDM[2][4];
            double tinf = PTM[0] * PT[0];
            if (alt > ZN1[0]) {
                tinf *= 1.0 + (double)NRLMSISE00.this.sw[16] * this.globe7(PT);
            }
            this.setTemperature(0, tinf);
            double g0 = PTM[3] * PS[0];
            if (alt > ZN1[4]) {
                g0 *= 1.0 + (double)NRLMSISE00.this.sw[19] * this.globe7(PS);
            }
            double tlb = PTM[1] * PD[3][0];
            double s = g0 / (tinf - (tlb *= 1.0 + (double)NRLMSISE00.this.sw[17] * this.globe7(PD[3])));
            this.meso_tn1[1] = PTM[6] * PTL[0][0];
            this.meso_tn1[2] = PTM[2] * PTL[1][0];
            this.meso_tn1[3] = PTM[7] * PTL[2][0];
            this.meso_tn1[4] = PTM[4] * PTL[3][0];
            this.meso_tgn1[1] = PTM[8] * PMA[8][0];
            if (alt < 300.0) {
                double r = PTM[4] * PTL[3][0];
                this.meso_tn1[1] = this.meso_tn1[1] / (1.0 - (double)NRLMSISE00.this.sw[18] * this.glob7s(PTL[0]));
                this.meso_tn1[2] = this.meso_tn1[2] / (1.0 - (double)NRLMSISE00.this.sw[18] * this.glob7s(PTL[1]));
                this.meso_tn1[3] = this.meso_tn1[3] / (1.0 - (double)NRLMSISE00.this.sw[18] * this.glob7s(PTL[2]));
                this.meso_tn1[4] = this.meso_tn1[4] / (1.0 - (double)(NRLMSISE00.this.sw[18] * NRLMSISE00.this.sw[20]) * this.glob7s(PTL[3]));
                this.meso_tgn1[1] = this.meso_tgn1[1] * (1.0 + (double)(NRLMSISE00.this.sw[18] * NRLMSISE00.this.sw[20]) * this.glob7s(PMA[8]));
                this.meso_tgn1[1] = this.meso_tgn1[1] * (this.meso_tn1[4] * this.meso_tn1[4] / (r * r));
            }
            this.setTemperature(1, this.densu(alt, 1.0, tinf, tlb, 0.0, 0.0, PTM[5], s));
            double g28 = (double)NRLMSISE00.this.sw[21] * this.globe7(PD[2]);
            double db28 = PDM[2][0] * FastMath.exp((double)g28) * PD[2][0];
            double diffusiveDensity = this.densu(alt, db28, tinf, tlb, 28.0, alpha[2], PTM[5], s);
            this.setDensity(2, diffusiveDensity);
            double zhf = PDL[1][24] * (1.0 + (double)NRLMSISE00.this.sw[5] * PDL[0][24] * FastMath.sin((double)(0.0174533 * this.lat)) * FastMath.cos((double)(0.0172142 * ((double)this.doy - PT[13]))));
            double zh28 = PDM[2][2] * zhf;
            double zhm28 = PDM[2][3] * PDL[1][5];
            double b28 = this.densu(zh28, db28, tinf, tlb, 28.0 - xmm, alpha[2] - 1.0, PTM[5], s);
            if (NRLMSISE00.this.sw[15] != 0 && alt <= altl[2]) {
                this.dm28 = this.densu(alt, b28, tinf, tlb, xmm, alpha[2], PTM[5], s);
                this.setDensity(2, this.dnet(diffusiveDensity, this.dm28, zhm28, xmm, 28.0));
            }
            double g4 = (double)NRLMSISE00.this.sw[21] * this.globe7(PD[0]);
            double db04 = PDM[0][0] * FastMath.exp((double)g4) * PD[0][0];
            diffusiveDensity = this.densu(alt, db04, tinf, tlb, 4.0, alpha[0], PTM[5], s);
            this.setDensity(0, diffusiveDensity);
            if (NRLMSISE00.this.sw[15] != 0 && alt < altl[0]) {
                double zh04 = PDM[0][2];
                double b04 = this.densu(zh04, db04, tinf, tlb, 4.0 - xmm, alpha[0] - 1.0, PTM[5], s);
                double dm04 = this.densu(alt, b04, tinf, tlb, xmm, 0.0, PTM[5], s);
                double zhm04 = zhm28;
                diffusiveDensity = this.dnet(diffusiveDensity, dm04, zhm04, xmm, 4.0);
                double rl = FastMath.log((double)(b28 * PDM[0][1] / b04));
                double zc04 = PDM[0][4] * PDL[1][0];
                double hc04 = PDM[0][5] * PDL[1][1];
                this.setDensity(0, diffusiveDensity * this.ccor(alt, rl, hc04, zc04));
            }
            double g16 = (double)NRLMSISE00.this.sw[21] * this.globe7(PD[1]);
            double db16 = PDM[1][0] * FastMath.exp((double)g16) * PD[1][0];
            diffusiveDensity = this.densu(alt, db16, tinf, tlb, 16.0, alpha[1], PTM[5], s);
            this.setDensity(1, diffusiveDensity);
            if (NRLMSISE00.this.sw[15] != 0 && alt < altl[1]) {
                double zh16 = PDM[1][2];
                double b16 = this.densu(zh16, db16, tinf, tlb, 16.0 - xmm, alpha[1] - 1.0, PTM[5], s);
                double dm16 = this.densu(alt, b16, tinf, tlb, xmm, 0.0, PTM[5], s);
                double zhm16 = zhm28;
                diffusiveDensity = this.dnet(diffusiveDensity, dm16, zhm16, xmm, 16.0);
                double rl = PDM[1][1] * PDL[1][16] * (1.0 + (double)NRLMSISE00.this.sw[1] * PDL[0][23] * (this.f107a - 150.0));
                double hc16 = PDM[1][5] * PDL[1][3];
                double zc16 = PDM[1][4] * PDL[1][2];
                double hc216 = PDM[1][5] * PDL[1][4];
                double hcc16 = PDM[1][7] * PDL[1][13];
                double zcc16 = PDM[1][6] * PDL[1][12];
                double rc16 = PDM[1][3] * PDL[1][14];
                this.setDensity(1, (diffusiveDensity *= this.ccor2(alt, rl, hc16, zc16, hc216)) * this.ccor(alt, rc16, hcc16, zcc16));
            }
            double g32 = (double)NRLMSISE00.this.sw[21] * this.globe7(PD[4]);
            double db32 = PDM[3][0] * FastMath.exp((double)g32) * PD[4][0];
            diffusiveDensity = this.densu(alt, db32, tinf, tlb, 32.0, alpha[3], PTM[5], s);
            this.setDensity(3, diffusiveDensity);
            if (NRLMSISE00.this.sw[15] != 0) {
                if (alt <= altl[3]) {
                    double zh32 = PDM[3][2];
                    double b32 = this.densu(zh32, db32, tinf, tlb, 32.0 - xmm, alpha[3] - 1.0, PTM[5], s);
                    double dm32 = this.densu(alt, b32, tinf, tlb, xmm, 0.0, PTM[5], s);
                    double zhm32 = zhm28;
                    diffusiveDensity = this.dnet(diffusiveDensity, dm32, zhm32, xmm, 32.0);
                    double rl = FastMath.log((double)(b28 * PDM[3][1] / b32));
                    double hc32 = PDM[3][5] * PDL[1][7];
                    double zc32 = PDM[3][4] * PDL[1][6];
                    diffusiveDensity *= this.ccor(alt, rl, hc32, zc32);
                }
                double hcc32 = PDM[3][7] * PDL[1][22];
                double hcc232 = PDM[3][7] * PDL[0][22];
                double zcc32 = PDM[3][6] * PDL[1][21];
                double rc32 = PDM[3][3] * PDL[1][23] * (1.0 + (double)NRLMSISE00.this.sw[1] * PDL[0][23] * (this.f107a - 150.0));
                this.setDensity(3, diffusiveDensity * this.ccor2(alt, rc32, hcc32, zcc32, hcc232));
            }
            double g40 = (double)NRLMSISE00.this.sw[21] * this.globe7(PD[5]);
            double db40 = PDM[4][0] * FastMath.exp((double)g40) * PD[5][0];
            diffusiveDensity = this.densu(alt, db40, tinf, tlb, 40.0, alpha[4], PTM[5], s);
            this.setDensity(4, diffusiveDensity);
            if (NRLMSISE00.this.sw[15] != 0 && alt <= altl[4]) {
                double zh40 = PDM[4][2];
                double b40 = this.densu(zh40, db40, tinf, tlb, 40.0 - xmm, alpha[4] - 1.0, PTM[5], s);
                double dm40 = this.densu(alt, b40, tinf, tlb, xmm, 0.0, PTM[5], s);
                double zhm40 = zhm28;
                diffusiveDensity = this.dnet(diffusiveDensity, dm40, zhm40, xmm, 40.0);
                double rl = FastMath.log((double)(b28 * PDM[4][1] / b40));
                double hc40 = PDM[4][5] * PDL[1][9];
                double zc40 = PDM[4][4] * PDL[1][8];
                this.setDensity(4, diffusiveDensity * this.ccor(alt, rl, hc40, zc40));
            }
            double g1 = (double)NRLMSISE00.this.sw[21] * this.globe7(PD[6]);
            double db01 = PDM[5][0] * FastMath.exp((double)g1) * PD[6][0];
            diffusiveDensity = this.densu(alt, db01, tinf, tlb, 1.0, alpha[6], PTM[5], s);
            this.setDensity(6, diffusiveDensity);
            if (NRLMSISE00.this.sw[15] != 0 && alt <= altl[6]) {
                double zh01 = PDM[5][2];
                double b01 = this.densu(zh01, db01, tinf, tlb, 1.0 - xmm, alpha[6] - 1.0, PTM[5], s);
                double dm01 = this.densu(alt, b01, tinf, tlb, xmm, 0.0, PTM[5], s);
                double zhm01 = zhm28;
                diffusiveDensity = this.dnet(diffusiveDensity, dm01, zhm01, xmm, 1.0);
                double rl = FastMath.log((double)(b28 * PDM[5][1] * FastMath.sqrt((double)(PDL[1][17] * PDL[1][17])) / b01));
                double hc01 = PDM[5][5] * PDL[1][11];
                double zc01 = PDM[5][4] * PDL[1][10];
                double hcc01 = PDM[5][7] * PDL[1][19];
                double zcc01 = PDM[5][6] * PDL[1][18];
                double rc01 = PDM[5][3] * PDL[1][20];
                this.setDensity(6, (diffusiveDensity *= this.ccor(alt, rl, hc01, zc01)) * this.ccor(alt, rc01, hcc01, zcc01));
            }
            double g14 = (double)NRLMSISE00.this.sw[21] * this.globe7(PD[7]);
            double db14 = PDM[6][0] * FastMath.exp((double)g14) * PD[7][0];
            diffusiveDensity = this.densu(alt, db14, tinf, tlb, 14.0, alpha[7], PTM[5], s);
            this.setDensity(7, diffusiveDensity);
            if (NRLMSISE00.this.sw[15] != 0 && alt <= altl[7]) {
                double zh14 = PDM[6][2];
                double b14 = this.densu(zh14, db14, tinf, tlb, 14.0 - xmm, alpha[7] - 1.0, PTM[5], s);
                double dm14 = this.densu(alt, b14, tinf, tlb, xmm, 0.0, PTM[5], s);
                double zhm14 = zhm28;
                diffusiveDensity = this.dnet(diffusiveDensity, dm14, zhm14, xmm, 14.0);
                double rl = FastMath.log((double)(b28 * PDM[6][1] * PDL[0][2] / b14));
                double hc14 = PDM[6][5] * PDL[0][1];
                double zc14 = PDM[6][4] * PDL[0][0];
                double hcc14 = PDM[6][7] * PDL[0][4];
                double zcc14 = PDM[6][6] * PDL[0][3];
                double rc14 = PDM[6][3] * PDL[0][5];
                this.setDensity(7, (diffusiveDensity *= this.ccor(alt, rl, hc14, zc14)) * this.ccor(alt, rc14, hcc14, zcc14));
            }
            double g16h = (double)NRLMSISE00.this.sw[21] * this.globe7(PD[8]);
            double db16h = PDM[7][0] * FastMath.exp((double)g16h) * PD[8][0];
            double tho = PDM[7][9] * PDL[0][6];
            diffusiveDensity = this.densu(alt, db16h, tho, tho, 16.0, alpha[8], PTM[5], s);
            double zsht = PDM[7][5];
            double zmho = PDM[7][4];
            double zsho = this.scalh(zmho, 16.0, tho);
            this.setDensity(8, diffusiveDensity *= FastMath.exp((double)(-zsht / zsho * (FastMath.exp((double)((zmho - alt) / zsht)) - 1.0))));
            for (int i = 0; i < 9; ++i) {
                this.setDensity(i, this.getDensity(i) * 1000000.0);
            }
            double tmd = 1.66E-27 * (4.0 * this.getDensity(0) + 16.0 * this.getDensity(1) + 28.0 * this.getDensity(2) + 32.0 * this.getDensity(3) + 40.0 * this.getDensity(4) + 1.0 * this.getDensity(6) + 14.0 * this.getDensity(7));
            this.setDensity(5, tmd);
        }

        void gtd7(double alt) {
            double altt = alt > ZN2[0] ? alt : ZN2[0];
            this.gts7(altt);
            if (alt >= ZN2[0]) {
                return;
            }
            double r = PMA[2][0] * PAVGM[2];
            this.meso_tgn2[0] = this.meso_tgn1[1];
            this.meso_tn2[0] = this.meso_tn1[4];
            this.meso_tn2[1] = PMA[0][0] * PAVGM[0] / (1.0 - (double)NRLMSISE00.this.sw[20] * this.glob7s(PMA[0]));
            this.meso_tn2[2] = PMA[1][0] * PAVGM[1] / (1.0 - (double)NRLMSISE00.this.sw[20] * this.glob7s(PMA[1]));
            this.meso_tn2[3] = PMA[2][0] * PAVGM[2] / (1.0 - (double)(NRLMSISE00.this.sw[20] * NRLMSISE00.this.sw[22]) * this.glob7s(PMA[2]));
            this.meso_tgn2[1] = PMA[9][0] * PAVGM[8] * (1.0 + (double)(NRLMSISE00.this.sw[20] * NRLMSISE00.this.sw[22]) * this.glob7s(PMA[9])) * this.meso_tn2[3] * this.meso_tn2[3] / (r * r);
            this.meso_tn3[0] = this.meso_tn2[3];
            if (alt < ZN3[0]) {
                double q = PMA[6][0] * PAVGM[6];
                this.meso_tgn3[0] = this.meso_tgn2[1];
                this.meso_tn3[1] = PMA[3][0] * PAVGM[3] / (1.0 - (double)NRLMSISE00.this.sw[22] * this.glob7s(PMA[3]));
                this.meso_tn3[2] = PMA[4][0] * PAVGM[4] / (1.0 - (double)NRLMSISE00.this.sw[22] * this.glob7s(PMA[4]));
                this.meso_tn3[3] = PMA[5][0] * PAVGM[5] / (1.0 - (double)NRLMSISE00.this.sw[22] * this.glob7s(PMA[5]));
                this.meso_tn3[4] = PMA[6][0] * PAVGM[6] / (1.0 - (double)NRLMSISE00.this.sw[22] * this.glob7s(PMA[6]));
                this.meso_tgn3[1] = PMA[7][0] * PAVGM[7] * (1.0 + (double)NRLMSISE00.this.sw[22] * this.glob7s(PMA[7])) * this.meso_tn3[4] * this.meso_tn3[4] / (q * q);
            }
            double dmc = alt > 62.5 ? 1.0 - (ZN2[0] - alt) / (ZN2[0] - 62.5) : 0.0;
            double dz28 = this.getDensity(2);
            double dm28m = this.dm28 * 1000000.0;
            double dmr = dz28 / dm28m - 1.0;
            double dst = this.densm(alt, dm28m, PDM[2][4]) * (1.0 + dmr * dmc);
            this.setDensity(2, dst);
            dmr = this.getDensity(0) / (dz28 * PDM[0][1]) - 1.0;
            dst = this.getDensity(2) * PDM[0][1] * (1.0 + dmr * dmc);
            this.setDensity(0, dst);
            this.setDensity(1, 0.0);
            this.setDensity(8, 0.0);
            dmr = this.getDensity(3) / (dz28 * PDM[3][1]) - 1.0;
            dst = this.getDensity(2) * PDM[3][1] * (1.0 + dmr * dmc);
            this.setDensity(3, dst);
            dmr = this.getDensity(4) / (dz28 * PDM[4][1]) - 1.0;
            dst = this.getDensity(2) * PDM[4][1] * (1.0 + dmr * dmc);
            this.setDensity(4, dst);
            this.setDensity(6, 0.0);
            this.setDensity(7, 0.0);
            double tmd = 1.66E-27 * (4.0 * this.getDensity(0) + 16.0 * this.getDensity(1) + 28.0 * this.getDensity(2) + 32.0 * this.getDensity(3) + 40.0 * this.getDensity(4) + 1.0 * this.getDensity(6) + 14.0 * this.getDensity(7));
            this.setDensity(5, tmd);
            this.setTemperature(1, this.densm(alt, 1.0, 0.0));
        }

        void gtd7d(double alt) {
            this.gtd7(alt);
            double dTot = this.getDensity(5) + 2.656E-26 * this.getDensity(8);
            this.setDensity(5, dTot);
        }

        void setDensity(int index, double d) {
            this.densities[index] = d;
        }

        void setTemperature(int index, double t) {
            this.temperatures[index] = t;
        }

        public double getDensity(int index) {
            return this.densities[index];
        }

        private double globe7(double[] p) {
            double[] t = new double[14];
            double cd32 = FastMath.cos((double)(0.0172142 * ((double)this.doy - p[31])));
            double cd18 = FastMath.cos((double)(0.0344284 * ((double)this.doy - p[17])));
            double cd14 = FastMath.cos((double)(0.0172142 * ((double)this.doy - p[13])));
            double cd39 = FastMath.cos((double)(0.0344284 * ((double)this.doy - p[38])));
            double df = this.f107 - this.f107a;
            double dfa = this.f107a - 150.0;
            t[0] = p[19] * df * (1.0 + p[59] * dfa) + p[20] * df * df + p[21] * dfa + p[29] * dfa * dfa;
            double f1 = 1.0 + (p[47] * dfa + p[19] * df + p[20] * df * df) * (double)NRLMSISE00.this.swc[1];
            double f2 = 1.0 + (p[49] * dfa + p[19] * df + p[20] * df * df) * (double)NRLMSISE00.this.swc[1];
            t[1] = p[1] * this.plg[0][2] + p[2] * this.plg[0][4] + p[22] * this.plg[0][6] + p[14] * this.plg[0][2] * dfa * (double)NRLMSISE00.this.swc[1] + p[26] * this.plg[0][1];
            t[2] = p[18] * cd32;
            t[3] = (p[15] + p[16] * this.plg[0][2]) * cd18;
            t[4] = f1 * (p[9] * this.plg[0][1] + p[10] * this.plg[0][3]) * cd14;
            t[5] = p[37] * this.plg[0][1] * cd39;
            if (NRLMSISE00.this.sw[7] != 0) {
                double t71 = p[11] * this.plg[1][2] * cd14 * (double)NRLMSISE00.this.swc[5];
                double t72 = p[12] * this.plg[1][2] * cd14 * (double)NRLMSISE00.this.swc[5];
                t[6] = f2 * ((p[3] * this.plg[1][1] + p[4] * this.plg[1][3] + p[27] * this.plg[1][5] + t71) * this.ctloc + (p[6] * this.plg[1][1] + p[7] * this.plg[1][3] + p[28] * this.plg[1][5] + t72) * this.stloc);
            }
            if (NRLMSISE00.this.sw[8] != 0) {
                double t81 = (p[23] * this.plg[2][3] + p[35] * this.plg[2][5]) * cd14 * (double)NRLMSISE00.this.swc[5];
                double t82 = (p[33] * this.plg[2][3] + p[36] * this.plg[2][5]) * cd14 * (double)NRLMSISE00.this.swc[5];
                t[7] = f2 * ((p[5] * this.plg[2][2] + p[41] * this.plg[2][4] + t81) * this.c2tloc + (p[8] * this.plg[2][2] + p[42] * this.plg[2][4] + t82) * this.s2tloc);
            }
            if (NRLMSISE00.this.sw[14] != 0) {
                t[13] = f2 * ((p[39] * this.plg[3][3] + (p[93] * this.plg[3][4] + p[46] * this.plg[3][6]) * cd14 * (double)NRLMSISE00.this.swc[5]) * this.s3tloc + (p[40] * this.plg[3][3] + (p[94] * this.plg[3][4] + p[48] * this.plg[3][6]) * cd14 * (double)NRLMSISE00.this.swc[5]) * this.c3tloc);
            }
            if (NRLMSISE00.this.sw[9] == -1) {
                if (p[51] != 0.0) {
                    double exp1 = FastMath.exp((double)(-10800.0 * FastMath.abs((double)p[51]) / (1.0 + p[138] * (45.0 - FastMath.abs((double)this.lat)))));
                    double p24 = FastMath.max((double)p[24], (double)1.0E-4);
                    this.apt = this.sg0(FastMath.min((double)exp1, (double)0.99999), p24, p[25]);
                    t[8] = this.apt * (p[50] + p[96] * this.plg[0][2] + p[54] * this.plg[0][4] + (p[125] * this.plg[0][1] + p[126] * this.plg[0][3] + p[127] * this.plg[0][5]) * cd14 * (double)NRLMSISE00.this.swc[5] + (p[128] * this.plg[1][1] + p[129] * this.plg[1][3] + p[130] * this.plg[1][5]) * (double)NRLMSISE00.this.swc[7] * FastMath.cos((double)(0.2618 * (this.hl - p[131]))));
                }
            } else {
                double apd = this.ap[0] - 4.0;
                double p44 = p[43] < 0.0 ? 1.0E-5 : p[43];
                double p45 = p[44];
                this.apdf = apd + (p45 - 1.0) * (apd + (FastMath.exp((double)(-p44 * apd)) - 1.0) / p44);
                if (NRLMSISE00.this.sw[9] != 0) {
                    t[8] = this.apdf * (p[32] + p[45] * this.plg[0][2] + p[34] * this.plg[0][4] + (p[100] * this.plg[0][1] + p[101] * this.plg[0][3] + p[102] * this.plg[0][5]) * cd14 * (double)NRLMSISE00.this.swc[5] + (p[121] * this.plg[1][1] + p[122] * this.plg[1][3] + p[123] * this.plg[1][5]) * (double)NRLMSISE00.this.swc[7] * FastMath.cos((double)(0.2618 * (this.hl - p[124]))));
                }
            }
            if (NRLMSISE00.this.sw[10] != 0) {
                double lonr = 0.0174533 * this.lon;
                if (NRLMSISE00.this.sw[11] != 0) {
                    t[10] = (1.0 + p[80] * dfa * (double)NRLMSISE00.this.swc[1]) * ((p[64] * this.plg[1][2] + p[65] * this.plg[1][4] + p[66] * this.plg[1][6] + p[103] * this.plg[1][1] + p[104] * this.plg[1][3] + p[105] * this.plg[1][5] + (p[109] * this.plg[1][1] + p[110] * this.plg[1][3] + p[111] * this.plg[1][5]) * (double)NRLMSISE00.this.swc[5] * cd14) * FastMath.cos((double)lonr) + (p[90] * this.plg[1][2] + p[91] * this.plg[1][4] + p[92] * this.plg[1][6] + p[106] * this.plg[1][1] + p[107] * this.plg[1][3] + p[108] * this.plg[1][5] + (p[112] * this.plg[1][1] + p[113] * this.plg[1][3] + p[114] * this.plg[1][5]) * (double)NRLMSISE00.this.swc[5] * cd14) * FastMath.sin((double)lonr));
                }
                if (NRLMSISE00.this.sw[12] != 0) {
                    t[11] = (1.0 + p[95] * this.plg[0][1]) * (1.0 + p[81] * dfa * (double)NRLMSISE00.this.swc[1]) * (1.0 + p[119] * this.plg[0][1] * (double)NRLMSISE00.this.swc[5] * cd14) * (p[68] * this.plg[0][1] + p[69] * this.plg[0][3] + p[70] * this.plg[0][5]) * FastMath.cos((double)(7.2722E-5 * (this.sec - p[71])));
                    t[11] = t[11] + (double)NRLMSISE00.this.swc[11] * (1.0 + p[137] * dfa * (double)NRLMSISE00.this.swc[1]) * (p[76] * this.plg[2][3] + p[77] * this.plg[2][5] + p[78] * this.plg[2][7]) * FastMath.cos((double)(7.2722E-5 * (this.sec - p[79]) + 2.0 * lonr));
                }
                if (NRLMSISE00.this.sw[13] != 0) {
                    if (NRLMSISE00.this.sw[9] == -1) {
                        if (p[51] != 0.0) {
                            t[12] = this.apt * (double)NRLMSISE00.this.swc[11] * (1.0 + p[132] * this.plg[0][1]) * (p[52] * this.plg[1][2] + p[98] * this.plg[1][4] + p[67] * this.plg[1][6]) * FastMath.cos((double)(0.0174533 * (this.lon - p[97]))) + this.apt * (double)NRLMSISE00.this.swc[11] * (double)NRLMSISE00.this.swc[5] * cd14 * (p[133] * this.plg[1][1] + p[134] * this.plg[1][3] + p[135] * this.plg[1][5]) * FastMath.cos((double)(0.0174533 * (this.lon - p[136]))) + this.apt * (double)NRLMSISE00.this.swc[12] * (p[55] * this.plg[0][1] + p[56] * this.plg[0][3] + p[57] * this.plg[0][5]) * FastMath.cos((double)(7.2722E-5 * (this.sec - p[58])));
                        }
                    } else {
                        t[12] = this.apdf * (double)NRLMSISE00.this.swc[11] * (1.0 + p[120] * this.plg[0][1]) * ((p[60] * this.plg[1][2] + p[61] * this.plg[1][4] + p[62] * this.plg[1][6]) * FastMath.cos((double)(0.0174533 * (this.lon - p[63])))) + this.apdf * (double)NRLMSISE00.this.swc[11] * (double)NRLMSISE00.this.swc[5] * cd14 * (p[115] * this.plg[1][1] + p[116] * this.plg[1][3] + p[117] * this.plg[1][5]) * FastMath.cos((double)(0.0174533 * (this.lon - p[118]))) + this.apdf * (double)NRLMSISE00.this.swc[12] * (p[83] * this.plg[0][1] + p[84] * this.plg[0][3] + p[85] * this.plg[0][5]) * FastMath.cos((double)(7.2722E-5 * (this.sec - p[75])));
                    }
                }
            }
            double tinf = p[30];
            for (int i = 0; i < 14; ++i) {
                tinf += (double)FastMath.abs((int)NRLMSISE00.this.sw[i + 1]) * t[i];
            }
            return tinf;
        }

        private double glob7s(double[] p) {
            double[] t = new double[14];
            double cd32 = FastMath.cos((double)(0.0172142 * ((double)this.doy - p[31])));
            double cd18 = FastMath.cos((double)(0.0344284 * ((double)this.doy - p[17])));
            double cd14 = FastMath.cos((double)(0.0172142 * ((double)this.doy - p[13])));
            double cd39 = FastMath.cos((double)(0.0344284 * ((double)this.doy - p[38])));
            t[0] = p[21] * (this.f107a - 150.0);
            t[1] = p[1] * this.plg[0][2] + p[2] * this.plg[0][4] + p[22] * this.plg[0][6] + p[26] * this.plg[0][1] + p[14] * this.plg[0][3] + p[59] * this.plg[0][5];
            t[2] = (p[18] + p[47] * this.plg[0][2] + p[29] * this.plg[0][4]) * cd32;
            t[3] = (p[15] + p[16] * this.plg[0][2] + p[30] * this.plg[0][4]) * cd18;
            t[4] = (p[9] * this.plg[0][1] + p[10] * this.plg[0][3] + p[20] * this.plg[0][5]) * cd14;
            t[5] = p[37] * this.plg[0][1] * cd39;
            if (NRLMSISE00.this.sw[7] != 0) {
                double t71 = p[11] * this.plg[1][2] * cd14 * (double)NRLMSISE00.this.swc[5];
                double t72 = p[12] * this.plg[1][2] * cd14 * (double)NRLMSISE00.this.swc[5];
                t[6] = (p[3] * this.plg[1][1] + p[4] * this.plg[1][3] + t71) * this.ctloc + (p[6] * this.plg[1][1] + p[7] * this.plg[1][3] + t72) * this.stloc;
            }
            if (NRLMSISE00.this.sw[8] != 0) {
                double t81 = (p[23] * this.plg[2][3] + p[35] * this.plg[2][5]) * cd14 * (double)NRLMSISE00.this.swc[5];
                double t82 = (p[33] * this.plg[2][3] + p[36] * this.plg[2][5]) * cd14 * (double)NRLMSISE00.this.swc[5];
                t[7] = (p[5] * this.plg[2][2] + p[41] * this.plg[2][4] + t81) * this.c2tloc + (p[8] * this.plg[2][2] + p[42] * this.plg[2][4] + t82) * this.s2tloc;
            }
            if (NRLMSISE00.this.sw[14] != 0) {
                t[13] = p[39] * this.plg[3][3] * this.s3tloc + p[40] * this.plg[3][3] * this.c3tloc;
            }
            if (NRLMSISE00.this.sw[9] == 1) {
                t[8] = this.apdf * (p[32] + p[45] * this.plg[0][2] * (double)NRLMSISE00.this.swc[2]);
            } else if (NRLMSISE00.this.sw[9] == -1) {
                t[8] = this.apt * (p[50] + p[96] * this.plg[0][2] * (double)NRLMSISE00.this.swc[2]);
            }
            if (NRLMSISE00.this.sw[10] != 0 && NRLMSISE00.this.sw[11] != 0) {
                double lonr = 0.0174533 * this.lon;
                t[10] = (1.0 + this.plg[0][1] * (p[80] * (double)NRLMSISE00.this.swc[5] * FastMath.cos((double)(0.0172142 * ((double)this.doy - p[81]))) + p[85] * (double)NRLMSISE00.this.swc[6] * FastMath.cos((double)(0.0344284 * ((double)this.doy - p[86])))) + p[83] * (double)NRLMSISE00.this.swc[3] * FastMath.cos((double)(0.0172142 * ((double)this.doy - p[84]))) + p[87] * (double)NRLMSISE00.this.swc[4] * FastMath.cos((double)(0.0344284 * ((double)this.doy - p[88])))) * ((p[64] * this.plg[1][2] + p[65] * this.plg[1][4] + p[66] * this.plg[1][6] + p[74] * this.plg[1][1] + p[75] * this.plg[1][3] + p[76] * this.plg[1][5]) * FastMath.cos((double)lonr) + (p[90] * this.plg[1][2] + p[91] * this.plg[1][4] + p[92] * this.plg[1][6] + p[77] * this.plg[1][1] + p[78] * this.plg[1][3] + p[79] * this.plg[1][5]) * FastMath.sin((double)lonr));
            }
            double gl = 0.0;
            for (int i = 0; i < 14; ++i) {
                gl += (double)FastMath.abs((int)NRLMSISE00.this.sw[i + 1]) * t[i];
            }
            return gl;
        }

        private double sg0(double ex, double p24, double p25) {
            double g01 = this.g0(this.ap[1], p24, p25);
            double g02 = this.g0(this.ap[2], p24, p25);
            double g03 = this.g0(this.ap[3], p24, p25);
            double g04 = this.g0(this.ap[4], p24, p25);
            double g05 = this.g0(this.ap[5], p24, p25);
            double g06 = this.g0(this.ap[6], p24, p25);
            double ex2 = ex * ex;
            double ex3 = ex * ex2;
            double ex4 = ex2 * ex2;
            double ex8 = ex4 * ex4;
            double ex12 = ex4 * ex8;
            double g234 = g02 * ex + g03 * ex2 + g04 * ex3;
            double g56 = g05 * ex4 + g06 * ex12;
            double ex19 = ex3 * ex4 * ex12;
            double omex = 1.0 - ex;
            double sumex = 1.0 + (1.0 - ex19) / omex * FastMath.sqrt((double)ex);
            return (g01 + (g234 + g56 * (1.0 - ex8) / omex)) / sumex;
        }

        private double g0(double apI, double p24, double p25) {
            double am4 = apI - 4.0;
            return am4 + (p25 - 1.0) * (am4 + (FastMath.exp((double)(-p24 * am4)) - 1.0) / p24);
        }

        private double ccor(double alt, double r, double h1, double zh) {
            double e = (alt - zh) / h1;
            if (e > 70.0) {
                return 1.0;
            }
            if (e < -70.0) {
                return FastMath.exp((double)r);
            }
            return FastMath.exp((double)(r / (1.0 + FastMath.exp((double)e))));
        }

        private double ccor2(double alt, double r, double h1, double zh, double h2) {
            double e1 = (alt - zh) / h1;
            double e2 = (alt - zh) / h2;
            if (e1 > 70.0 || e2 > 70.0) {
                return 1.0;
            }
            if (e1 < -70.0 && e2 < -70.0) {
                return FastMath.exp((double)r);
            }
            double ex1 = FastMath.exp((double)e1);
            double ex2 = FastMath.exp((double)e2);
            return FastMath.exp((double)(r / (1.0 + 0.5 * (ex1 + ex2))));
        }

        private double scalh(double alt, double xm, double temp) {
            double denom = 1.0 + alt / this.rlat;
            double galt = this.glat / (denom * denom);
            return 831.4 * temp / (galt * xm);
        }

        private double dnet(double dd, double dm, double zhm, double xmm, double xm) {
            double a;
            double ylog;
            if (!(dm > 0.0) || !(dd > 0.0)) {
                double ddd = dd;
                if (dd == 0.0 && dm == 0.0) {
                    ddd = 1.0;
                }
                if (dm == 0.0) {
                    return ddd;
                }
                if (dd == 0.0) {
                    return dm;
                }
            }
            if ((ylog = (a = zhm / (xmm - xm)) * FastMath.log((double)(dm / dd))) < -10.0) {
                return dd;
            }
            if (ylog > 10.0) {
                return dm;
            }
            return dd * FastMath.pow((double)(1.0 + FastMath.exp((double)ylog)), (double)(1.0 / a));
        }

        private double splini(double[] xa, double[] ya, double[] y2a, double x) {
            int n = xa.length;
            double yi = 0.0;
            int klo = 0;
            for (int khi = 1; x > xa[klo] && khi < n; ++khi) {
                double xx = x;
                if (khi < n - 1) {
                    xx = x < xa[khi] ? x : xa[khi];
                }
                double h = xa[khi] - xa[klo];
                double a = (xa[khi] - xx) / h;
                double b = (xx - xa[klo]) / h;
                double a2 = a * a;
                double b2 = b * b;
                yi += ((1.0 - a2) * ya[klo] / 2.0 + b2 * ya[khi] / 2.0 + ((-(1.0 + a2 * a2) / 4.0 + a2 / 2.0) * y2a[klo] + (b2 * b2 / 4.0 - b2 / 2.0) * y2a[khi]) * h * h / 6.0) * h;
                ++klo;
            }
            return yi;
        }

        private double splint(double[] xa, double[] ya, double[] y2a, double x) {
            int n = xa.length;
            int klo = 0;
            int khi = n - 1;
            while (khi - klo > 1) {
                int k = khi + klo >>> 1;
                if (xa[k] > x) {
                    khi = k;
                    continue;
                }
                klo = k;
            }
            double h = xa[khi] - xa[klo];
            double a = (xa[khi] - x) / h;
            double b = (x - xa[klo]) / h;
            return a * ya[klo] + b * ya[khi] + ((a * a * a - a) * y2a[klo] + (b * b * b - b) * y2a[khi]) * h * h / 6.0;
        }

        private double[] spline(double[] x, double[] y, double yp1, double ypn) {
            int n = x.length;
            double[] y2 = new double[n];
            double[] u = new double[n];
            if (yp1 < 1.0E30) {
                y2[0] = -0.5;
                u[0] = 3.0 / (x[1] - x[0]) * ((y[1] - y[0]) / (x[1] - x[0]) - yp1);
            }
            for (int i = 1; i < n - 1; ++i) {
                double sig = (x[i] - x[i - 1]) / (x[i + 1] - x[i - 1]);
                double p = sig * y2[i - 1] + 2.0;
                y2[i] = (sig - 1.0) / p;
                u[i] = (6.0 * ((y[i + 1] - y[i]) / (x[i + 1] - x[i]) - (y[i] - y[i - 1]) / (x[i] - x[i - 1])) / (x[i + 1] - x[i - 1]) - sig * u[i - 1]) / p;
            }
            double qn = 0.0;
            double un = 0.0;
            if (ypn < 1.0E30) {
                qn = 0.5;
                un = 3.0 / (x[n - 1] - x[n - 2]) * (ypn - (y[n - 1] - y[n - 2]) / (x[n - 1] - x[n - 2]));
            }
            y2[n - 1] = (un - qn * u[n - 2]) / (qn * y2[n - 2] + 1.0);
            for (int k = n - 2; k >= 0; --k) {
                y2[k] = y2[k] * y2[k + 1] + u[k];
            }
            return y2;
        }

        private double densm(double alt, double d0, double xm) {
            double densm = d0;
            int mn = ZN2.length;
            double z = alt > ZN2[mn - 1] ? alt : ZN2[mn - 1];
            double z1 = ZN2[0];
            double z2 = ZN2[mn - 1];
            double t1 = this.meso_tn2[0];
            double t2 = this.meso_tn2[mn - 1];
            double zg = this.zeta(z, z1);
            double zgdif = this.zeta(z2, z1);
            double[] xs = new double[mn];
            double[] ys = new double[mn];
            for (int k = 0; k < mn; ++k) {
                xs[k] = this.zeta(ZN2[k], z1) / zgdif;
                ys[k] = 1.0 / this.meso_tn2[k];
            }
            double qSM = (this.rlat + z2) / (this.rlat + z1);
            double yd1 = -this.meso_tgn2[0] / (t1 * t1) * zgdif;
            double yd2 = -this.meso_tgn2[1] / (t2 * t2) * zgdif * qSM * qSM;
            double[] y2out = this.spline(xs, ys, yd1, yd2);
            double x = zg / zgdif;
            double y = this.splint(xs, ys, y2out, x);
            double tz = 1.0 / y;
            if (xm != 0.0) {
                double glb = this.galt(z1);
                double gamm = xm * glb * zgdif / 831.4;
                double yi = this.splini(xs, ys, y2out, x);
                double expl = FastMath.min((double)50.0, (double)(gamm * yi));
                densm *= t1 / tz * FastMath.exp((double)(-expl));
            }
            if (alt > ZN3[0]) {
                return xm == 0.0 ? tz : densm;
            }
            z = alt;
            mn = ZN3.length;
            z1 = ZN3[0];
            z2 = ZN3[mn - 1];
            t1 = this.meso_tn3[0];
            t2 = this.meso_tn3[mn - 1];
            zg = this.zeta(z, z1);
            zgdif = this.zeta(z2, z1);
            xs = new double[mn];
            ys = new double[mn];
            for (int k = 0; k < mn; ++k) {
                xs[k] = this.zeta(ZN3[k], z1) / zgdif;
                ys[k] = 1.0 / this.meso_tn3[k];
            }
            double qTS = (this.rlat + z2) / (this.rlat + z1);
            yd1 = -this.meso_tgn3[0] / (t1 * t1) * zgdif;
            yd2 = -this.meso_tgn3[1] / (t2 * t2) * zgdif * qTS * qTS;
            y2out = this.spline(xs, ys, yd1, yd2);
            x = zg / zgdif;
            y = this.splint(xs, ys, y2out, x);
            tz = 1.0 / y;
            if (xm != 0.0) {
                double glb = this.galt(z1);
                double gamm = xm * glb * zgdif / 831.4;
                double yi = this.splini(xs, ys, y2out, x);
                double expl = FastMath.min((double)50.0, (double)(gamm * yi));
                densm *= t1 / tz * FastMath.exp((double)(-expl));
            }
            return xm == 0.0 ? tz : densm;
        }

        private double densu(double alt, double dlb, double tinf, double tlb, double xm, double alpha, double zlb, double s2) {
            double tt;
            double z = alt > ZN1[0] ? alt : ZN1[0];
            double zg2 = this.zeta(z, zlb);
            double ta = tt = tinf - (tinf - tlb) * FastMath.exp((double)(-s2 * zg2));
            double tz = tt;
            int mn = ZN1.length;
            double[] xs = new double[mn];
            double[] ys = new double[mn];
            double x = 0.0;
            double[] y2out = new double[mn];
            double zgdif = 0.0;
            if (alt < ZN1[0]) {
                double dta;
                double p = (this.rlat + zlb) / (this.rlat + ZN1[0]);
                this.meso_tgn1[0] = dta = (tinf - ta) * s2 * p * p;
                this.meso_tn1[0] = ta;
                z = alt > ZN1[mn - 1] ? alt : ZN1[mn - 1];
                double t1 = this.meso_tn1[0];
                double t2 = this.meso_tn1[mn - 1];
                double zg = this.zeta(z, ZN1[0]);
                zgdif = this.zeta(ZN1[mn - 1], ZN1[0]);
                for (int k = 0; k < mn; ++k) {
                    xs[k] = this.zeta(ZN1[k], ZN1[0]) / zgdif;
                    ys[k] = 1.0 / this.meso_tn1[k];
                }
                double q = (this.rlat + ZN1[mn - 1]) / (this.rlat + ZN1[0]);
                double yd1 = -this.meso_tgn1[0] / (t1 * t1) * zgdif;
                double yd2 = -this.meso_tgn1[1] / (t2 * t2) * zgdif * q * q;
                y2out = this.spline(xs, ys, yd1, yd2);
                x = zg / zgdif;
                double y = this.splint(xs, ys, y2out, x);
                tz = 1.0 / y;
            }
            if (xm == 0.0) {
                return tz;
            }
            double glb = this.galt(zlb);
            double gamma = xm * glb / (831.4 * s2 * tinf);
            double expl = tt <= 0.0 ? 50.0 : FastMath.min((double)50.0, (double)FastMath.exp((double)(-s2 * gamma * zg2)));
            double densu = dlb * FastMath.pow((double)(tlb / tt), (double)(1.0 + alpha + gamma)) * expl;
            if (alt < ZN1[0]) {
                glb = this.galt(ZN1[0]);
                gamma = xm * glb * zgdif / 831.4;
                expl = tz <= 0.0 ? 50.0 : FastMath.min((double)50.0, (double)(gamma * this.splini(xs, ys, y2out, x)));
                densu *= FastMath.pow((double)(this.meso_tn1[0] / tz), (double)(1.0 + alpha)) * FastMath.exp((double)(-expl));
            }
            return densu;
        }

        private double galt(double alt) {
            double r = 1.0 + alt / this.rlat;
            return this.glat / (r * r);
        }

        private double zeta(double zz, double zl) {
            return (zz - zl) * (this.rlat + zl) / (this.rlat + zz);
        }
    }
}

