/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces.drag;

import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.forces.drag.DragSensitive;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class IsotropicDrag
implements DragSensitive {
    private final double SCALE = FastMath.scalb((double)1.0, (int)-3);
    private final ParameterDriver[] dragParametersDrivers = new ParameterDriver[1];
    private final double crossSection;
    private final DSFactory factory;

    public IsotropicDrag(double crossSection, double dragCoeff) {
        this(crossSection, dragCoeff, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public IsotropicDrag(double crossSection, double dragCoeff, double dragCoeffMin, double dragCoeffMax) {
        try {
            this.dragParametersDrivers[0] = new ParameterDriver("drag coefficient", dragCoeff, this.SCALE, dragCoeffMin, dragCoeffMax);
        }
        catch (OrekitException oe) {
            throw new OrekitInternalError(oe);
        }
        this.crossSection = crossSection;
        this.factory = new DSFactory(1, 1);
    }

    @Override
    public ParameterDriver[] getDragParametersDrivers() {
        return (ParameterDriver[])this.dragParametersDrivers.clone();
    }

    @Override
    public Vector3D dragAcceleration(AbsoluteDate date, Frame frame, Vector3D position, Rotation rotation, double mass, double density, Vector3D relativeVelocity, double[] parameters) {
        double dragCoeff = parameters[0];
        return new Vector3D(relativeVelocity.getNorm() * density * dragCoeff * this.crossSection / (2.0 * mass), relativeVelocity);
    }

    @Override
    public <T extends RealFieldElement<T>> FieldVector3D<T> dragAcceleration(FieldAbsoluteDate<T> date, Frame frame, FieldVector3D<T> position, FieldRotation<T> rotation, T mass, T density, FieldVector3D<T> relativeVelocity, T[] parameters) {
        T dragCoeff = parameters[0];
        return new FieldVector3D((RealFieldElement)((RealFieldElement)relativeVelocity.getNorm().multiply(((RealFieldElement)density.multiply(dragCoeff)).multiply(this.crossSection / 2.0))).divide(mass), relativeVelocity);
    }

    @Override
    public FieldVector3D<DerivativeStructure> dragAcceleration(AbsoluteDate date, Frame frame, Vector3D position, Rotation rotation, double mass, double density, Vector3D relativeVelocity, double[] parameters, String paramName) {
        if (!"drag coefficient".equals(paramName)) {
            throw new OrekitException((Localizable)OrekitMessages.UNSUPPORTED_PARAMETER_NAME, paramName, "drag coefficient");
        }
        DerivativeStructure dragCoeffDS = this.factory.variable(0, parameters[0]);
        return new FieldVector3D((RealFieldElement)dragCoeffDS.multiply(relativeVelocity.getNorm() * density * this.crossSection / (2.0 * mass)), relativeVelocity);
    }
}

