/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.forces;

import org.hipparchus.RealFieldElement;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.forces.AbstractParametricAcceleration;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class PolynomialParametricAcceleration
extends AbstractParametricAcceleration {
    private static final double ACCELERATION_SCALE = FastMath.scalb((double)1.0, (int)-20);
    private final ParameterDriver[] drivers;
    private AbsoluteDate referenceDate;

    public PolynomialParametricAcceleration(Vector3D direction, boolean isInertial, String prefix, AbsoluteDate referenceDate, int degree) {
        this(direction, isInertial, null, prefix, referenceDate, degree);
    }

    public PolynomialParametricAcceleration(Vector3D direction, AttitudeProvider attitudeOverride, String prefix, AbsoluteDate referenceDate, int degree) {
        this(direction, false, attitudeOverride, prefix, referenceDate, degree);
    }

    private PolynomialParametricAcceleration(Vector3D direction, boolean isInertial, AttitudeProvider attitudeOverride, String prefix, AbsoluteDate referenceDate, int degree) {
        super(direction, isInertial, attitudeOverride);
        this.referenceDate = referenceDate;
        this.drivers = new ParameterDriver[degree + 1];
        try {
            for (int i = 0; i < this.drivers.length; ++i) {
                this.drivers[i] = new ParameterDriver(prefix + "[" + i + "]", 0.0, ACCELERATION_SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
            }
        }
        catch (OrekitException oe) {
            throw new OrekitInternalError(oe);
        }
    }

    @Override
    public boolean dependsOnPositionOnly() {
        return this.isInertial();
    }

    @Override
    public void init(SpacecraftState initialState, AbsoluteDate target) {
        if (this.referenceDate == null) {
            this.referenceDate = initialState.getDate();
        }
    }

    @Override
    protected double signedAmplitude(SpacecraftState state, double[] parameters) {
        double dt = state.getDate().durationFrom(this.referenceDate);
        double amplitude = 0.0;
        for (int i = parameters.length - 1; i >= 0; --i) {
            amplitude += amplitude * dt + parameters[i];
        }
        return amplitude;
    }

    @Override
    protected <T extends RealFieldElement<T>> T signedAmplitude(FieldSpacecraftState<T> state, T[] parameters) {
        T dt = state.getDate().durationFrom(this.referenceDate);
        RealFieldElement amplitude = (RealFieldElement)dt.getField().getZero();
        for (int i = parameters.length - 1; i >= 0; --i) {
            amplitude = (RealFieldElement)amplitude.add(((RealFieldElement)amplitude.multiply(dt)).add(parameters[i]));
        }
        return (T)amplitude;
    }

    @Override
    public ParameterDriver[] getParametersDrivers() {
        return (ParameterDriver[])this.drivers.clone();
    }
}

