/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.files.ccsds;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.files.ccsds.CcsdsTimeScale;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;

public class TDMFile {
    private double formatVersion;
    private List<String> headerComment;
    private AbsoluteDate creationDate;
    private String originator;
    private List<ObservationsBlock> observationsBlocks = new ArrayList<ObservationsBlock>();

    public double getFormatVersion() {
        return this.formatVersion;
    }

    public void setFormatVersion(double formatVersion) {
        this.formatVersion = formatVersion;
    }

    public List<String> getHeaderComment() {
        return this.headerComment;
    }

    public void setHeaderComment(List<String> headerComment) {
        this.headerComment = new ArrayList<String>(headerComment);
    }

    public AbsoluteDate getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(AbsoluteDate creationDate) {
        this.creationDate = creationDate;
    }

    public String getOriginator() {
        return this.originator;
    }

    public void setOriginator(String originator) {
        this.originator = originator;
    }

    public void addObservationsBlock() {
        this.observationsBlocks.add(new ObservationsBlock());
    }

    public List<ObservationsBlock> getObservationsBlocks() {
        return Collections.unmodifiableList(this.observationsBlocks);
    }

    public void setObservationsBlocks(List<ObservationsBlock> observationsBlocks) {
        this.observationsBlocks = new ArrayList<ObservationsBlock>(observationsBlocks);
    }

    public void checkTimeSystems() {
        CcsdsTimeScale timeSystem = this.getObservationsBlocks().get(0).getMetaData().getTimeSystem();
        for (ObservationsBlock block : this.observationsBlocks) {
            if (timeSystem.equals((Object)block.getMetaData().getTimeSystem())) continue;
            throw new OrekitException((Localizable)OrekitMessages.CCSDS_TDM_INCONSISTENT_TIME_SYSTEMS, new Object[]{timeSystem, block.getMetaData().getTimeSystem()});
        }
    }

    public static class TDMMetaData {
        private CcsdsTimeScale timeSystem;
        private AbsoluteDate startTime;
        private String startTimeString;
        private AbsoluteDate stopTime;
        private String stopTimeString;
        private Map<Integer, String> participants = new TreeMap<Integer, String>();
        private String mode;
        private String path;
        private String path1;
        private String path2;
        private String transmitBand;
        private String receiveBand;
        private int turnaroundNumerator;
        private int turnaroundDenominator;
        private String timetagRef;
        private double integrationInterval;
        private String integrationRef;
        private double freqOffset;
        private String rangeMode;
        private double rangeModulus;
        private String rangeUnits;
        private String angleType;
        private String referenceFrameString;
        private Frame referenceFrame;
        private Map<Integer, Double> transmitDelays = new TreeMap<Integer, Double>();
        private Map<Integer, Double> receiveDelays = new TreeMap<Integer, Double>();
        private String dataQuality;
        private double correctionAngle1;
        private double correctionAngle2;
        private double correctionDoppler;
        private double correctionRange;
        private double correctionReceive;
        private double correctionTransmit;
        private String correctionsApplied;
        private List<String> comment = new ArrayList<String>();

        public CcsdsTimeScale getTimeSystem() {
            return this.timeSystem;
        }

        public void setTimeSystem(CcsdsTimeScale timeSystem) {
            this.timeSystem = timeSystem;
        }

        public AbsoluteDate getStartTime() {
            return this.startTime;
        }

        public void setStartTime(AbsoluteDate startTime) {
            this.startTime = startTime;
        }

        public String getStartTimeString() {
            return this.startTimeString;
        }

        public void setStartTimeString(String startTimeString) {
            this.startTimeString = startTimeString;
        }

        public AbsoluteDate getStopTime() {
            return this.stopTime;
        }

        public void setStopTime(AbsoluteDate stopTime) {
            this.stopTime = stopTime;
        }

        public String getStopTimeString() {
            return this.stopTimeString;
        }

        public void setStopTimeString(String stopTimeString) {
            this.stopTimeString = stopTimeString;
        }

        public Map<Integer, String> getParticipants() {
            return this.participants;
        }

        public void setParticipants(Map<Integer, String> participants) {
            this.participants = new TreeMap<Integer, String>();
            this.participants.putAll(participants);
        }

        public void addParticipant(int participantNumber, String participant) {
            this.participants.put(participantNumber, participant);
        }

        public String getMode() {
            return this.mode;
        }

        public void setMode(String mode) {
            this.mode = mode;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getPath1() {
            return this.path1;
        }

        public void setPath1(String path1) {
            this.path1 = path1;
        }

        public String getPath2() {
            return this.path2;
        }

        public void setPath2(String path2) {
            this.path2 = path2;
        }

        public String getTransmitBand() {
            return this.transmitBand;
        }

        public void setTransmitBand(String transmitBand) {
            this.transmitBand = transmitBand;
        }

        public String getReceiveBand() {
            return this.receiveBand;
        }

        public void setReceiveBand(String receiveBand) {
            this.receiveBand = receiveBand;
        }

        public int getTurnaroundNumerator() {
            return this.turnaroundNumerator;
        }

        public void setTurnaroundNumerator(int turnaroundNumerator) {
            this.turnaroundNumerator = turnaroundNumerator;
        }

        public int getTurnaroundDenominator() {
            return this.turnaroundDenominator;
        }

        public void setTurnaroundDenominator(int turnaroundDenominator) {
            this.turnaroundDenominator = turnaroundDenominator;
        }

        public String getTimetagRef() {
            return this.timetagRef;
        }

        public void setTimetagRef(String timetagRef) {
            this.timetagRef = timetagRef;
        }

        public double getIntegrationInterval() {
            return this.integrationInterval;
        }

        public void setIntegrationInterval(double integrationInterval) {
            this.integrationInterval = integrationInterval;
        }

        public String getIntegrationRef() {
            return this.integrationRef;
        }

        public void setIntegrationRef(String integrationRef) {
            this.integrationRef = integrationRef;
        }

        public double getFreqOffset() {
            return this.freqOffset;
        }

        public void setFreqOffset(double freqOffset) {
            this.freqOffset = freqOffset;
        }

        public String getRangeMode() {
            return this.rangeMode;
        }

        public void setRangeMode(String rangeMode) {
            this.rangeMode = rangeMode;
        }

        public double getRangeModulus() {
            return this.rangeModulus;
        }

        public void setRangeModulus(double rangeModulus) {
            this.rangeModulus = rangeModulus;
        }

        public String getRangeUnits() {
            return this.rangeUnits;
        }

        public void setRangeUnits(String rangeUnits) {
            this.rangeUnits = rangeUnits;
        }

        public String getAngleType() {
            return this.angleType;
        }

        public void setAngleType(String angleType) {
            this.angleType = angleType;
        }

        public Frame getReferenceFrame() {
            return this.referenceFrame;
        }

        public void setReferenceFrame(Frame refFrame) {
            this.referenceFrame = refFrame;
        }

        public String getReferenceFrameString() {
            return this.referenceFrameString;
        }

        public void setReferenceFrameString(String frame) {
            this.referenceFrameString = frame;
        }

        public Map<Integer, Double> getTransmitDelays() {
            return this.transmitDelays;
        }

        public void setTransmitDelays(Map<Integer, Double> transmitDelays) {
            this.transmitDelays = new TreeMap<Integer, Double>();
            this.transmitDelays.putAll(transmitDelays);
        }

        public void addTransmitDelay(int participantNumber, double transmitDelay) {
            this.transmitDelays.put(participantNumber, transmitDelay);
        }

        public Map<Integer, Double> getReceiveDelays() {
            return this.receiveDelays;
        }

        public void setReceiveDelays(Map<Integer, Double> receiveDelays) {
            this.receiveDelays = new TreeMap<Integer, Double>();
            this.receiveDelays.putAll(receiveDelays);
        }

        public void addReceiveDelay(int participantNumber, double receiveDelay) {
            this.receiveDelays.put(participantNumber, receiveDelay);
        }

        public String getDataQuality() {
            return this.dataQuality;
        }

        public void setDataQuality(String dataQuality) {
            this.dataQuality = dataQuality;
        }

        public double getCorrectionAngle1() {
            return this.correctionAngle1;
        }

        public void setCorrectionAngle1(double correctionAngle1) {
            this.correctionAngle1 = correctionAngle1;
        }

        public double getCorrectionAngle2() {
            return this.correctionAngle2;
        }

        public void setCorrectionAngle2(double correctionAngle2) {
            this.correctionAngle2 = correctionAngle2;
        }

        public double getCorrectionDoppler() {
            return this.correctionDoppler;
        }

        public void setCorrectionDoppler(double correctionDoppler) {
            this.correctionDoppler = correctionDoppler;
        }

        public double getCorrectionRange() {
            return this.correctionRange;
        }

        public void setCorrectionRange(double correctionRange) {
            this.correctionRange = correctionRange;
        }

        public double getCorrectionReceive() {
            return this.correctionReceive;
        }

        public void setCorrectionReceive(double correctionReceive) {
            this.correctionReceive = correctionReceive;
        }

        public double getCorrectionTransmit() {
            return this.correctionTransmit;
        }

        public void setCorrectionTransmit(double correctionTransmit) {
            this.correctionTransmit = correctionTransmit;
        }

        public String getCorrectionsApplied() {
            return this.correctionsApplied;
        }

        public void setCorrectionsApplied(String correctionsApplied) {
            this.correctionsApplied = correctionsApplied;
        }

        public List<String> getComment() {
            return Collections.unmodifiableList(this.comment);
        }

        public void setComment(List<String> comment) {
            this.comment = new ArrayList<String>(comment);
        }
    }

    public static class Observation {
        private String keyword;
        private AbsoluteDate epoch;
        private double measurement;

        Observation(String keyword, AbsoluteDate epoch, double measurement) {
            this.keyword = keyword;
            this.epoch = epoch;
            this.measurement = measurement;
        }

        public String getKeyword() {
            return this.keyword;
        }

        public void setKeyword(String keyword) {
            this.keyword = keyword;
        }

        public AbsoluteDate getEpoch() {
            return this.epoch;
        }

        public void setEpoch(AbsoluteDate epoch) {
            this.epoch = epoch;
        }

        public double getMeasurement() {
            return this.measurement;
        }

        public void setMeasurement(double measurement) {
            this.measurement = measurement;
        }
    }

    public static class ObservationsBlock {
        private TDMMetaData metaData = new TDMMetaData();
        private List<Observation> observations = new ArrayList<Observation>();
        private List<String> observationsComment = new ArrayList<String>();

        public List<Observation> getObservations() {
            return this.observations;
        }

        public void setObservations(List<Observation> observations) {
            this.observations = new ArrayList<Observation>(observations);
        }

        public void addObservation(Observation observation) {
            this.observations.add(observation);
        }

        public void addObservation(String keyword, AbsoluteDate epoch, double measurement) {
            this.addObservation(new Observation(keyword, epoch, measurement));
        }

        public TDMMetaData getMetaData() {
            return this.metaData;
        }

        public void setMetaData(TDMMetaData metaData) {
            this.metaData = metaData;
        }

        public List<String> getObservationsComment() {
            return this.observationsComment;
        }

        public void setObservationsComment(List<String> observationsComment) {
            this.observationsComment = new ArrayList<String>(observationsComment);
        }

        public void addObservationComment(String observationComment) {
            this.observationsComment.add(observationComment);
        }
    }
}

