/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.Collections;
import java.util.List;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.MathUtils;
import org.orekit.estimation.measurements.AngularAzEl;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.frames.Frame;
import org.orekit.models.earth.IonosphericModel;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class AngularIonosphericDelayModifier
implements EstimationModifier<AngularAzEl> {
    private final IonosphericModel ionoModel;

    public AngularIonosphericDelayModifier(IonosphericModel model) {
        this.ionoModel = model;
    }

    private double angularErrorIonosphericModel(GroundStation station, SpacecraftState state) {
        Vector3D position = state.getPVCoordinates().getPosition();
        double elevation = station.getBaseFrame().getElevation(position, state.getFrame(), state.getDate());
        if (elevation > 0.0) {
            double azimuth = station.getBaseFrame().getAzimuth(position, state.getFrame(), state.getDate());
            double delay = this.ionoModel.pathDelay(state.getDate(), station.getBaseFrame().getPoint(), elevation, azimuth);
            return delay;
        }
        return 0.0;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }

    @Override
    public void modify(EstimatedMeasurement<AngularAzEl> estimated) {
        AngularAzEl measure = estimated.getObservedMeasurement();
        GroundStation station = measure.getStation();
        SpacecraftState state = estimated.getStates()[0];
        double delay = this.angularErrorIonosphericModel(station, state);
        double dt = delay / 2.99792458E8;
        SpacecraftState transitState = state.shiftedBy(-dt);
        AbsoluteDate date = transitState.getDate();
        Vector3D position = transitState.getPVCoordinates().getPosition();
        Frame inertial = transitState.getFrame();
        double elevation = station.getBaseFrame().getElevation(position, inertial, date);
        double baseAzimuth = station.getBaseFrame().getAzimuth(position, inertial, date);
        double twoPiWrap = MathUtils.normalizeAngle((double)baseAzimuth, (double)measure.getObservedValue()[0]) - baseAzimuth;
        double azimuth = baseAzimuth + twoPiWrap;
        estimated.setEstimatedValue(azimuth, elevation);
    }
}

