/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.generation;

import org.hipparchus.random.CorrelatedRandomVectorGenerator;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.estimation.measurements.TurnAroundRange;
import org.orekit.estimation.measurements.generation.AbstractMeasurementBuilder;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class TurnAroundRangeBuilder
extends AbstractMeasurementBuilder<TurnAroundRange> {
    private final GroundStation masterStation;
    private final GroundStation slaveStation;

    public TurnAroundRangeBuilder(CorrelatedRandomVectorGenerator noiseSource, GroundStation masterStation, GroundStation slaveStation, double sigma, double baseWeight, ObservableSatellite satellite) {
        super(noiseSource, sigma, baseWeight, satellite);
        this.masterStation = masterStation;
        this.slaveStation = slaveStation;
    }

    @Override
    public TurnAroundRange build(SpacecraftState[] states) {
        ObservableSatellite satellite = this.getSatellites()[0];
        double sigma = this.getTheoreticalStandardDeviation()[0];
        double baseWeight = this.getBaseWeight()[0];
        SpacecraftState state = states[satellite.getPropagatorIndex()];
        TurnAroundRange dummy = new TurnAroundRange(this.masterStation, this.slaveStation, state.getDate(), Double.NaN, sigma, baseWeight, satellite);
        for (EstimationModifier modifier : this.getModifiers()) {
            dummy.addModifier(modifier);
        }
        for (ParameterDriver driver : dummy.getParametersDrivers()) {
            AbsoluteDate end;
            if (driver.getReferenceDate() != null) continue;
            AbsoluteDate start = this.getStart();
            driver.setReferenceDate(start.durationFrom(end = this.getEnd()) <= 0.0 ? start : end);
        }
        double range = dummy.estimate(0, 0, states).getEstimatedValue()[0];
        double[] noise = this.getNoise();
        if (noise != null) {
            range += noise[0];
        }
        TurnAroundRange measurement = new TurnAroundRange(this.masterStation, this.slaveStation, state.getDate(), range, sigma, baseWeight, satellite);
        for (EstimationModifier modifier : this.getModifiers()) {
            measurement.addModifier(modifier);
        }
        return measurement;
    }
}

