/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.generation;

import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.random.CorrelatedRandomVectorGenerator;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.estimation.measurements.PV;
import org.orekit.estimation.measurements.generation.AbstractMeasurementBuilder;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class PVBuilder
extends AbstractMeasurementBuilder<PV> {
    public PVBuilder(CorrelatedRandomVectorGenerator noiseSource, double sigmaPosition, double sigmaVelocity, double baseWeight, ObservableSatellite satellite) {
        super(noiseSource, new double[]{sigmaPosition, sigmaVelocity}, new double[]{baseWeight}, satellite);
    }

    @Override
    public PV build(SpacecraftState[] states) {
        ObservableSatellite satellite = this.getSatellites()[0];
        double[] sigma = this.getTheoreticalStandardDeviation();
        double baseWeight = this.getBaseWeight()[0];
        SpacecraftState state = states[satellite.getPropagatorIndex()];
        PV dummy = new PV(state.getDate(), Vector3D.NaN, Vector3D.NaN, sigma[0], sigma[1], baseWeight, satellite);
        for (EstimationModifier modifier : this.getModifiers()) {
            dummy.addModifier(modifier);
        }
        for (ParameterDriver driver : dummy.getParametersDrivers()) {
            AbsoluteDate end;
            if (driver.getReferenceDate() != null) continue;
            AbsoluteDate start = this.getStart();
            driver.setReferenceDate(start.durationFrom(end = this.getEnd()) <= 0.0 ? start : end);
        }
        double[] pv = dummy.estimate(0, 0, states).getEstimatedValue();
        double[] noise = this.getNoise();
        if (noise != null) {
            pv[0] = pv[0] + noise[0];
            pv[1] = pv[1] + noise[1];
            pv[2] = pv[2] + noise[2];
            pv[3] = pv[3] + noise[3];
            pv[4] = pv[4] + noise[4];
            pv[5] = pv[5] + noise[5];
        }
        PV measurement = new PV(state.getDate(), new Vector3D(pv[0], pv[1], pv[2]), new Vector3D(pv[3], pv[4], pv[5]), sigma[0], sigma[1], baseWeight, satellite);
        for (EstimationModifier modifier : this.getModifiers()) {
            measurement.addModifier(modifier);
        }
        return measurement;
    }
}

