/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements;

import java.util.List;
import java.util.stream.Collectors;
import org.orekit.estimation.measurements.ComparableMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.propagation.SpacecraftState;
import org.orekit.utils.ParameterDriver;

public interface ObservedMeasurement<T extends ObservedMeasurement<T>>
extends ComparableMeasurement {
    public void setEnabled(boolean var1);

    public boolean isEnabled();

    public int getDimension();

    public double[] getTheoreticalStandardDeviation();

    public double[] getBaseWeight();

    public void addModifier(EstimationModifier<T> var1);

    public List<EstimationModifier<T>> getModifiers();

    public List<ParameterDriver> getParametersDrivers();

    @Deprecated
    public List<Integer> getPropagatorsIndices();

    default public List<ObservableSatellite> getSatellites() {
        return this.getPropagatorsIndices().stream().map(i -> new ObservableSatellite((int)i)).collect(Collectors.toList());
    }

    public EstimatedMeasurement<T> estimate(int var1, int var2, SpacecraftState[] var3);
}

