/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.leastsquares;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.hipparchus.optim.ConvergenceChecker;
import org.hipparchus.optim.nonlinear.vector.leastsquares.LeastSquaresBuilder;
import org.hipparchus.optim.nonlinear.vector.leastsquares.LeastSquaresOptimizer;
import org.hipparchus.optim.nonlinear.vector.leastsquares.LeastSquaresProblem;
import org.hipparchus.optim.nonlinear.vector.leastsquares.MultivariateJacobianFunction;
import org.hipparchus.optim.nonlinear.vector.leastsquares.ParameterValidator;
import org.hipparchus.util.Incrementor;
import org.orekit.errors.OrekitException;
import org.orekit.estimation.leastsquares.BatchLSObserver;
import org.orekit.estimation.leastsquares.Model;
import org.orekit.estimation.leastsquares.ModelObserver;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimationsProvider;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.conversion.NumericalPropagatorBuilder;
import org.orekit.propagation.numerical.NumericalPropagator;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterDriversList;

public class BatchLSEstimator {
    private final NumericalPropagatorBuilder[] builders;
    private final List<ObservedMeasurement<?>> measurements;
    private final LeastSquaresOptimizer optimizer;
    private double parametersConvergenceThreshold;
    private final LeastSquaresBuilder lsBuilder;
    private BatchLSObserver observer;
    private Map<ObservedMeasurement<?>, EstimatedMeasurement<?>> estimations;
    private Orbit[] orbits;
    private LeastSquaresOptimizer.Optimum optimum;
    private Incrementor evaluationsCounter;
    private Incrementor iterationsCounter;

    public BatchLSEstimator(LeastSquaresOptimizer optimizer, NumericalPropagatorBuilder ... propagatorBuilder) {
        this.builders = propagatorBuilder;
        this.measurements = new ArrayList();
        this.optimizer = optimizer;
        this.parametersConvergenceThreshold = Double.NaN;
        this.lsBuilder = new LeastSquaresBuilder();
        this.observer = null;
        this.estimations = null;
        this.orbits = new Orbit[this.builders.length];
        this.lsBuilder.lazyEvaluation(false);
        this.lsBuilder.weight(null);
    }

    public void setObserver(BatchLSObserver observer) {
        this.observer = observer;
    }

    public void addMeasurement(ObservedMeasurement<?> measurement) {
        this.measurements.add(measurement);
    }

    public void setMaxIterations(int maxIterations) {
        this.lsBuilder.maxIterations(maxIterations);
    }

    public void setMaxEvaluations(int maxEvaluations) {
        this.lsBuilder.maxEvaluations(maxEvaluations);
    }

    public ParameterDriversList getOrbitalParametersDrivers(boolean estimatedOnly) {
        ParameterDriversList estimated = new ParameterDriversList();
        for (int i = 0; i < this.builders.length; ++i) {
            String suffix = this.builders.length > 1 ? "[" + i + "]" : null;
            for (ParameterDriversList.DelegatingDriver delegating : this.builders[i].getOrbitalParametersDrivers().getDrivers()) {
                if (!delegating.isSelected() && estimatedOnly) continue;
                for (ParameterDriver driver : delegating.getRawDrivers()) {
                    if (suffix != null && !driver.getName().endsWith(suffix)) {
                        driver.setName(driver.getName() + suffix);
                    }
                    estimated.add(driver);
                }
            }
        }
        return estimated;
    }

    public ParameterDriversList getPropagatorParametersDrivers(boolean estimatedOnly) {
        ParameterDriversList estimated = new ParameterDriversList();
        for (NumericalPropagatorBuilder builder : this.builders) {
            for (ParameterDriversList.DelegatingDriver delegating : builder.getPropagationParametersDrivers().getDrivers()) {
                if (!delegating.isSelected() && estimatedOnly) continue;
                for (ParameterDriver driver : delegating.getRawDrivers()) {
                    estimated.add(driver);
                }
            }
        }
        return estimated;
    }

    public ParameterDriversList getMeasurementsParametersDrivers(boolean estimatedOnly) {
        ParameterDriversList parameters = new ParameterDriversList();
        for (ObservedMeasurement<?> measurement : this.measurements) {
            for (ParameterDriver driver : measurement.getParametersDrivers()) {
                if (estimatedOnly && !driver.isSelected()) continue;
                parameters.add(driver);
            }
        }
        parameters.sort();
        return parameters;
    }

    public void setParametersConvergenceThreshold(double parametersConvergenceThreshold) {
        this.parametersConvergenceThreshold = parametersConvergenceThreshold;
    }

    public NumericalPropagator[] estimate() {
        for (ParameterDriver parameterDriver : this.getOrbitalParametersDrivers(false).getDrivers()) {
            if (parameterDriver.getReferenceDate() != null) continue;
            parameterDriver.setReferenceDate(this.builders[0].getInitialOrbitDate());
        }
        for (ParameterDriver parameterDriver : this.getPropagatorParametersDrivers(false).getDrivers()) {
            if (parameterDriver.getReferenceDate() != null) continue;
            parameterDriver.setReferenceDate(this.builders[0].getInitialOrbitDate());
        }
        for (ParameterDriver parameterDriver : this.getMeasurementsParametersDrivers(false).getDrivers()) {
            if (parameterDriver.getReferenceDate() != null) continue;
            parameterDriver.setReferenceDate(this.builders[0].getInitialOrbitDate());
        }
        ParameterDriversList estimatedOrbitalParameters = this.getOrbitalParametersDrivers(true);
        ParameterDriversList parameterDriversList = this.getPropagatorParametersDrivers(true);
        ParameterDriversList estimatedMeasurementsParameters = this.getMeasurementsParametersDrivers(true);
        double[] start = new double[estimatedOrbitalParameters.getNbParams() + parameterDriversList.getNbParams() + estimatedMeasurementsParameters.getNbParams()];
        int iStart = 0;
        for (ParameterDriver parameterDriver : estimatedOrbitalParameters.getDrivers()) {
            start[iStart++] = parameterDriver.getNormalizedValue();
        }
        for (ParameterDriver parameterDriver : parameterDriversList.getDrivers()) {
            start[iStart++] = parameterDriver.getNormalizedValue();
        }
        for (ParameterDriver parameterDriver : estimatedMeasurementsParameters.getDrivers()) {
            start[iStart++] = parameterDriver.getNormalizedValue();
        }
        this.lsBuilder.start(start);
        int p = 0;
        for (ObservedMeasurement<?> observedMeasurement : this.measurements) {
            if (!observedMeasurement.isEnabled()) continue;
            p += observedMeasurement.getDimension();
        }
        double[] dArray = new double[p];
        this.lsBuilder.target(dArray);
        ModelObserver modelObserver = new ModelObserver(){

            @Override
            public void modelCalled(Orbit[] newOrbits, Map<ObservedMeasurement<?>, EstimatedMeasurement<?>> newEstimations) {
                BatchLSEstimator.access$002(BatchLSEstimator.this, newOrbits);
                BatchLSEstimator.this.estimations = newEstimations;
            }
        };
        Model model = new Model(this.builders, this.measurements, estimatedMeasurementsParameters, modelObserver);
        this.lsBuilder.model((MultivariateJacobianFunction)model);
        this.lsBuilder.parameterValidator((ParameterValidator)new Validator(estimatedOrbitalParameters, parameterDriversList, estimatedMeasurementsParameters));
        this.lsBuilder.checker((ConvergenceChecker)new ConvergenceChecker<LeastSquaresProblem.Evaluation>(){

            public boolean converged(int iteration, LeastSquaresProblem.Evaluation previous, LeastSquaresProblem.Evaluation current) {
                double lInf = current.getPoint().getLInfDistance(previous.getPoint());
                return lInf <= BatchLSEstimator.this.parametersConvergenceThreshold;
            }
        });
        TappedLSProblem problem = new TappedLSProblem(this.lsBuilder.build(), model, estimatedOrbitalParameters, parameterDriversList, estimatedMeasurementsParameters);
        try {
            this.optimum = this.optimizer.optimize((LeastSquaresProblem)problem);
            return model.createPropagators(this.optimum.getPoint());
        }
        catch (MathRuntimeException mrte) {
            throw new OrekitException(mrte);
        }
    }

    public Map<ObservedMeasurement<?>, EstimatedMeasurement<?>> getLastEstimations() {
        return Collections.unmodifiableMap(this.estimations);
    }

    public LeastSquaresOptimizer.Optimum getOptimum() {
        return this.optimum;
    }

    /*
     * WARNING - void declaration
     */
    public RealMatrix getPhysicalCovariances(double threshold) {
        RealMatrix covariances;
        try {
            covariances = this.optimum.getCovariances(threshold).copy();
        }
        catch (MathIllegalArgumentException miae) {
            throw new OrekitException((MathRuntimeException)((Object)miae));
        }
        double[] scale = new double[covariances.getRowDimension()];
        int index = 0;
        for (ParameterDriver parameterDriver : this.getOrbitalParametersDrivers(true).getDrivers()) {
            scale[index++] = parameterDriver.getScale();
        }
        for (ParameterDriver parameterDriver : this.getPropagatorParametersDrivers(true).getDrivers()) {
            scale[index++] = parameterDriver.getScale();
        }
        for (ParameterDriver parameterDriver : this.getMeasurementsParametersDrivers(true).getDrivers()) {
            scale[index++] = parameterDriver.getScale();
        }
        for (int i = 0; i < covariances.getRowDimension(); ++i) {
            void var7_14;
            boolean bl = false;
            while (var7_14 < covariances.getColumnDimension()) {
                covariances.setEntry(i, (int)var7_14, scale[i] * scale[var7_14] * covariances.getEntry(i, (int)var7_14));
                ++var7_14;
            }
        }
        return covariances;
    }

    public int getIterationsCount() {
        return this.iterationsCounter.getCount();
    }

    public int getEvaluationsCount() {
        return this.evaluationsCounter.getCount();
    }

    static /* synthetic */ Orbit[] access$002(BatchLSEstimator x0, Orbit[] x1) {
        x0.orbits = x1;
        return x1;
    }

    private static class Validator
    implements ParameterValidator {
        private final ParameterDriversList estimatedOrbitalParameters;
        private final ParameterDriversList estimatedPropagatorParameters;
        private final ParameterDriversList estimatedMeasurementsParameters;

        Validator(ParameterDriversList estimatedOrbitalParameters, ParameterDriversList estimatedPropagatorParameters, ParameterDriversList estimatedMeasurementsParameters) {
            this.estimatedOrbitalParameters = estimatedOrbitalParameters;
            this.estimatedPropagatorParameters = estimatedPropagatorParameters;
            this.estimatedMeasurementsParameters = estimatedMeasurementsParameters;
        }

        public RealVector validate(RealVector params) {
            int i = 0;
            for (ParameterDriver parameterDriver : this.estimatedOrbitalParameters.getDrivers()) {
                parameterDriver.setNormalizedValue(params.getEntry(i));
                params.setEntry(i++, parameterDriver.getNormalizedValue());
            }
            for (ParameterDriver parameterDriver : this.estimatedPropagatorParameters.getDrivers()) {
                parameterDriver.setNormalizedValue(params.getEntry(i));
                params.setEntry(i++, parameterDriver.getNormalizedValue());
            }
            for (ParameterDriver parameterDriver : this.estimatedMeasurementsParameters.getDrivers()) {
                parameterDriver.setNormalizedValue(params.getEntry(i));
                params.setEntry(i++, parameterDriver.getNormalizedValue());
            }
            return params;
        }
    }

    private class Provider
    implements EstimationsProvider {
        private EstimatedMeasurement<?>[] sortedEstimations;

        private Provider() {
        }

        @Override
        public int getNumber() {
            return BatchLSEstimator.this.estimations.size();
        }

        @Override
        public EstimatedMeasurement<?> getEstimatedMeasurement(int index) {
            if (index < 0 || index >= BatchLSEstimator.this.estimations.size()) {
                throw new OrekitException((Localizable)LocalizedCoreFormats.OUT_OF_RANGE_SIMPLE, index, 0, BatchLSEstimator.this.estimations.size());
            }
            if (this.sortedEstimations == null) {
                this.sortedEstimations = new EstimatedMeasurement[BatchLSEstimator.this.estimations.size()];
                int i = 0;
                for (Map.Entry entry : BatchLSEstimator.this.estimations.entrySet()) {
                    this.sortedEstimations[i++] = (EstimatedMeasurement)entry.getValue();
                }
                Arrays.sort(this.sortedEstimations, 0, this.sortedEstimations.length, Comparator.naturalOrder());
            }
            return this.sortedEstimations[index];
        }
    }

    private class TappedLSProblem
    implements LeastSquaresProblem {
        private final LeastSquaresProblem problem;
        private final Model model;
        private final ParameterDriversList estimatedOrbitalParameters;
        private final ParameterDriversList estimatedPropagatorParameters;
        private final ParameterDriversList estimatedMeasurementsParameters;

        TappedLSProblem(LeastSquaresProblem problem, Model model, ParameterDriversList estimatedOrbitalParameters, ParameterDriversList estimatedPropagatorParameters, ParameterDriversList estimatedMeasurementsParameters) {
            this.problem = problem;
            this.model = model;
            this.estimatedOrbitalParameters = estimatedOrbitalParameters;
            this.estimatedPropagatorParameters = estimatedPropagatorParameters;
            this.estimatedMeasurementsParameters = estimatedMeasurementsParameters;
        }

        public Incrementor getEvaluationCounter() {
            BatchLSEstimator.this.evaluationsCounter = this.problem.getEvaluationCounter();
            this.model.setEvaluationsCounter(BatchLSEstimator.this.evaluationsCounter);
            return BatchLSEstimator.this.evaluationsCounter;
        }

        public Incrementor getIterationCounter() {
            BatchLSEstimator.this.iterationsCounter = this.problem.getIterationCounter();
            this.model.setIterationsCounter(BatchLSEstimator.this.iterationsCounter);
            return BatchLSEstimator.this.iterationsCounter;
        }

        public ConvergenceChecker<LeastSquaresProblem.Evaluation> getConvergenceChecker() {
            return this.problem.getConvergenceChecker();
        }

        public RealVector getStart() {
            return this.problem.getStart();
        }

        public int getObservationSize() {
            return this.problem.getObservationSize();
        }

        public int getParameterSize() {
            return this.problem.getParameterSize();
        }

        public LeastSquaresProblem.Evaluation evaluate(RealVector point) {
            LeastSquaresProblem.Evaluation evaluation = this.problem.evaluate(point);
            if (BatchLSEstimator.this.observer != null) {
                BatchLSEstimator.this.observer.evaluationPerformed(BatchLSEstimator.this.iterationsCounter.getCount(), BatchLSEstimator.this.evaluationsCounter.getCount(), BatchLSEstimator.this.orbits, this.estimatedOrbitalParameters, this.estimatedPropagatorParameters, this.estimatedMeasurementsParameters, new Provider(), evaluation);
            }
            return evaluation;
        }
    }
}

