/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.bodies;

import java.io.Serializable;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldLine;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Line;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.geometry.euclidean.twod.Vector2D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.bodies.BodyShape;
import org.orekit.bodies.Ellipse;
import org.orekit.bodies.Ellipsoid;
import org.orekit.bodies.FieldGeodeticPoint;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class OneAxisEllipsoid
extends Ellipsoid
implements BodyShape {
    private static final long serialVersionUID = 20130518L;
    private static final double ANGULAR_THRESHOLD = 1.0E-4;
    private final Frame bodyFrame;
    private final double ae2;
    private final double ap2;
    private final double f;
    private final double e2;
    private final double g;
    private final double g2;
    private double angularThreshold;

    public OneAxisEllipsoid(double ae, double f, Frame bodyFrame) {
        super(bodyFrame, ae, ae, ae * (1.0 - f));
        this.f = f;
        this.ae2 = ae * ae;
        this.e2 = f * (2.0 - f);
        this.g = 1.0 - f;
        this.g2 = this.g * this.g;
        this.ap2 = this.ae2 * this.g2;
        this.setAngularThreshold(1.0E-12);
        this.bodyFrame = bodyFrame;
    }

    public void setAngularThreshold(double angularThreshold) {
        this.angularThreshold = angularThreshold;
    }

    public double getEquatorialRadius() {
        return this.getA();
    }

    public double getFlattening() {
        return this.f;
    }

    @Override
    public Frame getBodyFrame() {
        return this.bodyFrame;
    }

    public Vector3D getCartesianIntersectionPoint(Line line, Vector3D close, Frame frame, AbsoluteDate date) {
        double c;
        double cz2;
        double a;
        double ac;
        double dz;
        double dy;
        Transform frameToBodyFrame = frame.getTransformTo(this.bodyFrame, date);
        Line lineInBodyFrame = frameToBodyFrame.transformLine(line);
        Vector3D point = lineInBodyFrame.getOrigin();
        double x = point.getX();
        double y = point.getY();
        double z = point.getZ();
        double z2 = z * z;
        double r2 = x * x + y * y;
        Vector3D direction = lineInBodyFrame.getDirection();
        double dx = direction.getX();
        double b = -(this.g2 * (x * dx + y * (dy = direction.getY())) + z * (dz = direction.getZ()));
        double b2 = b * b;
        if (b2 < (ac = (a = 1.0 - this.e2 * (cz2 = dx * dx + dy * dy)) * (c = this.g2 * (r2 - this.ae2) + z2))) {
            return null;
        }
        double s = FastMath.sqrt((double)(b2 - ac));
        double k1 = b < 0.0 ? (b - s) / a : c / (b + s);
        double k2 = c / (a * k1);
        Vector3D closeInBodyFrame = frameToBodyFrame.transformPosition(close);
        double closeAbscissa = lineInBodyFrame.getAbscissa(closeInBodyFrame);
        double k = FastMath.abs((double)(k1 - closeAbscissa)) < FastMath.abs((double)(k2 - closeAbscissa)) ? k1 : k2;
        return lineInBodyFrame.pointAt(k);
    }

    @Override
    public GeodeticPoint getIntersectionPoint(Line line, Vector3D close, Frame frame, AbsoluteDate date) {
        Vector3D intersection = this.getCartesianIntersectionPoint(line, close, frame, date);
        if (intersection == null) {
            return null;
        }
        double ix = intersection.getX();
        double iy = intersection.getY();
        double iz = intersection.getZ();
        double lambda = FastMath.atan2((double)iy, (double)ix);
        double phi = FastMath.atan2((double)iz, (double)(this.g2 * FastMath.sqrt((double)(ix * ix + iy * iy))));
        return new GeodeticPoint(phi, lambda, 0.0);
    }

    public <T extends RealFieldElement<T>> FieldVector3D<T> getCartesianIntersectionPoint(FieldLine<T> line, FieldVector3D<T> close, Frame frame, FieldAbsoluteDate<T> date) {
        FieldTransform<T> frameToBodyFrame = frame.getTransformTo(this.bodyFrame, date);
        FieldLine<T> lineInBodyFrame = frameToBodyFrame.transformLine(line);
        FieldVector3D point = lineInBodyFrame.getOrigin();
        RealFieldElement x = point.getX();
        RealFieldElement y = point.getY();
        RealFieldElement z = point.getZ();
        RealFieldElement z2 = (RealFieldElement)z.multiply((Object)z);
        RealFieldElement r2 = (RealFieldElement)((RealFieldElement)x.multiply((Object)x)).add(y.multiply((Object)y));
        FieldVector3D direction = lineInBodyFrame.getDirection();
        RealFieldElement dx = direction.getX();
        RealFieldElement dy = direction.getY();
        RealFieldElement dz = direction.getZ();
        RealFieldElement cz2 = (RealFieldElement)((RealFieldElement)dx.multiply((Object)dx)).add(dy.multiply((Object)dy));
        RealFieldElement a = (RealFieldElement)((RealFieldElement)((RealFieldElement)cz2.multiply(this.e2)).subtract(1.0)).negate();
        RealFieldElement b = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)x.multiply((Object)dx)).add(y.multiply((Object)dy))).multiply(this.g2)).add(z.multiply((Object)dz))).negate();
        RealFieldElement c = (RealFieldElement)((RealFieldElement)((RealFieldElement)r2.subtract(this.ae2)).multiply(this.g2)).add((Object)z2);
        RealFieldElement b2 = (RealFieldElement)b.multiply((Object)b);
        RealFieldElement ac = (RealFieldElement)a.multiply((Object)c);
        if (b2.getReal() < ac.getReal()) {
            return null;
        }
        RealFieldElement s = (RealFieldElement)((RealFieldElement)b2.subtract((Object)ac)).sqrt();
        RealFieldElement k1 = b.getReal() < 0.0 ? (RealFieldElement)((RealFieldElement)b.subtract((Object)s)).divide((Object)a) : (RealFieldElement)c.divide(b.add((Object)s));
        RealFieldElement k2 = (RealFieldElement)c.divide(a.multiply((Object)k1));
        FieldVector3D<T> closeInBodyFrame = frameToBodyFrame.transformPosition(close);
        RealFieldElement closeAbscissa = lineInBodyFrame.getAbscissa(closeInBodyFrame);
        RealFieldElement k = FastMath.abs((double)(k1.getReal() - closeAbscissa.getReal())) < FastMath.abs((double)(k2.getReal() - closeAbscissa.getReal())) ? k1 : k2;
        return lineInBodyFrame.pointAt(k);
    }

    @Override
    public <T extends RealFieldElement<T>> FieldGeodeticPoint<T> getIntersectionPoint(FieldLine<T> line, FieldVector3D<T> close, Frame frame, FieldAbsoluteDate<T> date) {
        FieldVector3D<T> intersection = this.getCartesianIntersectionPoint(line, close, frame, date);
        if (intersection == null) {
            return null;
        }
        RealFieldElement ix = intersection.getX();
        RealFieldElement iy = intersection.getY();
        RealFieldElement iz = intersection.getZ();
        RealFieldElement lambda = (RealFieldElement)iy.atan2((Object)ix);
        RealFieldElement phi = (RealFieldElement)iz.atan2(((RealFieldElement)((RealFieldElement)((RealFieldElement)ix.multiply((Object)ix)).add(iy.multiply((Object)iy))).sqrt()).multiply(this.g2));
        return new FieldGeodeticPoint<RealFieldElement>(phi, lambda, (RealFieldElement)phi.getField().getZero());
    }

    @Override
    public Vector3D transform(GeodeticPoint point) {
        double longitude = point.getLongitude();
        double cLambda = FastMath.cos((double)longitude);
        double sLambda = FastMath.sin((double)longitude);
        double latitude = point.getLatitude();
        double cPhi = FastMath.cos((double)latitude);
        double sPhi = FastMath.sin((double)latitude);
        double h = point.getAltitude();
        double n = this.getA() / FastMath.sqrt((double)(1.0 - this.e2 * sPhi * sPhi));
        double r = (n + h) * cPhi;
        return new Vector3D(r * cLambda, r * sLambda, (this.g2 * n + h) * sPhi);
    }

    @Override
    public <T extends RealFieldElement<T>> FieldVector3D<T> transform(FieldGeodeticPoint<T> point) {
        T latitude = point.getLatitude();
        T longitude = point.getLongitude();
        T altitude = point.getAltitude();
        RealFieldElement cLambda = (RealFieldElement)longitude.cos();
        RealFieldElement sLambda = (RealFieldElement)longitude.sin();
        RealFieldElement cPhi = (RealFieldElement)latitude.cos();
        RealFieldElement sPhi = (RealFieldElement)latitude.sin();
        RealFieldElement n = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)sPhi.multiply((Object)sPhi)).multiply(this.e2)).subtract(1.0)).negate()).sqrt()).reciprocal()).multiply(this.getA());
        RealFieldElement r = (RealFieldElement)((RealFieldElement)n.add(altitude)).multiply((Object)cPhi);
        return new FieldVector3D((RealFieldElement)r.multiply((Object)cLambda), (RealFieldElement)r.multiply((Object)sLambda), (RealFieldElement)sPhi.multiply(altitude.add(n.multiply(this.g2))));
    }

    @Override
    public Vector3D projectToGround(Vector3D point, AbsoluteDate date, Frame frame) {
        Transform toBody = frame.getTransformTo(this.bodyFrame, date);
        Vector3D p = toBody.transformPosition(point);
        double z = p.getZ();
        double r = FastMath.hypot((double)p.getX(), (double)p.getY());
        Ellipse meridian = new Ellipse(Vector3D.ZERO, new Vector3D(p.getX() / r, p.getY() / r, 0.0), Vector3D.PLUS_K, this.getA(), this.getC(), this.bodyFrame);
        Vector3D groundPoint = meridian.toSpace(meridian.projectToEllipse(new Vector2D(r, z)));
        return toBody.getInverse().transformPosition(groundPoint);
    }

    @Override
    public TimeStampedPVCoordinates projectToGround(TimeStampedPVCoordinates pv, Frame frame) {
        Transform toBody = frame.getTransformTo(this.bodyFrame, pv.getDate());
        TimeStampedPVCoordinates pvInBodyFrame = toBody.transformPVCoordinates(pv);
        Vector3D p = pvInBodyFrame.getPosition();
        double r = FastMath.hypot((double)p.getX(), (double)p.getY());
        Vector3D meridian = new Vector3D(p.getX() / r, p.getY() / r, 0.0);
        Ellipse firstPrincipalCurvature = new Ellipse(Vector3D.ZERO, meridian, Vector3D.PLUS_K, this.getA(), this.getC(), this.bodyFrame);
        TimeStampedPVCoordinates gpFirst = firstPrincipalCurvature.projectToEllipse(pvInBodyFrame);
        Vector3D gpP = gpFirst.getPosition();
        double gr = MathArrays.linearCombination((double)gpP.getX(), (double)meridian.getX(), (double)gpP.getY(), (double)meridian.getY());
        double gz = gpP.getZ();
        Vector3D east = new Vector3D(-meridian.getY(), meridian.getX(), 0.0);
        Vector3D zenith = new Vector3D(gr * this.getC() / this.getA(), meridian, gz * this.getA() / this.getC(), Vector3D.PLUS_K).normalize();
        Vector3D north = Vector3D.crossProduct((Vector3D)zenith, (Vector3D)east);
        Ellipse secondPrincipalCurvature = this.getPlaneSection(gpP, north);
        TimeStampedPVCoordinates gpSecond = secondPrincipalCurvature.projectToEllipse(pvInBodyFrame);
        Vector3D gpV = gpFirst.getVelocity().add((Vector)gpSecond.getVelocity());
        Vector3D gpA = gpFirst.getAcceleration().add((Vector)gpSecond.getAcceleration());
        TimeStampedPVCoordinates groundPV = new TimeStampedPVCoordinates(pv.getDate(), gpP, gpV, gpA);
        return toBody.getInverse().transformPVCoordinates(groundPV);
    }

    @Override
    public GeodeticPoint transform(Vector3D point, Frame frame, AbsoluteDate date) {
        double h;
        double phi;
        Vector3D pointInBodyFrame = frame.getTransformTo(this.bodyFrame, date).transformPosition(point);
        double r2 = pointInBodyFrame.getX() * pointInBodyFrame.getX() + pointInBodyFrame.getY() * pointInBodyFrame.getY();
        double r = FastMath.sqrt((double)r2);
        double z = pointInBodyFrame.getZ();
        double lambda = FastMath.atan2((double)pointInBodyFrame.getY(), (double)pointInBodyFrame.getX());
        if (r <= 1.0E-4 * FastMath.abs((double)z)) {
            double osculatingRadius = this.ae2 / this.getC();
            double evoluteCuspZ = FastMath.copySign((double)(this.getA() * this.e2 / this.g), (double)(-z));
            double deltaZ = z - evoluteCuspZ;
            phi = FastMath.copySign((double)(1.5707963267948966 - FastMath.atan((double)(r / FastMath.abs((double)deltaZ)))), (double)deltaZ);
            h = FastMath.hypot((double)deltaZ, (double)r) - osculatingRadius;
        } else if (FastMath.abs((double)z) <= 1.0E-4 * r) {
            double osculatingRadius = this.ap2 / this.getA();
            double evoluteCuspR = this.getA() * this.e2;
            double deltaR = r - evoluteCuspR;
            if (deltaR >= 0.0) {
                phi = deltaR == 0.0 ? 0.0 : FastMath.atan((double)(z / deltaR));
                h = FastMath.hypot((double)deltaR, (double)z) - osculatingRadius;
            } else {
                double rClose = r / this.e2;
                double zClose = FastMath.copySign((double)(this.g * FastMath.sqrt((double)(this.ae2 - rClose * rClose))), (double)z);
                phi = FastMath.atan((double)((zClose - z) / (rClose - r)));
                h = -FastMath.hypot((double)(r - rClose), (double)(z - zClose));
            }
        } else {
            double epsPhi = 1.0E-15;
            double epsH = 1.0E-14 * FastMath.max((double)this.getA(), (double)FastMath.sqrt((double)(r2 + z * z)));
            double c = this.getA() * this.e2;
            double absZ = FastMath.abs((double)z);
            double zc = this.g * absZ;
            double sn = absZ;
            double sn2 = sn * sn;
            double cn = this.g * r;
            double cn2 = cn * cn;
            double an2 = cn2 + sn2;
            double an = FastMath.sqrt((double)an2);
            double bn = 0.0;
            phi = Double.POSITIVE_INFINITY;
            h = Double.POSITIVE_INFINITY;
            for (int i = 0; i < 10; ++i) {
                double oldSn = sn;
                double oldCn = cn;
                double oldPhi = phi;
                double oldH = h;
                double an3 = an2 * an;
                double csncn = c * sn * cn;
                bn = 1.5 * csncn * ((r * sn - zc * cn) * an - csncn);
                sn = (zc * an3 + c * sn2 * sn) * an3 - bn * sn;
                cn = (r * an3 - c * cn2 * cn) * an3 - bn * cn;
                if (sn * oldSn < 0.0 || cn < 0.0) {
                    while (sn * oldSn < 0.0 || cn < 0.0) {
                        sn = (sn + oldSn) / 2.0;
                        cn = (cn + oldCn) / 2.0;
                    }
                    continue;
                }
                int exp = (FastMath.getExponent((double)sn) + FastMath.getExponent((double)cn)) / 2;
                sn = FastMath.scalb((double)sn, (int)(-exp));
                cn = FastMath.scalb((double)cn, (int)(-exp));
                sn2 = sn * sn;
                cn2 = cn * cn;
                an2 = cn2 + sn2;
                an = FastMath.sqrt((double)an2);
                double cc = this.g * cn;
                h = (r * cc + absZ * sn - this.getA() * this.g * an) / FastMath.sqrt((double)(an2 - this.e2 * cn2));
                if (FastMath.abs((double)(oldH - h)) < epsH && FastMath.abs((double)(oldPhi - (phi = FastMath.copySign((double)FastMath.atan((double)(sn / cc)), (double)z)))) < 1.0E-15) break;
            }
        }
        return new GeodeticPoint(phi, lambda, h);
    }

    @Override
    public <T extends RealFieldElement<T>> FieldGeodeticPoint<T> transform(FieldVector3D<T> point, Frame frame, FieldAbsoluteDate<T> date) {
        RealFieldElement h;
        RealFieldElement phi;
        FieldVector3D<T> pointInBodyFrame = frame.getTransformTo(this.bodyFrame, date).transformPosition(point);
        RealFieldElement r2 = (RealFieldElement)((RealFieldElement)pointInBodyFrame.getX().multiply((Object)pointInBodyFrame.getX())).add(pointInBodyFrame.getY().multiply((Object)pointInBodyFrame.getY()));
        RealFieldElement r = (RealFieldElement)r2.sqrt();
        RealFieldElement z = pointInBodyFrame.getZ();
        RealFieldElement lambda = (RealFieldElement)pointInBodyFrame.getY().atan2((Object)pointInBodyFrame.getX());
        if (r.getReal() <= 1.0E-4 * FastMath.abs((double)z.getReal())) {
            double osculatingRadius = this.ae2 / this.getC();
            double evoluteCuspZ = FastMath.copySign((double)(this.getA() * this.e2 / this.g), (double)(-z.getReal()));
            RealFieldElement deltaZ = (RealFieldElement)z.subtract(evoluteCuspZ);
            phi = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)r.divide(deltaZ.abs())).atan()).negate()).add(1.5707963267948966)).copySign((Object)deltaZ);
            h = (RealFieldElement)((RealFieldElement)deltaZ.hypot((Object)r)).subtract(osculatingRadius);
        } else if (FastMath.abs((double)z.getReal()) <= 1.0E-4 * r.getReal()) {
            double osculatingRadius = this.ap2 / this.getA();
            double evoluteCuspR = this.getA() * this.e2;
            RealFieldElement deltaR = (RealFieldElement)r.subtract(evoluteCuspR);
            if (deltaR.getReal() >= 0.0) {
                phi = deltaR.getReal() == 0.0 ? (RealFieldElement)z.getField().getZero() : (RealFieldElement)((RealFieldElement)z.divide((Object)deltaR)).atan();
                h = (RealFieldElement)((RealFieldElement)deltaR.hypot((Object)z)).subtract(osculatingRadius);
            } else {
                RealFieldElement rClose = (RealFieldElement)r.divide(this.e2);
                RealFieldElement zClose = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)rClose.multiply((Object)rClose)).negate()).add(this.ae2)).sqrt()).multiply(this.g)).copySign((Object)z);
                phi = (RealFieldElement)((RealFieldElement)((RealFieldElement)zClose.subtract((Object)z)).divide(rClose.subtract((Object)r))).atan();
                h = (RealFieldElement)((RealFieldElement)((RealFieldElement)r.subtract((Object)rClose)).hypot(z.subtract((Object)zClose))).negate();
            }
        } else {
            double epsPhi = 1.0E-15;
            double epsH = 1.0E-14 * this.getA();
            double c = this.getA() * this.e2;
            RealFieldElement absZ = (RealFieldElement)z.abs();
            RealFieldElement zc = (RealFieldElement)absZ.multiply(this.g);
            RealFieldElement sn = absZ;
            RealFieldElement sn2 = (RealFieldElement)sn.multiply((Object)sn);
            RealFieldElement cn = (RealFieldElement)r.multiply(this.g);
            RealFieldElement cn2 = (RealFieldElement)cn.multiply((Object)cn);
            RealFieldElement an2 = (RealFieldElement)cn2.add((Object)sn2);
            RealFieldElement an = (RealFieldElement)an2.sqrt();
            RealFieldElement bn = (RealFieldElement)an.getField().getZero();
            phi = (RealFieldElement)((RealFieldElement)an.getField().getZero()).add(Double.POSITIVE_INFINITY);
            h = (RealFieldElement)((RealFieldElement)an.getField().getZero()).add(Double.POSITIVE_INFINITY);
            for (int i = 0; i < 10; ++i) {
                RealFieldElement oldSn = sn;
                RealFieldElement oldCn = cn;
                RealFieldElement oldPhi = phi;
                RealFieldElement oldH = h;
                RealFieldElement an3 = (RealFieldElement)an2.multiply((Object)an);
                RealFieldElement csncn = (RealFieldElement)((RealFieldElement)sn.multiply((Object)cn)).multiply(c);
                bn = (RealFieldElement)((RealFieldElement)csncn.multiply(1.5)).multiply(((RealFieldElement)((RealFieldElement)((RealFieldElement)r.multiply((Object)sn)).subtract(zc.multiply((Object)cn))).multiply((Object)an)).subtract((Object)csncn));
                sn = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)zc.multiply((Object)an3)).add(((RealFieldElement)sn2.multiply((Object)sn)).multiply(c))).multiply((Object)an3)).subtract(bn.multiply((Object)sn));
                cn = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)r.multiply((Object)an3)).subtract(((RealFieldElement)cn2.multiply((Object)cn)).multiply(c))).multiply((Object)an3)).subtract(bn.multiply((Object)cn));
                if (sn.getReal() * oldSn.getReal() < 0.0 || cn.getReal() < 0.0) {
                    while (sn.getReal() * oldSn.getReal() < 0.0 || cn.getReal() < 0.0) {
                        sn = (RealFieldElement)((RealFieldElement)sn.add((Object)oldSn)).multiply(0.5);
                        cn = (RealFieldElement)((RealFieldElement)cn.add((Object)oldCn)).multiply(0.5);
                    }
                    continue;
                }
                int exp = (FastMath.getExponent((double)sn.getReal()) + FastMath.getExponent((double)cn.getReal())) / 2;
                sn = (RealFieldElement)sn.scalb(-exp);
                cn = (RealFieldElement)cn.scalb(-exp);
                sn2 = (RealFieldElement)sn.multiply((Object)sn);
                cn2 = (RealFieldElement)cn.multiply((Object)cn);
                an2 = (RealFieldElement)cn2.add((Object)sn2);
                an = (RealFieldElement)an2.sqrt();
                RealFieldElement cc = (RealFieldElement)cn.multiply(this.g);
                h = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)r.multiply((Object)cc)).add(absZ.multiply((Object)sn))).subtract(an.multiply(this.getA() * this.g))).divide(((RealFieldElement)an2.subtract(cn2.multiply(this.e2))).sqrt());
                if (!(FastMath.abs((double)(oldH.getReal() - h.getReal())) < epsH)) continue;
                phi = (RealFieldElement)((RealFieldElement)((RealFieldElement)sn.divide((Object)cc)).atan()).copySign((Object)z);
                if (FastMath.abs((double)(oldPhi.getReal() - phi.getReal())) < 1.0E-15) break;
            }
        }
        return new FieldGeodeticPoint<RealFieldElement>(phi, lambda, h);
    }

    public FieldGeodeticPoint<DerivativeStructure> transform(PVCoordinates point, Frame frame, AbsoluteDate date) {
        Transform toBody = frame.getTransformTo(this.bodyFrame, date);
        PVCoordinates pointInBodyFrame = toBody.transformPVCoordinates(point);
        FieldVector3D<DerivativeStructure> p = pointInBodyFrame.toDerivativeStructureVector(2);
        DerivativeStructure pr2 = ((DerivativeStructure)p.getX()).multiply((DerivativeStructure)p.getX()).add(((DerivativeStructure)p.getY()).multiply((DerivativeStructure)p.getY()));
        DerivativeStructure pr = pr2.sqrt();
        DerivativeStructure pz = (DerivativeStructure)p.getZ();
        TimeStampedPVCoordinates groundPoint = this.projectToGround(new TimeStampedPVCoordinates(date, pointInBodyFrame), this.bodyFrame);
        FieldVector3D<DerivativeStructure> gp = groundPoint.toDerivativeStructureVector(2);
        DerivativeStructure gpr2 = ((DerivativeStructure)gp.getX()).multiply((DerivativeStructure)gp.getX()).add(((DerivativeStructure)gp.getY()).multiply((DerivativeStructure)gp.getY()));
        DerivativeStructure gpr = gpr2.sqrt();
        DerivativeStructure gpz = (DerivativeStructure)gp.getZ();
        DerivativeStructure dr = pr.subtract(gpr);
        DerivativeStructure dz = pz.subtract(gpz);
        double insideIfNegative = this.g2 * (pr2.getReal() - this.ae2) + pz.getReal() * pz.getReal();
        return new FieldGeodeticPoint<DerivativeStructure>(DerivativeStructure.atan2((DerivativeStructure)gpz, (DerivativeStructure)gpr.multiply(this.g2)), DerivativeStructure.atan2((DerivativeStructure)((DerivativeStructure)p.getY()), (DerivativeStructure)((DerivativeStructure)p.getX())), DerivativeStructure.hypot((DerivativeStructure)dr, (DerivativeStructure)dz).copySign(insideIfNegative));
    }

    private Object writeReplace() {
        return new DataTransferObject(this.getA(), this.f, this.bodyFrame, this.angularThreshold);
    }

    private static class DataTransferObject
    implements Serializable {
        private static final long serialVersionUID = 20130518L;
        private final double ae;
        private final double f;
        private final Frame bodyFrame;
        private final double angularThreshold;

        DataTransferObject(double ae, double f, Frame bodyFrame, double angularThreshold) {
            this.ae = ae;
            this.f = f;
            this.bodyFrame = bodyFrame;
            this.angularThreshold = angularThreshold;
        }

        private Object readResolve() {
            OneAxisEllipsoid ellipsoid = new OneAxisEllipsoid(this.ae, this.f, this.bodyFrame);
            ellipsoid.setAngularThreshold(this.angularThreshold);
            return ellipsoid;
        }
    }
}

